/*
 * Decompiled with CFR 0.152.
 */
package com.mobiwire.CSAndroidGoLib;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.RemoteException;
import android.text.Html;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.mobiwire.CSAndroidGoLib.AndroidGoCSApi;
import com.mobiwire.CSAndroidGoLib.Utils.AndroidBmpUtil;
import com.mobiwire.CSAndroidGoLib.Utils.PrinterServiceUtil;
import com.sagereal.printer.PrinterInterface;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class CsPrinter {
    ArrayList<Bitmap> arrayBitmap = new ArrayList();

    public void addTextToPrint(String text, String textTwo, int textSize, boolean isBold, boolean isUnderline, int align) {
        Bitmap bitmap = this.drawText(text, textTwo, textSize, isBold, isUnderline, align, null);
        this.arrayBitmap.add(bitmap);
    }

    public void addBitmapToPrint(Bitmap bitmap) {
        this.arrayBitmap.add(bitmap);
    }

    public void addBitmapFromRawToPrint(Context context, int res) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)res);
        this.arrayBitmap.add(bitmap);
    }

    public void addBarQrCodeToPrint(String str, BarcodeFormat type, int bmpWidth, int bmpHeight) {
        try {
            Bitmap bitmap = this.createBarQrCode(str, type, bmpWidth, bmpHeight);
            this.arrayBitmap.add(bitmap);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
    }

    public void print(Context context) {
        Bitmap last = this.createSingleImageFromMultipleImages(this.arrayBitmap);
        CsPrinter.printBitmap(context, last);
        this.arrayBitmap = new ArrayList();
        CsPrinter.printEndLine();
        CsPrinter.printEndLine();
    }

    public static void printText(String data) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printText(data);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print text");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printText_isBold(String data, boolean isBold) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printText_isBold(data, isBold);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print text bold");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printText_isUnderline(String data, boolean isUnderline) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printText_isUnderline(data, isUnderline);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print text undeline");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printText_FullParm(String data, int textSize, int textDirectiion, int textFont, int alignment, boolean isBold, boolean isUnderline) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printText_FullParm(data, textSize, textDirectiion, textFont, alignment, isBold, isUnderline);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print text full param");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static int getPrinterStatus() {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService != null) {
                int value = printInterfaceService.getPrinterStatus();
                Log.e((String)AndroidGoCSApi.TAG, (String)("printer status : " + value));
                return value;
            }
            Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
        return -1;
    }

    public static int getCurrentVoltageStatus() {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService != null) {
                int value = printInterfaceService.getCurrentVoltageStatus();
                Log.e((String)AndroidGoCSApi.TAG, (String)("current voltage status : " + value));
                return value;
            }
            Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
        return -1;
    }

    public static void printText_size(String data, int textSize) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printText_size(data, textSize);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print text size");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printText_font(String data, int textFont) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printText_font(data, textFont);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print text font");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printText_size_font(String data, int textSize, int textFont) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printText_size_font(data, textSize, textFont);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print text font");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printBitmap(String filePath) {
        block6: {
            try {
                PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
                if (printInterfaceService == null) {
                    Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
                    break block6;
                }
                File file = new File(filePath);
                int size = (int)file.length();
                byte[] bytes = new byte[size];
                try {
                    BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
                    buf.read(bytes, 0, bytes.length);
                    buf.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                printInterfaceService.printBitmap_bDate(bytes);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print bitmap");
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void printBitmap_bDate(byte[] byt) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printBitmap_bDate(byt);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print bitmap byte");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printBitmap_bDate_speed(byte[] byt, int speed) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printBitmap_bDate_speed(byt, speed);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print bitmap byte with speed");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printEndLine() {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printEndLine();
                Log.e((String)AndroidGoCSApi.TAG, (String)"print end line");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printBitmap_in(byte[] byt) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printBitmap_in(byt);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print bitmap");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printBitmap_inIs(Context mContext, byte[] byt, int speed) {
        try {
            PrinterInterface printInterfaceService = PrinterServiceUtil.getPrinterService();
            if (printInterfaceService == null) {
                Log.e((String)AndroidGoCSApi.TAG, (String)"service printer is KO");
            } else {
                printInterfaceService.printBitmap_inIs(byt, speed);
                Log.e((String)AndroidGoCSApi.TAG, (String)"print bitmap with speed");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void printTextHTML(final Context context, String html) {
        Log.e((String)"ismail", (String)"printTextFormat");
        TextView view = new TextView(context);
        view.setTextColor(-16777216);
        view.setBackgroundColor(-1);
        view.setText((CharSequence)Html.fromHtml((String)html, (Html.ImageGetter)new Html.ImageGetter(){

            public Drawable getDrawable(String source) {
                int dourceId = context.getResources().getIdentifier(source, "drawable", context.getPackageName());
                Drawable drawable = context.getResources().getDrawable(dourceId);
                drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                return drawable;
            }
        }, (Html.TagHandler)null));
        view.setDrawingCacheEnabled(true);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache(true);
        Bitmap b = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        Bitmap b2 = Bitmap.createBitmap((int)384, (int)384, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(b2);
        canvas.drawColor(-1);
        canvas.drawBitmap(CsPrinter.getResizedBitmap(b, b.getWidth(), 384), 0.0f, 0.0f, (Paint)null);
        view.setDrawingCacheEnabled(false);
        Bitmap bitm = CsPrinter.getResizedBitmap(b2, 384, 240);
        CsPrinter.printBitmap(context, bitm);
    }

    public static void printBitmap(Context context, Bitmap bitmap) {
        try {
            AndroidBmpUtil.save(bitmap, "/sdcard/test3.bmp");
            byte[] inputStreamToByte = null;
            FileInputStream is_black = new FileInputStream("/sdcard/test3.bmp");
            inputStreamToByte = CsPrinter.InputStreamToByte(is_black);
            CsPrinter.printBitmap_bDate_speed(inputStreamToByte, 2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] InputStreamToByte(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((ch = is.read(buffer)) != -1) {
            bytestream.write(buffer, 0, ch);
        }
        byte[] data = bytestream.toByteArray();
        bytestream.close();
        return data;
    }

    public static byte[] getByteArray(Bitmap bitmap) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
        return bos.toByteArray();
    }

    public static Bitmap getResizedBitmap(Bitmap bm, int newWidth, int newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        return resizedBitmap;
    }

    public static File savebitmap(Bitmap bmp) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bytes);
        File f = new File("/sdcard/test1.bmp");
        f.createNewFile();
        FileOutputStream fo = new FileOutputStream(f);
        fo.write(bytes.toByteArray());
        fo.close();
        return f;
    }

    public Bitmap drawText(String text, String textTwo, int textSize, boolean isBold, boolean isUnderline, int align, Typeface ttf) {
        int textWidth = 384;
        if (textTwo != null) {
            int llen = 20;
            int rlen = 20;
            String text1 = this.padRight(text, rlen);
            String text2 = this.padLeft(textTwo, llen);
            text = text1 + text2;
        }
        TextPaint textPaint = new TextPaint(65);
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setColor(-16777216);
        textPaint.setTextAlign(Paint.Align.LEFT);
        textPaint.setTextSize((float)textSize);
        textPaint.setFakeBoldText(isBold);
        textPaint.setTypeface(ttf);
        if (isUnderline) {
            textPaint.setFlags(8);
        }
        StaticLayout mTextLayout = new StaticLayout((CharSequence)text, textPaint, textWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        if (align == 0) {
            mTextLayout = new StaticLayout((CharSequence)text, textPaint, textWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        } else if (align == 1) {
            mTextLayout = new StaticLayout((CharSequence)text, textPaint, textWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        } else if (align == 2) {
            mTextLayout = new StaticLayout((CharSequence)text, textPaint, textWidth, Layout.Alignment.ALIGN_OPPOSITE, 1.0f, 0.0f, false);
        }
        Bitmap b = Bitmap.createBitmap((int)textWidth, (int)mTextLayout.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(b);
        Paint paint = new Paint(65);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(-1);
        c.drawPaint(paint);
        c.save();
        c.translate(0.0f, 0.0f);
        mTextLayout.draw(c);
        c.restore();
        return b;
    }

    public String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    private Bitmap createSingleImageFromMultipleImages(ArrayList<Bitmap> listBitmap) {
        int hight = 0;
        for (int i = 0; i < listBitmap.size(); ++i) {
            hight += listBitmap.get(i).getHeight();
        }
        Bitmap result = Bitmap.createBitmap((int)listBitmap.get(0).getWidth(), (int)hight, (Bitmap.Config)listBitmap.get(0).getConfig());
        Canvas canvas = new Canvas(result);
        int hightToDraw = 0;
        for (int i = 0; i < listBitmap.size(); ++i) {
            canvas.drawBitmap(listBitmap.get(i), 0.0f, (float)hightToDraw, null);
            hightToDraw += listBitmap.get(i).getHeight();
        }
        return result;
    }

    public Bitmap createBarQrCode(String str, BarcodeFormat type, int bmpWidth, int bmpHeight) throws WriterException {
        BitMatrix matrix = new MultiFormatWriter().encode(str, type, bmpWidth, bmpHeight);
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pixels[y * width + x] = matrix.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }
}

