/*
 * Decompiled with CFR 0.152.
 */
package com.mobiwire.CSAndroidGoLib.Utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.util.Log;
import com.mediatek.engineermode.atservice.IATService;
import java.util.List;

public class ATServiceUtils {
    private static final String TAG = "ATServiceUtils";
    public static IATService atService;
    private static ServiceConnection conn;

    public static void bindService(Context context) {
        Intent intent = new Intent("com.sagereal.atcmd.service.ACTION");
        Intent service = new Intent(ATServiceUtils.createExplicitFromImplicitIntent(context, intent));
        if (null == conn) {
            Log.e((String)TAG, (String)"\u521b\u5efaconn\u5e76\u8fde\u63a5");
            conn = new ServiceConnection(){

                public void onServiceConnected(ComponentName name, IBinder service) {
                    Log.e((String)ATServiceUtils.TAG, (String)("Connected!!! conn = " + conn));
                    atService = IATService.Stub.asInterface(service);
                }

                public void onServiceDisconnected(ComponentName name) {
                }
            };
            context.bindService(service, conn, 1);
        } else {
            Log.e((String)TAG, (String)"\u5df2\u7ecf\u8fde\u63a5\u4e0a\u4e86");
        }
    }

    public static void unBindService(Context context) {
        if (null != conn) {
            Log.e((String)TAG, (String)"\u65ad\u5f00\u8fde\u63a5 connection = null");
            context.unbindService(conn);
            conn = null;
            atService = null;
        } else {
            Log.e((String)TAG, (String)"\u5df2\u7ecf\u65ad\u5f00\u4e86\u8fde\u63a5");
        }
    }

    public static IATService getATService() {
        return atService;
    }

    public static Intent createExplicitFromImplicitIntent(Context context, Intent implicitIntent) {
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent, 0);
        if (resolveInfo == null || resolveInfo.size() != 1) {
            return null;
        }
        ResolveInfo serviceInfo = (ResolveInfo)resolveInfo.get(0);
        String packageName = serviceInfo.serviceInfo.packageName;
        String className = serviceInfo.serviceInfo.name;
        ComponentName component = new ComponentName(packageName, className);
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        return explicitIntent;
    }
}

