/*
 * Decompiled with CFR 0.152.
 */
package com.mobiwire.CSAndroidGoLib.Utils;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Matrix;
import android.net.Uri;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class BitmapUtils {
    private static final String path = "test.bmp";
    private static final String PATH = "file:///sdcard/test.bmp";
    private static final Uri imageUri = Uri.parse((String)"file:///sdcard/test.bmp");

    public static Bitmap zoomImg(Bitmap bm, int newWidth, int newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newbm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newbm;
    }

    public static void saveBmp(Context mcontent, Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        int nBmpWidth = bitmap.getWidth();
        int nBmpHeight = bitmap.getHeight();
        int bufferSize = nBmpHeight * (nBmpWidth * 3 + nBmpWidth % 4);
        try {
            String filename = BitmapUtils.getPathFromUri(mcontent, imageUri);
            Log.e((String)"jiangcunbin", (String)("photo save path : " + filename));
            File file = new File(filename);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileos = new FileOutputStream(filename);
            int bfType = 19778;
            long bfSize = 54 + bufferSize;
            int bfReserved1 = 0;
            int bfReserved2 = 0;
            long bfOffBits = 54L;
            BitmapUtils.writeWord(fileos, bfType);
            BitmapUtils.writeDword(fileos, bfSize);
            BitmapUtils.writeWord(fileos, bfReserved1);
            BitmapUtils.writeWord(fileos, bfReserved2);
            BitmapUtils.writeDword(fileos, bfOffBits);
            long biSize = 40L;
            long biWidth = nBmpWidth;
            long biHeight = nBmpHeight;
            int biPlanes = 1;
            int biBitCount = 24;
            long biCompression = 0L;
            long biSizeImage = 442368L;
            long biXpelsPerMeter = 0L;
            long biYPelsPerMeter = 0L;
            long biClrUsed = 0L;
            long biClrImportant = 0L;
            BitmapUtils.writeDword(fileos, biSize);
            BitmapUtils.writeLong(fileos, biWidth);
            BitmapUtils.writeLong(fileos, biHeight);
            BitmapUtils.writeWord(fileos, biPlanes);
            BitmapUtils.writeWord(fileos, biBitCount);
            BitmapUtils.writeDword(fileos, biCompression);
            BitmapUtils.writeDword(fileos, biSizeImage);
            BitmapUtils.writeLong(fileos, biXpelsPerMeter);
            BitmapUtils.writeLong(fileos, biYPelsPerMeter);
            BitmapUtils.writeDword(fileos, biClrUsed);
            BitmapUtils.writeDword(fileos, biClrImportant);
            byte[] bmpData = new byte[bufferSize];
            int wWidth = nBmpWidth * 3 + nBmpWidth % 4;
            int nCol = 0;
            int nRealCol = nBmpHeight - 1;
            while (nCol < nBmpHeight) {
                int wRow = 0;
                int wByteIdex = 0;
                while (wRow < nBmpWidth) {
                    int clr = bitmap.getPixel(wRow, nCol);
                    bmpData[nRealCol * wWidth + wByteIdex] = (byte)Color.blue((int)clr);
                    bmpData[nRealCol * wWidth + wByteIdex + 1] = (byte)Color.green((int)clr);
                    bmpData[nRealCol * wWidth + wByteIdex + 2] = (byte)Color.red((int)clr);
                    ++wRow;
                    wByteIdex += 3;
                }
                ++nCol;
                --nRealCol;
            }
            fileos.write(bmpData);
            fileos.flush();
            fileos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void writeWord(FileOutputStream stream, int value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        stream.write(b);
    }

    protected static void writeDword(FileOutputStream stream, long value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
        stream.write(b);
    }

    protected static void writeLong(FileOutputStream stream, long value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
        stream.write(b);
    }

    public static String getPathFromUri(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String path = null;
        if (scheme == null) {
            path = uri.getPath();
        } else if ("file".equals(scheme)) {
            path = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                path = cursor.getString(index);
            }
            cursor.close();
        }
        return path;
    }
}

