/*
 * Decompiled with CFR 0.152.
 */
package com.mobiwire.CSAndroidGoLib.Utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.util.Log;
import com.mediatek.settings.service.CSAndoridGo;
import java.util.List;

public class ServiceUtil {
    private static final String TAG = "ServiceUtil";
    private static ServiceConnection connection;
    private static CSAndoridGo iMyAidlInterface;

    public static void bindRemoteService(Context context) {
        Intent intent = new Intent();
        intent.setAction("com.mediatek.settings.MyService.action");
        Intent service = new Intent(ServiceUtil.createExplicitFromImplicitIntent(context, intent));
        if (null == connection) {
            Log.e((String)TAG, (String)"\u521b\u5efaconn\u5e76\u8fde\u63a5");
            connection = new ServiceConnection(){

                public void onServiceConnected(ComponentName name, IBinder service) {
                    Log.e((String)ServiceUtil.TAG, (String)("Connected!!! connection = " + connection));
                    iMyAidlInterface = CSAndoridGo.Stub.asInterface(service);
                }

                public void onServiceDisconnected(ComponentName componentName) {
                }
            };
            context.bindService(service, connection, 1);
        } else {
            Log.e((String)TAG, (String)"\u5df2\u7ecf\u8fde\u63a5\u4e0a\u4e86");
        }
    }

    public static void unbindRemoteService(Context context) {
        if (null != connection) {
            Log.e((String)TAG, (String)"\u65ad\u5f00\u8fde\u63a5 connection = null");
            context.unbindService(connection);
            connection = null;
            iMyAidlInterface = null;
        } else {
            Log.e((String)TAG, (String)"\u5df2\u7ecf\u65ad\u5f00\u4e86\u8fde\u63a5");
        }
    }

    public static CSAndoridGo getiMyAidlInterface() {
        return iMyAidlInterface;
    }

    public static Intent createExplicitFromImplicitIntent(Context context, Intent implicitIntent) {
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent, 0);
        if (resolveInfo == null || resolveInfo.size() != 1) {
            return null;
        }
        ResolveInfo serviceInfo = (ResolveInfo)resolveInfo.get(0);
        String packageName = serviceInfo.serviceInfo.packageName;
        String className = serviceInfo.serviceInfo.name;
        ComponentName component = new ComponentName(packageName, className);
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        return explicitIntent;
    }
}

