/*
 * Decompiled with CFR 0.152.
 */
package com.mobiwire.spinnerDatePicker;

import android.content.Context;
import android.text.format.DateFormat;
import android.text.format.Time;
import com.mobiwire.spinnerDatePicker.CommonDateUtils;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final String NO_YEAR_DATE_FEB29TH = "--02-29";
    private static final SimpleDateFormat[] DATE_FORMATS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar parseDate(String string2, boolean mustContainYear) {
        Date date;
        ParsePosition parsePosition = new ParsePosition(0);
        if (!mustContainYear) {
            boolean noYearParsed;
            if (NO_YEAR_DATE_FEB29TH.equals(string2)) {
                return DateUtils.getUtcDate(0, 1, 29);
            }
            SimpleDateFormat simpleDateFormat = CommonDateUtils.NO_YEAR_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                date = CommonDateUtils.NO_YEAR_DATE_FORMAT.parse(string2, parsePosition);
            }
            boolean bl = noYearParsed = parsePosition.getIndex() == string2.length();
            if (noYearParsed) {
                return DateUtils.getUtcDate(date, true);
            }
        }
        for (int i = 0; i < DATE_FORMATS.length; ++i) {
            SimpleDateFormat f;
            SimpleDateFormat simpleDateFormat = f = DATE_FORMATS[i];
            synchronized (simpleDateFormat) {
                parsePosition.setIndex(0);
                date = f.parse(string2, parsePosition);
                if (parsePosition.getIndex() == string2.length()) {
                    return DateUtils.getUtcDate(date, false);
                }
                continue;
            }
        }
        return null;
    }

    private static final Calendar getUtcDate(Date date, boolean noYear) {
        Calendar calendar = Calendar.getInstance(UTC_TIMEZONE, Locale.US);
        calendar.setTime(date);
        if (noYear) {
            calendar.set(1, 0);
        }
        return calendar;
    }

    private static final Calendar getUtcDate(int year, int month, int dayOfMonth) {
        Calendar calendar = Calendar.getInstance(UTC_TIMEZONE, Locale.US);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, dayOfMonth);
        return calendar;
    }

    public static boolean isYearSet(Calendar cal) {
        return cal.get(1) > 1;
    }

    public static String formatDate(Context context, String string2) {
        return DateUtils.formatDate(context, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Context context, String string2, boolean longForm) {
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return string2;
        }
        Calendar cal = DateUtils.parseDate(string2, false);
        if (cal == null) {
            return string2;
        }
        boolean isYearSet = DateUtils.isYearSet(cal);
        java.text.DateFormat outFormat = !isYearSet ? DateUtils.getLocalizedDateFormatWithoutYear(context) : (longForm ? DateFormat.getLongDateFormat((Context)context) : DateFormat.getDateFormat((Context)context));
        java.text.DateFormat dateFormat = outFormat;
        synchronized (dateFormat) {
            outFormat.setTimeZone(UTC_TIMEZONE);
            return outFormat.format(cal.getTime());
        }
    }

    public static boolean isMonthBeforeDay(Context context) {
        char[] dateFormatOrder = DateFormat.getDateFormatOrder((Context)context);
        for (int i = 0; i < dateFormatOrder.length; ++i) {
            if (dateFormatOrder[i] == 'd') {
                return false;
            }
            if (dateFormatOrder[i] != 'M') continue;
            return true;
        }
        return false;
    }

    public static java.text.DateFormat getLocalizedDateFormatWithoutYear(Context context) {
        String pattern = ((SimpleDateFormat)SimpleDateFormat.getDateInstance(1)).toPattern();
        String yearPattern = pattern.contains("de") ? "[^Mm]*[Yy]+[^Mm]*" : "[^DdMm]*[Yy]+[^DdMm]*";
        try {
            return new SimpleDateFormat(pattern.replaceAll(yearPattern, ""));
        }
        catch (IllegalArgumentException e) {
            return new SimpleDateFormat(DateUtils.isMonthBeforeDay(context) ? "MMMM dd" : "dd MMMM");
        }
    }

    public static Date getNextAnnualDate(Calendar target) {
        Calendar today = Calendar.getInstance();
        today.setTime(new Date());
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        boolean isYearSet = DateUtils.isYearSet(target);
        int targetYear = target.get(1);
        int targetMonth = target.get(2);
        int targetDay = target.get(5);
        boolean isFeb29 = targetMonth == 1 && targetDay == 29;
        GregorianCalendar anniversary = new GregorianCalendar();
        anniversary.set(!isYearSet ? today.get(1) : targetYear, targetMonth, targetDay);
        if (!isYearSet) {
            int anniversaryYear = today.get(1);
            if (anniversary.before(today) || isFeb29 && !anniversary.isLeapYear(anniversaryYear)) {
                while (isFeb29 && !anniversary.isLeapYear(++anniversaryYear)) {
                }
                anniversary.set(anniversaryYear, targetMonth, targetDay);
            }
        }
        return anniversary.getTime();
    }

    public static int getDayDifference(Time time, long date1, long date2) {
        time.set(date1);
        int startDay = Time.getJulianDay((long)date1, (long)time.gmtoff);
        time.set(date2);
        int currentDay = Time.getJulianDay((long)date2, (long)time.gmtoff);
        return Math.abs(currentDay - startDay);
    }

    static {
        for (SimpleDateFormat format : DATE_FORMATS = new SimpleDateFormat[]{CommonDateUtils.FULL_DATE_FORMAT, CommonDateUtils.DATE_AND_TIME_FORMAT, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'", Locale.US), new SimpleDateFormat("yyyyMMdd", Locale.US), new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS'Z'", Locale.US), new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.US), new SimpleDateFormat("yyyyMMdd'T'HHmm'Z'", Locale.US)}) {
            format.setLenient(true);
            format.setTimeZone(UTC_TIMEZONE);
        }
        CommonDateUtils.NO_YEAR_DATE_FORMAT.setTimeZone(UTC_TIMEZONE);
    }
}

