/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CofigFile {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setGlobalDBParameters() {
        try {
            Crypto theCrypto;
            System.out.println("\n*********************************************************");
            System.out.println("            SETTING CONFIG FILE PARAMETERS");
            System.out.println("*********************************************************\n");
            long lnConfigFileSize = Utils.getFileSize(LocalParameters.getDBConfigFilePath());
            if (lnConfigFileSize > 102400L) {
                System.out.println("Configuration File Too Large. File Size: " + lnConfigFileSize + " bytes, Maximum Size Allowed: " + 102400L + " bytes");
                return false;
            }
            MSGXMLFactory theMSGXMLFactory = new MSGXMLFactory();
            String strConfigFileXMLString = Utils.readFile(LocalParameters.getDBConfigFilePath());
            if (!theMSGXMLFactory.validateXML(strConfigFileXMLString, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='CONFIG'><xs:complexType><xs:sequence><xs:element name='DATABASE' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element name='TYPE' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='MySQL' /><xs:enumeration value='MicrosoftSQL' /><xs:enumeration value='Oracle' /><xs:enumeration value='PostgreSQL' /><xs:enumeration value='MicrosoftAccess' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:string' name='HOSTNAME' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='PORT' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='NAME' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='USERNAME' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='PASSWORD' maxOccurs='1' minOccurs='1'/><xs:element name='PASSWORD_TYPE' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='CLEARTEXT' /><xs:enumeration value='ENCRYPTED' /></xs:restriction></xs:simpleType></xs:element></xs:sequence></xs:complexType></xs:element><xs:element name='TABLES' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element name='CLIENT_WEB_SERVERS_PARAMETERS_TABLE' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/></xs:sequence></xs:complexType></xs:element><xs:element name='CLIENT_PARAMETERS_TABLE' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/><xs:element type='xs:unsignedLong' name='PARAMETERS_ID_FIELD_VALUE' maxOccurs='1' minOccurs='1'/></xs:sequence></xs:complexType></xs:element><xs:element name='MT_MSG_TABLE' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_PRODUCT_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='APPLY_TRANSACTION_CHARGE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_STATUS_CODE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_STATUS_DESCRIPTION_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_STATUS_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SENDER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='RECEIVER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_TYPE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_SOURCE_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_DESTINATION_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_PRIORITY_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_SEND_COUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_SEND_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_RESPONSE_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_RESPONSE_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_RESPONSE_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SCHEDULE_MSG_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_SCHEDULED_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_CREATED_FIELD' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='STATUS' use='required'/></xs:complexType></xs:element><xs:element name='MO_MSG_TABLE' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_PRODUCT_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='APPLY_TRANSACTION_CHARGE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_STATUS_CODE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_STATUS_DESCRIPTION_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_STATUS_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SENDER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='RECEIVER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_TYPE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_SOURCE_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_DESTINATION_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_PRIORITY_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_SEND_COUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_SEND_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_RESPONSE_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_RESPONSE_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='MSG_RESPONSE_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SCHEDULE_MSG_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_SCHEDULED_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_CREATED_FIELD' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='STATUS' use='required'/></xs:complexType></xs:element></xs:sequence></xs:complexType></xs:element></xs:sequence></xs:complexType></xs:element></xs:schema>")) {
                System.err.println("Configuration XML File is NOT VALID.");
                return false;
            }
            InputSource source = new InputSource(new StringReader(strConfigFileXMLString));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objConfig = configXPath.evaluate("/CONFIG", xmlDocument, XPathConstants.NODE);
            Constants.DatabaseType enDatabaseType = null;
            String strDatabaseType = configXPath.evaluate("DATABASE/TYPE", objConfig).trim();
            Constants.DatabaseType[] databaseTypeArray = Constants.DatabaseType.values();
            int n = databaseTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constants.DatabaseType databaseType = databaseTypeArray[n2];
                if (strDatabaseType.equalsIgnoreCase(databaseType.getValue())) {
                    enDatabaseType = databaseType;
                }
                ++n2;
            }
            String strDatabaseHostName = configXPath.evaluate("DATABASE/HOSTNAME", objConfig).trim();
            int intDatabasePort = Integer.parseInt(configXPath.evaluate("DATABASE/PORT", objConfig).trim());
            String strDatabaseName = configXPath.evaluate("DATABASE/NAME", objConfig).trim();
            String strDatabaseUsername = configXPath.evaluate("DATABASE/USERNAME", objConfig).trim();
            String strDatabasePassword = configXPath.evaluate("DATABASE/PASSWORD", objConfig).trim();
            Constants.PasswordType enDatabasePasswordType = null;
            String strDatabasePasswordType = configXPath.evaluate("DATABASE/PASSWORD_TYPE", objConfig).trim();
            Constants.PasswordType[] passwordTypeArray = Constants.PasswordType.values();
            int n3 = passwordTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Constants.PasswordType databasePasswordType = passwordTypeArray[n4];
                if (strDatabasePasswordType.equalsIgnoreCase(databasePasswordType.getValue())) {
                    enDatabasePasswordType = databasePasswordType;
                }
                ++n4;
            }
            String strClientWebServersParametersTableName = configXPath.evaluate("TABLES/CLIENT_WEB_SERVERS_PARAMETERS_TABLE/TABLE_NAME", objConfig).trim();
            String strClientParametersTableName = configXPath.evaluate("TABLES/CLIENT_PARAMETERS_TABLE/TABLE_NAME", objConfig).trim();
            int intParametersID = Integer.parseInt(configXPath.evaluate("TABLES/CLIENT_PARAMETERS_TABLE/PARAMETERS_ID_FIELD_VALUE", objConfig).trim());
            strClientWebServersParametersTableName = strClientWebServersParametersTableName.length() > 0 ? strClientWebServersParametersTableName : LocalParameters.getClientWebServersParametersTableName();
            String string = strClientParametersTableName = strClientParametersTableName.length() > 0 ? strClientParametersTableName : LocalParameters.getClientParametersTableName();
            if (!enDatabasePasswordType.getValue().equalsIgnoreCase(Constants.PasswordType.ENCRYPTED.getValue())) {
                System.out.println("\nEncrypting Database Password ...\n");
                theCrypto = new Crypto();
                String strDatabasePassword_ENCRYPTED = theCrypto.encrypt(Constants.strKey, strDatabasePassword);
                Element elDatabasePassword = (Element)configXPath.evaluate("DATABASE/PASSWORD", objConfig, XPathConstants.NODE);
                elDatabasePassword.setTextContent(strDatabasePassword_ENCRYPTED);
                Element elDatabasePasswordType = (Element)configXPath.evaluate("DATABASE/PASSWORD_TYPE", objConfig, XPathConstants.NODE);
                elDatabasePasswordType.setTextContent(Constants.PasswordType.ENCRYPTED.getValue());
                if (!Utils.writeFile(LocalParameters.getDBConfigFilePath(), theMSGXMLFactory.convertDocumentToString(xmlDocument, false))) {
                    System.out.println("\nParameter File Password Protection FAILED!\n");
                    return false;
                }
                System.out.println("\nParameter File Password Protected Successfully\n");
                enDatabasePasswordType = Constants.PasswordType.ENCRYPTED;
            } else {
                System.out.println("\nDatabase Password is Protected\n");
                theCrypto = new Crypto();
                strDatabasePassword = theCrypto.decrypt(Constants.strKey, strDatabasePassword);
            }
            System.out.println("\nDatabase Config File Parameters ... ");
            LocalParameters.setDatabaseType(enDatabaseType);
            LocalParameters.setDatabaseHostName(strDatabaseHostName);
            LocalParameters.setDatabasePort(intDatabasePort);
            LocalParameters.setDatabaseName(strDatabaseName);
            LocalParameters.setDatabaseUsername(strDatabaseUsername);
            LocalParameters.setDatabasePassword(strDatabasePassword);
            LocalParameters.setDatabasePasswordType(enDatabasePasswordType);
            LocalParameters.setClientWebServersParametersTableName(strClientWebServersParametersTableName);
            LocalParameters.setClientParametersTableName(strClientParametersTableName);
            LocalParameters.setParametersID(intParametersID);
            System.out.println("Database Type             : " + (Object)((Object)LocalParameters.getDatabaseType()));
            System.out.println("Database Host Name        : " + LocalParameters.getDatabaseHostName());
            System.out.println("Database Port             : " + LocalParameters.getDatabasePort());
            System.out.println("Database Name             : " + LocalParameters.getDatabaseName());
            System.out.println("Database Username         : " + LocalParameters.getDatabaseUsername());
            System.out.println("Database Password (Hidden): ******");
            System.out.println("Database Password Type    : " + (Object)((Object)LocalParameters.getDatabasePasswordType()));
            System.out.println();
            System.out.println("Client Web Servers Parameters Table Name       : " + LocalParameters.getClientWebServersParametersTableName());
            System.out.println("Client Parameters Table Name                   : " + LocalParameters.getClientParametersTableName());
            System.out.println("Parameters ID                                  : " + LocalParameters.getParametersID());
            System.out.println();
            System.out.println("");
            LocalParameters.setMTMSGTableStatus(CofigFile.setMTMSGTable(configXPath, objConfig));
            System.out.println("");
            LocalParameters.setMOMSGTableStatus(CofigFile.setMOMSGTable(configXPath, objConfig));
            System.out.println("*********************************************************\n");
            return true;
        }
        catch (Exception e) {
            System.err.println("An error has occured!!!\n" + e.toString());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setMTMSGTable(XPath configXPath, Object objConfig) {
        String strMSGTableName;
        block5: {
            block4: {
                try {
                    strMSGTableName = configXPath.evaluate("TABLES/MT_MSG_TABLE/TABLE_NAME", objConfig).trim();
                    if (strMSGTableName.length() != 0 && !strMSGTableName.isEmpty()) break block4;
                    System.out.println("MT_MSG_TABLE Name NOT Provided");
                    return false;
                }
                catch (Exception e) {
                    System.err.println("setMTMSGTable: An error has occured!!!\n" + e.toString());
                    e.printStackTrace();
                    return false;
                }
            }
            String strTableStatus = configXPath.evaluate("TABLES/MT_MSG_TABLE/@STATUS", objConfig).trim();
            if (strTableStatus.equalsIgnoreCase(Constants.Status.ACTIVE.getValue())) break block5;
            System.out.println("MT_MSG_TABLE STATUS NOT ACTIVE");
            return false;
        }
        String strMSGTableFieldTransactionID = configXPath.evaluate("TABLES/MT_MSG_TABLE/TRANSACTION_ID_FIELD", objConfig).trim();
        String strMSGTableFieldMSGID = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_ID_FIELD", objConfig).trim();
        String strMSGTableFieldMSGProductID = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_PRODUCT_ID_FIELD", objConfig).trim();
        String strMSGTableFieldApplyTransactionCharge = configXPath.evaluate("TABLES/MT_MSG_TABLE/APPLY_TRANSACTION_CHARGE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGStatusCode = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_STATUS_CODE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGStatusDescription = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_STATUS_DESCRIPTION_FIELD", objConfig).trim();
        String strMSGTableFieldMSGStatusDate = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_STATUS_DATE_FIELD", objConfig).trim();
        String strMSGTableFieldSender = configXPath.evaluate("TABLES/MT_MSG_TABLE/SENDER_FIELD", objConfig).trim();
        String strMSGTableFieldReceiver = configXPath.evaluate("TABLES/MT_MSG_TABLE/RECEIVER_FIELD", objConfig).trim();
        String strMSGTableFieldMSG = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_FIELD", objConfig).trim();
        String strMSGTableFieldMSGType = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_TYPE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGSourceReference = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_SOURCE_REFERENCE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGDestinationReference = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_DESTINATION_REFERENCE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGXMLData = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_XML_DATA_FIELD", objConfig).trim();
        String strMSGTableFieldMSGPriority = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_PRIORITY_FIELD", objConfig).trim();
        String strMSGTableFieldMSGSendCount = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_SEND_COUNT_FIELD", objConfig).trim();
        String strMSGTableFieldDateScheduled = configXPath.evaluate("TABLES/MT_MSG_TABLE/DATE_SCHEDULED_FIELD", objConfig).trim();
        String strMSGTableFieldSendIntegrityHash = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_SEND_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strMSGTableFieldResponseDate = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_RESPONSE_DATE_FIELD", objConfig).trim();
        String strMSGTableFieldResponseXMLData = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_RESPONSE_XML_DATA_FIELD", objConfig).trim();
        String strMSGTableFieldResponseIntegrityHash = configXPath.evaluate("TABLES/MT_MSG_TABLE/MSG_RESPONSE_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strMSGTableFieldScheduleMSG = configXPath.evaluate("TABLES/MT_MSG_TABLE/SCHEDULE_MSG_FIELD", objConfig).trim();
        String strMSGTableFieldTransactionDate = configXPath.evaluate("TABLES/MT_MSG_TABLE/TRANSACTION_DATE_FIELD", objConfig).trim();
        String strMSGTableFieldDateCreated = configXPath.evaluate("TABLES/MT_MSG_TABLE/DATE_CREATED_FIELD", objConfig).trim();
        MTMSGTable theMTMSGTable = new MTMSGTable();
        strMSGTableName = strMSGTableName.length() > 0 ? strMSGTableName : theMTMSGTable.getMSGTableName();
        strMSGTableFieldTransactionID = strMSGTableFieldTransactionID.length() > 0 ? strMSGTableFieldTransactionID : theMTMSGTable.getMSGTableFieldTransactionID();
        strMSGTableFieldMSGID = strMSGTableFieldMSGID.length() > 0 ? strMSGTableFieldMSGID : theMTMSGTable.getMSGTableFieldMSGID();
        strMSGTableFieldMSGProductID = strMSGTableFieldMSGProductID.length() > 0 ? strMSGTableFieldMSGProductID : theMTMSGTable.getMSGTableFieldMSGProductID();
        strMSGTableFieldMSGStatusCode = strMSGTableFieldMSGStatusCode.length() > 0 ? strMSGTableFieldMSGStatusCode : theMTMSGTable.getMSGTableFieldMSGStatusCode();
        strMSGTableFieldMSGStatusDescription = strMSGTableFieldMSGStatusDescription.length() > 0 ? strMSGTableFieldMSGStatusDescription : theMTMSGTable.getMSGTableFieldMSGStatusDescription();
        strMSGTableFieldMSGStatusDate = strMSGTableFieldMSGStatusDate.length() > 0 ? strMSGTableFieldMSGStatusDate : theMTMSGTable.getMSGTableFieldMSGStatusDate();
        strMSGTableFieldSender = strMSGTableFieldSender.length() > 0 ? strMSGTableFieldSender : theMTMSGTable.getMSGTableFieldSender();
        strMSGTableFieldReceiver = strMSGTableFieldReceiver.length() > 0 ? strMSGTableFieldReceiver : theMTMSGTable.getMSGTableFieldReceiver();
        strMSGTableFieldMSG = strMSGTableFieldMSG.length() > 0 ? strMSGTableFieldMSG : theMTMSGTable.getMSGTableFieldMSG();
        strMSGTableFieldMSGType = strMSGTableFieldMSGType.length() > 0 ? strMSGTableFieldMSGType : theMTMSGTable.getMSGTableFieldMSGType();
        strMSGTableFieldMSGSourceReference = strMSGTableFieldMSGSourceReference.length() > 0 ? strMSGTableFieldMSGSourceReference : theMTMSGTable.getMSGTableFieldMSGSourceReference();
        strMSGTableFieldMSGDestinationReference = strMSGTableFieldMSGDestinationReference.length() > 0 ? strMSGTableFieldMSGDestinationReference : theMTMSGTable.getMSGTableFieldMSGDestinationReference();
        strMSGTableFieldMSGXMLData = strMSGTableFieldMSGXMLData.length() > 0 ? strMSGTableFieldMSGXMLData : theMTMSGTable.getMSGTableFieldMSGXMLData();
        strMSGTableFieldMSGPriority = strMSGTableFieldMSGPriority.length() > 0 ? strMSGTableFieldMSGPriority : theMTMSGTable.getMSGTableFieldMSGPriority();
        strMSGTableFieldMSGSendCount = strMSGTableFieldMSGSendCount.length() > 0 ? strMSGTableFieldMSGSendCount : theMTMSGTable.getMSGTableFieldMSGSendCount();
        strMSGTableFieldSendIntegrityHash = strMSGTableFieldSendIntegrityHash.length() > 0 ? strMSGTableFieldSendIntegrityHash : theMTMSGTable.getMSGTableFieldSendIntegrityHash();
        strMSGTableFieldResponseDate = strMSGTableFieldResponseDate.length() > 0 ? strMSGTableFieldResponseDate : theMTMSGTable.getMSGTableFieldResponseDate();
        strMSGTableFieldResponseXMLData = strMSGTableFieldResponseXMLData.length() > 0 ? strMSGTableFieldResponseXMLData : theMTMSGTable.getMSGTableFieldResponseXMLData();
        strMSGTableFieldResponseIntegrityHash = strMSGTableFieldResponseIntegrityHash.length() > 0 ? strMSGTableFieldResponseIntegrityHash : theMTMSGTable.getMSGTableFieldResponseIntegrityHash();
        strMSGTableFieldScheduleMSG = strMSGTableFieldScheduleMSG.length() > 0 ? strMSGTableFieldScheduleMSG : theMTMSGTable.getMSGTableFieldScheduleMSG();
        strMSGTableFieldDateScheduled = strMSGTableFieldDateScheduled.length() > 0 ? strMSGTableFieldDateScheduled : theMTMSGTable.getMSGTableFieldDateScheduled();
        strMSGTableFieldApplyTransactionCharge = strMSGTableFieldApplyTransactionCharge.length() > 0 ? strMSGTableFieldApplyTransactionCharge : theMTMSGTable.getMSGTableFieldApplyTransactionCharge();
        strMSGTableFieldTransactionDate = strMSGTableFieldTransactionDate.length() > 0 ? strMSGTableFieldTransactionDate : theMTMSGTable.getMSGTableFieldTransactionDate();
        strMSGTableFieldDateCreated = strMSGTableFieldDateCreated.length() > 0 ? strMSGTableFieldDateCreated : theMTMSGTable.getMSGTableFieldDateCreated();
        theMTMSGTable.setMSGTableName(strMSGTableName);
        theMTMSGTable.setMSGTableFieldTransactionID(strMSGTableFieldTransactionID);
        theMTMSGTable.setMSGTableFieldMSGID(strMSGTableFieldMSGID);
        theMTMSGTable.setMSGTableFieldMSGProductID(strMSGTableFieldMSGProductID);
        theMTMSGTable.setMSGTableFieldMSGStatusCode(strMSGTableFieldMSGStatusCode);
        theMTMSGTable.setMSGTableFieldMSGStatusDescription(strMSGTableFieldMSGStatusDescription);
        theMTMSGTable.setMSGTableFieldMSGStatusDate(strMSGTableFieldMSGStatusDate);
        theMTMSGTable.setMSGTableFieldSender(strMSGTableFieldSender);
        theMTMSGTable.setMSGTableFieldReceiver(strMSGTableFieldReceiver);
        theMTMSGTable.setMSGTableFieldMSG(strMSGTableFieldMSG);
        theMTMSGTable.setMSGTableFieldMSGType(strMSGTableFieldMSGType);
        theMTMSGTable.setMSGTableFieldMSGSourceReference(strMSGTableFieldMSGSourceReference);
        theMTMSGTable.setMSGTableFieldMSGDestinationReference(strMSGTableFieldMSGDestinationReference);
        theMTMSGTable.setMSGTableFieldMSGXMLData(strMSGTableFieldMSGXMLData);
        theMTMSGTable.setMSGTableFieldMSGPriority(strMSGTableFieldMSGPriority);
        theMTMSGTable.setMSGTableFieldMSGSendCount(strMSGTableFieldMSGSendCount);
        theMTMSGTable.setMSGTableFieldSendIntegrityHash(strMSGTableFieldSendIntegrityHash);
        theMTMSGTable.setMSGTableFieldResponseDate(strMSGTableFieldResponseDate);
        theMTMSGTable.setMSGTableFieldResponseXMLData(strMSGTableFieldResponseXMLData);
        theMTMSGTable.setMSGTableFieldResponseIntegrityHash(strMSGTableFieldResponseIntegrityHash);
        theMTMSGTable.setMSGTableFieldScheduleMSG(strMSGTableFieldScheduleMSG);
        theMTMSGTable.setMSGTableFieldDateScheduled(strMSGTableFieldDateScheduled);
        theMTMSGTable.setMSGTableFieldApplyTransactionCharge(strMSGTableFieldApplyTransactionCharge);
        theMTMSGTable.setMSGTableFieldTransactionDate(strMSGTableFieldTransactionDate);
        theMTMSGTable.setMSGTableFieldDateCreated(strMSGTableFieldDateCreated);
        System.out.println("MT MSG Table Name                           : " + theMTMSGTable.getMSGTableName());
        System.out.println("MT MSG Table Field Transaction ID           : " + theMTMSGTable.getMSGTableFieldTransactionID());
        System.out.println("MT MSG Table Field MSG ID                   : " + theMTMSGTable.getMSGTableFieldMSGID());
        System.out.println("MT MSG Table Field MSG Product ID           : " + theMTMSGTable.getMSGTableFieldMSGProductID());
        System.out.println("MT MSG Table Field Apply Transaction Charge : " + theMTMSGTable.getMSGTableFieldApplyTransactionCharge());
        System.out.println("MT MSG Table Field MSG Status Code          : " + theMTMSGTable.getMSGTableFieldMSGStatusCode());
        System.out.println("MT MSG Table Field MSG Status Description   : " + theMTMSGTable.getMSGTableFieldMSGStatusDescription());
        System.out.println("MT MSG Table Field MSG Status Date          : " + theMTMSGTable.getMSGTableFieldMSGStatusDate());
        System.out.println("MT MSG Table Field Sender                   : " + theMTMSGTable.getMSGTableFieldSender());
        System.out.println("MT MSG Table Field Receiver                 : " + theMTMSGTable.getMSGTableFieldReceiver());
        System.out.println("MT MSG Table Field MSG                      : " + theMTMSGTable.getMSGTableFieldMSG());
        System.out.println("MT MSG Table Field MSG Type                 : " + theMTMSGTable.getMSGTableFieldMSGType());
        System.out.println("MT MSG Table Field MSG Source Reference     : " + theMTMSGTable.getMSGTableFieldMSGSourceReference());
        System.out.println("MT MSG Table Field MSG Destination Reference: " + theMTMSGTable.getMSGTableFieldMSGDestinationReference());
        System.out.println("MT MSG Table Field MSG XML Data             : " + theMTMSGTable.getMSGTableFieldMSGXMLData());
        System.out.println("MT MSG Table Field MSG Priority             : " + theMTMSGTable.getMSGTableFieldMSGPriority());
        System.out.println("MT MSG Table Field MSG Send Count           : " + theMTMSGTable.getMSGTableFieldMSGSendCount());
        System.out.println("MT MSG Table Field Send Integrity Hash      : " + theMTMSGTable.getMSGTableFieldSendIntegrityHash());
        System.out.println("MT MSG Table Field Response Date            : " + theMTMSGTable.getMSGTableFieldResponseDate());
        System.out.println("MT MSG Table Field Response XML Data        : " + theMTMSGTable.getMSGTableFieldResponseXMLData());
        System.out.println("MT MSG Table Field Response Integrity Hash  : " + theMTMSGTable.getMSGTableFieldResponseIntegrityHash());
        System.out.println("MT MSG Table Field Schedule MSG             : " + theMTMSGTable.getMSGTableFieldScheduleMSG());
        System.out.println("MT MSG Table Field Date Scheduled           : " + theMTMSGTable.getMSGTableFieldDateScheduled());
        System.out.println("MT MSG Table Field Transaction Date         : " + theMTMSGTable.getMSGTableFieldTransactionDate());
        System.out.println("MT MSG Table Field Date Created             : " + theMTMSGTable.getMSGTableFieldDateCreated());
        return true;
    }

    public static boolean setMOMSGTable(XPath configXPath, Object objConfig) {
        String strMSGTableName;
        block5: {
            block4: {
                try {
                    strMSGTableName = configXPath.evaluate("TABLES/MO_MSG_TABLE/TABLE_NAME", objConfig).trim();
                    if (strMSGTableName.length() != 0 && !strMSGTableName.isEmpty()) break block4;
                    System.out.println("MO_MSG_TABLE Name NOT Provided");
                    return false;
                }
                catch (Exception e) {
                    System.err.println("setMOMSGTable: An error has occured!!!\n" + e.toString());
                    e.printStackTrace();
                    return false;
                }
            }
            String strTableStatus = configXPath.evaluate("TABLES/MO_MSG_TABLE/@STATUS", objConfig).trim();
            if (strTableStatus.equalsIgnoreCase(Constants.Status.ACTIVE.getValue())) break block5;
            System.out.println("MO_MSG_TABLE STATUS NOT ACTIVE");
            return false;
        }
        String strMSGTableFieldTransactionID = configXPath.evaluate("TABLES/MO_MSG_TABLE/TRANSACTION_ID_FIELD", objConfig).trim();
        String strMSGTableFieldMSGID = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_ID_FIELD", objConfig).trim();
        String strMSGTableFieldMSGProductID = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_PRODUCT_ID_FIELD", objConfig).trim();
        String strMSGTableFieldApplyTransactionCharge = configXPath.evaluate("TABLES/MO_MSG_TABLE/APPLY_TRANSACTION_CHARGE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGStatusCode = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_STATUS_CODE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGStatusDescription = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_STATUS_DESCRIPTION_FIELD", objConfig).trim();
        String strMSGTableFieldMSGStatusDate = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_STATUS_DATE_FIELD", objConfig).trim();
        String strMSGTableFieldSender = configXPath.evaluate("TABLES/MO_MSG_TABLE/SENDER_FIELD", objConfig).trim();
        String strMSGTableFieldReceiver = configXPath.evaluate("TABLES/MO_MSG_TABLE/RECEIVER_FIELD", objConfig).trim();
        String strMSGTableFieldMSG = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_FIELD", objConfig).trim();
        String strMSGTableFieldMSGType = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_TYPE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGSourceReference = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_SOURCE_REFERENCE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGDestinationReference = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_DESTINATION_REFERENCE_FIELD", objConfig).trim();
        String strMSGTableFieldMSGXMLData = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_XML_DATA_FIELD", objConfig).trim();
        String strMSGTableFieldMSGPriority = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_PRIORITY_FIELD", objConfig).trim();
        String strMSGTableFieldMSGSendCount = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_SEND_COUNT_FIELD", objConfig).trim();
        String strMSGTableFieldDateScheduled = configXPath.evaluate("TABLES/MO_MSG_TABLE/DATE_SCHEDULED_FIELD", objConfig).trim();
        String strMSGTableFieldSendIntegrityHash = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_SEND_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strMSGTableFieldResponseDate = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_RESPONSE_DATE_FIELD", objConfig).trim();
        String strMSGTableFieldResponseXMLData = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_RESPONSE_XML_DATA_FIELD", objConfig).trim();
        String strMSGTableFieldResponseIntegrityHash = configXPath.evaluate("TABLES/MO_MSG_TABLE/MSG_RESPONSE_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strMSGTableFieldScheduleMSG = configXPath.evaluate("TABLES/MO_MSG_TABLE/SCHEDULE_MSG_FIELD", objConfig).trim();
        String strMSGTableFieldTransactionDate = configXPath.evaluate("TABLES/MO_MSG_TABLE/TRANSACTION_DATE_FIELD", objConfig).trim();
        String strMSGTableFieldDateCreated = configXPath.evaluate("TABLES/MO_MSG_TABLE/DATE_CREATED_FIELD", objConfig).trim();
        MOMSGTable theMOMSGTable = new MOMSGTable();
        strMSGTableName = strMSGTableName.length() > 0 ? strMSGTableName : theMOMSGTable.getMSGTableName();
        strMSGTableFieldTransactionID = strMSGTableFieldTransactionID.length() > 0 ? strMSGTableFieldTransactionID : theMOMSGTable.getMSGTableFieldTransactionID();
        strMSGTableFieldMSGID = strMSGTableFieldMSGID.length() > 0 ? strMSGTableFieldMSGID : theMOMSGTable.getMSGTableFieldMSGID();
        strMSGTableFieldMSGProductID = strMSGTableFieldMSGProductID.length() > 0 ? strMSGTableFieldMSGProductID : theMOMSGTable.getMSGTableFieldMSGProductID();
        strMSGTableFieldMSGStatusCode = strMSGTableFieldMSGStatusCode.length() > 0 ? strMSGTableFieldMSGStatusCode : theMOMSGTable.getMSGTableFieldMSGStatusCode();
        strMSGTableFieldMSGStatusDescription = strMSGTableFieldMSGStatusDescription.length() > 0 ? strMSGTableFieldMSGStatusDescription : theMOMSGTable.getMSGTableFieldMSGStatusDescription();
        strMSGTableFieldMSGStatusDate = strMSGTableFieldMSGStatusDate.length() > 0 ? strMSGTableFieldMSGStatusDate : theMOMSGTable.getMSGTableFieldMSGStatusDate();
        strMSGTableFieldSender = strMSGTableFieldSender.length() > 0 ? strMSGTableFieldSender : theMOMSGTable.getMSGTableFieldSender();
        strMSGTableFieldReceiver = strMSGTableFieldReceiver.length() > 0 ? strMSGTableFieldReceiver : theMOMSGTable.getMSGTableFieldReceiver();
        strMSGTableFieldMSG = strMSGTableFieldMSG.length() > 0 ? strMSGTableFieldMSG : theMOMSGTable.getMSGTableFieldMSG();
        strMSGTableFieldMSGType = strMSGTableFieldMSGType.length() > 0 ? strMSGTableFieldMSGType : theMOMSGTable.getMSGTableFieldMSGType();
        strMSGTableFieldMSGSourceReference = strMSGTableFieldMSGSourceReference.length() > 0 ? strMSGTableFieldMSGSourceReference : theMOMSGTable.getMSGTableFieldMSGSourceReference();
        strMSGTableFieldMSGDestinationReference = strMSGTableFieldMSGDestinationReference.length() > 0 ? strMSGTableFieldMSGDestinationReference : theMOMSGTable.getMSGTableFieldMSGDestinationReference();
        strMSGTableFieldMSGXMLData = strMSGTableFieldMSGXMLData.length() > 0 ? strMSGTableFieldMSGXMLData : theMOMSGTable.getMSGTableFieldMSGXMLData();
        strMSGTableFieldMSGPriority = strMSGTableFieldMSGPriority.length() > 0 ? strMSGTableFieldMSGPriority : theMOMSGTable.getMSGTableFieldMSGPriority();
        strMSGTableFieldMSGSendCount = strMSGTableFieldMSGSendCount.length() > 0 ? strMSGTableFieldMSGSendCount : theMOMSGTable.getMSGTableFieldMSGSendCount();
        strMSGTableFieldSendIntegrityHash = strMSGTableFieldSendIntegrityHash.length() > 0 ? strMSGTableFieldSendIntegrityHash : theMOMSGTable.getMSGTableFieldSendIntegrityHash();
        strMSGTableFieldResponseDate = strMSGTableFieldResponseDate.length() > 0 ? strMSGTableFieldResponseDate : theMOMSGTable.getMSGTableFieldResponseDate();
        strMSGTableFieldResponseXMLData = strMSGTableFieldResponseXMLData.length() > 0 ? strMSGTableFieldResponseXMLData : theMOMSGTable.getMSGTableFieldResponseXMLData();
        strMSGTableFieldResponseIntegrityHash = strMSGTableFieldResponseIntegrityHash.length() > 0 ? strMSGTableFieldResponseIntegrityHash : theMOMSGTable.getMSGTableFieldResponseIntegrityHash();
        strMSGTableFieldScheduleMSG = strMSGTableFieldScheduleMSG.length() > 0 ? strMSGTableFieldScheduleMSG : theMOMSGTable.getMSGTableFieldScheduleMSG();
        strMSGTableFieldDateScheduled = strMSGTableFieldDateScheduled.length() > 0 ? strMSGTableFieldDateScheduled : theMOMSGTable.getMSGTableFieldDateScheduled();
        strMSGTableFieldApplyTransactionCharge = strMSGTableFieldApplyTransactionCharge.length() > 0 ? strMSGTableFieldApplyTransactionCharge : theMOMSGTable.getMSGTableFieldApplyTransactionCharge();
        strMSGTableFieldTransactionDate = strMSGTableFieldTransactionDate.length() > 0 ? strMSGTableFieldTransactionDate : theMOMSGTable.getMSGTableFieldTransactionDate();
        strMSGTableFieldDateCreated = strMSGTableFieldDateCreated.length() > 0 ? strMSGTableFieldDateCreated : theMOMSGTable.getMSGTableFieldDateCreated();
        theMOMSGTable.setMSGTableName(strMSGTableName);
        theMOMSGTable.setMSGTableFieldTransactionID(strMSGTableFieldTransactionID);
        theMOMSGTable.setMSGTableFieldMSGID(strMSGTableFieldMSGID);
        theMOMSGTable.setMSGTableFieldMSGProductID(strMSGTableFieldMSGProductID);
        theMOMSGTable.setMSGTableFieldMSGStatusCode(strMSGTableFieldMSGStatusCode);
        theMOMSGTable.setMSGTableFieldMSGStatusDescription(strMSGTableFieldMSGStatusDescription);
        theMOMSGTable.setMSGTableFieldMSGStatusDate(strMSGTableFieldMSGStatusDate);
        theMOMSGTable.setMSGTableFieldSender(strMSGTableFieldSender);
        theMOMSGTable.setMSGTableFieldReceiver(strMSGTableFieldReceiver);
        theMOMSGTable.setMSGTableFieldMSG(strMSGTableFieldMSG);
        theMOMSGTable.setMSGTableFieldMSGType(strMSGTableFieldMSGType);
        theMOMSGTable.setMSGTableFieldMSGSourceReference(strMSGTableFieldMSGSourceReference);
        theMOMSGTable.setMSGTableFieldMSGDestinationReference(strMSGTableFieldMSGDestinationReference);
        theMOMSGTable.setMSGTableFieldMSGXMLData(strMSGTableFieldMSGXMLData);
        theMOMSGTable.setMSGTableFieldMSGPriority(strMSGTableFieldMSGPriority);
        theMOMSGTable.setMSGTableFieldMSGSendCount(strMSGTableFieldMSGSendCount);
        theMOMSGTable.setMSGTableFieldSendIntegrityHash(strMSGTableFieldSendIntegrityHash);
        theMOMSGTable.setMSGTableFieldResponseDate(strMSGTableFieldResponseDate);
        theMOMSGTable.setMSGTableFieldResponseXMLData(strMSGTableFieldResponseXMLData);
        theMOMSGTable.setMSGTableFieldResponseIntegrityHash(strMSGTableFieldResponseIntegrityHash);
        theMOMSGTable.setMSGTableFieldScheduleMSG(strMSGTableFieldScheduleMSG);
        theMOMSGTable.setMSGTableFieldDateScheduled(strMSGTableFieldDateScheduled);
        theMOMSGTable.setMSGTableFieldApplyTransactionCharge(strMSGTableFieldApplyTransactionCharge);
        theMOMSGTable.setMSGTableFieldTransactionDate(strMSGTableFieldTransactionDate);
        theMOMSGTable.setMSGTableFieldDateCreated(strMSGTableFieldDateCreated);
        System.out.println("MO MSG Table Name                           : " + theMOMSGTable.getMSGTableName());
        System.out.println("MO MSG Table Field Transaction ID           : " + theMOMSGTable.getMSGTableFieldTransactionID());
        System.out.println("MO MSG Table Field MSG ID                   : " + theMOMSGTable.getMSGTableFieldMSGID());
        System.out.println("MO MSG Table Field MSG Product ID           : " + theMOMSGTable.getMSGTableFieldMSGProductID());
        System.out.println("MO MSG Table Field Apply Transaction Charge : " + theMOMSGTable.getMSGTableFieldApplyTransactionCharge());
        System.out.println("MO MSG Table Field MSG Status Code          : " + theMOMSGTable.getMSGTableFieldMSGStatusCode());
        System.out.println("MO MSG Table Field MSG Status Description   : " + theMOMSGTable.getMSGTableFieldMSGStatusDescription());
        System.out.println("MO MSG Table Field MSG Status Date          : " + theMOMSGTable.getMSGTableFieldMSGStatusDate());
        System.out.println("MO MSG Table Field Sender                   : " + theMOMSGTable.getMSGTableFieldSender());
        System.out.println("MO MSG Table Field Receiver                 : " + theMOMSGTable.getMSGTableFieldReceiver());
        System.out.println("MO MSG Table Field MSG                      : " + theMOMSGTable.getMSGTableFieldMSG());
        System.out.println("MO MSG Table Field MSG Type                 : " + theMOMSGTable.getMSGTableFieldMSGType());
        System.out.println("MO MSG Table Field MSG Source Reference     : " + theMOMSGTable.getMSGTableFieldMSGSourceReference());
        System.out.println("MO MSG Table Field MSG Destination Reference: " + theMOMSGTable.getMSGTableFieldMSGDestinationReference());
        System.out.println("MO MSG Table Field MSG XML Data             : " + theMOMSGTable.getMSGTableFieldMSGXMLData());
        System.out.println("MO MSG Table Field MSG Priority             : " + theMOMSGTable.getMSGTableFieldMSGPriority());
        System.out.println("MO MSG Table Field MSG Send Count           : " + theMOMSGTable.getMSGTableFieldMSGSendCount());
        System.out.println("MO MSG Table Field Send Integrity Hash      : " + theMOMSGTable.getMSGTableFieldSendIntegrityHash());
        System.out.println("MO MSG Table Field Response Date            : " + theMOMSGTable.getMSGTableFieldResponseDate());
        System.out.println("MO MSG Table Field Response XML Data        : " + theMOMSGTable.getMSGTableFieldResponseXMLData());
        System.out.println("MO MSG Table Field Response Integrity Hash  : " + theMOMSGTable.getMSGTableFieldResponseIntegrityHash());
        System.out.println("MO MSG Table Field Schedule MSG             : " + theMOMSGTable.getMSGTableFieldScheduleMSG());
        System.out.println("MO MSG Table Field Date Scheduled           : " + theMOMSGTable.getMSGTableFieldDateScheduled());
        System.out.println("MO MSG Table Field Transaction Date         : " + theMOMSGTable.getMSGTableFieldTransactionDate());
        System.out.println("MO MSG Table Field Date Created             : " + theMOMSGTable.getMSGTableFieldDateCreated());
        return true;
    }
}

