/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.security.util.HostnameChecker;

public class HTTPSClient {
    public String httpsGet(String theHttpsURL, int intConnectionTimeoutSeconds) {
        String returnString = "";
        URL theURL = null;
        HttpURLConnection conn = null;
        InputStream ins = null;
        InputStreamReader isr = null;
        BufferedReader rd = null;
        try {
            try {
                theURL = new URL(theHttpsURL);
                conn = (HttpsURLConnection)theURL.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("GET");
                conn.setRequestProperty("charset", "utf-8");
                conn.setUseCaches(false);
                conn.setConnectTimeout(intConnectionTimeoutSeconds * 1000);
                conn.setReadTimeout(intConnectionTimeoutSeconds * 1000);
                conn.connect();
                ins = conn.getInputStream();
                isr = new InputStreamReader(ins);
                rd = new BufferedReader(isr);
                returnString = "";
                String line = "";
                while ((line = rd.readLine()) != null) {
                    returnString = String.valueOf(returnString) + line;
                }
                rd.close();
            }
            catch (Exception e) {
                System.out.println("Error on httpsGet(): " + e.getMessage());
                returnString = null;
                conn.disconnect();
                theURL = null;
                conn = null;
                ins = null;
                isr = null;
                rd = null;
            }
        }
        finally {
            conn.disconnect();
            theURL = null;
            conn = null;
            ins = null;
            isr = null;
            rd = null;
        }
        return returnString;
    }

    public String httpsPost(String theHttpsURL, String theData, int intConnectionTimeoutSeconds) {
        String returnString = "";
        URL theURL = null;
        HttpURLConnection conn = null;
        InputStream ins = null;
        InputStreamReader isr = null;
        BufferedReader rd = null;
        try {
            try {
                theURL = new URL(theHttpsURL);
                conn = (HttpsURLConnection)theURL.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("charset", "utf-8");
                conn.setUseCaches(false);
                conn.setConnectTimeout(intConnectionTimeoutSeconds * 1000);
                conn.setReadTimeout(intConnectionTimeoutSeconds * 1000);
                conn.connect();
                DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                wr.writeBytes(theData);
                wr.flush();
                wr.close();
                ins = conn.getInputStream();
                isr = new InputStreamReader(ins);
                rd = new BufferedReader(isr);
                returnString = "";
                String line = "";
                while ((line = rd.readLine()) != null) {
                    returnString = String.valueOf(returnString) + line;
                }
                rd.close();
            }
            catch (Exception e) {
                System.out.println("Error on httpsPost(): " + e.getMessage());
                returnString = null;
                conn.disconnect();
                theURL = null;
                conn = null;
                ins = null;
                isr = null;
                rd = null;
            }
        }
        finally {
            conn.disconnect();
            theURL = null;
            conn = null;
            ins = null;
            isr = null;
            rd = null;
        }
        return returnString;
    }

    public String httpsPost(String theHttpsURL, String theData, int intConnectionTimeoutSeconds, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        String returnString = "";
        URL theURL = null;
        HttpURLConnection conn = null;
        InputStream ins = null;
        InputStreamReader isr = null;
        BufferedReader rd = null;
        try {
            try {
                theURL = new URL(theHttpsURL);
                conn = (HttpsURLConnection)theURL.openConnection();
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
                ((HttpsURLConnection)conn).setHostnameVerifier(hostnameVerifier);
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("charset", "utf-8");
                conn.setUseCaches(false);
                conn.setConnectTimeout(intConnectionTimeoutSeconds * 1000);
                conn.setReadTimeout(intConnectionTimeoutSeconds * 1000);
                conn.connect();
                DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                wr.writeBytes(theData);
                wr.flush();
                wr.close();
                ins = conn.getInputStream();
                isr = new InputStreamReader(ins);
                rd = new BufferedReader(isr);
                returnString = "";
                String line = "";
                while ((line = rd.readLine()) != null) {
                    returnString = String.valueOf(returnString) + line;
                }
                rd.close();
            }
            catch (Exception e) {
                System.out.println("Error on httpsPost(): " + e.getMessage());
                returnString = null;
                conn.disconnect();
                theURL = null;
                conn = null;
                ins = null;
                isr = null;
                rd = null;
            }
        }
        finally {
            conn.disconnect();
            theURL = null;
            conn = null;
            ins = null;
            isr = null;
            rd = null;
        }
        return returnString;
    }

    public SSLSocketFactory getPrivateCASSLSocketFactory(InputStream isCACertificate, String strCryptographicProtocol, boolean bValidateCertificateChain) {
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        SSLContext ctx = null;
        try {
            System.out.println("Getting Private CA SSL Socket Factory...");
            trustManagers = bValidateCertificateChain ? this.getTrustManagers("X509", isCACertificate) : this.getTrustManagersWithNoCertificateValidation();
            ctx = SSLContext.getInstance(strCryptographicProtocol);
            ctx.init(keyManagers, trustManagers, new SecureRandom());
        }
        catch (Exception e) {
            ctx = null;
        }
        return ctx != null ? ctx.getSocketFactory() : null;
    }

    public void setDefaultPrivateCA(String strCACertFilePath, String strCryptographicProtocol, boolean bValidateCertificateChain, boolean bVerifyHostname) {
        try {
            System.out.println("Set Default Private CA SSL Socket Factory...");
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            trustManagers = bValidateCertificateChain ? this.getTrustManagers("X509", new FileInputStream(new File(strCACertFilePath))) : this.getTrustManagersWithNoCertificateValidation();
            SSLContext ctx = SSLContext.getInstance(strCryptographicProtocol);
            ctx.init(keyManagers, trustManagers, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
            HostnameVerifier hv = this.verifyHostname(bVerifyHostname);
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SSLSocketFactory getPrivateCAWithClientAuthSSLSocketFactory(InputStream isClientCertificate, String strClientCertPassword, InputStream isCACertificate, String strCryptographicProtocol, boolean bValidateCertificateChain) {
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        SSLContext ctx = null;
        try {
            System.out.println("Getting Private CA with Client Authentication SSL Socket Factory...");
            keyManagers = this.getKeyManagers("PKCS12", isClientCertificate, strClientCertPassword);
            trustManagers = bValidateCertificateChain ? this.getTrustManagers("X509", isCACertificate) : this.getTrustManagersWithNoCertificateValidation();
            ctx = SSLContext.getInstance(strCryptographicProtocol);
            ctx.init(keyManagers, trustManagers, new SecureRandom());
        }
        catch (Exception e) {
            ctx = null;
        }
        return ctx != null ? ctx.getSocketFactory() : null;
    }

    public void setDefaultPrivateCAWithClientAuth(String strClientCertPath, String strClientCertPassword, String strCACertFilePath, String strCryptographicProtocol, boolean bValidateCertificateChain, boolean bVerifyHostname) {
        try {
            System.out.println("Set Default Private CA with Client Authentication SSL Socket Factory...");
            KeyManager[] keyManagers = this.getKeyManagers("PKCS12", new FileInputStream(new File(strClientCertPath)), strClientCertPassword);
            TrustManager[] trustManagers = null;
            trustManagers = bValidateCertificateChain ? this.getTrustManagers("X509", new FileInputStream(new File(strCACertFilePath))) : this.getTrustManagersWithNoCertificateValidation();
            SSLContext ctx = SSLContext.getInstance(strCryptographicProtocol);
            ctx.init(keyManagers, trustManagers, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
            HostnameVerifier hv = this.verifyHostname(bVerifyHostname);
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SSLSocketFactory getPublicCASSLSocketFactory(String strCryptographicProtocol, boolean bValidateCertificateChain) {
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        SSLContext ctx = null;
        try {
            System.out.println("Get Public CA SSL Socket Factory...");
            trustManagers = bValidateCertificateChain ? null : this.getTrustManagersWithNoCertificateValidation();
            ctx = SSLContext.getInstance(strCryptographicProtocol);
            ctx.init(keyManagers, trustManagers, new SecureRandom());
        }
        catch (Exception e) {
            ctx = null;
        }
        return ctx != null ? ctx.getSocketFactory() : null;
    }

    public void setDefaultPublicCA(String strCryptographicProtocol, boolean bValidateCertificateChain, boolean bVerifyHostname) {
        try {
            System.out.println("Set Default Public CA SSL Socket Factory...");
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            trustManagers = bValidateCertificateChain ? null : this.getTrustManagersWithNoCertificateValidation();
            SSLContext ctx = SSLContext.getInstance(strCryptographicProtocol);
            ctx.init(keyManagers, trustManagers, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
            HostnameVerifier hv = this.verifyHostname(bVerifyHostname);
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SSLSocketFactory getPublicCAWithClientAuthSSLSocketFactory(InputStream isClientCertificate, String strClientCertPassword, String strCryptographicProtocol, boolean bValidateCertificateChain) {
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        SSLContext ctx = null;
        try {
            System.out.println("Get Public CA with Client Authentication SSL Socket Factory...");
            keyManagers = this.getKeyManagers("PKCS12", isClientCertificate, strClientCertPassword);
            trustManagers = bValidateCertificateChain ? null : this.getTrustManagersWithNoCertificateValidation();
            ctx = SSLContext.getInstance(strCryptographicProtocol);
            ctx.init(keyManagers, trustManagers, new SecureRandom());
        }
        catch (Exception e) {
            ctx = null;
        }
        return ctx != null ? ctx.getSocketFactory() : null;
    }

    public void setDefaultPublicCAWithClientAuth(String strClientCertPath, String strClientCertPassword, String strCryptographicProtocol, boolean bValidateCertificateChain, boolean bVerifyHostname) {
        try {
            System.out.println("Set Default Public CA with Client Authentication SSL Socket Factory...");
            KeyManager[] keyManagers = this.getKeyManagers("PKCS12", new FileInputStream(new File(strClientCertPath)), strClientCertPassword);
            TrustManager[] trustManagers = null;
            trustManagers = bValidateCertificateChain ? null : this.getTrustManagersWithNoCertificateValidation();
            SSLContext ctx = SSLContext.getInstance(strCryptographicProtocol);
            ctx.init(keyManagers, trustManagers, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
            HostnameVerifier hv = this.verifyHostname(bVerifyHostname);
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HostnameVerifier verifyHostname(boolean bVerifyHostname) {
        HostnameVerifier hv = null;
        if (bVerifyHostname) {
            System.out.println("Verifying Hostname ...");
            hv = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return this.hostnameMatches(hostname, session);
                }

                private boolean hostnameMatches(String hostname, SSLSession session) {
                    HostnameChecker checker = HostnameChecker.getInstance((byte)1);
                    boolean validCertificate = false;
                    boolean validPrincipal = false;
                    try {
                        Certificate[] peerCertificates = session.getPeerCertificates();
                        if (peerCertificates.length > 0 && peerCertificates[0] instanceof X509Certificate) {
                            X509Certificate peerCertificate = (X509Certificate)peerCertificates[0];
                            try {
                                checker.match(hostname, peerCertificate);
                                validCertificate = true;
                            }
                            catch (CertificateException certificateException) {}
                        }
                    }
                    catch (SSLPeerUnverifiedException ex) {
                        try {
                            Principal peerPrincipal = session.getPeerPrincipal();
                            if (peerPrincipal instanceof KerberosPrincipal) {
                                validPrincipal = HostnameChecker.match((String)hostname, (Principal)((KerberosPrincipal)peerPrincipal));
                            }
                        }
                        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                            // empty catch block
                        }
                    }
                    return validCertificate || validPrincipal;
                }
            };
        } else {
            System.out.println("Hostname will NOT be verified ...");
            hv = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
        }
        return hv;
    }

    protected KeyManager[] getKeyManagers(String keyStoreType, InputStream keyStoreFile, String keyStorePassword) {
        KeyManagerFactory kmf = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(keyStoreFile, keyStorePassword.toCharArray());
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            System.err.println("Error on getJKSTrustManagers() : " + e.getMessage());
        }
        return kmf.getKeyManagers();
    }

    protected TrustManager[] getTrustManagers(String trustStoreType, InputStream caInput) {
        TrustManagerFactory tmf;
        block6: {
            CertificateFactory cf = null;
            Certificate ca = null;
            tmf = null;
            try {
                try {
                    cf = CertificateFactory.getInstance(trustStoreType);
                    ca = cf.generateCertificate(caInput);
                    System.out.println("Getting CA certificate ...");
                    String keyStoreType = KeyStore.getDefaultType();
                    KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                    keyStore.load(null, null);
                    keyStore.setCertificateEntry("ca", ca);
                    String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                    tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
                    tmf.init(keyStore);
                }
                catch (Exception e) {
                    System.err.println("Error on getTrustManagers() : " + e.getMessage());
                    caInput = null;
                    cf = null;
                    ca = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                caInput = null;
                cf = null;
                ca = null;
                throw throwable;
            }
            caInput = null;
            cf = null;
            ca = null;
        }
        if (tmf != null) {
            return tmf.getTrustManagers();
        }
        return null;
    }

    protected TrustManager[] getJKSTrustManagers(String trustStoreType, InputStream trustStoreFile, String trustStorePassword) {
        TrustManagerFactory tmf = null;
        try {
            KeyStore trustStore = KeyStore.getInstance(trustStoreType);
            trustStore.load(trustStoreFile, trustStorePassword.toCharArray());
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
        }
        catch (Exception e) {
            System.err.println("Error on getJKSTrustManagers() : " + e.getMessage());
        }
        return tmf.getTrustManagers();
    }

    protected TrustManager[] getTrustManagersWithNoCertificateValidation() {
        TrustManager[] trustAllCerts = null;
        try {
            trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
        catch (Exception e) {
            System.err.println("Error on getTrustManagersWithNoCertificateValidation() : " + e.getMessage());
        }
        return trustAllCerts;
    }

    public void disableCertificateValidation(String strCryptographicProtocol) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance(strCryptographicProtocol);
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception e) {
            System.err.println("Error on disableCertificateValidation() : " + e.getMessage());
        }
    }
}

