/*
 * Decompiled with CFR 0.152.
 */
public class MSGReceiver {
    MSGReceiver() {
    }

    public void processMOMSG(MSGXMLFactory theMSGXMLFactory, String strPOSTXMLData, MSGResponse theMSGResponse) {
        if (theMSGXMLFactory.validateXML(strPOSTXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='MESSAGES'><xs:complexType><xs:sequence><xs:element name='MSG' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element type='xs:string' name='FROM' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='TO' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='TEXT' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='REFERENCE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='DATE_CREATED' maxOccurs='1' minOccurs='1'/><xs:element name='OTHER_DETAILS' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:any minOccurs='0' maxOccurs='20' processContents='skip'/></xs:sequence></xs:complexType></xs:element><xs:element type='xs:string' name='INTEGRITY_HASH' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:unsignedLong' name='ID' use='required'/><xs:attribute type='xs:unsignedLong' name='PRODUCT_ID' use='required'/><xs:attribute type='xs:string' name='TYPE' fixed='MO' use='required'/></xs:complexType></xs:element></xs:sequence><xs:attribute type='xs:decimal' name='VERSION' use='required'/><xs:attribute type='xs:string' name='DATETIME' use='required'/></xs:complexType></xs:element></xs:schema>")) {
            MSG theMSGIN = theMSGXMLFactory.getMOMSG(strPOSTXMLData);
            theMSGResponse.setTransactionID(theMSGIN.getTransactionID());
            theMSGResponse.setMSGID(theMSGIN.getMSGID());
            theMSGResponse.setText(LocalParameters.getClientMOMSGResponseErrorText());
            System.out.println("MSG ID            : " + theMSGIN.getMSGID());
            System.out.println("Product ID        : " + theMSGIN.getProductID());
            System.out.println("MSG Type          : " + (Object)((Object)theMSGIN.getMSGType()));
            System.out.println("Sender            : " + theMSGIN.getSender());
            System.out.println("Receiver          : " + theMSGIN.getReceiver());
            System.out.println("MSG               : " + theMSGIN.getMSG());
            System.out.println("Reference         : " + theMSGIN.getMSGSourceReference());
            System.out.println("Date Created      : " + theMSGIN.getDateCreated());
            System.out.println("MSG XML Data      : " + theMSGIN.getMSGXMLData());
            System.out.println("Integrity Hash    : " + theMSGIN.getIntegrityHash());
            MSGClientDB theMSGClientDB = new MSGClientDB();
            boolean bDataIntegrityOK = true;
            if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES) && LocalParameters.getIntegrityHashInboundCheck().equals((Object)Constants.Enabled.YES)) {
                String strIntegrityHash = String.valueOf(theMSGIN.getMSGID()) + "-" + theMSGIN.getProductID() + "-" + (Object)((Object)theMSGIN.getMSGType()) + "-" + theMSGIN.getSender() + "-" + theMSGIN.getReceiver() + "-" + theMSGIN.getMSG() + "-" + theMSGIN.getMSGSourceReference() + "-" + theMSGIN.getDateCreated() + "-" + theMSGIN.getMSGXMLData() + "-" + LocalParameters.getIntegritySecret();
                boolean bl = bDataIntegrityOK = (strIntegrityHash = Utils.hash("SHA-256", strIntegrityHash)).equalsIgnoreCase(theMSGIN.getIntegrityHash());
            }
            if (bDataIntegrityOK) {
                if (theMSGClientDB.isMOMSGRecordExist(theMSGIN.getMSGID())) {
                    theMSGResponse.setTransactionID(theMSGClientDB.getMOMSGTransactionID(theMSGIN.getMSGID()));
                    theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                    theMSGResponse.setResponseDescription("Duplicate Error! MSG ID " + theMSGResponse.getMSGID() + " Exist. Message NOT Accepted");
                    theMSGResponse.setApplyTransactionCharge(Constants.Enabled.YES.getValue());
                    theMSGResponse.setText(LocalParameters.getClientMOMSGResponseSuccessText());
                } else {
                    int intUpdateCount = theMSGClientDB.insertMSGLog(theMSGIN);
                    if (intUpdateCount > 0) {
                        theMSGResponse.setTransactionID(theMSGClientDB.getMOMSGTransactionID(theMSGIN.getMSGID()));
                        theMSGResponse.setResponse(Constants.MSGServerResponse.OK.getValue());
                        theMSGResponse.setResponseDescription("Transaction Accepted.");
                        theMSGResponse.setApplyTransactionCharge(Constants.Enabled.YES.getValue());
                        theMSGResponse.setText(LocalParameters.getClientMOMSGResponseSuccessText());
                    } else {
                        theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                        theMSGResponse.setResponseDescription("MSG ID " + theMSGResponse.getMSGID() + " Inserted FAILED. Message NOT Accepted");
                        theMSGResponse.setApplyTransactionCharge(Constants.Enabled.NO.getValue());
                    }
                }
            } else {
                theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                theMSGResponse.setResponseDescription("Security Violation - Integrity Check Failed. Message NOT Accepted");
            }
        } else {
            theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
            theMSGResponse.setResponseDescription("Invalid XML. Message NOT Accepted");
        }
    }

    public void processMTMSGResult(MSGXMLFactory theMSGXMLFactory, String strPOSTXMLData, MSGResponse theMSGResponse) {
        theMSGResponse.setApplyTransactionCharge(Constants.Enabled.NO.getValue());
        if (theMSGXMLFactory.validateXML(strPOSTXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='MESSAGES'><xs:complexType><xs:sequence><xs:element name='MSG' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element type='xs:positiveInteger' name='RESPONSE_CODE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='DESCRIPTION' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='REFERENCE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='DATE_CREATED' maxOccurs='1' minOccurs='1'/><xs:element name='OTHER_DETAILS' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:any minOccurs='0' maxOccurs='20' processContents='skip'/></xs:sequence></xs:complexType></xs:element><xs:element type='xs:string' name='INTEGRITY_HASH' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='ORIGINATOR_ID' use='required'/><xs:attribute type='xs:unsignedLong' name='ID' use='required'/><xs:attribute type='xs:unsignedLong' name='PRODUCT_ID' use='required'/><xs:attribute type='xs:string' name='TYPE' fixed='MT' use='required'/></xs:complexType></xs:element></xs:sequence><xs:attribute type='xs:decimal' name='VERSION' use='required'/><xs:attribute type='xs:string' name='DATETIME' use='required'/></xs:complexType></xs:element></xs:schema>")) {
            MSGResult theMSGResult = theMSGXMLFactory.getMOMSGResult(strPOSTXMLData);
            theMSGResponse.setTransactionID(theMSGResult.getTransactionID());
            theMSGResponse.setMSGID(theMSGResult.getMSGID());
            System.out.println("Transaction ID       : " + theMSGResult.getTransactionID());
            System.out.println("MSG ID               : " + theMSGResult.getMSGID());
            System.out.println("Product ID           : " + theMSGResult.getProductID());
            System.out.println("MSG Type             : " + theMSGResult.getMSGType());
            System.out.println("Response Code        : " + theMSGResult.getResponseCode());
            System.out.println("Response Description : " + theMSGResult.getResponseDescription());
            System.out.println("Reference            : " + theMSGResult.getReference());
            System.out.println("Date Created         : " + theMSGResult.getDateCreated());
            System.out.println("Other Details        : " + theMSGResult.getOtherDetails());
            System.out.println("Integrity Hash       : " + theMSGResult.getIntegrityHash());
            MSGClientDB theMSGClientDB = new MSGClientDB();
            boolean bDataIntegrityOK = true;
            if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES) && LocalParameters.getIntegrityHashInboundCheck().equals((Object)Constants.Enabled.YES)) {
                String strIntegrirtyHash = String.valueOf(theMSGResult.getTransactionID()) + "-" + theMSGResult.getMSGID() + "-" + theMSGResult.getProductID() + "-" + theMSGResult.getMSGType() + "-" + theMSGResult.getResponseCode() + "-" + theMSGResult.getResponseDescription() + "-" + theMSGResult.getReference() + "-" + theMSGResult.getDateCreated() + "-" + theMSGResult.getOtherDetails() + "-" + LocalParameters.getIntegritySecret();
                boolean bl = bDataIntegrityOK = (strIntegrirtyHash = Utils.hash("SHA-256", strIntegrirtyHash)).equalsIgnoreCase(theMSGResult.getIntegrityHash());
            }
            if (bDataIntegrityOK) {
                Constants.MSGStatusCode theCurrentMSGStatusCode = theMSGClientDB.getMSGStatusCode(theMSGResult.getMSGType(), theMSGResponse.getTransactionID());
                if (theCurrentMSGStatusCode == null) {
                    theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                    theMSGResponse.setResponseDescription("Transaction ID " + theMSGResponse.getTransactionID() + " Does not EXIST or Message Status Code Cannot be determined. Transaction Update NOT Accepted");
                } else if (theCurrentMSGStatusCode.equals((Object)Constants.MSGStatusCode.SENT) || theCurrentMSGStatusCode.equals((Object)Constants.MSGStatusCode.SEND_ERROR) || theCurrentMSGStatusCode.equals((Object)Constants.MSGStatusCode.SEND_FAILED) || theCurrentMSGStatusCode.equals((Object)Constants.MSGStatusCode.DUPLICATE_TRANSACTION_ERROR)) {
                    int intUpdateCount = theMSGClientDB.updateMSGResultStatus(theMSGResult);
                    if (intUpdateCount > 0) {
                        theMSGResponse.setResponse(Constants.MSGServerResponse.OK.getValue());
                        theMSGResponse.setResponseDescription("Transaction Update Accepted.");
                    } else {
                        theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                        theMSGResponse.setResponseDescription("Transaction ID " + theMSGResult.getTransactionID() + " NOT found. Transaction Update NOT Accepted");
                    }
                } else {
                    theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                    theMSGResponse.setResponseDescription("MSG Status Code " + theCurrentMSGStatusCode.getValue() + " CANNOT be modified. Transaction Update NOT Accepted");
                }
            } else {
                theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                theMSGResponse.setResponseDescription("Security Violation - Integrity Check Failed. Transaction NOT Accepted");
            }
        } else {
            theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
            theMSGResponse.setResponseDescription("Invalid XML. Transaction Update NOT Accepted");
        }
    }
}

