/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class MSGSender {
    MSGSender() {
    }

    public void processMSG(Constants.MSGType theMSGType, ArrayList<MSG> msgArrList) {
        try {
            ArrayList<MSGSenderThread> msgSenderThreadArrList = new ArrayList<MSGSenderThread>();
            int maxThreads = RemoteParameters.getMaxMSGSenderThreads();
            int intMaxDataPerThread = RemoteParameters.getMaxMSGPerThread();
            long threadCount = 0L;
            MSGClientDB theMSGClientDB = new MSGClientDB();
            while (msgSenderThreadArrList.size() > 0 || msgArrList.size() > 0) {
                if (msgArrList.size() > 0) {
                    int pendingThreads = (int)Math.ceil((double)msgArrList.size() / (double)intMaxDataPerThread);
                    int activeThreads = msgSenderThreadArrList.size();
                    int noOfThreads = maxThreads - activeThreads;
                    if (noOfThreads > pendingThreads) {
                        noOfThreads = pendingThreads;
                    }
                    int i = 0;
                    while (i < noOfThreads) {
                        ArrayList<MSG> msgThreadArrList = new ArrayList<MSG>();
                        int intDataPerThread = intMaxDataPerThread;
                        if (intDataPerThread > msgArrList.size()) {
                            intDataPerThread = msgArrList.size();
                        }
                        int j = 0;
                        while (j < intDataPerThread) {
                            msgThreadArrList.add(msgArrList.get(0));
                            msgArrList.remove(0);
                            ++j;
                        }
                        MSGSenderThread msgSenderThread = new MSGSenderThread(threadCount, msgThreadArrList);
                        System.out.println(String.valueOf(threadCount) + " - Adding: " + msgSenderThread.getName());
                        msgSenderThreadArrList.add(msgSenderThread);
                        ++threadCount;
                        ++i;
                    }
                } else {
                    System.out.println("\nThread waiting for " + RemoteParameters.getPauseNewMSGSeconds() + " seconds to process the NEXT Messages Batch");
                    Thread.sleep(RemoteParameters.getPauseNewMSGSeconds() * 1000);
                    msgArrList = theMSGClientDB.getMSGData(theMSGType);
                }
                ListIterator msgSenderThreadArrIterator = msgSenderThreadArrList.listIterator();
                while (msgSenderThreadArrIterator.hasNext()) {
                    MSGSenderThread nextMSGSenderThread = (MSGSenderThread)msgSenderThreadArrIterator.next();
                    if (nextMSGSenderThread.isAlive()) continue;
                    System.out.println("Removing: " + nextMSGSenderThread.getName());
                    msgSenderThreadArrIterator.remove();
                }
            }
            System.out.println("Main thread's run is over");
        }
        catch (Exception e) {
            System.err.println("processMSG(ArrayList<MSG> msgArrList) Error message: " + e.getMessage());
        }
    }

    public boolean sendMSG(ArrayList<MSG> theMSGArrList) {
        try {
            for (MSG theMSG : theMSGArrList) {
                switch (RemoteParameters.getServiceURLMode()) {
                    case HTTP_XML_POST: {
                        System.out.println("Sending out MSG using HTTP_XML_POST Sending Mode\n");
                        this.send_HTTP_XML_POST_MSG(theMSG);
                        break;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("sendMSG(ArrayList<MSG> msgArrList): " + e.getMessage());
            return false;
        }
    }

    private boolean send_HTTP_XML_POST_MSG(MSG theMSG) throws UnsupportedEncodingException {
        block31: {
            MSGXMLFactory theMSGXMLFactory = new MSGXMLFactory();
            MSGClientDB theMSGClientDB = new MSGClientDB();
            String strPostData = theMSGXMLFactory.generateSimpleMSGXMLString(theMSG);
            MSGResponse theMSGResponse = new MSGResponse();
            strPostData = "data=" + URLEncoder.encode(strPostData, "UTF-8");
            String strMSGStatusDescription = "Status Description Not Provided";
            String strUrl = RemoteParameters.getServiceURL();
            String strReplyXMLData = null;
            if (RemoteParameters.getSSLEnabled().equals((Object)Constants.Enabled.NO)) {
                HTTPClient theHTTPClient = new HTTPClient();
                strReplyXMLData = theHTTPClient.httpPost(strUrl, strPostData, RemoteParameters.getConnectionTimeoutSeconds());
                theHTTPClient = null;
            } else {
                HTTPSClient theHTTPSClient = new HTTPSClient();
                strReplyXMLData = theHTTPSClient.httpsPost(strUrl, strPostData, LocalParameters.getClientConnectionTimeoutSeconds());
                theHTTPSClient = null;
            }
            boolean isMSGXMLClearText = false;
            if (strReplyXMLData != null) {
                block30: {
                    if (RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.Rijndael_128)) {
                        try {
                            if (theMSGXMLFactory.validateXML(strReplyXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='WRAPPER'><xs:complexType><xs:simpleContent><xs:extension base='xs:string'><xs:attribute type='xs:string' name='ID' use='required'/><xs:attribute type='xs:string' name='t' use='required'/></xs:extension></xs:simpleContent></xs:complexType></xs:element></xs:schema>")) {
                                DocumentBuilder wrapperDocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                                InputSource wrapperIS = new InputSource();
                                wrapperIS.setCharacterStream(new StringReader(strReplyXMLData));
                                Document wrapperDoc = wrapperDocBuilder.parse(wrapperIS);
                                String strEncryptedReplyXMLData = wrapperDoc.getElementsByTagName("WRAPPER").item(0).getTextContent();
                                String strTimeStamp = wrapperDoc.getElementsByTagName("WRAPPER").item(0).getAttributes().getNamedItem("t").getTextContent();
                                Crypto theCrypto = new Crypto();
                                String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                                strReplyXMLData = theCrypto.decrypt(strEncryptionKey, strEncryptedReplyXMLData);
                                isMSGXMLClearText = true;
                                break block30;
                            }
                            System.err.println("\nError on HTTP POST Client\n");
                            if (theMSG.getSendCount() + 1 < RemoteParameters.getMaxMSGSendCount()) {
                                System.out.println("Invalid WRAPPER XML Response. The message will be sent a gain later ...");
                                strMSGStatusDescription = "Message Send Error - Respose received could not be understood. Invalid WRAPPER XML Response";
                                theMSGResponse.setTransactionID(theMSG.getTransactionID());
                                theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                                theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                theMSGResponse.setResponseCode(Constants.MSGStatusCode.SEND_ERROR.getValue());
                                theMSGResponse.setResponseDescription(strMSGStatusDescription);
                                theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                            } else {
                                System.out.println("Invalid WRAPPER XML Response. The message will be marked as UNKNOWN_RESPONSE");
                                strMSGStatusDescription = "Unknown Response - Respose received could not be understood. Invalid WRAPPER XML Response";
                                theMSGResponse.setTransactionID(theMSG.getTransactionID());
                                theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                                theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                theMSGResponse.setResponseCode(Constants.MSGStatusCode.UNKNOWN_RESPONSE.getValue());
                                theMSGResponse.setResponseDescription(strMSGStatusDescription);
                                theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                            }
                            isMSGXMLClearText = false;
                        }
                        catch (Exception e) {
                            System.err.println("ERROR: " + e.getMessage());
                            if (theMSG.getSendCount() + 1 < RemoteParameters.getMaxMSGSendCount()) {
                                System.out.println("The message will be sent a gain later ...");
                                strMSGStatusDescription = "Message Send Error - Respose received could not be understood";
                                theMSGResponse.setTransactionID(theMSG.getTransactionID());
                                theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                                theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                theMSGResponse.setResponseCode(Constants.MSGStatusCode.SEND_ERROR.getValue());
                                theMSGResponse.setResponseDescription(strMSGStatusDescription);
                                theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                            } else {
                                System.out.println("The message will be marked as UNKNOWN_RESPONSE");
                                strMSGStatusDescription = "Unknown Response - Respose received could not be understood";
                                theMSGResponse.setTransactionID(theMSG.getTransactionID());
                                theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                                theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                theMSGResponse.setResponseCode(Constants.MSGStatusCode.UNKNOWN_RESPONSE.getValue());
                                theMSGResponse.setResponseDescription(strMSGStatusDescription);
                                theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                            }
                            isMSGXMLClearText = false;
                        }
                    } else {
                        isMSGXMLClearText = true;
                    }
                }
                if (theMSGXMLFactory.validateXML(strReplyXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='MESSAGES'><xs:complexType><xs:sequence><xs:element name='MSG'><xs:complexType><xs:sequence><xs:element name='RESPONSE' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='OK' /><xs:enumeration value='ERROR' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:positiveInteger' name='RESPONSE_CODE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='DESCRIPTION' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='INTEGRITY_HASH' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='ORIGINATOR_ID' use='required'/><xs:attribute type='xs:unsignedLong' name='ID' use='required'/><xs:attribute type='xs:string' name='TYPE' fixed='MT' use='required'/></xs:complexType></xs:element></xs:sequence><xs:attribute type='xs:decimal' name='VERSION' use='required'/><xs:attribute type='xs:string' name='DATETIME' use='required'/></xs:complexType></xs:element></xs:schema>") && isMSGXMLClearText) {
                    try {
                        theMSGResponse = theMSGXMLFactory.getMSGResponse(strReplyXMLData);
                        theMSGResponse.setTransactionID(theMSG.getTransactionID());
                        System.out.println("\nResponse Details ...");
                        System.out.println("Transaction ID       : " + theMSGResponse.getTransactionID());
                        System.out.println("MSG ID               : " + theMSGResponse.getMSGID());
                        System.out.println("MSG Type             : " + theMSGResponse.getMSGType());
                        System.out.println("Response             : " + theMSGResponse.getResponse());
                        System.out.println("Response Code        : " + theMSGResponse.getResponseCode());
                        System.out.println("Response Description : " + theMSGResponse.getResponseDescription());
                        System.out.println("Integrity Hash       : " + theMSGResponse.getIntegrityHash());
                        String strResponse = theMSGResponse.getResponse();
                        strMSGStatusDescription = theMSGResponse.getResponseDescription();
                        int intMSGStatusCode = theMSGResponse.getResponseCode();
                        boolean bDataIntegrityOK = true;
                        if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES) && LocalParameters.getIntegrityHashInboundCheck().equals((Object)Constants.Enabled.YES)) {
                            String strIntegrirtyHash = theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret());
                            boolean bl = bDataIntegrityOK = strIntegrirtyHash.equalsIgnoreCase(theMSGResponse.getIntegrityHash());
                        }
                        if (bDataIntegrityOK) {
                            if (!strResponse.equalsIgnoreCase(Constants.MSGServerResponse.OK.getValue())) {
                                boolean bStatusCodeFound = false;
                                Constants.MSGStatusCode[] mSGStatusCodeArray = Constants.MSGStatusCode.values();
                                int n = mSGStatusCodeArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Constants.MSGStatusCode theStatusCode = mSGStatusCodeArray[n2];
                                    if (intMSGStatusCode == theStatusCode.getValue()) {
                                        bStatusCodeFound = true;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (!bStatusCodeFound) {
                                    intMSGStatusCode = Constants.MSGStatusCode.SEND_FAILED.getValue();
                                    strMSGStatusDescription = "Message Send FAILED: Response Code = " + intMSGStatusCode + " - " + strMSGStatusDescription;
                                    theMSGResponse.setResponseCode(intMSGStatusCode);
                                    theMSGResponse.setResponseDescription(strMSGStatusDescription);
                                    theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                }
                            }
                        } else {
                            intMSGStatusCode = Constants.MSGStatusCode.TRANSACTION_REJECTED_ERROR.getValue();
                            strMSGStatusDescription = "Security Violation - Integrity Check Failed. Response NOT Accepted";
                            theMSGResponse.setResponseCode(intMSGStatusCode);
                            theMSGResponse.setResponseDescription(strMSGStatusDescription);
                            theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                            System.out.println("\n" + strMSGStatusDescription + "\n");
                        }
                        theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                    }
                    catch (Exception e) {
                        System.err.println("ERROR: " + e.getMessage());
                        if (theMSG.getSendCount() + 1 < RemoteParameters.getMaxMSGSendCount()) {
                            System.out.println("The message will be sent a gain later ...");
                            strMSGStatusDescription = "Message Send Error - Respose received could not be understood";
                            theMSGResponse.setTransactionID(theMSG.getTransactionID());
                            theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                            theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                            theMSGResponse.setResponseCode(Constants.MSGStatusCode.SEND_ERROR.getValue());
                            theMSGResponse.setResponseDescription(strMSGStatusDescription);
                            theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                            theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                            break block31;
                        }
                        System.out.println("The message will be marked as UNKNOWN_RESPONSE");
                        strMSGStatusDescription = "Unknown Response - Respose received could not be understood";
                        theMSGResponse.setTransactionID(theMSG.getTransactionID());
                        theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                        theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                        theMSGResponse.setResponseCode(Constants.MSGStatusCode.UNKNOWN_RESPONSE.getValue());
                        theMSGResponse.setResponseDescription(strMSGStatusDescription);
                        theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                        theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                    }
                } else if (isMSGXMLClearText) {
                    System.err.println("\nError on HTTP POST Client\n");
                    if (theMSG.getSendCount() + 1 < RemoteParameters.getMaxMSGSendCount()) {
                        System.out.println("Invalid XML Response. The message will be sent a gain later ...");
                        strMSGStatusDescription = "Message Send Error - Respose received could not be understood. Invalid XML Response";
                        theMSGResponse.setTransactionID(theMSG.getTransactionID());
                        theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                        theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                        theMSGResponse.setResponseCode(Constants.MSGStatusCode.SEND_ERROR.getValue());
                        theMSGResponse.setResponseDescription(strMSGStatusDescription);
                        theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                        theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                    } else {
                        System.out.println("Invalid XML Response. The message will be marked as UNKNOWN_RESPONSE");
                        strMSGStatusDescription = "Unknown Response - Respose received could not be understood. Invalid XML Response";
                        theMSGResponse.setTransactionID(theMSG.getTransactionID());
                        theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                        theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                        theMSGResponse.setResponseCode(Constants.MSGStatusCode.UNKNOWN_RESPONSE.getValue());
                        theMSGResponse.setResponseDescription(strMSGStatusDescription);
                        theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                        theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                    }
                }
            } else {
                System.err.println("\nError on HTTP POST Client\n");
                if (theMSG.getSendCount() + 1 < RemoteParameters.getMaxMSGSendCount()) {
                    System.out.println("The message will be sent a gain later ...");
                    strMSGStatusDescription = "Message Send Error - No response was received";
                    theMSGResponse.setTransactionID(theMSG.getTransactionID());
                    theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                    theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                    theMSGResponse.setResponseCode(Constants.MSGStatusCode.SEND_ERROR.getValue());
                    theMSGResponse.setResponseDescription(strMSGStatusDescription);
                    theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                    theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                } else {
                    System.out.println("The message will be SEND_FAILED");
                    strMSGStatusDescription = "Message Send FAILED - No response was received";
                    theMSGResponse.setTransactionID(theMSG.getTransactionID());
                    theMSGResponse.setMSGType(Constants.MSGType.MT.getValue());
                    theMSGResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                    theMSGResponse.setResponseCode(Constants.MSGStatusCode.SEND_FAILED.getValue());
                    theMSGResponse.setResponseDescription(strMSGStatusDescription);
                    theMSGResponse.setIntegrityHash(theMSGResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                    theMSGClientDB.setMSGServerResponseStatus(theMSGResponse, true);
                }
            }
        }
        return true;
    }
}

