/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class MSGXMLFactory {
    private Constants.XMLAPIMessageVersion getXMLVersion(ArrayList<MSG> theMSGArrList) {
        String strPrevSourceHolder = "";
        String strPrevDestinationHolder = "";
        String strPrevMessageHolder = "";
        String strPrevDateScheduled = "";
        boolean bIdenticalSource = true;
        boolean bIdenticalDestination = true;
        boolean bIdenticalMessage = true;
        boolean bIdenticalDateScheduled = true;
        int intCount = 0;
        System.out.println("\nDetermining XML Version ...\n");
        for (MSG theMSG : theMSGArrList) {
            if (++intCount > 1) {
                if (theMSG.getIntegrityHash() != null) {
                    return Constants.XMLAPIMessageVersion.API_MESSAGE_VERSION_1_01;
                }
                if (!strPrevSourceHolder.equalsIgnoreCase(theMSG.getSender())) {
                    bIdenticalSource = false;
                }
                if (!strPrevDestinationHolder.equalsIgnoreCase(theMSG.getReceiver())) {
                    bIdenticalDestination = false;
                }
                if (!strPrevMessageHolder.equalsIgnoreCase(theMSG.getMSG())) {
                    bIdenticalMessage = false;
                }
                if (theMSG.getScheduleMSG().equals((Object)Constants.ScheduleMSG.YES) && !strPrevDateScheduled.equalsIgnoreCase(theMSG.getDateScheduled())) {
                    bIdenticalDateScheduled = false;
                }
            }
            strPrevSourceHolder = theMSG.getSender();
            strPrevDestinationHolder = theMSG.getReceiver();
            strPrevMessageHolder = theMSG.getMSG();
            strPrevDateScheduled = theMSG.getDateScheduled();
        }
        if (bIdenticalSource && bIdenticalDestination && bIdenticalMessage && bIdenticalDateScheduled) {
            return Constants.XMLAPIMessageVersion.API_MESSAGE_VERSION_1_01;
        }
        if (bIdenticalSource && bIdenticalMessage && bIdenticalDateScheduled) {
            return Constants.XMLAPIMessageVersion.API_MESSAGE_VERSION_4_01;
        }
        if (bIdenticalSource && bIdenticalDateScheduled) {
            return Constants.XMLAPIMessageVersion.API_MESSAGE_VERSION_2_01;
        }
        if (bIdenticalMessage && bIdenticalDateScheduled) {
            return Constants.XMLAPIMessageVersion.API_MESSAGE_VERSION_3_01;
        }
        return Constants.XMLAPIMessageVersion.API_MESSAGE_VERSION_1_01;
    }

    public String generateGetParametersXMLString() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elMessages = doc.createElement("MESSAGES");
            doc.appendChild(elMessages);
            Attr attrVersion = doc.createAttribute("VERSION");
            attrVersion.setValue("0.01");
            elMessages.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DATETIME");
            attrDateTime.setValue(MSGClientDB.getDBDateTime());
            elMessages.setAttributeNode(attrDateTime);
            Element elLogin = doc.createElement("LOGIN");
            elMessages.appendChild(elLogin);
            Attr attrUsername = doc.createAttribute("USERNAME");
            attrUsername.setValue(LocalParameters.getSystemUsername());
            elLogin.setAttributeNode(attrUsername);
            Attr attrPassword = doc.createAttribute("PASSWORD");
            attrPassword.setValue(LocalParameters.getSystemPassword());
            elLogin.setAttributeNode(attrPassword);
            Element elMSG = doc.createElement("MSG");
            elMessages.appendChild(elMSG);
            Element elClientID = doc.createElement("CLIENT_ID");
            elClientID.appendChild(doc.createTextNode(Long.toString(LocalParameters.getClientID())));
            elMSG.appendChild(elClientID);
            Element elAction = doc.createElement("ACTION");
            elAction.appendChild(doc.createTextNode("GET_PARAMETERS"));
            elMSG.appendChild(elAction);
            String output = this.convertDocumentToString(doc, false);
            output = output.trim();
            if (LocalParameters.getClientEncryptionType().equals((Object)Constants.ClientEncryptionType.Rijndael_128)) {
                String wrapperOutput;
                DocumentBuilderFactory wrapperDocFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder wrapperDocBuilder = wrapperDocFactory.newDocumentBuilder();
                String strTimeStamp = MSGClientDB.getDBTimeStamp();
                String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                Crypto theCrypto = new Crypto();
                String encryptedOutput = theCrypto.encrypt(strEncryptionKey, output);
                Document wrapperDoc = wrapperDocBuilder.newDocument();
                Element elWrapper = wrapperDoc.createElement("WRAPPER");
                elWrapper.appendChild(wrapperDoc.createTextNode(encryptedOutput));
                wrapperDoc.appendChild(elWrapper);
                Attr attrSystemUserID = wrapperDoc.createAttribute("ID");
                attrSystemUserID.setValue(Long.toString(LocalParameters.getSystemUserID()));
                elWrapper.setAttributeNode(attrSystemUserID);
                Attr attrTimeStamp = wrapperDoc.createAttribute("t");
                attrTimeStamp.setValue(strTimeStamp);
                elWrapper.setAttributeNode(attrTimeStamp);
                output = wrapperOutput = this.convertDocumentToString(wrapperDoc, false);
                System.out.println("\nDATA TO BE TRANSMITED IS ENCRYPTED");
            } else {
                System.out.println("\nDATA TO BE TRANSMITED IN CLEAR TEXT");
            }
            return output;
        }
        catch (Exception e) {
            System.err.println("generateGetParametersXMLString(): " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String generateMSGXMLString(ArrayList<MSG> theMSGArrList) {
        try {
            String output;
            Constants.XMLAPIMessageVersion theXMLVersion = this.getXMLVersion(theMSGArrList);
            System.out.println("Got XML Version: " + theXMLVersion.getValue());
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elMessages = doc.createElement("MESSAGES");
            doc.appendChild(elMessages);
            Attr attrVersion = doc.createAttribute("VERSION");
            attrVersion.setValue(theXMLVersion.getValue());
            elMessages.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DATETIME");
            attrDateTime.setValue(MSGClientDB.getDBDateTime());
            elMessages.setAttributeNode(attrDateTime);
            Element elLogin = doc.createElement("LOGIN");
            elMessages.appendChild(elLogin);
            Attr attrUsername = doc.createAttribute("USERNAME");
            attrUsername.setValue(LocalParameters.getSystemUsername());
            elLogin.setAttributeNode(attrUsername);
            Attr attrPassword = doc.createAttribute("PASSWORD");
            attrPassword.setValue(LocalParameters.getSystemPassword());
            elLogin.setAttributeNode(attrPassword);
            int intCount = 0;
            Iterator<MSG> iterator = theMSGArrList.iterator();
            while (true) {
                Node elMSGOutXMLParameters;
                if (!iterator.hasNext()) {
                    String wrapperOutput;
                    output = this.convertDocumentToString(doc, false);
                    output = output.trim();
                    if (!RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.Rijndael_128)) break;
                    DocumentBuilderFactory wrapperDocFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder wrapperDocBuilder = wrapperDocFactory.newDocumentBuilder();
                    String strTimeStamp = MSGClientDB.getDBTimeStamp();
                    String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                    Crypto theCrypto = new Crypto();
                    String encryptedOutput = theCrypto.encrypt(strEncryptionKey, output);
                    Document wrapperDoc = wrapperDocBuilder.newDocument();
                    Element elWrapper = wrapperDoc.createElement("WRAPPER");
                    elWrapper.appendChild(wrapperDoc.createTextNode(encryptedOutput));
                    wrapperDoc.appendChild(elWrapper);
                    Attr attrSystemUserID = wrapperDoc.createAttribute("ID");
                    attrSystemUserID.setValue(Long.toString(LocalParameters.getSystemUserID()));
                    elWrapper.setAttributeNode(attrSystemUserID);
                    Attr attrTimeStamp = wrapperDoc.createAttribute("t");
                    attrTimeStamp.setValue(strTimeStamp);
                    elWrapper.setAttributeNode(attrTimeStamp);
                    output = wrapperOutput = this.convertDocumentToString(wrapperDoc, false);
                    System.out.println("\nDATA TO BE TRANSMITED IS ENCRYPTED");
                    return output;
                }
                MSG theMSG = iterator.next();
                ++intCount;
                Element elMSG = doc.createElement("MSG");
                Attr attrOriginatorID = doc.createAttribute("ORIGINATOR_ID");
                attrOriginatorID.setValue(theMSG.getTransactionID());
                elMSG.setAttributeNode(attrOriginatorID);
                Attr attrProductID = doc.createAttribute("PRODUCT_ID");
                attrProductID.setValue(Long.toString(theMSG.getProductID()));
                elMSG.setAttributeNode(attrProductID);
                Attr attrType = doc.createAttribute("TYPE");
                attrType.setValue(Constants.MSGType.MT.getValue());
                elMSG.setAttributeNode(attrType);
                Attr attrCharge = doc.createAttribute("CHARGE");
                attrCharge.setValue(theMSG.getApplyTransactionCharge());
                elMSG.setAttributeNode(attrCharge);
                switch (theXMLVersion) {
                    case API_MESSAGE_VERSION_1_01: {
                        elMessages.appendChild(elMSG);
                        Element elFrom = doc.createElement("FROM");
                        elFrom.appendChild(doc.createTextNode(theMSG.getSender()));
                        elMSG.appendChild(elFrom);
                        Element elTo = doc.createElement("TO");
                        elTo.appendChild(doc.createTextNode(theMSG.getReceiver()));
                        elMSG.appendChild(elTo);
                        Element elText = doc.createElement("TEXT");
                        elText.appendChild(doc.createTextNode(theMSG.getMSG()));
                        elMSG.appendChild(elText);
                        break;
                    }
                    case API_MESSAGE_VERSION_2_01: {
                        Element elFrom;
                        if (intCount == 1) {
                            elFrom = doc.createElement("FROM");
                            elFrom.appendChild(doc.createTextNode(theMSG.getSender()));
                            elMessages.appendChild(elFrom);
                        }
                        elMessages.appendChild(elMSG);
                        Element elTo = doc.createElement("TO");
                        elTo.appendChild(doc.createTextNode(theMSG.getReceiver()));
                        elMSG.appendChild(elTo);
                        Element elText = doc.createElement("TEXT");
                        elText.appendChild(doc.createTextNode(theMSG.getMSG()));
                        elMSG.appendChild(elText);
                        break;
                    }
                    case API_MESSAGE_VERSION_3_01: {
                        if (intCount == 1) {
                            Element elText = doc.createElement("TEXT");
                            elText.appendChild(doc.createTextNode(theMSG.getMSG()));
                            elMessages.appendChild(elText);
                        }
                        elMessages.appendChild(elMSG);
                        Element elFrom = doc.createElement("FROM");
                        elFrom.appendChild(doc.createTextNode(theMSG.getSender()));
                        elMSG.appendChild(elFrom);
                        Element elTo = doc.createElement("TO");
                        elTo.appendChild(doc.createTextNode(theMSG.getReceiver()));
                        elMSG.appendChild(elTo);
                        break;
                    }
                    case API_MESSAGE_VERSION_4_01: {
                        Element elText;
                        Element elFrom;
                        if (intCount == 1) {
                            elFrom = doc.createElement("FROM");
                            elFrom.appendChild(doc.createTextNode(theMSG.getSender()));
                            elMessages.appendChild(elFrom);
                            elText = doc.createElement("TEXT");
                            elText.appendChild(doc.createTextNode(theMSG.getMSG()));
                            elMessages.appendChild(elText);
                        }
                        elMessages.appendChild(elMSG);
                        Element elTo = doc.createElement("TO");
                        elTo.appendChild(doc.createTextNode(theMSG.getReceiver()));
                        elMSG.appendChild(elTo);
                        break;
                    }
                    default: {
                        System.err.println("Invalid XML Version\n");
                        return null;
                    }
                }
                if (theMSG.getMSGSourceReference().length() > 0) {
                    Element elReference = doc.createElement("REFERENCE");
                    elReference.appendChild(doc.createTextNode(theMSG.getMSGSourceReference()));
                    elMSG.appendChild(elReference);
                }
                if (theMSG.getScheduleMSG().equals((Object)Constants.ScheduleMSG.YES)) {
                    Element elDateScheduled = doc.createElement("DATE_SCHEDULED");
                    elDateScheduled.appendChild(doc.createTextNode(theMSG.getDateScheduled()));
                    elMSG.appendChild(elDateScheduled);
                }
                Element elDateCreated = doc.createElement("DATE_CREATED");
                elDateCreated.appendChild(doc.createTextNode(theMSG.getTransactionDate()));
                elMSG.appendChild(elDateCreated);
                Document docOtherDetailsParameters = this.convertStringToDocument(theMSG.getMSGXMLData());
                if (docOtherDetailsParameters != null && (elMSGOutXMLParameters = doc.importNode(docOtherDetailsParameters.getDocumentElement(), true)) != null) {
                    elMSG.appendChild(elMSGOutXMLParameters);
                }
                if (!LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES)) continue;
                Element elIntegrityHash = doc.createElement("INTEGRITY_HASH");
                elIntegrityHash.appendChild(doc.createTextNode(theMSG.getIntegrityHash()));
                elMSG.appendChild(elIntegrityHash);
            }
            System.out.println("\nDATA TO BE TRANSMITED IN CLEAR TEXT");
            return output;
        }
        catch (Exception e) {
            System.err.println("sendSMS(ArrayList<SMS> smsArrList): " + e.getMessage());
            return null;
        }
    }

    public String generateSimpleMSGXMLString(MSG theMSG) {
        try {
            Node elMSGOutXMLParameters;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elMessages = doc.createElement("MESSAGES");
            doc.appendChild(elMessages);
            Attr attrVersion = doc.createAttribute("VERSION");
            attrVersion.setValue("1.01");
            elMessages.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DATETIME");
            attrDateTime.setValue(MSGClientDB.getDBDateTime());
            elMessages.setAttributeNode(attrDateTime);
            Element elLogin = doc.createElement("LOGIN");
            elMessages.appendChild(elLogin);
            Attr attrUsername = doc.createAttribute("USERNAME");
            attrUsername.setValue(LocalParameters.getSystemUsername());
            elLogin.setAttributeNode(attrUsername);
            Attr attrPassword = doc.createAttribute("PASSWORD");
            attrPassword.setValue(LocalParameters.getSystemPassword());
            elLogin.setAttributeNode(attrPassword);
            Element elMSG = doc.createElement("MSG");
            elMessages.appendChild(elMSG);
            Attr attrOriginatorID = doc.createAttribute("ORIGINATOR_ID");
            attrOriginatorID.setValue(theMSG.getTransactionID());
            elMSG.setAttributeNode(attrOriginatorID);
            Attr attrProductID = doc.createAttribute("PRODUCT_ID");
            attrProductID.setValue(Long.toString(theMSG.getProductID()));
            elMSG.setAttributeNode(attrProductID);
            Attr attrType = doc.createAttribute("TYPE");
            attrType.setValue(Constants.MSGType.MT.getValue());
            elMSG.setAttributeNode(attrType);
            Attr attrCharge = doc.createAttribute("CHARGE");
            attrCharge.setValue(theMSG.getApplyTransactionCharge());
            elMSG.setAttributeNode(attrCharge);
            Element elFrom = doc.createElement("FROM");
            elFrom.appendChild(doc.createTextNode(theMSG.getSender()));
            elMSG.appendChild(elFrom);
            Element elTo = doc.createElement("TO");
            elTo.appendChild(doc.createTextNode(theMSG.getReceiver()));
            elMSG.appendChild(elTo);
            Element elText = doc.createElement("TEXT");
            elText.appendChild(doc.createTextNode(theMSG.getMSG()));
            elMSG.appendChild(elText);
            if (theMSG.getMSGSourceReference().length() > 0) {
                Element elReference = doc.createElement("REFERENCE");
                elReference.appendChild(doc.createTextNode(theMSG.getMSGSourceReference()));
                elMSG.appendChild(elReference);
            }
            if (theMSG.getScheduleMSG().equals((Object)Constants.ScheduleMSG.YES)) {
                Element elDateScheduled = doc.createElement("DATE_SCHEDULED");
                elDateScheduled.appendChild(doc.createTextNode(theMSG.getDateScheduled()));
                elMSG.appendChild(elDateScheduled);
            }
            Element elDateCreated = doc.createElement("DATE_CREATED");
            elDateCreated.appendChild(doc.createTextNode(theMSG.getTransactionDate()));
            elMSG.appendChild(elDateCreated);
            Document docOtherDetailsParameters = this.convertStringToDocument(theMSG.getMSGXMLData());
            if (docOtherDetailsParameters != null && (elMSGOutXMLParameters = doc.importNode(docOtherDetailsParameters.getDocumentElement(), true)) != null) {
                elMSG.appendChild(elMSGOutXMLParameters);
            }
            if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES)) {
                Element elIntegrityHash = doc.createElement("INTEGRITY_HASH");
                elIntegrityHash.appendChild(doc.createTextNode(theMSG.getIntegrityHash()));
                elMSG.appendChild(elIntegrityHash);
            }
            String output = this.convertDocumentToString(doc, false);
            output = output.trim();
            if (RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.Rijndael_128)) {
                String wrapperOutput;
                DocumentBuilderFactory wrapperDocFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder wrapperDocBuilder = wrapperDocFactory.newDocumentBuilder();
                String strTimeStamp = MSGClientDB.getDBTimeStamp();
                String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                Crypto theCrypto = new Crypto();
                String encryptedOutput = theCrypto.encrypt(strEncryptionKey, output);
                Document wrapperDoc = wrapperDocBuilder.newDocument();
                Element elWrapper = wrapperDoc.createElement("WRAPPER");
                elWrapper.appendChild(wrapperDoc.createTextNode(encryptedOutput));
                wrapperDoc.appendChild(elWrapper);
                Attr attrSystemUserID = wrapperDoc.createAttribute("ID");
                attrSystemUserID.setValue(Long.toString(LocalParameters.getSystemUserID()));
                elWrapper.setAttributeNode(attrSystemUserID);
                Attr attrTimeStamp = wrapperDoc.createAttribute("t");
                attrTimeStamp.setValue(strTimeStamp);
                elWrapper.setAttributeNode(attrTimeStamp);
                output = wrapperOutput = this.convertDocumentToString(wrapperDoc, false);
                System.out.println("\nDATA TO BE TRANSMITED IS ENCRYPTED");
            } else {
                System.out.println("\nDATA TO BE TRANSMITED IN CLEAR TEXT");
            }
            return output;
        }
        catch (Exception e) {
            System.err.println("sendMSG(ArrayList<MSG> msgArrList): " + e.getMessage());
            return null;
        }
    }

    public String generateUpdateMSGResponseXMLString(long lnWrapperID, MSGResponse theResponse) {
        try {
            Element elDescription;
            Element elResponse;
            Element elIntegrityHash;
            String strIntegrirtyHash;
            Attr attrCharge;
            Element elMSG;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elMessages = doc.createElement("MESSAGES");
            doc.appendChild(elMessages);
            Attr attrVersion = doc.createAttribute("VERSION");
            attrVersion.setValue("1.01");
            elMessages.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DATETIME");
            attrDateTime.setValue(MSGClientDB.getDBDateTime());
            elMessages.setAttributeNode(attrDateTime);
            if (theResponse.getMSGType().equalsIgnoreCase(Constants.MSGType.MO.getValue())) {
                elMSG = doc.createElement("MSG");
                elMessages.appendChild(elMSG);
                Attr attrID = doc.createAttribute("ID");
                attrID.setValue(Long.toString(theResponse.getMSGID()));
                elMSG.setAttributeNode(attrID);
                Attr attrType = doc.createAttribute("TYPE");
                attrType.setValue(theResponse.getMSGType());
                elMSG.setAttributeNode(attrType);
                Attr attrMode = doc.createAttribute("MODE");
                attrMode.setValue(theResponse.getResponseMode());
                elMSG.setAttributeNode(attrMode);
                attrCharge = doc.createAttribute("CHARGE");
                attrCharge.setValue(theResponse.getApplyTransactionCharge());
                elMSG.setAttributeNode(attrCharge);
                if (theResponse.getResponseMode().equalsIgnoreCase(Constants.MOMSGResponseMode.ONLINE.getValue())) {
                    Element elText = doc.createElement("TEXT");
                    elText.appendChild(doc.createTextNode(theResponse.getText()));
                    elMSG.appendChild(elText);
                    Element elReference = doc.createElement("REFERENCE");
                    elReference.appendChild(doc.createTextNode(theResponse.getTransactionID()));
                    elMSG.appendChild(elReference);
                    if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES)) {
                        strIntegrirtyHash = theResponse.generate_Online_MO_ClientResponseIntegrityHash(LocalParameters.getIntegritySecret());
                        elIntegrityHash = doc.createElement("INTEGRITY_HASH");
                        elIntegrityHash.appendChild(doc.createTextNode(strIntegrirtyHash));
                        elMSG.appendChild(elIntegrityHash);
                    }
                } else {
                    elResponse = doc.createElement("RESPONSE");
                    elResponse.appendChild(doc.createTextNode(theResponse.getResponse()));
                    elMSG.appendChild(elResponse);
                    elDescription = doc.createElement("DESCRIPTION");
                    elDescription.appendChild(doc.createTextNode(theResponse.getResponseDescription()));
                    elMSG.appendChild(elDescription);
                    Element elReference = doc.createElement("REFERENCE");
                    elReference.appendChild(doc.createTextNode(theResponse.getTransactionID()));
                    elMSG.appendChild(elReference);
                    if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES)) {
                        String strIntegrirtyHash2 = theResponse.generate_Offline_MO_ClientResponseIntegrityHash(LocalParameters.getIntegritySecret());
                        Element elIntegrityHash2 = doc.createElement("INTEGRITY_HASH");
                        elIntegrityHash2.appendChild(doc.createTextNode(strIntegrirtyHash2));
                        elMSG.appendChild(elIntegrityHash2);
                    }
                }
            } else if (theResponse.getMSGType().equalsIgnoreCase(Constants.MSGType.MT.getValue())) {
                elMSG = doc.createElement("MSG");
                elMessages.appendChild(elMSG);
                Attr attrOriginatorID = doc.createAttribute("ORIGINATOR_ID");
                attrOriginatorID.setValue(theResponse.getTransactionID());
                elMSG.setAttributeNode(attrOriginatorID);
                Attr attrID = doc.createAttribute("ID");
                attrID.setValue(Long.toString(theResponse.getMSGID()));
                elMSG.setAttributeNode(attrID);
                Attr attrType = doc.createAttribute("TYPE");
                attrType.setValue(theResponse.getMSGType());
                elMSG.setAttributeNode(attrType);
                attrCharge = doc.createAttribute("CHARGE");
                attrCharge.setValue(theResponse.getApplyTransactionCharge());
                elMSG.setAttributeNode(attrCharge);
                elResponse = doc.createElement("RESPONSE");
                elResponse.appendChild(doc.createTextNode(theResponse.getResponse()));
                elMSG.appendChild(elResponse);
                elDescription = doc.createElement("DESCRIPTION");
                elDescription.appendChild(doc.createTextNode(theResponse.getResponseDescription()));
                elMSG.appendChild(elDescription);
                if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES)) {
                    strIntegrirtyHash = theResponse.generate_MT_ClientResultResponseIntegrityHash(LocalParameters.getIntegritySecret());
                    elIntegrityHash = doc.createElement("INTEGRITY_HASH");
                    elIntegrityHash.appendChild(doc.createTextNode(strIntegrirtyHash));
                    elMSG.appendChild(elIntegrityHash);
                }
            }
            String output = this.convertDocumentToString(doc, false);
            output = output.trim();
            if (RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.Rijndael_128)) {
                String wrapperOutput;
                DocumentBuilderFactory wrapperDocFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder wrapperDocBuilder = wrapperDocFactory.newDocumentBuilder();
                String strTimeStamp = MSGClientDB.getDBTimeStamp();
                String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                Crypto theCrypto = new Crypto();
                String encryptedOutput = theCrypto.encrypt(strEncryptionKey, output);
                Document wrapperDoc = wrapperDocBuilder.newDocument();
                Element elWrapper = wrapperDoc.createElement("WRAPPER");
                elWrapper.appendChild(wrapperDoc.createTextNode(encryptedOutput));
                wrapperDoc.appendChild(elWrapper);
                Attr attrWrapperID = wrapperDoc.createAttribute("ID");
                attrWrapperID.setValue(Long.toString(lnWrapperID));
                elWrapper.setAttributeNode(attrWrapperID);
                Attr attrTimeStamp = wrapperDoc.createAttribute("t");
                attrTimeStamp.setValue(strTimeStamp);
                elWrapper.setAttributeNode(attrTimeStamp);
                output = wrapperOutput = this.convertDocumentToString(wrapperDoc, false);
                System.out.println("\nDATA TO BE TRANSMITED IS ENCRYPTED");
            } else {
                System.out.println("\nDATA TO BE TRANSMITED IN CLEAR TEXT");
            }
            return output;
        }
        catch (Exception e) {
            System.err.println("generateUpdateMSGResponseXMLString(long lnWrapperID, MSGResponse theResponse, String strPesaType): " + e.getMessage());
            return null;
        }
    }

    public MSGWrapper getMSGWrapper(String strWrapperXML) {
        MSGWrapper msgWrapper = new MSGWrapper();
        try {
            InputSource source = new InputSource(new StringReader(strWrapperXML));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/WRAPPER", xmlDocument, XPathConstants.NODE);
            long lnID = Long.parseLong(configXPath.evaluate("@ID", objMessages).trim());
            String strTimeStamp = configXPath.evaluate("@t", objMessages).trim();
            String strEncryptedData = configXPath.evaluate("/WRAPPER", objMessages).trim();
            msgWrapper.setID(lnID);
            msgWrapper.setTimeStamp(strTimeStamp);
            msgWrapper.setEncryptedData(strEncryptedData);
            return msgWrapper;
        }
        catch (Exception e) {
            System.err.println("getMSGWrapper(String strWrapperXML) error: " + e.getMessage());
            return null;
        }
    }

    public String getReceiverXMLMSGType(String strPOSTXMLData) {
        try {
            InputSource source = new InputSource(new StringReader(strPOSTXMLData));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            String strMSGType = configXPath.evaluate("MSG/@TYPE", objMessages).trim();
            return strMSGType;
        }
        catch (Exception e) {
            System.err.println("getReceiverXMLMSGType(String strPOSTXMLData) error: " + e.getMessage());
            return null;
        }
    }

    public MSGResult getMOMSGResult(String strResponseXML) {
        MSGResult msgResult = new MSGResult();
        try {
            InputSource source = new InputSource(new StringReader(strResponseXML));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            String strOriginatorID = configXPath.evaluate("MSG/@ORIGINATOR_ID", objMessages).trim();
            long lnMSGID = Long.parseLong(configXPath.evaluate("MSG/@ID", objMessages).trim());
            long lnProductID = Long.parseLong(configXPath.evaluate("MSG/@PRODUCT_ID", objMessages).trim());
            String strMSGType = configXPath.evaluate("MSG/@TYPE", objMessages).trim();
            int intResponseCode = Integer.parseInt(configXPath.evaluate("MSG/RESPONSE_CODE", objMessages).trim());
            String strResponseDescription = configXPath.evaluate("MSG/DESCRIPTION", objMessages).trim();
            String strReference = configXPath.evaluate("MSG/REFERENCE", objMessages).trim();
            String strDateCreated = configXPath.evaluate("MSG/DATE_CREATED", objMessages).trim();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource domsource = new DOMSource((Node)configXPath.evaluate("/MESSAGES/MSG/OTHER_DETAILS", xmlDocument, XPathConstants.NODE));
            StringWriter writer = new StringWriter();
            transformer.transform(domsource, new StreamResult(writer));
            String strOtherDetails = writer.getBuffer().toString();
            String strIntegrityHash = configXPath.evaluate("MSG/INTEGRITY_HASH", objMessages).trim();
            msgResult.setTransactionID(strOriginatorID);
            msgResult.setMSGID(lnMSGID);
            msgResult.setProductID(lnProductID);
            msgResult.setMSGType(strMSGType);
            msgResult.setResponseCode(intResponseCode);
            msgResult.setResponseDescription(strResponseDescription);
            msgResult.setReference(strReference);
            msgResult.setDateCreated(strDateCreated);
            msgResult.setOtherDetails(strOtherDetails);
            msgResult.setIntegrityHash(strIntegrityHash);
            return msgResult;
        }
        catch (Exception e) {
            System.err.println("getMSGOfflineResponse(String strResponseXML) error: " + e.getMessage());
            return null;
        }
    }

    public MSGResponse getMSGResponse(String strResponseXML) {
        MSGResponse msgResponse = new MSGResponse();
        try {
            InputSource source = new InputSource(new StringReader(strResponseXML));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            long lnMSGID = Long.parseLong(configXPath.evaluate("MSG/@ID", objMessages).trim());
            String strOriginatorID = configXPath.evaluate("MSG/@ORIGINATOR_ID", objMessages).trim();
            String strMSGType = configXPath.evaluate("MSG/@TYPE", objMessages).trim();
            String strResponse = configXPath.evaluate("MSG/RESPONSE", objMessages).trim();
            int intResponseCode = Integer.parseInt(configXPath.evaluate("MSG/RESPONSE_CODE", objMessages).trim());
            String strResponseDescription = configXPath.evaluate("MSG/DESCRIPTION", objMessages).trim();
            String strIntegrityHash = configXPath.evaluate("MSG/INTEGRITY_HASH", objMessages).trim();
            msgResponse.setMSGID(lnMSGID);
            msgResponse.setTransactionID(strOriginatorID);
            msgResponse.setMSGType(strMSGType);
            msgResponse.setResponse(strResponse);
            msgResponse.setResponseCode(intResponseCode);
            msgResponse.setResponseDescription(strResponseDescription);
            msgResponse.setIntegrityHash(strIntegrityHash);
            return msgResponse;
        }
        catch (Exception e) {
            System.err.println("getMSGOnlineResponse(String strResponseXML) error: " + e.getMessage());
            return null;
        }
    }

    public MSG getMOMSG(String strPOSTXMLData) {
        MSG theMSG = new MSG();
        try {
            InputSource source = new InputSource(new StringReader(strPOSTXMLData));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            long lnMSGID = Long.parseLong(configXPath.evaluate("MSG/@ID", objMessages).trim());
            long lnProductID = Long.parseLong(configXPath.evaluate("MSG/@PRODUCT_ID", objMessages).trim());
            String strMSGType = configXPath.evaluate("MSG/@TYPE", objMessages).trim();
            String strSender = configXPath.evaluate("MSG/FROM", objMessages).trim();
            String strReceiver = configXPath.evaluate("MSG/TO", objMessages).trim();
            String strMSG = configXPath.evaluate("MSG/TEXT", objMessages).trim();
            String strReference = configXPath.evaluate("MSG/REFERENCE", objMessages).trim();
            String strDateCreated = configXPath.evaluate("MSG/DATE_CREATED", objMessages).trim();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource domsource = new DOMSource((Node)configXPath.evaluate("/MESSAGES/MSG/OTHER_DETAILS", xmlDocument, XPathConstants.NODE));
            StringWriter writer = new StringWriter();
            transformer.transform(domsource, new StreamResult(writer));
            String strOtherDetails = writer.getBuffer().toString();
            String strIntegrityHash = configXPath.evaluate("MSG/INTEGRITY_HASH", objMessages).trim();
            theMSG.setMSGID(lnMSGID);
            theMSG.setProductID(lnProductID);
            Constants.MSGType[] mSGTypeArray = Constants.MSGType.values();
            int n = mSGTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constants.MSGType msgType = mSGTypeArray[n2];
                if (strMSGType.equalsIgnoreCase(msgType.getValue())) {
                    theMSG.setMSGType(msgType);
                }
                ++n2;
            }
            theMSG.setSender(strSender);
            theMSG.setReceiver(strReceiver);
            theMSG.setMSG(strMSG);
            theMSG.setMSGSourceReference(strReference);
            theMSG.setDateCreated(strDateCreated);
            theMSG.setMSGXMLData(strOtherDetails);
            theMSG.setIntegrityHash(strIntegrityHash);
            return theMSG;
        }
        catch (Exception e) {
            System.err.println("getMOMSG(String strPOSTXMLData) error: " + e.getMessage());
            return null;
        }
    }

    public static void setMOResponseParametersMSG(String strClientXMLParameters) {
        try {
            InputSource source = new InputSource(new StringReader(strClientXMLParameters));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/OTHER_DETAILS", xmlDocument, XPathConstants.NODE);
            String strClientResponseMode = configXPath.evaluate("MO_MSG/@MODE", objMessages).trim();
            String strClientResponseSuccessText = configXPath.evaluate("MO_MSG/TEXT/SUCCESS", objMessages).trim();
            String strClientResponseErrorText = configXPath.evaluate("MO_MSG/TEXT/ERROR", objMessages).trim();
            Constants.MOMSGResponseMode[] mOMSGResponseModeArray = Constants.MOMSGResponseMode.values();
            int n = mOMSGResponseModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constants.MOMSGResponseMode theMOMSGResponseMode = mOMSGResponseModeArray[n2];
                if (strClientResponseMode.equalsIgnoreCase(theMOMSGResponseMode.getValue())) {
                    LocalParameters.setClientMOMSGResponseMode(theMOMSGResponseMode);
                }
                ++n2;
            }
            LocalParameters.setClientMOMSGResponseSuccessText(strClientResponseSuccessText);
            LocalParameters.setClientMOMSGResponseErrorText(strClientResponseErrorText);
        }
        catch (Exception e) {
            System.err.println("setMOResponseParametersMSG(String strClientXMLParameters) error: " + e.getMessage());
        }
    }

    public String generateSytemHealthXMLString() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elSystemHealth = doc.createElement("SystemHealth");
            doc.appendChild(elSystemHealth);
            Attr attrVersion = doc.createAttribute("Version");
            attrVersion.setValue(Constants.SystemHealth.XMLVersion.getValue());
            elSystemHealth.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DateTime");
            attrDateTime.setValue(MSGClientDB.getDBDateTime());
            elSystemHealth.setAttributeNode(attrDateTime);
            Element elSystemStartTime = doc.createElement("SystemStartTime");
            elSystemStartTime.appendChild(doc.createTextNode(SystemHealth.getSystemStartTime().toString()));
            elSystemHealth.appendChild(elSystemStartTime);
            Element elSystemLastHeartBeatTime = doc.createElement("SystemLastHeartBeatTime");
            elSystemLastHeartBeatTime.appendChild(doc.createTextNode(SystemHealth.getSystemLastHeartBeatTime().toString()));
            elSystemHealth.appendChild(elSystemLastHeartBeatTime);
            Element elAuthErrorCount = doc.createElement("AuthErrorCount");
            elAuthErrorCount.appendChild(doc.createTextNode(Long.toString(SystemHealth.getAuthErrorCount())));
            elSystemHealth.appendChild(elAuthErrorCount);
            Element elLowCreditErrorCount = doc.createElement("LowCreditErrorCount");
            elLowCreditErrorCount.appendChild(doc.createTextNode(Long.toString(SystemHealth.getLowCreditErrorCount())));
            elSystemHealth.appendChild(elLowCreditErrorCount);
            Element elInvalidMSGErrorCount = doc.createElement("InvalidMSGErrorCount");
            elInvalidMSGErrorCount.appendChild(doc.createTextNode(Long.toString(SystemHealth.getInvalidMSGErrorCount())));
            elSystemHealth.appendChild(elInvalidMSGErrorCount);
            String output = this.convertDocumentToString(doc, false);
            output = output.trim();
            return output;
        }
        catch (Exception e) {
            System.err.println("sendMSG(ArrayList<MSG> smsArrList): " + e.getMessage());
            return null;
        }
    }

    public boolean validateXML(String theXML, String theSchema) {
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder parser = null;
        InputSource XMLSource = null;
        Document XMLDocument = null;
        StreamSource schemaSource = null;
        Schema schema = null;
        Validator validator = null;
        boolean isValidXML = false;
        try {
            try {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(false);
                parser = documentBuilderFactory.newDocumentBuilder();
                final String dtd = theSchema;
                parser.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(dtd);
                    }
                });
                XMLSource = new InputSource(new StringReader(theXML));
                XMLDocument = parser.parse(XMLSource);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schemaSource = new StreamSource(new StringReader(theSchema));
                schema = schemaFactory.newSchema(schemaSource);
                validator = schema.newValidator();
                validator.validate(new DOMSource(XMLDocument));
                isValidXML = true;
            }
            catch (Exception e) {
                isValidXML = false;
                System.err.println("XML is NOT valid - ERROR: " + e.getMessage());
                documentBuilderFactory = null;
                parser = null;
                XMLSource = null;
                XMLDocument = null;
                schemaSource = null;
                schema = null;
                validator = null;
            }
        }
        finally {
            documentBuilderFactory = null;
            parser = null;
            XMLSource = null;
            XMLDocument = null;
            schemaSource = null;
            schema = null;
            validator = null;
        }
        return isValidXML;
    }

    public String convertDocumentToString(Document doc, boolean bOmitXMLDeclaration) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            if (bOmitXMLDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "no");
            }
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

