/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class ServiceThread
extends Thread {
    Constants.ServiceType serviceType = null;
    MSGClientDB theMSGClientDB = new MSGClientDB();
    boolean bMTMSGServiceRunning = false;
    boolean bMOMSGServiceRunning = false;

    ServiceThread(Constants.ServiceType theServiceType) {
        this.serviceType = theServiceType;
        this.start();
    }

    @Override
    public void run() {
        try {
            if (this.serviceType.equals((Object)Constants.ServiceType.MT_MSG)) {
                System.out.println("MT MSG Service Activated\n");
                this.bMTMSGServiceRunning = true;
                this.runMTMSGService();
                this.bMTMSGServiceRunning = false;
                System.out.println("MT MSG  Service has Ended\n");
            } else if (this.serviceType.equals((Object)Constants.ServiceType.MO_MSG)) {
                System.out.println("MO MSG Service Activated\n");
                this.bMOMSGServiceRunning = true;
                this.runMOMSGService();
                this.bMOMSGServiceRunning = false;
                System.out.println("MO MSG Service has Ended\n");
            } else {
                System.err.println("\nINVALID MSG SERVICE - THREAD TERMINATED\n");
            }
        }
        catch (Exception e) {
            System.err.println("Thread - " + this.serviceType.getValue() + " error: " + e.getMessage());
        }
        System.out.println("Thread - " + this.serviceType.getValue() + " RUN is over");
    }

    public void stopService() {
        if (this.serviceType.equals((Object)Constants.ServiceType.MT_MSG)) {
            this.bMTMSGServiceRunning = false;
            System.out.println("Stopping MT MSG Service ...\n");
        } else if (this.serviceType.equals((Object)Constants.ServiceType.MO_MSG)) {
            System.out.println("Stopping MO MSG  Service ...\n");
            this.bMOMSGServiceRunning = false;
        } else {
            System.err.println("\nINVALID MSG SERVICE - THREAD TERMINATED\n");
        }
    }

    private void runMTMSGService() {
        try {
            try {
                this.theMSGClientDB.QueueValidRelayedMSG(Constants.MSGType.MT);
                boolean isNewMSG = true;
                while (this.bMTMSGServiceRunning) {
                    try {
                        if (LocalParameters.isMTMSGTableActive()) {
                            System.out.println("MT MSG Service is Active");
                            SystemHealth.setSystemLastHeartBeatTime();
                            ArrayList<MSG> msgArrList = this.theMSGClientDB.getMSGData(Constants.MSGType.MT);
                            System.out.println();
                            System.out.println(String.valueOf(msgArrList.size()) + " MSG ready to be sent ...\n");
                            if (msgArrList.size() > 0) {
                                isNewMSG = false;
                                MSGSender theMSGSender = new MSGSender();
                                if (RemoteParameters.getMaxMSGSenderThreads() > 1) {
                                    theMSGSender.processMSG(Constants.MSGType.MT, msgArrList);
                                } else {
                                    theMSGSender.sendMSG(msgArrList);
                                }
                                System.out.println(String.valueOf(msgArrList.size()) + " MSG Processed\n");
                            } else {
                                isNewMSG = true;
                            }
                            if (isNewMSG) {
                                System.out.println("\nWaiting for " + RemoteParameters.getPauseNewMSGSeconds() + " seconds to process NEW MT MSG Messages Batch");
                                Thread.sleep(RemoteParameters.getPauseNewMSGSeconds() * 1000);
                                continue;
                            }
                            System.out.println("\nWaiting for " + RemoteParameters.getPausePerMSGSeconds() + " seconds to process the NEXT MT MSG Messages Batch");
                            Thread.sleep(RemoteParameters.getPausePerMSGSeconds() * 1000);
                            continue;
                        }
                        System.out.println("MT MSG Service is CANNOT be Stated since MT MSG Table is NOT Active\n");
                        System.out.println("The Service will be terminated ...");
                        this.bMTMSGServiceRunning = false;
                        break;
                    }
                    catch (Exception e) {
                        System.err.println("Error on runMTMSGService() : " + e.getMessage());
                        System.out.println("\nWaiting for " + RemoteParameters.getPauseNewMSGSeconds() + " seconds to process NEW MT MSG Messages Batch");
                        Thread.sleep(RemoteParameters.getPauseNewMSGSeconds() * 1000);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error Occured while Starting runMTMSGService() : " + e.getMessage());
                this.bMTMSGServiceRunning = false;
                System.out.println("MT MSG Service STOPPED!");
            }
        }
        finally {
            this.bMTMSGServiceRunning = false;
            System.out.println("MT MSG Service STOPPED!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runMOMSGService() {
        try {
            try {
                while (true) {
                    if (!this.bMOMSGServiceRunning) {
                        return;
                    }
                    try {
                        if (!LocalParameters.isMOMSGTableActive()) {
                            System.out.println("MO MSG Service is CANNOT be Stated since MO MSG Table is NOT Active\n");
                            System.out.println("The Service will be terminated ...");
                            this.bMOMSGServiceRunning = false;
                            return;
                        }
                        System.out.println("MO MSG Service is Active");
                        System.out.println("MO MSG Service Thread will sleep for 60 seconds");
                        Thread.sleep(60000L);
                    }
                    catch (Exception e) {
                        System.err.println("Error on runMOMSGService() : " + e.getMessage());
                        System.out.println("MO MSG Service Thread will sleep for 60 seconds");
                        Thread.sleep(60000L);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error Occured while Starting runMOMSGService() : " + e.getMessage());
                this.bMOMSGServiceRunning = false;
                System.out.println("MO MSG Service STOPPED!");
                return;
            }
        }
        finally {
            this.bMOMSGServiceRunning = false;
            System.out.println("MO MSG Service STOPPED!");
        }
    }
}

