/*
 * Decompiled with CFR 0.152.
 */
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SystemHealth {
    private static long lnAuthErrorCount = 0L;
    private static long lnLowCreditErrorCount = 0L;
    private static long lnInvalidMSGErrorCount = 0L;
    private static Date systemStartTime = Calendar.getInstance().getTime();
    private static Date systemLastHeartBeatTime = Calendar.getInstance().getTime();

    public SystemHealth() {
        try {
            lnAuthErrorCount = 0L;
            lnLowCreditErrorCount = 0L;
            lnInvalidMSGErrorCount = 0L;
            systemStartTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(MSGClientDB.getDBDateTime());
            systemLastHeartBeatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(MSGClientDB.getDBDateTime());
        }
        catch (ParseException e) {
            System.err.println("SystemHealth() ParseException: " + e.getMessage());
            System.err.println("Local System Time will be used");
            systemStartTime = Calendar.getInstance().getTime();
            systemLastHeartBeatTime = Calendar.getInstance().getTime();
        }
        catch (Exception e) {
            System.err.println("SystemHealth() Exception: " + e.getMessage());
        }
    }

    public static long getAuthErrorCount() {
        return lnAuthErrorCount;
    }

    public static long getLowCreditErrorCount() {
        return lnLowCreditErrorCount;
    }

    public static long getInvalidMSGErrorCount() {
        return lnInvalidMSGErrorCount;
    }

    public static Date getSystemStartTime() {
        return systemStartTime;
    }

    public static Date getSystemLastHeartBeatTime() {
        return systemLastHeartBeatTime;
    }

    public static long getSystemUpTime() {
        long longStartTime = 0L;
        long longCurrentTime = 0L;
        long sysUpTime = 0L;
        try {
            longStartTime = SystemHealth.getSystemStartTime().getTime();
            longCurrentTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(MSGClientDB.getDBDateTime()).getTime();
            sysUpTime = longCurrentTime - longStartTime;
        }
        catch (ParseException e) {
            System.err.println("SystemHealth() ParseException: " + e.getMessage());
            System.err.println("Local System Time will be used");
            longStartTime = SystemHealth.getSystemStartTime().getTime();
            longCurrentTime = Calendar.getInstance().getTime().getTime();
            sysUpTime = longCurrentTime - longStartTime;
        }
        catch (Exception e) {
            System.err.println("SystemHealth() Exception: " + e.getMessage());
        }
        return sysUpTime /= 1000L;
    }

    public static String getSystemUpTimeInWords() {
        long longStartTime = 0L;
        long longCurrentTime = 0L;
        long sysUpTime = 0L;
        try {
            longStartTime = SystemHealth.getSystemStartTime().getTime();
            longCurrentTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(MSGClientDB.getDBDateTime()).getTime();
            sysUpTime = longCurrentTime - longStartTime;
        }
        catch (ParseException e) {
            System.err.println("SystemHealth() ParseException: " + e.getMessage());
            System.err.println("Local System Time will be used");
            longStartTime = SystemHealth.getSystemStartTime().getTime();
            longCurrentTime = Calendar.getInstance().getTime().getTime();
            sysUpTime = longCurrentTime - longStartTime;
        }
        catch (Exception e) {
            System.err.println("SystemHealth() Exception: " + e.getMessage());
        }
        if ((sysUpTime /= 1000L) < 60L) {
            return String.valueOf(sysUpTime) + " Seconds";
        }
        if (sysUpTime >= 60L && sysUpTime < 3600L) {
            long minutes = sysUpTime / 60L;
            long seconds = sysUpTime % 60L;
            return String.valueOf(minutes) + " Minutes " + seconds + " Seconds";
        }
        if (sysUpTime >= 3600L && sysUpTime < 86400L) {
            long hours = sysUpTime / 3600L;
            long seconds = sysUpTime % 3600L;
            long minutes = seconds / 60L;
            return String.valueOf(hours) + " Hours " + minutes + " Minutes " + (seconds %= 60L) + " Seconds";
        }
        if (sysUpTime >= 86400L) {
            long days = sysUpTime / 86400L;
            long seconds = sysUpTime % 86400L;
            long hours = seconds / 3600L;
            long minutes = (seconds %= 3600L) / 60L;
            return String.valueOf(days) + " Days " + hours + " Hours " + minutes + " Minutes " + (seconds %= 60L) + " Seconds";
        }
        return null;
    }

    public static void setAuthErrorCount(long theAuthErrorCount) {
        lnAuthErrorCount = theAuthErrorCount;
    }

    public static void setLowCreditErrorCount(long theLowCreditErrorCount) {
        lnLowCreditErrorCount = theLowCreditErrorCount;
    }

    public static void setInvalidMSGErrorCount(long theInvalidMSGErrorCount) {
        lnInvalidMSGErrorCount = theInvalidMSGErrorCount;
    }

    public static void setSystemStartTime() {
        try {
            systemStartTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(MSGClientDB.getDBDateTime());
        }
        catch (ParseException e) {
            System.err.println("SystemHealth() ParseException: " + e.getMessage());
            System.err.println("Local System Time will be used");
            systemStartTime = Calendar.getInstance().getTime();
        }
        catch (Exception e) {
            System.err.println("SystemHealth() Exception: " + e.getMessage());
        }
    }

    public static void setSystemLastHeartBeatTime() {
        try {
            systemLastHeartBeatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(MSGClientDB.getDBDateTime());
        }
        catch (ParseException e) {
            System.err.println("SystemHealth() ParseException: " + e.getMessage());
            System.err.println("Local System Time will be used");
            systemLastHeartBeatTime = Calendar.getInstance().getTime();
        }
        catch (Exception e) {
            System.err.println("SystemHealth() Exception: " + e.getMessage());
        }
    }
}

