/*
 * Decompiled with CFR 0.152.
 */
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Map;
import javax.security.cert.X509Certificate;

class WebServerHandler
implements HttpHandler {
    boolean bClientAuthEnabled = false;

    public WebServerHandler(boolean bClientAuthEnabled) {
        this.bClientAuthEnabled = bClientAuthEnabled;
    }

    public WebServerHandler() {
        this.bClientAuthEnabled = false;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String s;
        String requestHost = exchange.getRemoteAddress().getHostString();
        String requestPath = exchange.getRequestURI().getPath();
        int requestPort = exchange.getLocalAddress().getPort();
        System.out.println("Remote IP: " + requestHost + " Accessing: " + requestPath + " on PORT: " + requestPort);
        String strClientEmailAddress = null;
        if (this.bClientAuthEnabled) {
            try {
                HttpsExchange exchangeHTTPS = (HttpsExchange)exchange;
                X509Certificate[] peerCertificateChain = exchangeHTTPS.getSSLSession().getPeerCertificateChain();
                X509Certificate clientcert = peerCertificateChain[0];
                String strDelimiter = ",";
                String strEmailAddressDN = "EMAILADDRESS";
                Map<String, String> clientSubjectDN = Utils.queryToMap(clientcert.getSubjectDN().toString().toLowerCase(), strDelimiter);
                strClientEmailAddress = clientSubjectDN.get(strEmailAddressDN.toLowerCase());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        String requestMethod = exchange.getRequestMethod();
        Headers responseHeaders = exchange.getResponseHeaders();
        responseHeaders.set("Content-Type", "text/html");
        exchange.sendResponseHeaders(200, 0L);
        OutputStream responseBody = exchange.getResponseBody();
        if (requestMethod.equalsIgnoreCase("GET")) {
            responseHeaders.set("Content-Type", "text/html");
            s = "Access denied. Method NOT Supported.";
            responseBody.write(s.getBytes());
            responseBody.close();
        } else if (requestMethod.equalsIgnoreCase("POST")) {
            responseHeaders.set("Content-Type", "text/xml");
            String strPOSTData = "";
            BufferedReader rd = new BufferedReader(new InputStreamReader(exchange.getRequestBody()));
            String line = null;
            while ((line = rd.readLine()) != null) {
                strPOSTData = String.valueOf(strPOSTData) + line;
            }
            rd.close();
            String strResponseData = this.processMessagingXMLPOSTData(strClientEmailAddress, requestHost, requestPath, requestPort, strPOSTData);
            responseBody.write(strResponseData.getBytes());
            responseBody.close();
        } else {
            responseHeaders.set("Content-Type", "text/plain");
            s = "Access denied. Method NOT Supported.";
            responseBody.write(s.getBytes());
            responseBody.close();
        }
    }

    private String processMessagingXMLPOSTData(String strClientEmailAddress, String strRequestHost, String strRequestPath, int intRequestPort, String strPOSTData) {
        String strReturnPOSTData;
        block35: {
            MSGXMLFactory theMSGXMLFactory = new MSGXMLFactory();
            MSGResponse theResponse = new MSGResponse();
            theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
            theResponse.setResponseDescription("No Response was provided.");
            theResponse.setResponseMode(LocalParameters.getClientMOMSGResponseMode().getValue());
            long lnWrapperID = 0L;
            strReturnPOSTData = null;
            String strPesaType = "";
            try {
                try {
                    System.out.println("EMAILADDRESS=" + strClientEmailAddress);
                    System.out.println();
                    System.out.println("Host : " + strRequestHost);
                    System.out.println("Path : " + strRequestPath);
                    System.out.println("Port : " + intRequestPort);
                    System.out.println();
                    String[] allowedAccessSources = WebServerParameters.getMessagingWebServerAllowedAccessSources().split(",");
                    String[] restrictedAccessSources = WebServerParameters.getMessagingWebServerRestrictedAccessSources().split(",");
                    boolean bAccessSourceAllowed = false;
                    if (this.bClientAuthEnabled && LocalParameters.getSystemUsername().equalsIgnoreCase(strClientEmailAddress) || !this.bClientAuthEnabled) {
                        if (WebServerParameters.getMessagingWebServerAllowedAccessSourcesEnabled().equals((Object)Constants.Enabled.YES)) {
                            if (WebServerParameters.getMessagingWebServerAllowedAccessSourcesMatchType().equals((Object)Constants.MatchType.STRING) && Utils.findStringInArray(strRequestHost, allowedAccessSources) || WebServerParameters.getMessagingWebServerAllowedAccessSourcesMatchType().equals((Object)Constants.MatchType.REGEX) && Utils.findRegexInArray(strRequestHost, allowedAccessSources)) {
                                bAccessSourceAllowed = true;
                            } else {
                                bAccessSourceAllowed = false;
                                theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                theResponse.setResponseDescription("Access Denied. The Source is NOT allowed to access this service.");
                                System.out.println(theResponse.getResponseDescription());
                                System.out.println("Messaging Web Server Allowed Access Sources Enabled       : " + (Object)((Object)WebServerParameters.getMessagingWebServerAllowedAccessSourcesEnabled()));
                                System.out.println("Messaging Web Server Allowed Access Sources Match Type    : " + (Object)((Object)WebServerParameters.getMessagingWebServerAllowedAccessSourcesMatchType()));
                                System.out.println("Messaging Web Server Allowed Access Sources               : " + WebServerParameters.getMessagingWebServerAllowedAccessSources());
                            }
                        } else if (WebServerParameters.getMessagingWebServerRestrictedAccessSourcesEnabled().equals((Object)Constants.Enabled.YES)) {
                            if (WebServerParameters.getMessagingWebServerRestrictedAccessSourcesMatchType().equals((Object)Constants.MatchType.STRING) && Utils.findStringInArray(strRequestHost, restrictedAccessSources) || WebServerParameters.getMessagingWebServerRestrictedAccessSourcesMatchType().equals((Object)Constants.MatchType.REGEX) && Utils.findRegexInArray(strRequestHost, restrictedAccessSources)) {
                                bAccessSourceAllowed = false;
                                theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                theResponse.setResponseDescription(" Access Denied - The Source is RESTRICTED to access this service.");
                                System.out.println(theResponse.getResponseDescription());
                                System.out.println("Messaging Web Server Restricted Access Sources Enabled    : " + (Object)((Object)WebServerParameters.getMessagingWebServerRestrictedAccessSourcesEnabled()));
                                System.out.println("Messaging Web Server Restricted Access Sources Match Type : " + (Object)((Object)WebServerParameters.getMessagingWebServerRestrictedAccessSourcesMatchType()));
                                System.out.println("Messaging Web Server Restricted Access Sources            : " + WebServerParameters.getMessagingWebServerRestrictedAccessSources());
                            } else {
                                bAccessSourceAllowed = true;
                            }
                        } else {
                            bAccessSourceAllowed = true;
                        }
                    } else {
                        bAccessSourceAllowed = false;
                        theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                        theResponse.setResponseDescription("Access Denied - Certificate User does NOT match application user account.");
                    }
                    boolean bProcessXML = false;
                    if (!bAccessSourceAllowed) break block35;
                    if (strRequestPath.equalsIgnoreCase(WebServerParameters.getMessagingWebServerHomeFilePath()) && intRequestPort == WebServerParameters.getMessagingWebServerPort()) {
                        Map<String, String> parms = Utils.queryToMap(strPOSTData, "&");
                        String strPOSTXMLData = parms.get("data");
                        if (strPOSTXMLData != null) {
                            strPOSTXMLData = URLDecoder.decode(strPOSTXMLData, "UTF-8");
                            if (RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.Rijndael_128)) {
                                System.out.println("Client Encryption Type " + (Object)((Object)Constants.EncryptionType.Rijndael_128) + " Enabled");
                                if (theMSGXMLFactory.validateXML(strPOSTXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='WRAPPER'><xs:complexType><xs:simpleContent><xs:extension base='xs:string'><xs:attribute type='xs:string' name='ID' use='required'/><xs:attribute type='xs:string' name='t' use='required'/></xs:extension></xs:simpleContent></xs:complexType></xs:element></xs:schema>")) {
                                    MSGWrapper theMSGWrapper = theMSGXMLFactory.getMSGWrapper(strPOSTXMLData);
                                    Crypto theCrypto = new Crypto();
                                    String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + theMSGWrapper.getTimeStamp();
                                    strPOSTXMLData = theCrypto.decrypt(strEncryptionKey, theMSGWrapper.getEncryptedData());
                                    lnWrapperID = theMSGWrapper.getID();
                                    if (lnWrapperID != LocalParameters.getSystemUserID()) {
                                        theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                        theResponse.setResponseDescription("Wrapper ID/System User ID Miss Match.");
                                    } else {
                                        bProcessXML = true;
                                    }
                                } else {
                                    theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                    theResponse.setResponseDescription("Invalid WRAPPER XML.");
                                }
                            } else if (RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.NONE)) {
                                System.out.println("Client Encryption Type " + (Object)((Object)Constants.EncryptionType.NONE) + " Enabled");
                                bProcessXML = true;
                            } else {
                                System.out.println("Client Encryption Type '" + (Object)((Object)LocalParameters.getClientEncryptionType()) + "' is NOT Supported.");
                            }
                            if (bProcessXML) {
                                MSGReceiver theMSGReceiver;
                                strPesaType = theMSGXMLFactory.getReceiverXMLMSGType(strPOSTXMLData);
                                theResponse.setMSGType(strPesaType);
                                if (strPesaType.equalsIgnoreCase(Constants.MSGType.MT.getValue())) {
                                    if (LocalParameters.isMTMSGServiceActive()) {
                                        theMSGReceiver = new MSGReceiver();
                                        theMSGReceiver.processMTMSGResult(theMSGXMLFactory, strPOSTXMLData, theResponse);
                                    } else {
                                        theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                        theResponse.setResponseDescription("MT MSG Service is NOT Active. Message NOT Accepted");
                                    }
                                } else if (strPesaType.equalsIgnoreCase(Constants.MSGType.MO.getValue())) {
                                    if (LocalParameters.isMOMSGServiceActive()) {
                                        theMSGReceiver = new MSGReceiver();
                                        theMSGReceiver.processMOMSG(theMSGXMLFactory, strPOSTXMLData, theResponse);
                                    } else {
                                        theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                        theResponse.setResponseDescription("MO MSG Service is NOT Active. Message Update NOT Accepted");
                                    }
                                } else {
                                    theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                                    theResponse.setResponseDescription("MSG Type '" + strPesaType + "' is NOT Supported.");
                                }
                            }
                        } else {
                            theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                            theResponse.setResponseDescription("NO POST Data Found.");
                        }
                        break block35;
                    }
                    theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                    theResponse.setResponseDescription("Access Denied, Invalid Path or Port Specified.");
                    System.out.println();
                    System.out.println("Messaging Web Server Path  : " + WebServerParameters.getMessagingWebServerHomeFilePath());
                    System.out.println("Messaging Web Server Port  : " + WebServerParameters.getMessagingWebServerPort());
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    theResponse.setResponse(Constants.MSGServerResponse.ERROR.getValue());
                    theResponse.setResponseDescription("System Error: " + e.getMessage());
                    System.out.println(String.valueOf(theResponse.getResponse()) + " : " + theResponse.getResponseDescription());
                    strReturnPOSTData = theMSGXMLFactory.generateUpdateMSGResponseXMLString(lnWrapperID, theResponse);
                }
            }
            finally {
                System.out.println(String.valueOf(theResponse.getResponse()) + " : " + theResponse.getResponseDescription());
                strReturnPOSTData = theMSGXMLFactory.generateUpdateMSGResponseXMLString(lnWrapperID, theResponse);
            }
        }
        return strReturnPOSTData;
    }
}

