/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CofigFile {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setGlobalDBParameters() {
        try {
            Crypto theCrypto;
            System.out.println("\n*********************************************************");
            System.out.println("            SETTING CONFIG FILE PARAMETERS");
            System.out.println("*********************************************************\n");
            long lnConfigFileSize = Utils.getFileSize(LocalParameters.getDBConfigFilePath());
            if (lnConfigFileSize > 102400L) {
                System.out.println("Configuration File Too Large. File Size: " + lnConfigFileSize + " bytes, Maximum Size Allowed: " + 102400L + " bytes");
                return false;
            }
            PESAXMLFactory thePESAXMLFactory = new PESAXMLFactory();
            String strConfigFileXMLString = Utils.readFile(LocalParameters.getDBConfigFilePath());
            if (!thePESAXMLFactory.validateXML(strConfigFileXMLString, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='CONFIG'><xs:complexType><xs:sequence><xs:element name='DATABASE' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element name='TYPE' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='MySQL' /><xs:enumeration value='MicrosoftSQL' /><xs:enumeration value='Oracle' /><xs:enumeration value='PostgreSQL' /><xs:enumeration value='MicrosoftAccess' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:string' name='HOSTNAME' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='PORT' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='NAME' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='USERNAME' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='PASSWORD' maxOccurs='1' minOccurs='1'/><xs:element name='PASSWORD_TYPE' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='CLEARTEXT' /><xs:enumeration value='ENCRYPTED' /></xs:restriction></xs:simpleType></xs:element></xs:sequence></xs:complexType></xs:element><xs:element name='TABLES' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element name='CLIENT_WEB_SERVERS_PARAMETERS_TABLE' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/></xs:sequence></xs:complexType></xs:element><xs:element name='CLIENT_PARAMETERS_TABLE' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/><xs:element type='xs:unsignedLong' name='PARAMETERS_ID_FIELD_VALUE' maxOccurs='1' minOccurs='1'/></xs:sequence></xs:complexType></xs:element><xs:element name='PESA_IN_TABLE' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_TYPE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_PRODUCT_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='APPLY_TRANSACTION_CHARGE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_CODE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_DESCRIPTION_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SENDER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SENDER_DETAILS_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='RECEIVER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='RECEIVER_DETAILS_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='CURRENCY_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='AMOUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='ACCOUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SOURCE_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_DESTINATION_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_PRIORITY_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SEND_COUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SEND_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SCHEDULE_PESA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_SCHEDULED_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_CREATED_FIELD' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='STATUS' use='required'/></xs:complexType></xs:element><xs:element name='PESA_OUT_TABLE' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_TYPE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_PRODUCT_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='APPLY_TRANSACTION_CHARGE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_CODE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_DESCRIPTION_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SENDER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SENDER_DETAILS_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='RECEIVER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='RECEIVER_DETAILS_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='CURRENCY_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='AMOUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='ACCOUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SOURCE_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_DESTINATION_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_PRIORITY_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SEND_COUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SEND_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SCHEDULE_PESA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_SCHEDULED_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_CREATED_FIELD' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='STATUS' use='required'/></xs:complexType></xs:element><xs:element name='BUY_AIRTIME_TABLE' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:element type='xs:string' name='TABLE_NAME' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_TYPE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_PRODUCT_ID_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='APPLY_TRANSACTION_CHARGE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_CODE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_DESCRIPTION_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_STATUS_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SENDER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SENDER_DETAILS_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='RECEIVER_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='RECEIVER_DETAILS_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='CURRENCY_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='AMOUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='ACCOUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SOURCE_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_DESTINATION_REFERENCE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_PRIORITY_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SEND_COUNT_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_SEND_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_XML_DATA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='PESA_RESPONSE_INTEGRITY_HASH_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='SCHEDULE_PESA_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_SCHEDULED_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='TRANSACTION_DATE_FIELD' maxOccurs='1' minOccurs='0'/><xs:element type='xs:string' name='DATE_CREATED_FIELD' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='STATUS' use='required'/></xs:complexType></xs:element></xs:sequence></xs:complexType></xs:element></xs:sequence></xs:complexType></xs:element></xs:schema>")) {
                System.err.println("Configuration XML File is NOT VALID.");
                return false;
            }
            InputSource source = new InputSource(new StringReader(strConfigFileXMLString));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objConfig = configXPath.evaluate("/CONFIG", xmlDocument, XPathConstants.NODE);
            Constants.DatabaseType enDatabaseType = null;
            String strDatabaseType = configXPath.evaluate("DATABASE/TYPE", objConfig).trim();
            Constants.DatabaseType[] databaseTypeArray = Constants.DatabaseType.values();
            int n = databaseTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constants.DatabaseType databaseType = databaseTypeArray[n2];
                if (strDatabaseType.equalsIgnoreCase(databaseType.getValue())) {
                    enDatabaseType = databaseType;
                }
                ++n2;
            }
            String strDatabaseHostName = configXPath.evaluate("DATABASE/HOSTNAME", objConfig).trim();
            int intDatabasePort = Integer.parseInt(configXPath.evaluate("DATABASE/PORT", objConfig).trim());
            String strDatabaseName = configXPath.evaluate("DATABASE/NAME", objConfig).trim();
            String strDatabaseUsername = configXPath.evaluate("DATABASE/USERNAME", objConfig).trim();
            String strDatabasePassword = configXPath.evaluate("DATABASE/PASSWORD", objConfig).trim();
            Constants.PasswordType enDatabasePasswordType = null;
            String strDatabasePasswordType = configXPath.evaluate("DATABASE/PASSWORD_TYPE", objConfig).trim();
            Constants.PasswordType[] passwordTypeArray = Constants.PasswordType.values();
            int n3 = passwordTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Constants.PasswordType databasePasswordType = passwordTypeArray[n4];
                if (strDatabasePasswordType.equalsIgnoreCase(databasePasswordType.getValue())) {
                    enDatabasePasswordType = databasePasswordType;
                }
                ++n4;
            }
            String strClientWebServersParametersTableName = configXPath.evaluate("TABLES/CLIENT_WEB_SERVERS_PARAMETERS_TABLE/TABLE_NAME", objConfig).trim();
            String strClientParametersTableName = configXPath.evaluate("TABLES/CLIENT_PARAMETERS_TABLE/TABLE_NAME", objConfig).trim();
            int intParametersID = Integer.parseInt(configXPath.evaluate("TABLES/CLIENT_PARAMETERS_TABLE/PARAMETERS_ID_FIELD_VALUE", objConfig).trim());
            strClientWebServersParametersTableName = strClientWebServersParametersTableName.length() > 0 ? strClientWebServersParametersTableName : LocalParameters.getClientWebServersParametersTableName();
            String string = strClientParametersTableName = strClientParametersTableName.length() > 0 ? strClientParametersTableName : LocalParameters.getClientParametersTableName();
            if (!enDatabasePasswordType.getValue().equalsIgnoreCase(Constants.PasswordType.ENCRYPTED.getValue())) {
                System.out.println("\nEncrypting Database Password ...\n");
                theCrypto = new Crypto();
                String strDatabasePassword_ENCRYPTED = theCrypto.encrypt(Constants.strKey, strDatabasePassword);
                Element elDatabasePassword = (Element)configXPath.evaluate("DATABASE/PASSWORD", objConfig, XPathConstants.NODE);
                elDatabasePassword.setTextContent(strDatabasePassword_ENCRYPTED);
                Element elDatabasePasswordType = (Element)configXPath.evaluate("DATABASE/PASSWORD_TYPE", objConfig, XPathConstants.NODE);
                elDatabasePasswordType.setTextContent(Constants.PasswordType.ENCRYPTED.getValue());
                if (!Utils.writeFile(LocalParameters.getDBConfigFilePath(), thePESAXMLFactory.convertDocumentToString(xmlDocument, false))) {
                    System.out.println("\nParameter File Password Protection FAILED!\n");
                    return false;
                }
                System.out.println("\nParameter File Password Protected Successfully\n");
                enDatabasePasswordType = Constants.PasswordType.ENCRYPTED;
            } else {
                System.out.println("\nDatabase Password is Protected\n");
                theCrypto = new Crypto();
                strDatabasePassword = theCrypto.decrypt(Constants.strKey, strDatabasePassword);
            }
            System.out.println("\nDatabase Config File Parameters ... ");
            LocalParameters.setDatabaseType(enDatabaseType);
            LocalParameters.setDatabaseHostName(strDatabaseHostName);
            LocalParameters.setDatabasePort(intDatabasePort);
            LocalParameters.setDatabaseName(strDatabaseName);
            LocalParameters.setDatabaseUsername(strDatabaseUsername);
            LocalParameters.setDatabasePassword(strDatabasePassword);
            LocalParameters.setDatabasePasswordType(enDatabasePasswordType);
            LocalParameters.setClientWebServersParametersTableName(strClientWebServersParametersTableName);
            LocalParameters.setClientParametersTableName(strClientParametersTableName);
            LocalParameters.setParametersID(intParametersID);
            System.out.println("Database Type             : " + (Object)((Object)LocalParameters.getDatabaseType()));
            System.out.println("Database Host Name        : " + LocalParameters.getDatabaseHostName());
            System.out.println("Database Port             : " + LocalParameters.getDatabasePort());
            System.out.println("Database Name             : " + LocalParameters.getDatabaseName());
            System.out.println("Database Username         : " + LocalParameters.getDatabaseUsername());
            System.out.println("Database Password (Hidden): ******");
            System.out.println("Database Password Type    : " + (Object)((Object)LocalParameters.getDatabasePasswordType()));
            System.out.println();
            System.out.println("Client Web Servers Parameters Table Name       : " + LocalParameters.getClientWebServersParametersTableName());
            System.out.println("Client Parameters Table Name                   : " + LocalParameters.getClientParametersTableName());
            System.out.println("Parameters ID                                  : " + LocalParameters.getParametersID());
            System.out.println("\n*********************************************************");
            LocalParameters.setPESAINTableStatus(CofigFile.setPESAINTable(configXPath, objConfig));
            System.out.println("");
            LocalParameters.setPESAOUTTableStatus(CofigFile.setPESAOUTTable(configXPath, objConfig));
            System.out.println("*********************************************************\n");
            System.out.println("");
            LocalParameters.setBuyAirtimeTableStatus(CofigFile.setBuyAirtimeTable(configXPath, objConfig));
            System.out.println("*********************************************************\n");
            return true;
        }
        catch (Exception e) {
            System.err.println("An error has occured!!!\n" + e.toString());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setPESAOUTTable(XPath configXPath, Object objConfig) {
        String strPESAOUTTableName;
        block5: {
            block4: {
                try {
                    strPESAOUTTableName = configXPath.evaluate("TABLES/PESA_OUT_TABLE/TABLE_NAME", objConfig).trim();
                    if (strPESAOUTTableName.length() != 0 && !strPESAOUTTableName.isEmpty()) break block4;
                    System.out.println("PESA_OUT_TABLE Name NOT Provided");
                    return false;
                }
                catch (Exception e) {
                    System.err.println("setPESAOUTTable: An error has occured!!!\n" + e.toString());
                    e.printStackTrace();
                    return false;
                }
            }
            String strTableStatus = configXPath.evaluate("TABLES/PESA_OUT_TABLE/@STATUS", objConfig).trim();
            if (strTableStatus.equalsIgnoreCase(Constants.Status.ACTIVE.getValue())) break block5;
            System.out.println("PESA_OUT_TABLE STATUS NOT ACTIVE");
            return false;
        }
        String strPESAOUTTableFieldTransactionID = configXPath.evaluate("TABLES/PESA_OUT_TABLE/TRANSACTION_ID_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESAID = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_ID_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESAType = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_TYPE_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESAProductID = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_PRODUCT_ID_FIELD", objConfig).trim();
        String strPESAOUTTableFieldApplyTransactionCharge = configXPath.evaluate("TABLES/PESA_OUT_TABLE/APPLY_TRANSACTION_CHARGE_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESAStatusCode = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_STATUS_CODE_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESAStatusDescription = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_STATUS_DESCRIPTION_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESAStatusDate = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_STATUS_DATE_FIELD", objConfig).trim();
        String strPESAOUTTableFieldSender = configXPath.evaluate("TABLES/PESA_OUT_TABLE/SENDER_FIELD", objConfig).trim();
        String strPESAOUTTableFieldSenderDetails = configXPath.evaluate("TABLES/PESA_OUT_TABLE/SENDER_DETAILS_FIELD", objConfig).trim();
        String strPESAOUTTableFieldReceiver = configXPath.evaluate("TABLES/PESA_OUT_TABLE/RECEIVER_FIELD", objConfig).trim();
        String strPESAOUTTableFieldReceiverDetails = configXPath.evaluate("TABLES/PESA_OUT_TABLE/RECEIVER_DETAILS_FIELD", objConfig).trim();
        String strPESAOUTTableFieldCurrency = configXPath.evaluate("TABLES/PESA_OUT_TABLE/CURRENCY_FIELD", objConfig).trim();
        String strPESAOUTTableFieldAmount = configXPath.evaluate("TABLES/PESA_OUT_TABLE/AMOUNT_FIELD", objConfig).trim();
        String strPESAOUTTableFieldAccount = configXPath.evaluate("TABLES/PESA_OUT_TABLE/ACCOUNT_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESASourceReference = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_SOURCE_REFERENCE_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESADestinationReference = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_DESTINATION_REFERENCE_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESAXMLData = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_XML_DATA_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESAPriority = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_PRIORITY_FIELD", objConfig).trim();
        String strPESAOUTTableFieldPESASendCount = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_SEND_COUNT_FIELD", objConfig).trim();
        String strPESAOUTTableFieldDateScheduled = configXPath.evaluate("TABLES/PESA_OUT_TABLE/DATE_SCHEDULED_FIELD", objConfig).trim();
        String strPESAOUTTableFieldSendIntegrityHash = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_SEND_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strPESAOUTTableFieldResponseDate = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_RESPONSE_DATE_FIELD", objConfig).trim();
        String strPESAOUTTableFieldResponseXMLData = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_RESPONSE_XML_DATA_FIELD", objConfig).trim();
        String strPESAOUTTableFieldResponseIntegrityHash = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_RESPONSE_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strPESAOUTTableFieldSchedulePesa = configXPath.evaluate("TABLES/PESA_OUT_TABLE/SCHEDULE_PESA_FIELD", objConfig).trim();
        String strPESAOUTTableFieldTransactionDate = configXPath.evaluate("TABLES/PESA_OUT_TABLE/TRANSACTION_DATE_FIELD", objConfig).trim();
        String strPESAOUTTableFieldDateCreated = configXPath.evaluate("TABLES/PESA_OUT_TABLE/DATE_CREATED_FIELD", objConfig).trim();
        PESAOUTTable thePESAOUTTable = new PESAOUTTable();
        strPESAOUTTableName = strPESAOUTTableName.length() > 0 ? strPESAOUTTableName : thePESAOUTTable.getPESATableName();
        strPESAOUTTableFieldTransactionID = strPESAOUTTableFieldTransactionID.length() > 0 ? strPESAOUTTableFieldTransactionID : thePESAOUTTable.getPESATableFieldTransactionID();
        strPESAOUTTableFieldPESAID = strPESAOUTTableFieldPESAID.length() > 0 ? strPESAOUTTableFieldPESAID : thePESAOUTTable.getPESATableFieldPESAID();
        strPESAOUTTableFieldPESAType = strPESAOUTTableFieldPESAType.length() > 0 ? strPESAOUTTableFieldPESAType : thePESAOUTTable.getPESATableFieldPESAType();
        strPESAOUTTableFieldPESAProductID = strPESAOUTTableFieldPESAProductID.length() > 0 ? strPESAOUTTableFieldPESAProductID : thePESAOUTTable.getPESATableFieldPESAProductID();
        strPESAOUTTableFieldPESAStatusCode = strPESAOUTTableFieldPESAStatusCode.length() > 0 ? strPESAOUTTableFieldPESAStatusCode : thePESAOUTTable.getPESATableFieldPESAStatusCode();
        strPESAOUTTableFieldPESAStatusDescription = strPESAOUTTableFieldPESAStatusDescription.length() > 0 ? strPESAOUTTableFieldPESAStatusDescription : thePESAOUTTable.getPESATableFieldPESAStatusDescription();
        strPESAOUTTableFieldPESAStatusDate = strPESAOUTTableFieldPESAStatusDate.length() > 0 ? strPESAOUTTableFieldPESAStatusDate : thePESAOUTTable.getPESATableFieldPESAStatusDate();
        strPESAOUTTableFieldSender = strPESAOUTTableFieldSender.length() > 0 ? strPESAOUTTableFieldSender : thePESAOUTTable.getPESATableFieldSender();
        strPESAOUTTableFieldSenderDetails = strPESAOUTTableFieldSenderDetails.length() > 0 ? strPESAOUTTableFieldSenderDetails : thePESAOUTTable.getPESATableFieldSenderDetails();
        strPESAOUTTableFieldReceiver = strPESAOUTTableFieldReceiver.length() > 0 ? strPESAOUTTableFieldReceiver : thePESAOUTTable.getPESATableFieldReceiver();
        strPESAOUTTableFieldReceiverDetails = strPESAOUTTableFieldReceiverDetails.length() > 0 ? strPESAOUTTableFieldReceiverDetails : thePESAOUTTable.getPESATableFieldReceiverDetails();
        strPESAOUTTableFieldCurrency = strPESAOUTTableFieldCurrency.length() > 0 ? strPESAOUTTableFieldCurrency : thePESAOUTTable.getPESATableFieldCurrency();
        strPESAOUTTableFieldAmount = strPESAOUTTableFieldAmount.length() > 0 ? strPESAOUTTableFieldAmount : thePESAOUTTable.getPESATableFieldAmount();
        strPESAOUTTableFieldAccount = strPESAOUTTableFieldAccount.length() > 0 ? strPESAOUTTableFieldAccount : thePESAOUTTable.getPESATableFieldAccount();
        strPESAOUTTableFieldPESASourceReference = strPESAOUTTableFieldPESASourceReference.length() > 0 ? strPESAOUTTableFieldPESASourceReference : thePESAOUTTable.getPESATableFieldPESASourceReference();
        strPESAOUTTableFieldPESADestinationReference = strPESAOUTTableFieldPESADestinationReference.length() > 0 ? strPESAOUTTableFieldPESADestinationReference : thePESAOUTTable.getPESATableFieldPESADestinationReference();
        strPESAOUTTableFieldPESAXMLData = strPESAOUTTableFieldPESAXMLData.length() > 0 ? strPESAOUTTableFieldPESAXMLData : thePESAOUTTable.getPESATableFieldPESAXMLData();
        strPESAOUTTableFieldPESAPriority = strPESAOUTTableFieldPESAPriority.length() > 0 ? strPESAOUTTableFieldPESAPriority : thePESAOUTTable.getPESATableFieldPESAPriority();
        strPESAOUTTableFieldPESASendCount = strPESAOUTTableFieldPESASendCount.length() > 0 ? strPESAOUTTableFieldPESASendCount : thePESAOUTTable.getPESATableFieldPESASendCount();
        strPESAOUTTableFieldSendIntegrityHash = strPESAOUTTableFieldSendIntegrityHash.length() > 0 ? strPESAOUTTableFieldSendIntegrityHash : thePESAOUTTable.getPESATableFieldSendIntegrityHash();
        strPESAOUTTableFieldResponseDate = strPESAOUTTableFieldResponseDate.length() > 0 ? strPESAOUTTableFieldResponseDate : thePESAOUTTable.getPESATableFieldResponseDate();
        strPESAOUTTableFieldResponseXMLData = strPESAOUTTableFieldResponseXMLData.length() > 0 ? strPESAOUTTableFieldResponseXMLData : thePESAOUTTable.getPESATableFieldResponseXMLData();
        strPESAOUTTableFieldResponseIntegrityHash = strPESAOUTTableFieldResponseIntegrityHash.length() > 0 ? strPESAOUTTableFieldResponseIntegrityHash : thePESAOUTTable.getPESATableFieldResponseIntegrityHash();
        strPESAOUTTableFieldSchedulePesa = strPESAOUTTableFieldSchedulePesa.length() > 0 ? strPESAOUTTableFieldSchedulePesa : thePESAOUTTable.getPESATableFieldSchedulePesa();
        strPESAOUTTableFieldDateScheduled = strPESAOUTTableFieldDateScheduled.length() > 0 ? strPESAOUTTableFieldDateScheduled : thePESAOUTTable.getPESATableFieldDateScheduled();
        strPESAOUTTableFieldApplyTransactionCharge = strPESAOUTTableFieldApplyTransactionCharge.length() > 0 ? strPESAOUTTableFieldApplyTransactionCharge : thePESAOUTTable.getPESATableFieldApplyTransactionCharge();
        strPESAOUTTableFieldTransactionDate = strPESAOUTTableFieldTransactionDate.length() > 0 ? strPESAOUTTableFieldTransactionDate : thePESAOUTTable.getPESATableFieldTransactionDate();
        strPESAOUTTableFieldDateCreated = strPESAOUTTableFieldDateCreated.length() > 0 ? strPESAOUTTableFieldDateCreated : thePESAOUTTable.getPESATableFieldDateCreated();
        thePESAOUTTable.setPESATableName(strPESAOUTTableName);
        thePESAOUTTable.setPESATableFieldTransactionID(strPESAOUTTableFieldTransactionID);
        thePESAOUTTable.setPESATableFieldPESAID(strPESAOUTTableFieldPESAID);
        thePESAOUTTable.setPESATableFieldPESAType(strPESAOUTTableFieldPESAType);
        thePESAOUTTable.setPESATableFieldPESAProductID(strPESAOUTTableFieldPESAProductID);
        thePESAOUTTable.setPESATableFieldPESAStatusCode(strPESAOUTTableFieldPESAStatusCode);
        thePESAOUTTable.setPESATableFieldPESAStatusDescription(strPESAOUTTableFieldPESAStatusDescription);
        thePESAOUTTable.setPESATableFieldPESAStatusDate(strPESAOUTTableFieldPESAStatusDate);
        thePESAOUTTable.setPESATableFieldSender(strPESAOUTTableFieldSender);
        thePESAOUTTable.setPESATableFieldSenderDetails(strPESAOUTTableFieldSenderDetails);
        thePESAOUTTable.setPESATableFieldReceiver(strPESAOUTTableFieldReceiver);
        thePESAOUTTable.setPESATableFieldReceiverDetails(strPESAOUTTableFieldReceiverDetails);
        thePESAOUTTable.setPESATableFieldCurrency(strPESAOUTTableFieldCurrency);
        thePESAOUTTable.setPESATableFieldAmount(strPESAOUTTableFieldAmount);
        thePESAOUTTable.setPESATableFieldAccount(strPESAOUTTableFieldAccount);
        thePESAOUTTable.setPESATableFieldPESASourceReference(strPESAOUTTableFieldPESASourceReference);
        thePESAOUTTable.setPESATableFieldPESADestinationReference(strPESAOUTTableFieldPESADestinationReference);
        thePESAOUTTable.setPESATableFieldPESAXMLData(strPESAOUTTableFieldPESAXMLData);
        thePESAOUTTable.setPESATableFieldPESAPriority(strPESAOUTTableFieldPESAPriority);
        thePESAOUTTable.setPESATableFieldPESASendCount(strPESAOUTTableFieldPESASendCount);
        thePESAOUTTable.setPESATableFieldSendIntegrityHash(strPESAOUTTableFieldSendIntegrityHash);
        thePESAOUTTable.setPESATableFieldResponseDate(strPESAOUTTableFieldResponseDate);
        thePESAOUTTable.setPESATableFieldResponseXMLData(strPESAOUTTableFieldResponseXMLData);
        thePESAOUTTable.setPESATableFieldResponseIntegrityHash(strPESAOUTTableFieldResponseIntegrityHash);
        thePESAOUTTable.setPESATableFieldSchedulePesa(strPESAOUTTableFieldSchedulePesa);
        thePESAOUTTable.setPESATableFieldDateScheduled(strPESAOUTTableFieldDateScheduled);
        thePESAOUTTable.setPESATableFieldApplyTransactionCharge(strPESAOUTTableFieldApplyTransactionCharge);
        thePESAOUTTable.setPESATableFieldTransactionDate(strPESAOUTTableFieldTransactionDate);
        thePESAOUTTable.setPESATableFieldDateCreated(strPESAOUTTableFieldDateCreated);
        System.out.println();
        System.out.println("PESA OUT Table Name                            : " + thePESAOUTTable.getPESATableName());
        System.out.println("PESA OUT Table Field Transaction ID            : " + thePESAOUTTable.getPESATableFieldTransactionID());
        System.out.println("PESA OUT Table Field PESA ID                   : " + thePESAOUTTable.getPESATableFieldPESAID());
        System.out.println("PESA OUT Table Field PESA Type                 : " + thePESAOUTTable.getPESATableFieldPESAType());
        System.out.println("PESA OUT Table Field PESA Product ID           : " + thePESAOUTTable.getPESATableFieldPESAProductID());
        System.out.println("PESA OUT Table Field Apply Transaction Charge  : " + thePESAOUTTable.getPESATableFieldApplyTransactionCharge());
        System.out.println("PESA OUT Table Field PESA Status Code          : " + thePESAOUTTable.getPESATableFieldPESAStatusCode());
        System.out.println("PESA OUT Table Field PESA Status Description   : " + thePESAOUTTable.getPESATableFieldPESAStatusDescription());
        System.out.println("PESA OUT Table Field PESA Status Date          : " + thePESAOUTTable.getPESATableFieldPESAStatusDate());
        System.out.println("PESA OUT Table Field Sender                    : " + thePESAOUTTable.getPESATableFieldSender());
        System.out.println("PESA OUT Table Field Sender Details            : " + thePESAOUTTable.getPESATableFieldSenderDetails());
        System.out.println("PESA OUT Table Field Receiver                  : " + thePESAOUTTable.getPESATableFieldReceiver());
        System.out.println("PESA OUT Table Field Receiver Details          : " + thePESAOUTTable.getPESATableFieldReceiverDetails());
        System.out.println("PESA OUT Table Field Currency                  : " + thePESAOUTTable.getPESATableFieldCurrency());
        System.out.println("PESA OUT Table Field Amount                    : " + thePESAOUTTable.getPESATableFieldAmount());
        System.out.println("PESA OUT Table Field Account                   : " + thePESAOUTTable.getPESATableFieldAccount());
        System.out.println("PESA OUT Table Field PESA Source Reference     : " + thePESAOUTTable.getPESATableFieldPESASourceReference());
        System.out.println("PESA OUT Table Field PESA Destination Reference: " + thePESAOUTTable.getPESATableFieldPESADestinationReference());
        System.out.println("PESA OUT Table Field PESA XML Data             : " + thePESAOUTTable.getPESATableFieldPESAXMLData());
        System.out.println("PESA OUT Table Field PESA Priority             : " + thePESAOUTTable.getPESATableFieldPESAPriority());
        System.out.println("PESA OUT Table Field PESA Send Count           : " + thePESAOUTTable.getPESATableFieldPESASendCount());
        System.out.println("PESA OUT Table Field Send Integrity Hash       : " + thePESAOUTTable.getPESATableFieldSendIntegrityHash());
        System.out.println("PESA OUT Table Field Response Date             : " + thePESAOUTTable.getPESATableFieldResponseDate());
        System.out.println("PESA OUT Table Field Response XML Data         : " + thePESAOUTTable.getPESATableFieldResponseXMLData());
        System.out.println("PESA OUT Table Field Response Integrity Hash   : " + thePESAOUTTable.getPESATableFieldResponseIntegrityHash());
        System.out.println("PESA OUT Table Field Schedule Pesa             : " + thePESAOUTTable.getPESATableFieldSchedulePesa());
        System.out.println("PESA OUT Table Field Date Scheduled            : " + thePESAOUTTable.getPESATableFieldDateScheduled());
        System.out.println("PESA OUT Table Field Transaction Date          : " + thePESAOUTTable.getPESATableFieldTransactionDate());
        System.out.println("PESA OUT Table Field Date Created              : " + thePESAOUTTable.getPESATableFieldDateCreated());
        System.out.println("\nPESA_OUT_TABLE Set Successfully");
        return true;
    }

    public static boolean setPESAINTable(XPath configXPath, Object objConfig) {
        String strPESAINTableName;
        block5: {
            block4: {
                try {
                    strPESAINTableName = configXPath.evaluate("TABLES/PESA_IN_TABLE/TABLE_NAME", objConfig).trim();
                    if (strPESAINTableName.length() != 0 && !strPESAINTableName.isEmpty()) break block4;
                    System.out.println("PESA_IN_TABLE Name NOT Provided");
                    return false;
                }
                catch (Exception e) {
                    System.err.println("setPESAINTable: An error has occured!!!\n" + e.toString());
                    e.printStackTrace();
                    return false;
                }
            }
            String strTableStatus = configXPath.evaluate("TABLES/PESA_IN_TABLE/@STATUS", objConfig).trim();
            if (strTableStatus.equalsIgnoreCase(Constants.Status.ACTIVE.getValue())) break block5;
            System.out.println("PESA_IN_TABLE STATUS NOT ACTIVE");
            return false;
        }
        String strPESAINTableFieldTransactionID = configXPath.evaluate("TABLES/PESA_IN_TABLE/TRANSACTION_ID_FIELD", objConfig).trim();
        String strPESAINTableFieldPESAID = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_ID_FIELD", objConfig).trim();
        String strPESAINTableFieldPESAType = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_TYPE_FIELD", objConfig).trim();
        String strPESAINTableFieldPESAProductID = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_PRODUCT_ID_FIELD", objConfig).trim();
        String strPESAINTableFieldApplyTransactionCharge = configXPath.evaluate("TABLES/PESA_IN_TABLE/APPLY_TRANSACTION_CHARGE_FIELD", objConfig).trim();
        String strPESAINTableFieldPESAStatusCode = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_STATUS_CODE_FIELD", objConfig).trim();
        String strPESAINTableFieldPESAStatusDescription = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_STATUS_DESCRIPTION_FIELD", objConfig).trim();
        String strPESAINTableFieldPESAStatusDate = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_STATUS_DATE_FIELD", objConfig).trim();
        String strPESAINTableFieldSender = configXPath.evaluate("TABLES/PESA_IN_TABLE/SENDER_FIELD", objConfig).trim();
        String strPESAINTableFieldSenderDetails = configXPath.evaluate("TABLES/PESA_IN_TABLE/SENDER_DETAILS_FIELD", objConfig).trim();
        String strPESAINTableFieldReceiver = configXPath.evaluate("TABLES/PESA_IN_TABLE/RECEIVER_FIELD", objConfig).trim();
        String strPESAINTableFieldReceiverDetails = configXPath.evaluate("TABLES/PESA_IN_TABLE/RECEIVER_DETAILS_FIELD", objConfig).trim();
        String strPESAINTableFieldCurrency = configXPath.evaluate("TABLES/PESA_IN_TABLE/CURRENCY_FIELD", objConfig).trim();
        String strPESAINTableFieldAmount = configXPath.evaluate("TABLES/PESA_IN_TABLE/AMOUNT_FIELD", objConfig).trim();
        String strPESAINTableFieldAccount = configXPath.evaluate("TABLES/PESA_IN_TABLE/ACCOUNT_FIELD", objConfig).trim();
        String strPESAINTableFieldPESASourceReference = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_SOURCE_REFERENCE_FIELD", objConfig).trim();
        String strPESAINTableFieldPESADestinationReference = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_DESTINATION_REFERENCE_FIELD", objConfig).trim();
        String strPESAINTableFieldPESAXMLData = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_XML_DATA_FIELD", objConfig).trim();
        String strPESAINTableFieldPESAPriority = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_PRIORITY_FIELD", objConfig).trim();
        String strPESAINTableFieldPESASendCount = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_SEND_COUNT_FIELD", objConfig).trim();
        String strPESAINTableFieldDateScheduled = configXPath.evaluate("TABLES/PESA_IN_TABLE/DATE_SCHEDULED_FIELD", objConfig).trim();
        String strPESAINTableFieldSendIntegrityHash = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_SEND_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strPESAINTableFieldResponseDate = configXPath.evaluate("TABLES/PESA_OUT_TABLE/PESA_RESPONSE_DATE_FIELD", objConfig).trim();
        String strPESAINTableFieldResponseXMLData = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_RESPONSE_XML_DATA_FIELD", objConfig).trim();
        String strPESAINTableFieldResponseIntegrityHash = configXPath.evaluate("TABLES/PESA_IN_TABLE/PESA_RESPONSE_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strPESAINTableFieldSchedulePesa = configXPath.evaluate("TABLES/PESA_IN_TABLE/SCHEDULE_PESA_FIELD", objConfig).trim();
        String strPESAINTableFieldTransactionDate = configXPath.evaluate("TABLES/PESA_IN_TABLE/TRANSACTION_DATE_FIELD", objConfig).trim();
        String strPESAINTableFieldDateCreated = configXPath.evaluate("TABLES/PESA_IN_TABLE/DATE_CREATED_FIELD", objConfig).trim();
        PESAINTable thePESAINTable = new PESAINTable();
        strPESAINTableName = strPESAINTableName.length() > 0 ? strPESAINTableName : thePESAINTable.getPESATableName();
        strPESAINTableFieldTransactionID = strPESAINTableFieldTransactionID.length() > 0 ? strPESAINTableFieldTransactionID : thePESAINTable.getPESATableFieldTransactionID();
        strPESAINTableFieldPESAID = strPESAINTableFieldPESAID.length() > 0 ? strPESAINTableFieldPESAID : thePESAINTable.getPESATableFieldPESAID();
        strPESAINTableFieldPESAType = strPESAINTableFieldPESAType.length() > 0 ? strPESAINTableFieldPESAType : thePESAINTable.getPESATableFieldPESAType();
        strPESAINTableFieldPESAProductID = strPESAINTableFieldPESAProductID.length() > 0 ? strPESAINTableFieldPESAProductID : thePESAINTable.getPESATableFieldPESAProductID();
        strPESAINTableFieldPESAStatusCode = strPESAINTableFieldPESAStatusCode.length() > 0 ? strPESAINTableFieldPESAStatusCode : thePESAINTable.getPESATableFieldPESAStatusCode();
        strPESAINTableFieldPESAStatusDescription = strPESAINTableFieldPESAStatusDescription.length() > 0 ? strPESAINTableFieldPESAStatusDescription : thePESAINTable.getPESATableFieldPESAStatusDescription();
        strPESAINTableFieldPESAStatusDate = strPESAINTableFieldPESAStatusDate.length() > 0 ? strPESAINTableFieldPESAStatusDate : thePESAINTable.getPESATableFieldPESAStatusDate();
        strPESAINTableFieldSender = strPESAINTableFieldSender.length() > 0 ? strPESAINTableFieldSender : thePESAINTable.getPESATableFieldSender();
        strPESAINTableFieldSenderDetails = strPESAINTableFieldSenderDetails.length() > 0 ? strPESAINTableFieldSenderDetails : thePESAINTable.getPESATableFieldSenderDetails();
        strPESAINTableFieldReceiver = strPESAINTableFieldReceiver.length() > 0 ? strPESAINTableFieldReceiver : thePESAINTable.getPESATableFieldReceiver();
        strPESAINTableFieldReceiverDetails = strPESAINTableFieldReceiverDetails.length() > 0 ? strPESAINTableFieldReceiverDetails : thePESAINTable.getPESATableFieldReceiverDetails();
        strPESAINTableFieldCurrency = strPESAINTableFieldCurrency.length() > 0 ? strPESAINTableFieldCurrency : thePESAINTable.getPESATableFieldCurrency();
        strPESAINTableFieldAmount = strPESAINTableFieldAmount.length() > 0 ? strPESAINTableFieldAmount : thePESAINTable.getPESATableFieldAmount();
        strPESAINTableFieldAccount = strPESAINTableFieldAccount.length() > 0 ? strPESAINTableFieldAccount : thePESAINTable.getPESATableFieldAccount();
        strPESAINTableFieldPESASourceReference = strPESAINTableFieldPESASourceReference.length() > 0 ? strPESAINTableFieldPESASourceReference : thePESAINTable.getPESATableFieldPESASourceReference();
        strPESAINTableFieldPESADestinationReference = strPESAINTableFieldPESADestinationReference.length() > 0 ? strPESAINTableFieldPESADestinationReference : thePESAINTable.getPESATableFieldPESADestinationReference();
        strPESAINTableFieldPESAXMLData = strPESAINTableFieldPESAXMLData.length() > 0 ? strPESAINTableFieldPESAXMLData : thePESAINTable.getPESATableFieldPESAXMLData();
        strPESAINTableFieldPESAPriority = strPESAINTableFieldPESAPriority.length() > 0 ? strPESAINTableFieldPESAPriority : thePESAINTable.getPESATableFieldPESAPriority();
        strPESAINTableFieldPESASendCount = strPESAINTableFieldPESASendCount.length() > 0 ? strPESAINTableFieldPESASendCount : thePESAINTable.getPESATableFieldPESASendCount();
        strPESAINTableFieldSendIntegrityHash = strPESAINTableFieldSendIntegrityHash.length() > 0 ? strPESAINTableFieldSendIntegrityHash : thePESAINTable.getPESATableFieldSendIntegrityHash();
        strPESAINTableFieldResponseDate = strPESAINTableFieldResponseDate.length() > 0 ? strPESAINTableFieldResponseDate : thePESAINTable.getPESATableFieldResponseDate();
        strPESAINTableFieldResponseXMLData = strPESAINTableFieldResponseXMLData.length() > 0 ? strPESAINTableFieldResponseXMLData : thePESAINTable.getPESATableFieldResponseXMLData();
        strPESAINTableFieldResponseIntegrityHash = strPESAINTableFieldResponseIntegrityHash.length() > 0 ? strPESAINTableFieldResponseIntegrityHash : thePESAINTable.getPESATableFieldResponseIntegrityHash();
        strPESAINTableFieldSchedulePesa = strPESAINTableFieldSchedulePesa.length() > 0 ? strPESAINTableFieldSchedulePesa : thePESAINTable.getPESATableFieldSchedulePesa();
        strPESAINTableFieldDateScheduled = strPESAINTableFieldDateScheduled.length() > 0 ? strPESAINTableFieldDateScheduled : thePESAINTable.getPESATableFieldDateScheduled();
        strPESAINTableFieldApplyTransactionCharge = strPESAINTableFieldApplyTransactionCharge.length() > 0 ? strPESAINTableFieldApplyTransactionCharge : thePESAINTable.getPESATableFieldApplyTransactionCharge();
        strPESAINTableFieldTransactionDate = strPESAINTableFieldTransactionDate.length() > 0 ? strPESAINTableFieldTransactionDate : thePESAINTable.getPESATableFieldTransactionDate();
        strPESAINTableFieldDateCreated = strPESAINTableFieldDateCreated.length() > 0 ? strPESAINTableFieldDateCreated : thePESAINTable.getPESATableFieldDateCreated();
        thePESAINTable.setPESATableName(strPESAINTableName);
        thePESAINTable.setPESATableFieldTransactionID(strPESAINTableFieldTransactionID);
        thePESAINTable.setPESATableFieldPESAID(strPESAINTableFieldPESAID);
        thePESAINTable.setPESATableFieldPESAType(strPESAINTableFieldPESAType);
        thePESAINTable.setPESATableFieldPESAProductID(strPESAINTableFieldPESAProductID);
        thePESAINTable.setPESATableFieldPESAStatusCode(strPESAINTableFieldPESAStatusCode);
        thePESAINTable.setPESATableFieldPESAStatusDescription(strPESAINTableFieldPESAStatusDescription);
        thePESAINTable.setPESATableFieldPESAStatusDate(strPESAINTableFieldPESAStatusDate);
        thePESAINTable.setPESATableFieldSender(strPESAINTableFieldSender);
        thePESAINTable.setPESATableFieldSenderDetails(strPESAINTableFieldSenderDetails);
        thePESAINTable.setPESATableFieldReceiver(strPESAINTableFieldReceiver);
        thePESAINTable.setPESATableFieldReceiverDetails(strPESAINTableFieldReceiverDetails);
        thePESAINTable.setPESATableFieldCurrency(strPESAINTableFieldCurrency);
        thePESAINTable.setPESATableFieldAmount(strPESAINTableFieldAmount);
        thePESAINTable.setPESATableFieldAccount(strPESAINTableFieldAccount);
        thePESAINTable.setPESATableFieldPESASourceReference(strPESAINTableFieldPESASourceReference);
        thePESAINTable.setPESATableFieldPESADestinationReference(strPESAINTableFieldPESADestinationReference);
        thePESAINTable.setPESATableFieldPESAXMLData(strPESAINTableFieldPESAXMLData);
        thePESAINTable.setPESATableFieldPESAPriority(strPESAINTableFieldPESAPriority);
        thePESAINTable.setPESATableFieldPESASendCount(strPESAINTableFieldPESASendCount);
        thePESAINTable.setPESATableFieldSendIntegrityHash(strPESAINTableFieldSendIntegrityHash);
        thePESAINTable.setPESATableFieldResponseDate(strPESAINTableFieldResponseDate);
        thePESAINTable.setPESATableFieldResponseXMLData(strPESAINTableFieldResponseXMLData);
        thePESAINTable.setPESATableFieldResponseIntegrityHash(strPESAINTableFieldResponseIntegrityHash);
        thePESAINTable.setPESATableFieldSchedulePesa(strPESAINTableFieldSchedulePesa);
        thePESAINTable.setPESATableFieldDateScheduled(strPESAINTableFieldDateScheduled);
        thePESAINTable.setPESATableFieldApplyTransactionCharge(strPESAINTableFieldApplyTransactionCharge);
        thePESAINTable.setPESATableFieldTransactionDate(strPESAINTableFieldTransactionDate);
        thePESAINTable.setPESATableFieldDateCreated(strPESAINTableFieldDateCreated);
        System.out.println();
        System.out.println("PESA IN Table Name                            : " + thePESAINTable.getPESATableName());
        System.out.println("PESA IN Table Field Transaction ID            : " + thePESAINTable.getPESATableFieldTransactionID());
        System.out.println("PESA IN Table Field PESA ID                   : " + thePESAINTable.getPESATableFieldPESAID());
        System.out.println("PESA IN Table Field PESA Type                 : " + thePESAINTable.getPESATableFieldPESAType());
        System.out.println("PESA IN Table Field PESA Product ID           : " + thePESAINTable.getPESATableFieldPESAProductID());
        System.out.println("PESA IN Table Field Apply Transaction Charge  : " + thePESAINTable.getPESATableFieldApplyTransactionCharge());
        System.out.println("PESA IN Table Field PESA Status Code          : " + thePESAINTable.getPESATableFieldPESAStatusCode());
        System.out.println("PESA IN Table Field PESA Status Description   : " + thePESAINTable.getPESATableFieldPESAStatusDescription());
        System.out.println("PESA IN Table Field PESA Status Date          : " + thePESAINTable.getPESATableFieldPESAStatusDate());
        System.out.println("PESA IN Table Field Sender                    : " + thePESAINTable.getPESATableFieldSender());
        System.out.println("PESA IN Table Field Sender Details            : " + thePESAINTable.getPESATableFieldSenderDetails());
        System.out.println("PESA IN Table Field Receiver                  : " + thePESAINTable.getPESATableFieldReceiver());
        System.out.println("PESA IN Table Field Receiver Details          : " + thePESAINTable.getPESATableFieldReceiverDetails());
        System.out.println("PESA IN Table Field Currency                  : " + thePESAINTable.getPESATableFieldCurrency());
        System.out.println("PESA IN Table Field Amount                    : " + thePESAINTable.getPESATableFieldAmount());
        System.out.println("PESA IN Table Field Account                   : " + thePESAINTable.getPESATableFieldAccount());
        System.out.println("PESA IN Table Field PESA Source Reference     : " + thePESAINTable.getPESATableFieldPESASourceReference());
        System.out.println("PESA IN Table Field PESA Destination Reference: " + thePESAINTable.getPESATableFieldPESADestinationReference());
        System.out.println("PESA IN Table Field PESA XML Data             : " + thePESAINTable.getPESATableFieldPESAXMLData());
        System.out.println("PESA IN Table Field PESA Priority             : " + thePESAINTable.getPESATableFieldPESAPriority());
        System.out.println("PESA IN Table Field PESA Send Count           : " + thePESAINTable.getPESATableFieldPESASendCount());
        System.out.println("PESA IN Table Field Send Integrity Hash       : " + thePESAINTable.getPESATableFieldSendIntegrityHash());
        System.out.println("PESA IN Table Field Response Date             : " + thePESAINTable.getPESATableFieldResponseDate());
        System.out.println("PESA IN Table Field Response XML Data         : " + thePESAINTable.getPESATableFieldResponseXMLData());
        System.out.println("PESA IN Table Field Response Integrity Hash   : " + thePESAINTable.getPESATableFieldResponseIntegrityHash());
        System.out.println("PESA IN Table Field Schedule Pesa             : " + thePESAINTable.getPESATableFieldSchedulePesa());
        System.out.println("PESA IN Table Field Date Scheduled            : " + thePESAINTable.getPESATableFieldDateScheduled());
        System.out.println("PESA IN Table Field Transaction Date          : " + thePESAINTable.getPESATableFieldTransactionDate());
        System.out.println("PESA IN Table Field Date Created              : " + thePESAINTable.getPESATableFieldDateCreated());
        System.out.println("\nPESA_IN_TABLE Set Successfully");
        return true;
    }

    public static boolean setBuyAirtimeTable(XPath configXPath, Object objConfig) {
        String strBuyAirtimeTableName;
        block5: {
            block4: {
                try {
                    strBuyAirtimeTableName = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/TABLE_NAME", objConfig).trim();
                    if (strBuyAirtimeTableName.length() != 0 && !strBuyAirtimeTableName.isEmpty()) break block4;
                    System.out.println("BUY_AIRTIME_TABLE Name NOT Provided");
                    return false;
                }
                catch (Exception e) {
                    System.err.println("setBuyAirtimeTable: An error has occured!!!\n" + e.toString());
                    e.printStackTrace();
                    return false;
                }
            }
            String strTableStatus = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/@STATUS", objConfig).trim();
            if (strTableStatus.equalsIgnoreCase(Constants.Status.ACTIVE.getValue())) break block5;
            System.out.println("BUY_AIRTIME_TABLE STATUS NOT ACTIVE");
            return false;
        }
        String strBuyAirtimeTableFieldTransactionID = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/TRANSACTION_ID_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESAID = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_ID_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESAType = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_TYPE_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESAProductID = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_PRODUCT_ID_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldApplyTransactionCharge = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/APPLY_TRANSACTION_CHARGE_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESAStatusCode = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_STATUS_CODE_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESAStatusDescription = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_STATUS_DESCRIPTION_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESAStatusDate = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_STATUS_DATE_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldSender = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/SENDER_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldSenderDetails = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/SENDER_DETAILS_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldReceiver = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/RECEIVER_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldReceiverDetails = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/RECEIVER_DETAILS_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldCurrency = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/CURRENCY_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldAmount = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/AMOUNT_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldAccount = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/ACCOUNT_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESASourceReference = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_SOURCE_REFERENCE_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESADestinationReference = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_DESTINATION_REFERENCE_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESAXMLData = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_XML_DATA_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESAPriority = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_PRIORITY_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldPESASendCount = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_SEND_COUNT_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldDateScheduled = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/DATE_SCHEDULED_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldSendIntegrityHash = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_SEND_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldResponseDate = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_RESPONSE_DATE_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldResponseXMLData = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_RESPONSE_XML_DATA_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldResponseIntegrityHash = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/PESA_RESPONSE_INTEGRITY_HASH_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldSchedulePesa = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/SCHEDULE_PESA_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldTransactionDate = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/TRANSACTION_DATE_FIELD", objConfig).trim();
        String strBuyAirtimeTableFieldDateCreated = configXPath.evaluate("TABLES/BUY_AIRTIME_TABLE/DATE_CREATED_FIELD", objConfig).trim();
        BuyAirtimeTable theBuyAirtimeTable = new BuyAirtimeTable();
        strBuyAirtimeTableName = strBuyAirtimeTableName.length() > 0 ? strBuyAirtimeTableName : theBuyAirtimeTable.getPESATableName();
        strBuyAirtimeTableFieldTransactionID = strBuyAirtimeTableFieldTransactionID.length() > 0 ? strBuyAirtimeTableFieldTransactionID : theBuyAirtimeTable.getPESATableFieldTransactionID();
        strBuyAirtimeTableFieldPESAID = strBuyAirtimeTableFieldPESAID.length() > 0 ? strBuyAirtimeTableFieldPESAID : theBuyAirtimeTable.getPESATableFieldPESAID();
        strBuyAirtimeTableFieldPESAType = strBuyAirtimeTableFieldPESAType.length() > 0 ? strBuyAirtimeTableFieldPESAType : theBuyAirtimeTable.getPESATableFieldPESAType();
        strBuyAirtimeTableFieldPESAProductID = strBuyAirtimeTableFieldPESAProductID.length() > 0 ? strBuyAirtimeTableFieldPESAProductID : theBuyAirtimeTable.getPESATableFieldPESAProductID();
        strBuyAirtimeTableFieldPESAStatusCode = strBuyAirtimeTableFieldPESAStatusCode.length() > 0 ? strBuyAirtimeTableFieldPESAStatusCode : theBuyAirtimeTable.getPESATableFieldPESAStatusCode();
        strBuyAirtimeTableFieldPESAStatusDescription = strBuyAirtimeTableFieldPESAStatusDescription.length() > 0 ? strBuyAirtimeTableFieldPESAStatusDescription : theBuyAirtimeTable.getPESATableFieldPESAStatusDescription();
        strBuyAirtimeTableFieldPESAStatusDate = strBuyAirtimeTableFieldPESAStatusDate.length() > 0 ? strBuyAirtimeTableFieldPESAStatusDate : theBuyAirtimeTable.getPESATableFieldPESAStatusDate();
        strBuyAirtimeTableFieldSender = strBuyAirtimeTableFieldSender.length() > 0 ? strBuyAirtimeTableFieldSender : theBuyAirtimeTable.getPESATableFieldSender();
        strBuyAirtimeTableFieldSenderDetails = strBuyAirtimeTableFieldSenderDetails.length() > 0 ? strBuyAirtimeTableFieldSenderDetails : theBuyAirtimeTable.getPESATableFieldSenderDetails();
        strBuyAirtimeTableFieldReceiver = strBuyAirtimeTableFieldReceiver.length() > 0 ? strBuyAirtimeTableFieldReceiver : theBuyAirtimeTable.getPESATableFieldReceiver();
        strBuyAirtimeTableFieldReceiverDetails = strBuyAirtimeTableFieldReceiverDetails.length() > 0 ? strBuyAirtimeTableFieldReceiverDetails : theBuyAirtimeTable.getPESATableFieldReceiverDetails();
        strBuyAirtimeTableFieldCurrency = strBuyAirtimeTableFieldCurrency.length() > 0 ? strBuyAirtimeTableFieldCurrency : theBuyAirtimeTable.getPESATableFieldCurrency();
        strBuyAirtimeTableFieldAmount = strBuyAirtimeTableFieldAmount.length() > 0 ? strBuyAirtimeTableFieldAmount : theBuyAirtimeTable.getPESATableFieldAmount();
        strBuyAirtimeTableFieldAccount = strBuyAirtimeTableFieldAccount.length() > 0 ? strBuyAirtimeTableFieldAccount : theBuyAirtimeTable.getPESATableFieldAccount();
        strBuyAirtimeTableFieldPESASourceReference = strBuyAirtimeTableFieldPESASourceReference.length() > 0 ? strBuyAirtimeTableFieldPESASourceReference : theBuyAirtimeTable.getPESATableFieldPESASourceReference();
        strBuyAirtimeTableFieldPESADestinationReference = strBuyAirtimeTableFieldPESADestinationReference.length() > 0 ? strBuyAirtimeTableFieldPESADestinationReference : theBuyAirtimeTable.getPESATableFieldPESADestinationReference();
        strBuyAirtimeTableFieldPESAXMLData = strBuyAirtimeTableFieldPESAXMLData.length() > 0 ? strBuyAirtimeTableFieldPESAXMLData : theBuyAirtimeTable.getPESATableFieldPESAXMLData();
        strBuyAirtimeTableFieldPESAPriority = strBuyAirtimeTableFieldPESAPriority.length() > 0 ? strBuyAirtimeTableFieldPESAPriority : theBuyAirtimeTable.getPESATableFieldPESAPriority();
        strBuyAirtimeTableFieldPESASendCount = strBuyAirtimeTableFieldPESASendCount.length() > 0 ? strBuyAirtimeTableFieldPESASendCount : theBuyAirtimeTable.getPESATableFieldPESASendCount();
        strBuyAirtimeTableFieldSendIntegrityHash = strBuyAirtimeTableFieldSendIntegrityHash.length() > 0 ? strBuyAirtimeTableFieldSendIntegrityHash : theBuyAirtimeTable.getPESATableFieldSendIntegrityHash();
        strBuyAirtimeTableFieldResponseDate = strBuyAirtimeTableFieldResponseDate.length() > 0 ? strBuyAirtimeTableFieldResponseDate : theBuyAirtimeTable.getPESATableFieldResponseDate();
        strBuyAirtimeTableFieldResponseXMLData = strBuyAirtimeTableFieldResponseXMLData.length() > 0 ? strBuyAirtimeTableFieldResponseXMLData : theBuyAirtimeTable.getPESATableFieldResponseXMLData();
        strBuyAirtimeTableFieldResponseIntegrityHash = strBuyAirtimeTableFieldResponseIntegrityHash.length() > 0 ? strBuyAirtimeTableFieldResponseIntegrityHash : theBuyAirtimeTable.getPESATableFieldResponseIntegrityHash();
        strBuyAirtimeTableFieldSchedulePesa = strBuyAirtimeTableFieldSchedulePesa.length() > 0 ? strBuyAirtimeTableFieldSchedulePesa : theBuyAirtimeTable.getPESATableFieldSchedulePesa();
        strBuyAirtimeTableFieldDateScheduled = strBuyAirtimeTableFieldDateScheduled.length() > 0 ? strBuyAirtimeTableFieldDateScheduled : theBuyAirtimeTable.getPESATableFieldDateScheduled();
        strBuyAirtimeTableFieldApplyTransactionCharge = strBuyAirtimeTableFieldApplyTransactionCharge.length() > 0 ? strBuyAirtimeTableFieldApplyTransactionCharge : theBuyAirtimeTable.getPESATableFieldApplyTransactionCharge();
        strBuyAirtimeTableFieldTransactionDate = strBuyAirtimeTableFieldTransactionDate.length() > 0 ? strBuyAirtimeTableFieldTransactionDate : theBuyAirtimeTable.getPESATableFieldTransactionDate();
        strBuyAirtimeTableFieldDateCreated = strBuyAirtimeTableFieldDateCreated.length() > 0 ? strBuyAirtimeTableFieldDateCreated : theBuyAirtimeTable.getPESATableFieldDateCreated();
        theBuyAirtimeTable.setPESATableName(strBuyAirtimeTableName);
        theBuyAirtimeTable.setPESATableFieldTransactionID(strBuyAirtimeTableFieldTransactionID);
        theBuyAirtimeTable.setPESATableFieldPESAID(strBuyAirtimeTableFieldPESAID);
        theBuyAirtimeTable.setPESATableFieldPESAType(strBuyAirtimeTableFieldPESAType);
        theBuyAirtimeTable.setPESATableFieldPESAProductID(strBuyAirtimeTableFieldPESAProductID);
        theBuyAirtimeTable.setPESATableFieldPESAStatusCode(strBuyAirtimeTableFieldPESAStatusCode);
        theBuyAirtimeTable.setPESATableFieldPESAStatusDescription(strBuyAirtimeTableFieldPESAStatusDescription);
        theBuyAirtimeTable.setPESATableFieldPESAStatusDate(strBuyAirtimeTableFieldPESAStatusDate);
        theBuyAirtimeTable.setPESATableFieldSender(strBuyAirtimeTableFieldSender);
        theBuyAirtimeTable.setPESATableFieldSenderDetails(strBuyAirtimeTableFieldSenderDetails);
        theBuyAirtimeTable.setPESATableFieldReceiver(strBuyAirtimeTableFieldReceiver);
        theBuyAirtimeTable.setPESATableFieldReceiverDetails(strBuyAirtimeTableFieldReceiverDetails);
        theBuyAirtimeTable.setPESATableFieldCurrency(strBuyAirtimeTableFieldCurrency);
        theBuyAirtimeTable.setPESATableFieldAmount(strBuyAirtimeTableFieldAmount);
        theBuyAirtimeTable.setPESATableFieldAccount(strBuyAirtimeTableFieldAccount);
        theBuyAirtimeTable.setPESATableFieldPESASourceReference(strBuyAirtimeTableFieldPESASourceReference);
        theBuyAirtimeTable.setPESATableFieldPESADestinationReference(strBuyAirtimeTableFieldPESADestinationReference);
        theBuyAirtimeTable.setPESATableFieldPESAXMLData(strBuyAirtimeTableFieldPESAXMLData);
        theBuyAirtimeTable.setPESATableFieldPESAPriority(strBuyAirtimeTableFieldPESAPriority);
        theBuyAirtimeTable.setPESATableFieldPESASendCount(strBuyAirtimeTableFieldPESASendCount);
        theBuyAirtimeTable.setPESATableFieldSendIntegrityHash(strBuyAirtimeTableFieldSendIntegrityHash);
        theBuyAirtimeTable.setPESATableFieldResponseDate(strBuyAirtimeTableFieldResponseDate);
        theBuyAirtimeTable.setPESATableFieldResponseXMLData(strBuyAirtimeTableFieldResponseXMLData);
        theBuyAirtimeTable.setPESATableFieldResponseIntegrityHash(strBuyAirtimeTableFieldResponseIntegrityHash);
        theBuyAirtimeTable.setPESATableFieldSchedulePesa(strBuyAirtimeTableFieldSchedulePesa);
        theBuyAirtimeTable.setPESATableFieldDateScheduled(strBuyAirtimeTableFieldDateScheduled);
        theBuyAirtimeTable.setPESATableFieldApplyTransactionCharge(strBuyAirtimeTableFieldApplyTransactionCharge);
        theBuyAirtimeTable.setPESATableFieldTransactionDate(strBuyAirtimeTableFieldTransactionDate);
        theBuyAirtimeTable.setPESATableFieldDateCreated(strBuyAirtimeTableFieldDateCreated);
        System.out.println();
        System.out.println("BUY AIRTIME Table Name                            : " + theBuyAirtimeTable.getPESATableName());
        System.out.println("BUY AIRTIME Table Field Transaction ID            : " + theBuyAirtimeTable.getPESATableFieldTransactionID());
        System.out.println("BUY AIRTIME Table Field PESA ID                   : " + theBuyAirtimeTable.getPESATableFieldPESAID());
        System.out.println("BUY AIRTIME Table Field PESA Type                 : " + theBuyAirtimeTable.getPESATableFieldPESAType());
        System.out.println("BUY AIRTIME Table Field PESA Product ID           : " + theBuyAirtimeTable.getPESATableFieldPESAProductID());
        System.out.println("BUY AIRTIME Table Field Apply Transaction Charge  : " + theBuyAirtimeTable.getPESATableFieldApplyTransactionCharge());
        System.out.println("BUY AIRTIME Table Field PESA Status Code          : " + theBuyAirtimeTable.getPESATableFieldPESAStatusCode());
        System.out.println("BUY AIRTIME Table Field PESA Status Description   : " + theBuyAirtimeTable.getPESATableFieldPESAStatusDescription());
        System.out.println("BUY AIRTIME Table Field PESA Status Date          : " + theBuyAirtimeTable.getPESATableFieldPESAStatusDate());
        System.out.println("BUY AIRTIME Table Field Sender                    : " + theBuyAirtimeTable.getPESATableFieldSender());
        System.out.println("BUY AIRTIME Table Field Sender Details            : " + theBuyAirtimeTable.getPESATableFieldSenderDetails());
        System.out.println("BUY AIRTIME Table Field Receiver                  : " + theBuyAirtimeTable.getPESATableFieldReceiver());
        System.out.println("BUY AIRTIME Table Field Receiver Details          : " + theBuyAirtimeTable.getPESATableFieldReceiverDetails());
        System.out.println("BUY AIRTIME Table Field Currency                  : " + theBuyAirtimeTable.getPESATableFieldCurrency());
        System.out.println("BUY AIRTIME Table Field Amount                    : " + theBuyAirtimeTable.getPESATableFieldAmount());
        System.out.println("BUY AIRTIME Table Field Account                   : " + theBuyAirtimeTable.getPESATableFieldAccount());
        System.out.println("BUY AIRTIME Table Field PESA Source Reference     : " + theBuyAirtimeTable.getPESATableFieldPESASourceReference());
        System.out.println("BUY AIRTIME Table Field PESA Destination Reference: " + theBuyAirtimeTable.getPESATableFieldPESADestinationReference());
        System.out.println("BUY AIRTIME Table Field PESA XML Data             : " + theBuyAirtimeTable.getPESATableFieldPESAXMLData());
        System.out.println("BUY AIRTIME Table Field PESA Priority             : " + theBuyAirtimeTable.getPESATableFieldPESAPriority());
        System.out.println("BUY AIRTIME Table Field PESA Send Count           : " + theBuyAirtimeTable.getPESATableFieldPESASendCount());
        System.out.println("BUY AIRTIME Table Field Send Integrity Hash       : " + theBuyAirtimeTable.getPESATableFieldSendIntegrityHash());
        System.out.println("BUY AIRTIME Table Field Response Date             : " + theBuyAirtimeTable.getPESATableFieldResponseDate());
        System.out.println("BUY AIRTIME Table Field Response XML Data         : " + theBuyAirtimeTable.getPESATableFieldResponseXMLData());
        System.out.println("BUY AIRTIME Table Field Response Integrity Hash   : " + theBuyAirtimeTable.getPESATableFieldResponseIntegrityHash());
        System.out.println("BUY AIRTIME Table Field Schedule Pesa             : " + theBuyAirtimeTable.getPESATableFieldSchedulePesa());
        System.out.println("BUY AIRTIME Table Field Date Scheduled            : " + theBuyAirtimeTable.getPESATableFieldDateScheduled());
        System.out.println("BUY AIRTIME Table Field Transaction Date          : " + theBuyAirtimeTable.getPESATableFieldTransactionDate());
        System.out.println("BUY AIRTIME Table Field Date Created              : " + theBuyAirtimeTable.getPESATableFieldDateCreated());
        System.out.println("\nBUY_AIRTIME_TABLE Set Successfully");
        return true;
    }
}

