/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.util.Calendar;
import java.util.Date;

public class PESAClient {
    public static void main(String[] args) throws Throwable {
        long lnCurrentTime;
        int i = 0;
        while (i < args.length) {
            if (i >= 1) {
                if (!args[0].equalsIgnoreCase("-c") && !args[0].equalsIgnoreCase("-conf")) break;
                System.out.println("\nDatabase Configuration File Path Set To: " + args[1]);
                LocalParameters.setDBConfigFilePath(args[1]);
                break;
            }
            ++i;
        }
        Date now = Calendar.getInstance().getTime();
        long lnLastParameterRefreshTime = lnCurrentTime = now.getTime();
        WebServer msgWebServer = null;
        WebServer mgtWebServer = null;
        while (true) {
            block35: {
                try {
                    try {
                        if (CofigFile.setGlobalDBParameters()) {
                            PESAClientDB thePESAClientDB = new PESAClientDB();
                            System.out.println("\nSYSTEM SET GLOBAL CONFIG FILE PARAMETERS SUCCESSFULLY\n");
                            if (PESAClientDB.Connect()) {
                                SystemHealth.setSystemStartTime();
                                if (thePESAClientDB.setGlobalPESAParameters()) {
                                    boolean bClientAuthEnabled;
                                    String strCryptographicProtocol;
                                    FileInputStream isCA;
                                    String strKeyStorePassword;
                                    FileInputStream isKeyStore;
                                    int intWebServerPort;
                                    if (WebServerParameters.getMessagingWebServerEnabled().equals((Object)Constants.Enabled.YES)) {
                                        msgWebServer = new WebServer();
                                        if (WebServerParameters.getMessagingWebServerCryptographyEnabled().equals((Object)Constants.Enabled.YES)) {
                                            intWebServerPort = WebServerParameters.getMessagingWebServerPort();
                                            isKeyStore = new FileInputStream(WebServerParameters.getMessagingWebServerCertificateFilePath());
                                            strKeyStorePassword = WebServerParameters.getMessagingWebServerCertificatePassword();
                                            isCA = new FileInputStream(WebServerParameters.getMessagingWebServerCACertificateFilePath());
                                            strCryptographicProtocol = WebServerParameters.getMessagingWebServerCryptographicProtocol();
                                            bClientAuthEnabled = WebServerParameters.getMessagingWebServerClientAuthEnabled().equals((Object)Constants.Enabled.YES);
                                            msgWebServer.startHTTPSWebServer(intWebServerPort, isKeyStore, strKeyStorePassword, isCA, strCryptographicProtocol, bClientAuthEnabled);
                                            System.out.println("HTTPS Messaging Webserver Started on Port " + WebServerParameters.getMessagingWebServerPort());
                                        } else {
                                            msgWebServer.startHTTPWebServer(WebServerParameters.getMessagingWebServerPort());
                                            System.out.println("HTTP Messaging Webserver Started on Port " + WebServerParameters.getMessagingWebServerPort());
                                        }
                                    } else {
                                        System.out.println("Messaging Webserver NOT Enabled");
                                    }
                                    if (WebServerParameters.getManagementWebServerEnabled().equals((Object)Constants.Enabled.YES)) {
                                        mgtWebServer = new WebServer();
                                        if (WebServerParameters.getManagementWebServerCryptographyEnabled().equals((Object)Constants.Enabled.YES)) {
                                            intWebServerPort = WebServerParameters.getManagementWebServerPort();
                                            isKeyStore = new FileInputStream(WebServerParameters.getManagementWebServerCertificateFilePath());
                                            strKeyStorePassword = WebServerParameters.getManagementWebServerCertificatePassword();
                                            isCA = new FileInputStream(WebServerParameters.getManagementWebServerCACertificateFilePath());
                                            strCryptographicProtocol = WebServerParameters.getManagementWebServerCryptographicProtocol();
                                            bClientAuthEnabled = WebServerParameters.getManagementWebServerClientAuthEnabled().equals((Object)Constants.Enabled.YES);
                                            mgtWebServer.startHTTPSWebServer(intWebServerPort, isKeyStore, strKeyStorePassword, isCA, strCryptographicProtocol, bClientAuthEnabled);
                                            System.out.println("HTTPS Management Webserver Started on Port " + WebServerParameters.getManagementWebServerPort());
                                        } else {
                                            mgtWebServer.startHTTPWebServer(WebServerParameters.getManagementWebServerPort());
                                            System.out.println("HTTP Management Webserver Started on Port " + WebServerParameters.getManagementWebServerPort());
                                        }
                                    } else {
                                        System.out.println("Management Webserver NOT Enabled");
                                    }
                                    if (PESAClientRemoteParameters.setGlobalRemoteParameters()) {
                                        System.out.println("\nSYSTEM SET GLOBAL CLIENT PESA PARAMETERS SUCCESSFULLY\n");
                                        ServiceThread thePESAOUTServiceThread = null;
                                        ServiceThread thePESAINServiceThread = null;
                                        ServiceThread theBuyAirtimeServiceThread = null;
                                        if (LocalParameters.isPESAOUTTableActive()) {
                                            thePESAOUTServiceThread = new ServiceThread(Constants.ServiceType.PESA_OUT);
                                            LocalParameters.setPESAOUTServiceStatus(true);
                                        }
                                        if (LocalParameters.isPESAINTableActive()) {
                                            thePESAINServiceThread = new ServiceThread(Constants.ServiceType.PESA_IN);
                                            LocalParameters.setPESAINServiceStatus(true);
                                        }
                                        if (LocalParameters.isBuyAirtimeTableActive()) {
                                            theBuyAirtimeServiceThread = new ServiceThread(Constants.ServiceType.BUY_AIRTIME);
                                            LocalParameters.setBuyAirtimeServiceStatus(true);
                                        }
                                        while (true) {
                                            System.out.println();
                                            System.out.println("System Start Time             : " + SystemHealth.getSystemStartTime());
                                            System.out.println("System Last Heart Beat Time   : " + SystemHealth.getSystemLastHeartBeatTime());
                                            System.out.println("System Up Time                : " + SystemHealth.getSystemUpTimeInWords());
                                            System.out.println();
                                            System.out.println("The Main System Thread will sleeping for 60 Seconds ...");
                                            System.out.println();
                                            Thread.sleep(60000L);
                                            if (PESAClientDB.isConnected()) {
                                                System.out.println("Database is Connected");
                                            } else {
                                                System.out.println("Database is NOT Connected. The system will attempt to re-connect ...");
                                                PESAClientDB.Connect();
                                            }
                                            if ((lnCurrentTime = Calendar.getInstance().getTime().getTime()) - lnLastParameterRefreshTime <= (long)(RemoteParameters.getRefreshParametersMinutes() * 60 * 1000) || RemoteParameters.getRefreshParametersMinutes() <= 0) continue;
                                            lnLastParameterRefreshTime = lnCurrentTime;
                                            System.out.println("REFRESHING DATABASE & REMOTE PARAMETERS");
                                            if (!thePESAClientDB.setGlobalPESAParameters() || !PESAClientRemoteParameters.setGlobalRemoteParameters()) break;
                                        }
                                        if (thePESAOUTServiceThread != null) {
                                            thePESAOUTServiceThread.stopService();
                                            thePESAOUTServiceThread = null;
                                        }
                                        if (thePESAINServiceThread != null) {
                                            thePESAINServiceThread.stopService();
                                            thePESAINServiceThread = null;
                                        }
                                        if (theBuyAirtimeServiceThread != null) {
                                            theBuyAirtimeServiceThread.stopService();
                                            theBuyAirtimeServiceThread = null;
                                        }
                                    } else {
                                        System.err.println("\n... THE SYSTEM COULD NOT SET GLOBAL REMOTE CLIENT PESA PARAMETERS !!!\n");
                                    }
                                } else {
                                    System.err.println("\n... THE SYSTEM COULD NOT SET GLOBAL CLIENT PESA PARAMETERS !!!\n");
                                }
                            } else {
                                System.out.println("\nError connecting to the database\n");
                            }
                        } else {
                            System.err.println("\n... THE SYSTEM COULD NOT SET GLOBAL CONFIG FILE PARAMETERS !!!\n");
                        }
                    }
                    catch (Exception e) {
                        System.err.println("PESASender Error message: " + e.getMessage());
                        PESAClientDB.Close();
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    PESAClientDB.Close();
                    throw throwable;
                }
                PESAClientDB.Close();
            }
            if (msgWebServer != null) {
                msgWebServer.stopWebServer();
                msgWebServer = null;
            }
            if (mgtWebServer != null) {
                mgtWebServer.stopWebServer();
                mgtWebServer = null;
            }
            System.out.println("\nSYSTEM EXITED\n");
            System.out.println("\nWaiting for " + RemoteParameters.getRestartSystemSeconds() + " seconds to RESTART THE SYSTEM");
            Thread.sleep(RemoteParameters.getRestartSystemSeconds() * 1000);
        }
    }
}

