/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class PESAClientDB {
    private static Connection conn = null;

    public static boolean Connect() {
        LocalParameters.setDataBaseConnectionParameters();
        PESAClientDB.Close();
        String userName = LocalParameters.getDatabaseUsername();
        String password = LocalParameters.getDatabasePassword();
        String dbDriver = LocalParameters.getDatabaseDriver();
        String url = LocalParameters.getDatabaseURL();
        try {
            Class.forName(dbDriver).newInstance();
            System.out.println("Database Driver found");
            conn = DriverManager.getConnection(url, userName, password);
            System.out.println("Database connection established");
            return true;
        }
        catch (Exception e) {
            System.err.println("Cannot connect to the database server");
            System.err.println("Error message: " + e.getMessage());
            PESAClientDB.Close();
            return false;
        }
    }

    public boolean setGlobalPESAParameters() {
        NamedParameterStatement p = null;
        ResultSet rs = null;
        String strSQL = null;
        try {
            System.out.println("\n*********************************************************");
            System.out.println("            SETTING PESA CLIENT DATABASE LOCAL PARAMETERS");
            System.out.println("*********************************************************");
            String strSQLFields = "cp.parameters_id AS parameters_id, cp.parameters_url AS parameters_url, cp.parameters_status AS parameters_status, cp.client_id AS client_id, cp.client_name AS client_name, cp.system_user_id AS system_user_id, cp.system_username AS system_username, cp.system_password AS system_password, cp.system_password_type AS system_password_type, cp.integrity_hash_enabled AS integrity_hash_enabled, cp.integrity_hash_inbound_check AS integrity_hash_inbound_check, cp.integrity_hash_outbound_check AS integrity_hash_outbound_check, cp.integrity_secret AS integrity_secret, cp.integrity_secret_type AS integrity_secret_type, cp.client_xml_parameters AS client_xml_parameters, cp.client_connection_timeout_seconds AS client_connection_timeout_seconds, cp.client_encryption_type AS client_encryption_type, cp.client_certificate_configuration AS client_certificate_configuration, cp.client_cryptographic_protocol AS client_cryptographic_protocol, cp.client_certificate_chain_validation AS client_certificate_chain_validation, cp.client_hostname_verification AS client_hostname_verification, cp.client_ca_certificate_file_path AS client_ca_certificate_file_path, cp.client_certificate_file_path AS client_certificate_file_path, cp.client_certificate_password AS client_certificate_password, cp.client_certificate_password_type AS client_certificate_password_type, cp.messaging_web_server_id AS messaging_web_server_id, cp.management_web_server_id AS management_web_server_id, cwsp_msg.web_server_id AS msg_web_server_id, cwsp_msg.web_server_name AS msg_web_server_name, cwsp_msg.web_server_enabled AS msg_web_server_enabled, cwsp_msg.web_server_port AS msg_web_server_port, cwsp_msg.web_server_thread_max_pool_size AS msg_web_server_thread_max_pool_size, cwsp_msg.web_server_thread_keep_alive_time AS msg_web_server_thread_keep_alive_time, cwsp_msg.cryptography_enabled AS msg_cryptography_enabled, cwsp_msg.cryptographic_protocol AS msg_cryptographic_protocol, cwsp_msg.client_auth_enabled AS msg_client_auth_enabled, cwsp_msg.strict_client_auth_check AS msg_strict_client_auth_check, cwsp_msg.home_file_path AS msg_home_file_path, cwsp_msg.ca_certificate_file_path AS msg_ca_certificate_file_path, cwsp_msg.certificate_file_path AS msg_certificate_file_path, cwsp_msg.certificate_password AS msg_certificate_password, cwsp_msg.certificate_password_type AS msg_certificate_password_type, cwsp_msg.allowed_access_sources_enabled AS msg_allowed_access_sources_enabled, cwsp_msg.allowed_access_sources_match_type AS msg_allowed_access_sources_match_type, cwsp_msg.max_allowed_access_sources AS msg_max_allowed_access_sources, cwsp_msg.allowed_access_sources AS msg_allowed_access_sources, cwsp_msg.restricted_access_sources_enabled AS msg_restricted_access_sources_enabled, cwsp_msg.restricted_access_sources_match_type AS msg_restricted_access_sources_match_type, cwsp_msg.max_restricted_access_sources AS msg_max_restricted_access_sources, cwsp_msg.restricted_access_sources AS msg_restricted_access_sources, cwsp_mgt.web_server_id AS mgt_web_server_id, cwsp_mgt.web_server_name AS mgt_web_server_name, cwsp_mgt.web_server_enabled AS mgt_web_server_enabled, cwsp_mgt.web_server_port AS mgt_web_server_port, cwsp_mgt.web_server_thread_max_pool_size AS mgt_web_server_thread_max_pool_size, cwsp_mgt.web_server_thread_keep_alive_time AS mgt_web_server_thread_keep_alive_time, cwsp_mgt.cryptography_enabled AS mgt_cryptography_enabled, cwsp_mgt.cryptographic_protocol AS mgt_cryptographic_protocol, cwsp_mgt.client_auth_enabled AS mgt_client_auth_enabled, cwsp_mgt.strict_client_auth_check AS mgt_strict_client_auth_check, cwsp_mgt.home_file_path AS mgt_home_file_path, cwsp_mgt.ca_certificate_file_path AS mgt_ca_certificate_file_path, cwsp_mgt.certificate_file_path AS mgt_certificate_file_path, cwsp_mgt.certificate_password AS mgt_certificate_password, cwsp_mgt.certificate_password_type AS mgt_certificate_password_type, cwsp_mgt.allowed_access_sources_enabled AS mgt_allowed_access_sources_enabled, cwsp_mgt.allowed_access_sources_match_type AS mgt_allowed_access_sources_match_type, cwsp_mgt.max_allowed_access_sources AS mgt_max_allowed_access_sources, cwsp_mgt.allowed_access_sources AS mgt_allowed_access_sources, cwsp_mgt.restricted_access_sources_enabled AS mgt_restricted_access_sources_enabled, cwsp_mgt.restricted_access_sources_match_type AS mgt_restricted_access_sources_match_type,  cwsp_mgt.max_restricted_access_sources AS mgt_max_restricted_access_sources, cwsp_mgt.restricted_access_sources AS mgt_restricted_access_sources";
            switch (LocalParameters.getDatabaseType()) {
                case MySQL: {
                    strSQL = "SELECT " + strSQLFields + " FROM " + LocalParameters.getClientParametersTableName() + " AS cp" + " LEFT JOIN " + LocalParameters.getClientWebServersParametersTableName() + " AS cwsp_msg  ON cp.messaging_web_server_id = cwsp_msg.web_server_id" + " LEFT JOIN " + LocalParameters.getClientWebServersParametersTableName() + " AS cwsp_mgt  ON cp.management_web_server_id = cwsp_mgt.web_server_id" + " WHERE parameters_id = :parameters_id";
                    break;
                }
                case MicrosoftSQL: {
                    strSQL = "SELECT " + strSQLFields + " FROM " + LocalParameters.getClientParametersTableName() + " AS cp" + " LEFT JOIN " + LocalParameters.getClientWebServersParametersTableName() + " AS cwsp_msg  ON cp.messaging_web_server_id = cwsp_msg.web_server_id" + " LEFT JOIN " + LocalParameters.getClientWebServersParametersTableName() + " AS cwsp_mgt  ON cp.management_web_server_id = cwsp_mgt.web_server_id" + " WHERE parameters_id = :parameters_id";
                    break;
                }
                case Oracle: {
                    System.err.println("Oracle Database Type is not yet supported\n");
                    return false;
                }
                case PostgreSQL: {
                    System.err.println("PostgreSQL Database Type is not yet supported\n");
                    return false;
                }
                case MicrosoftAccess: {
                    System.err.println("Microsoft Access Database Type is not yet supported\n");
                    return false;
                }
                default: {
                    System.err.println("Invalid Database Type selected\n");
                    return false;
                }
            }
            p = new NamedParameterStatement(conn, strSQL);
            p.setLong("parameters_id", LocalParameters.getParametersID());
            rs = p.executeQuery();
            if (rs.next()) {
                Object strManagementWebServerCertificatePassword22;
                Constants.Enabled[] strMessagingWebServerCertificatePassword_ENCRYPTED22;
                Constants.MatchType[] theCrypto42;
                Object strMessagingWebServerCertificatePassword22;
                Constants.Enabled[] strIntegritySecret_ENCRYPTED22;
                Constants.Enabled[] theCrypto32;
                Object strIntegritySecret22;
                Constants.Enabled[] strSystemPassword_ENCRYPTED22;
                Constants.Enabled[] theCrypto22;
                Object strSystemPassword22;
                Object strClientCertificatePassword22;
                LocalParameters.setParametersURL(rs.getString("parameters_url") != null ? rs.getString("parameters_url").trim() : "");
                if (Utils.sslURL(LocalParameters.getParametersURL())) {
                    LocalParameters.setClientSSLEnabled(Constants.Enabled.YES);
                } else {
                    LocalParameters.setClientSSLEnabled(Constants.Enabled.NO);
                }
                String strParametersStatus = rs.getString("parameters_status") != null ? rs.getString("parameters_status").trim() : "";
                Constants.ParametersStatus[] parametersStatusArray = Constants.ParametersStatus.values();
                int n = parametersStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Constants.ParametersStatus parametersStatus = parametersStatusArray[n2];
                    if (strParametersStatus.equalsIgnoreCase(parametersStatus.getValue())) {
                        LocalParameters.setParametersStatus(parametersStatus);
                    }
                    ++n2;
                }
                LocalParameters.setClientID(rs.getLong("client_id") > 0L ? rs.getLong("client_id") : 0L);
                LocalParameters.setClientName(rs.getString("client_name") != null ? rs.getString("client_name").trim() : "");
                LocalParameters.setClientXMLParameters(rs.getString("client_xml_parameters") != null ? rs.getString("client_xml_parameters").trim() : "");
                LocalParameters.setClientConnectionTimeoutSeconds(rs.getInt("client_connection_timeout_seconds") > 0 ? rs.getInt("client_connection_timeout_seconds") : 30);
                String strParametersEncryptionType = rs.getString("client_encryption_type") != null ? rs.getString("client_encryption_type").trim() : "";
                Constants.ClientEncryptionType[] clientEncryptionTypeArray = Constants.ClientEncryptionType.values();
                int n3 = clientEncryptionTypeArray.length;
                n = 0;
                while (n < n3) {
                    Constants.ClientEncryptionType clientEncryptionType = clientEncryptionTypeArray[n];
                    if (strParametersEncryptionType.equalsIgnoreCase(clientEncryptionType.getValue())) {
                        LocalParameters.setClientEncryptionType(clientEncryptionType);
                    }
                    ++n;
                }
                String strCertificateConfiguration = rs.getString("client_certificate_configuration") != null ? rs.getString("client_certificate_configuration").trim() : "";
                Constants.CertificateConfiguration[] certificateConfigurationArray = Constants.CertificateConfiguration.values();
                int n4 = certificateConfigurationArray.length;
                n3 = 0;
                while (n3 < n4) {
                    Constants.CertificateConfiguration certificateConfiguration = certificateConfigurationArray[n3];
                    if (strCertificateConfiguration.equalsIgnoreCase(certificateConfiguration.getValue())) {
                        LocalParameters.setClientCertificateConfiguration(certificateConfiguration);
                    }
                    ++n3;
                }
                LocalParameters.setClientCryptographicProtocol(rs.getString("client_cryptographic_protocol") != null ? rs.getString("client_cryptographic_protocol").trim() : "");
                String strCertificateChainValidation = rs.getString("client_certificate_chain_validation") != null ? rs.getString("client_certificate_chain_validation").trim() : "";
                Constants.CertificateChainValidation[] certificateChainValidationArray = Constants.CertificateChainValidation.values();
                int n5 = certificateChainValidationArray.length;
                n4 = 0;
                while (n4 < n5) {
                    Constants.CertificateChainValidation certificateChainValidation = certificateChainValidationArray[n4];
                    if (strCertificateChainValidation.equalsIgnoreCase(certificateChainValidation.getValue())) {
                        LocalParameters.setClientCertificateChainValidation(certificateChainValidation);
                    }
                    ++n4;
                }
                String strHostnameVerification = rs.getString("client_hostname_verification") != null ? rs.getString("client_hostname_verification").trim() : "";
                Constants.HostnameVerification[] hostnameVerificationArray = Constants.HostnameVerification.values();
                int n6 = hostnameVerificationArray.length;
                n5 = 0;
                while (n5 < n6) {
                    Constants.HostnameVerification hostnameVerification = hostnameVerificationArray[n5];
                    if (strHostnameVerification.equalsIgnoreCase(hostnameVerification.getValue())) {
                        LocalParameters.setClientHostnameVerification(hostnameVerification);
                    }
                    ++n5;
                }
                LocalParameters.setClientCACertificateFilePath(rs.getString("client_ca_certificate_file_path") != null ? rs.getString("client_ca_certificate_file_path").trim() : "");
                LocalParameters.setClientCertificateFilePath(rs.getString("client_certificate_file_path") != null ? rs.getString("client_certificate_file_path").trim() : "");
                String strClientCertificatePasswordType = rs.getString("client_certificate_password_type") != null ? rs.getString("client_certificate_password_type").trim() : "";
                Constants.PasswordType[] passwordTypeArray = Constants.PasswordType.values();
                int n7 = passwordTypeArray.length;
                n6 = 0;
                while (n6 < n7) {
                    Constants.PasswordType clientCertificatePasswordType = passwordTypeArray[n6];
                    if (strClientCertificatePasswordType.equalsIgnoreCase(clientCertificatePasswordType.getValue())) {
                        LocalParameters.setClientCertificatePasswordType(clientCertificatePasswordType);
                        strClientCertificatePassword22 = rs.getString("client_certificate_password") != null ? rs.getString("client_certificate_password").trim() : "";
                        Crypto theCrypto = new Crypto();
                        if (!clientCertificatePasswordType.getValue().equalsIgnoreCase(Constants.PasswordType.ENCRYPTED.getValue())) {
                            System.out.println("Encrypting Client Certificate Password ...");
                            String strClientCertificatePassword_ENCRYPTED = theCrypto.encrypt(Constants.strKey, (String)strClientCertificatePassword22);
                            this.setEncryptedClientCertificatePassword(strClientCertificatePassword_ENCRYPTED);
                        } else {
                            System.out.println("Client Certificate Password is Protected");
                            this.setEncryptedClientCertificatePassword((String)strClientCertificatePassword22);
                            strClientCertificatePassword22 = theCrypto.decrypt(Constants.strKey, (String)strClientCertificatePassword22);
                        }
                        LocalParameters.setClientCertificatePassword((String)strClientCertificatePassword22);
                    }
                    ++n6;
                }
                LocalParameters.setSystemUserID(rs.getLong("system_user_id") > 0L ? rs.getLong("system_user_id") : 0L);
                LocalParameters.setSystemUsername(rs.getString("system_username") != null ? rs.getString("system_username").trim() : "");
                String strSystemPasswordType = rs.getString("system_password_type") != null ? rs.getString("system_password_type").trim() : "";
                strClientCertificatePassword22 = Constants.PasswordType.values();
                int n8 = ((Constants.PasswordType[])strClientCertificatePassword22).length;
                n7 = 0;
                while (n7 < n8) {
                    Constants.PasswordType systemPasswordType = strClientCertificatePassword22[n7];
                    if (strSystemPasswordType.equalsIgnoreCase(systemPasswordType.getValue())) {
                        LocalParameters.setSystemPasswordType(systemPasswordType);
                        strSystemPassword22 = rs.getString("system_password") != null ? rs.getString("system_password").trim() : "";
                        theCrypto22 = new Crypto();
                        if (!systemPasswordType.getValue().equalsIgnoreCase(Constants.PasswordType.ENCRYPTED.getValue())) {
                            System.out.println("Encrypting System Password ...");
                            strSystemPassword_ENCRYPTED22 = theCrypto22.encrypt(Constants.strKey, (String)strSystemPassword22);
                            this.setEncryptedSystemPassword(LocalParameters.getParametersID(), (String)strSystemPassword_ENCRYPTED22);
                        } else {
                            System.out.println("System Password is Protected");
                            strSystemPassword22 = theCrypto22.decrypt(Constants.strKey, (String)strSystemPassword22);
                        }
                        strSystemPassword22 = theCrypto22.hash("SHA-256", (String)strSystemPassword22);
                        LocalParameters.setSystemPassword((String)strSystemPassword22);
                    }
                    ++n7;
                }
                String strIntegrityHashEnabled = rs.getString("integrity_hash_enabled") != null ? rs.getString("integrity_hash_enabled").trim() : "";
                strSystemPassword22 = Constants.Enabled.values();
                int strClientCertificatePassword22 = ((Constants.Enabled[])strSystemPassword22).length;
                n8 = 0;
                while (n8 < strClientCertificatePassword22) {
                    Constants.Enabled integrityHashEnabled = strSystemPassword22[n8];
                    if (strIntegrityHashEnabled.equalsIgnoreCase(integrityHashEnabled.getValue())) {
                        LocalParameters.setIntegrityHashEnabled(integrityHashEnabled);
                    }
                    ++n8;
                }
                String strIntegrityHashInboundCheck = rs.getString("integrity_hash_inbound_check") != null ? rs.getString("integrity_hash_inbound_check").trim() : "";
                theCrypto22 = Constants.Enabled.values();
                int strSystemPassword22 = theCrypto22.length;
                strClientCertificatePassword22 = 0;
                while (strClientCertificatePassword22 < strSystemPassword22) {
                    Constants.Enabled integrityHashInboundCheck = theCrypto22[strClientCertificatePassword22];
                    if (strIntegrityHashInboundCheck.equalsIgnoreCase(integrityHashInboundCheck.getValue())) {
                        LocalParameters.setIntegrityHashInboundCheck(integrityHashInboundCheck);
                    }
                    ++strClientCertificatePassword22;
                }
                String strIntegrityHashOutboundCheck = rs.getString("integrity_hash_outbound_check") != null ? rs.getString("integrity_hash_outbound_check").trim() : "";
                strSystemPassword_ENCRYPTED22 = Constants.Enabled.values();
                int theCrypto22 = strSystemPassword_ENCRYPTED22.length;
                strSystemPassword22 = 0;
                while (strSystemPassword22 < theCrypto22) {
                    Constants.Enabled integrityHashOutboundCheck = strSystemPassword_ENCRYPTED22[strSystemPassword22];
                    if (strIntegrityHashOutboundCheck.equalsIgnoreCase(integrityHashOutboundCheck.getValue())) {
                        LocalParameters.setIntegrityHashOutboundCheck(integrityHashOutboundCheck);
                    }
                    ++strSystemPassword22;
                }
                String strIntegritySecretType = rs.getString("integrity_secret_type") != null ? rs.getString("integrity_secret_type").trim() : "";
                Constants.PasswordType[] passwordTypeArray2 = Constants.PasswordType.values();
                int strSystemPassword_ENCRYPTED22 = passwordTypeArray2.length;
                theCrypto22 = 0;
                while (theCrypto22 < strSystemPassword_ENCRYPTED22) {
                    Constants.PasswordType integritySecretType = passwordTypeArray2[theCrypto22];
                    if (strIntegritySecretType.equalsIgnoreCase(integritySecretType.getValue())) {
                        LocalParameters.setIntegritySecretType(integritySecretType);
                        strIntegritySecret22 = rs.getString("integrity_secret") != null ? rs.getString("integrity_secret").trim() : "";
                        theCrypto32 = new Crypto();
                        if (!integritySecretType.getValue().equalsIgnoreCase(Constants.PasswordType.ENCRYPTED.getValue())) {
                            System.out.println("Encrypting Integrity Secret ...");
                            strIntegritySecret_ENCRYPTED22 = theCrypto32.encrypt(Constants.strKey, (String)strIntegritySecret22);
                            this.setEncryptedIntegritySecret(LocalParameters.getParametersID(), (String)strIntegritySecret_ENCRYPTED22);
                        } else {
                            System.out.println("Integrity Secret is Protected");
                            strIntegritySecret22 = theCrypto32.decrypt(Constants.strKey, (String)strIntegritySecret22);
                        }
                        LocalParameters.setIntegritySecret((String)strIntegritySecret22);
                    }
                    ++theCrypto22;
                }
                WebServerParameters.setMessagingWebServerID(rs.getInt("messaging_web_server_id") > 0 ? rs.getInt("messaging_web_server_id") : 0);
                WebServerParameters.setMessagingWebServerName(rs.getString("msg_web_server_name") != null ? rs.getString("msg_web_server_name").trim() : "");
                String strMessagingWebServerEnabled = rs.getString("msg_web_server_enabled") != null ? rs.getString("msg_web_server_enabled").trim() : "";
                strIntegritySecret22 = Constants.Enabled.values();
                int n9 = ((Constants.Enabled[])strIntegritySecret22).length;
                strSystemPassword_ENCRYPTED22 = 0;
                while (strSystemPassword_ENCRYPTED22 < n9) {
                    Constants.Enabled messagingWebServerEnabled = strIntegritySecret22[strSystemPassword_ENCRYPTED22];
                    if (strMessagingWebServerEnabled.equalsIgnoreCase(messagingWebServerEnabled.getValue())) {
                        WebServerParameters.setMessagingWebServerEnabled(messagingWebServerEnabled);
                    }
                    ++strSystemPassword_ENCRYPTED22;
                }
                WebServerParameters.setMessagingWebServerPort(rs.getInt("msg_web_server_port") > 0 ? rs.getInt("msg_web_server_port") : 8443);
                WebServerParameters.setMessagingWebServerThreadMaximumPoolSize(rs.getInt("msg_web_server_thread_max_pool_size") > 0 ? rs.getInt("msg_web_server_thread_max_pool_size") : 40);
                WebServerParameters.setMessagingWebServerThreadKeepAliveTime(rs.getInt("msg_web_server_thread_keep_alive_time") > 0 ? rs.getInt("msg_web_server_thread_keep_alive_time") : 30);
                String strMessagingWebServerCryptographyEnabled = rs.getString("msg_cryptography_enabled") != null ? rs.getString("msg_cryptography_enabled").trim() : "";
                theCrypto32 = Constants.Enabled.values();
                int strIntegritySecret22 = theCrypto32.length;
                n9 = 0;
                while (n9 < strIntegritySecret22) {
                    Constants.Enabled messagingWebServerCryptographyEnabled = theCrypto32[n9];
                    if (strMessagingWebServerCryptographyEnabled.equalsIgnoreCase(messagingWebServerCryptographyEnabled.getValue())) {
                        WebServerParameters.setMessagingWebServerCryptographyEnabled(messagingWebServerCryptographyEnabled);
                    }
                    ++n9;
                }
                WebServerParameters.setMessagingWebServerCryptographicProtocol(rs.getString("msg_cryptographic_protocol") != null ? rs.getString("msg_cryptographic_protocol").trim() : "");
                String strMessagingWebServerClientAuthEnabled = rs.getString("msg_client_auth_enabled") != null ? rs.getString("msg_client_auth_enabled").trim() : "";
                strIntegritySecret_ENCRYPTED22 = Constants.Enabled.values();
                int theCrypto32 = strIntegritySecret_ENCRYPTED22.length;
                strIntegritySecret22 = 0;
                while (strIntegritySecret22 < theCrypto32) {
                    Constants.Enabled messagingWebServerClientAuthEnabled = strIntegritySecret_ENCRYPTED22[strIntegritySecret22];
                    if (strMessagingWebServerClientAuthEnabled.equalsIgnoreCase(messagingWebServerClientAuthEnabled.getValue())) {
                        WebServerParameters.setMessagingWebServerClientAuthEnabled(messagingWebServerClientAuthEnabled);
                    }
                    ++strIntegritySecret22;
                }
                String strMessagingWebServerStrictClientAuthCheck = rs.getString("msg_strict_client_auth_check") != null ? rs.getString("msg_strict_client_auth_check").trim() : "";
                Constants.Enabled[] enabledArray = Constants.Enabled.values();
                int strIntegritySecret_ENCRYPTED22 = enabledArray.length;
                theCrypto32 = 0;
                while (theCrypto32 < strIntegritySecret_ENCRYPTED22) {
                    Constants.Enabled messagingWebServerStrictClientAuthCheck = enabledArray[theCrypto32];
                    if (strMessagingWebServerStrictClientAuthCheck.equalsIgnoreCase(messagingWebServerStrictClientAuthCheck.getValue())) {
                        WebServerParameters.setMessagingWebServerStrictClientAuthCheck(messagingWebServerStrictClientAuthCheck);
                    }
                    ++theCrypto32;
                }
                WebServerParameters.setMessagingWebServerHomeFilePath(rs.getString("msg_home_file_path") != null ? rs.getString("msg_home_file_path").trim() : "");
                WebServerParameters.setMessagingWebServerCACertificateFilePath(rs.getString("msg_ca_certificate_file_path") != null ? rs.getString("msg_ca_certificate_file_path").trim() : "");
                WebServerParameters.setMessagingWebServerCertificateFilePath(rs.getString("msg_certificate_file_path") != null ? rs.getString("msg_certificate_file_path").trim() : "");
                String strMessagingCertificatePasswordType = rs.getString("msg_certificate_password_type") != null ? rs.getString("msg_certificate_password_type").trim() : "";
                Constants.PasswordType[] passwordTypeArray3 = Constants.PasswordType.values();
                int n10 = passwordTypeArray3.length;
                strIntegritySecret_ENCRYPTED22 = 0;
                while (strIntegritySecret_ENCRYPTED22 < n10) {
                    Constants.PasswordType messagingCertificatePasswordType = passwordTypeArray3[strIntegritySecret_ENCRYPTED22];
                    if (strMessagingCertificatePasswordType.equalsIgnoreCase(messagingCertificatePasswordType.getValue())) {
                        WebServerParameters.setMessagingWebServerCertificatePasswordType(messagingCertificatePasswordType);
                        strMessagingWebServerCertificatePassword22 = rs.getString("msg_certificate_password") != null ? rs.getString("msg_certificate_password").trim() : "";
                        theCrypto42 = new Crypto();
                        if (!messagingCertificatePasswordType.getValue().equalsIgnoreCase(Constants.PasswordType.ENCRYPTED.getValue())) {
                            System.out.println("Encrypting Messaging WebServer Certificate Password ...");
                            strMessagingWebServerCertificatePassword_ENCRYPTED22 = theCrypto42.encrypt(Constants.strKey, (String)strMessagingWebServerCertificatePassword22);
                            this.setEncryptedWebServerCertificatePassword(WebServerParameters.getMessagingWebServerID(), (String)strMessagingWebServerCertificatePassword_ENCRYPTED22);
                        } else {
                            System.out.println("Messaging WebServer Certificate Password is Protected");
                            strMessagingWebServerCertificatePassword22 = theCrypto42.decrypt(Constants.strKey, (String)strMessagingWebServerCertificatePassword22);
                        }
                        WebServerParameters.setMessagingWebServerCertificatePassword((String)strMessagingWebServerCertificatePassword22);
                    }
                    ++strIntegritySecret_ENCRYPTED22;
                }
                String strMessagingWebServerAllowedAccessSourcesEnabled = rs.getString("msg_allowed_access_sources_enabled") != null ? rs.getString("msg_allowed_access_sources_enabled").trim() : "";
                strMessagingWebServerCertificatePassword22 = Constants.Enabled.values();
                int n11 = ((Constants.Enabled[])strMessagingWebServerCertificatePassword22).length;
                n10 = 0;
                while (n10 < n11) {
                    Constants.Enabled messagingWebServerAllowedAccessSourcesEnabled = strMessagingWebServerCertificatePassword22[n10];
                    if (strMessagingWebServerAllowedAccessSourcesEnabled.equalsIgnoreCase(messagingWebServerAllowedAccessSourcesEnabled.getValue())) {
                        WebServerParameters.setMessagingWebServerAllowedAccessSourcesEnabled(messagingWebServerAllowedAccessSourcesEnabled);
                    }
                    ++n10;
                }
                String strMessagingWebServerAllowedAccessSourcesMatchType = rs.getString("msg_allowed_access_sources_match_type") != null ? rs.getString("msg_allowed_access_sources_match_type").trim() : "";
                theCrypto42 = Constants.MatchType.values();
                int strMessagingWebServerCertificatePassword22 = theCrypto42.length;
                n11 = 0;
                while (n11 < strMessagingWebServerCertificatePassword22) {
                    Constants.MatchType messagingWebServerAllowedAccessSourcesMatchType = theCrypto42[n11];
                    if (strMessagingWebServerAllowedAccessSourcesMatchType.equalsIgnoreCase(messagingWebServerAllowedAccessSourcesMatchType.getValue())) {
                        WebServerParameters.setMessagingWebServerAllowedAccessSourcesMatchType(messagingWebServerAllowedAccessSourcesMatchType);
                    }
                    ++n11;
                }
                WebServerParameters.setMessagingWebServerMaxAllowedAccessSources(rs.getInt("msg_max_allowed_access_sources") > 0 ? rs.getInt("msg_max_allowed_access_sources") : 0);
                WebServerParameters.setMessagingWebServerAllowedAccessSources(rs.getString("msg_allowed_access_sources") != null ? rs.getString("msg_allowed_access_sources").trim() : "");
                String strMessagingWebServerRestrictedAccessSourcesEnabled = rs.getString("msg_restricted_access_sources_enabled") != null ? rs.getString("msg_restricted_access_sources_enabled").trim() : "";
                strMessagingWebServerCertificatePassword_ENCRYPTED22 = Constants.Enabled.values();
                int theCrypto42 = strMessagingWebServerCertificatePassword_ENCRYPTED22.length;
                strMessagingWebServerCertificatePassword22 = 0;
                while (strMessagingWebServerCertificatePassword22 < theCrypto42) {
                    Constants.Enabled messagingWebServerRestrictedAccessSourcesEnabled = strMessagingWebServerCertificatePassword_ENCRYPTED22[strMessagingWebServerCertificatePassword22];
                    if (strMessagingWebServerRestrictedAccessSourcesEnabled.equalsIgnoreCase(messagingWebServerRestrictedAccessSourcesEnabled.getValue())) {
                        WebServerParameters.setMessagingWebServerRestrictedAccessSourcesEnabled(messagingWebServerRestrictedAccessSourcesEnabled);
                    }
                    ++strMessagingWebServerCertificatePassword22;
                }
                String strMessagingWebServerRestrictedAccessSourcesMatchType = rs.getString("msg_restricted_access_sources_match_type") != null ? rs.getString("msg_restricted_access_sources_match_type").trim() : "";
                Constants.MatchType[] matchTypeArray = Constants.MatchType.values();
                int strMessagingWebServerCertificatePassword_ENCRYPTED22 = matchTypeArray.length;
                theCrypto42 = 0;
                while (theCrypto42 < strMessagingWebServerCertificatePassword_ENCRYPTED22) {
                    Constants.MatchType messagingWebServerRestrictedAccessSourcesMatchType = matchTypeArray[theCrypto42];
                    if (strMessagingWebServerRestrictedAccessSourcesMatchType.equalsIgnoreCase(messagingWebServerRestrictedAccessSourcesMatchType.getValue())) {
                        WebServerParameters.setMessagingWebServerRestrictedAccessSourcesMatchType(messagingWebServerRestrictedAccessSourcesMatchType);
                    }
                    ++theCrypto42;
                }
                WebServerParameters.setMessagingWebServerMaxRestrictedAccessSources(rs.getInt("msg_max_restricted_access_sources") > 0 ? rs.getInt("msg_max_restricted_access_sources") : 0);
                WebServerParameters.setMessagingWebServerRestrictedAccessSources(rs.getString("msg_restricted_access_sources") != null ? rs.getString("msg_restricted_access_sources").trim() : "");
                WebServerParameters.setManagementWebServerID(rs.getInt("management_web_server_id") > 0 ? rs.getInt("management_web_server_id") : 0);
                WebServerParameters.setManagementWebServerName(rs.getString("mgt_web_server_name") != null ? rs.getString("mgt_web_server_name").trim() : "");
                String strManagementWebServerEnabled = rs.getString("mgt_web_server_enabled") != null ? rs.getString("mgt_web_server_enabled").trim() : "";
                Constants.Enabled[] enabledArray2 = Constants.Enabled.values();
                int n12 = enabledArray2.length;
                strMessagingWebServerCertificatePassword_ENCRYPTED22 = 0;
                while (strMessagingWebServerCertificatePassword_ENCRYPTED22 < n12) {
                    Constants.Enabled managementWebServerEnabled = enabledArray2[strMessagingWebServerCertificatePassword_ENCRYPTED22];
                    if (strManagementWebServerEnabled.equalsIgnoreCase(managementWebServerEnabled.getValue())) {
                        WebServerParameters.setManagementWebServerEnabled(managementWebServerEnabled);
                    }
                    ++strMessagingWebServerCertificatePassword_ENCRYPTED22;
                }
                WebServerParameters.setManagementWebServerPort(rs.getInt("mgt_web_server_port") > 0 ? rs.getInt("mgt_web_server_port") : 8445);
                WebServerParameters.setManagementWebServerThreadMaximumPoolSize(rs.getInt("mgt_web_server_thread_max_pool_size") > 0 ? rs.getInt("mgt_web_server_thread_max_pool_size") : 40);
                WebServerParameters.setManagementWebServerThreadKeepAliveTime(rs.getInt("mgt_web_server_thread_keep_alive_time") > 0 ? rs.getInt("mgt_web_server_thread_keep_alive_time") : 30);
                String strManagementWebServerCryptographyEnabled = rs.getString("mgt_cryptography_enabled") != null ? rs.getString("mgt_cryptography_enabled").trim() : "";
                Constants.Enabled[] enabledArray3 = Constants.Enabled.values();
                int n13 = enabledArray3.length;
                n12 = 0;
                while (n12 < n13) {
                    Constants.Enabled managementWebServerCryptographyEnabled = enabledArray3[n12];
                    if (strManagementWebServerCryptographyEnabled.equalsIgnoreCase(managementWebServerCryptographyEnabled.getValue())) {
                        WebServerParameters.setManagementWebServerCryptographyEnabled(managementWebServerCryptographyEnabled);
                    }
                    ++n12;
                }
                WebServerParameters.setManagementWebServerCryptographicProtocol(rs.getString("mgt_cryptographic_protocol") != null ? rs.getString("mgt_cryptographic_protocol").trim() : "");
                String strManagementWebServerClientAuthEnabled = rs.getString("mgt_client_auth_enabled") != null ? rs.getString("mgt_client_auth_enabled").trim() : "";
                Constants.Enabled[] enabledArray4 = Constants.Enabled.values();
                int n14 = enabledArray4.length;
                n13 = 0;
                while (n13 < n14) {
                    Constants.Enabled managementWebServerClientAuthEnabled = enabledArray4[n13];
                    if (strManagementWebServerClientAuthEnabled.equalsIgnoreCase(managementWebServerClientAuthEnabled.getValue())) {
                        WebServerParameters.setManagementWebServerClientAuthEnabled(managementWebServerClientAuthEnabled);
                    }
                    ++n13;
                }
                String strManagementWebServerStrictClientAuthCheck = rs.getString("mgt_strict_client_auth_check") != null ? rs.getString("mgt_strict_client_auth_check").trim() : "";
                Constants.Enabled[] enabledArray5 = Constants.Enabled.values();
                int n15 = enabledArray5.length;
                n14 = 0;
                while (n14 < n15) {
                    Constants.Enabled managementWebServerStrictClientAuthCheck = enabledArray5[n14];
                    if (strManagementWebServerStrictClientAuthCheck.equalsIgnoreCase(managementWebServerStrictClientAuthCheck.getValue())) {
                        WebServerParameters.setManagementWebServerStrictClientAuthCheck(managementWebServerStrictClientAuthCheck);
                    }
                    ++n14;
                }
                WebServerParameters.setManagementWebServerHomeFilePath(rs.getString("mgt_home_file_path") != null ? rs.getString("mgt_home_file_path").trim() : "");
                WebServerParameters.setManagementWebServerCACertificateFilePath(rs.getString("mgt_ca_certificate_file_path") != null ? rs.getString("mgt_ca_certificate_file_path").trim() : "");
                WebServerParameters.setManagementWebServerCertificateFilePath(rs.getString("mgt_certificate_file_path") != null ? rs.getString("mgt_certificate_file_path").trim() : "");
                String strManagementCertificatePasswordType = rs.getString("mgt_certificate_password_type") != null ? rs.getString("mgt_certificate_password_type").trim() : "";
                Constants.PasswordType[] passwordTypeArray4 = Constants.PasswordType.values();
                int n16 = passwordTypeArray4.length;
                n15 = 0;
                while (n15 < n16) {
                    Constants.PasswordType managementCertificatePasswordType = passwordTypeArray4[n15];
                    if (strManagementCertificatePasswordType.equalsIgnoreCase(managementCertificatePasswordType.getValue())) {
                        WebServerParameters.setManagementWebServerCertificatePasswordType(managementCertificatePasswordType);
                        strManagementWebServerCertificatePassword22 = rs.getString("mgt_certificate_password") != null ? rs.getString("mgt_certificate_password").trim() : "";
                        Crypto theCrypto = new Crypto();
                        if (!managementCertificatePasswordType.getValue().equalsIgnoreCase(Constants.PasswordType.ENCRYPTED.getValue())) {
                            System.out.println("Encrypting Management WebServer Certificate Password ...");
                            String strManagementWebServerCertificatePassword_ENCRYPTED = theCrypto.encrypt(Constants.strKey, (String)strManagementWebServerCertificatePassword22);
                            this.setEncryptedWebServerCertificatePassword(WebServerParameters.getManagementWebServerID(), strManagementWebServerCertificatePassword_ENCRYPTED);
                        } else {
                            System.out.println("Management WebServer Certificate Password is Protected");
                            strManagementWebServerCertificatePassword22 = theCrypto.decrypt(Constants.strKey, (String)strManagementWebServerCertificatePassword22);
                        }
                        WebServerParameters.setManagementWebServerCertificatePassword((String)strManagementWebServerCertificatePassword22);
                    }
                    ++n15;
                }
                String strManagementWebServerAllowedAccessSourcesEnabled = rs.getString("mgt_allowed_access_sources_enabled") != null ? rs.getString("mgt_allowed_access_sources_enabled").trim() : "";
                strManagementWebServerCertificatePassword22 = Constants.Enabled.values();
                int n17 = ((Constants.Enabled[])strManagementWebServerCertificatePassword22).length;
                n16 = 0;
                while (n16 < n17) {
                    Constants.Enabled managementWebServerAllowedAccessSourcesEnabled = strManagementWebServerCertificatePassword22[n16];
                    if (strManagementWebServerAllowedAccessSourcesEnabled.equalsIgnoreCase(managementWebServerAllowedAccessSourcesEnabled.getValue())) {
                        WebServerParameters.setManagementWebServerAllowedAccessSourcesEnabled(managementWebServerAllowedAccessSourcesEnabled);
                    }
                    ++n16;
                }
                String strManagementWebServerAllowedAccessSourcesMatchType = rs.getString("mgt_allowed_access_sources_match_type") != null ? rs.getString("mgt_allowed_access_sources_match_type").trim() : "";
                Constants.MatchType[] matchTypeArray2 = Constants.MatchType.values();
                int strManagementWebServerCertificatePassword22 = matchTypeArray2.length;
                n17 = 0;
                while (n17 < strManagementWebServerCertificatePassword22) {
                    Constants.MatchType managementWebServerAllowedAccessSourcesMatchType = matchTypeArray2[n17];
                    if (strManagementWebServerAllowedAccessSourcesMatchType.equalsIgnoreCase(managementWebServerAllowedAccessSourcesMatchType.getValue())) {
                        WebServerParameters.setManagementWebServerAllowedAccessSourcesMatchType(managementWebServerAllowedAccessSourcesMatchType);
                    }
                    ++n17;
                }
                WebServerParameters.setManagementWebServerMaxAllowedAccessSources(rs.getInt("mgt_max_allowed_access_sources") > 0 ? rs.getInt("mgt_max_allowed_access_sources") : 0);
                WebServerParameters.setManagementWebServerAllowedAccessSources(rs.getString("mgt_allowed_access_sources") != null ? rs.getString("mgt_allowed_access_sources").trim() : "");
                String strManagementWebServerRestrictedAccessSourcesEnabled = rs.getString("mgt_restricted_access_sources_enabled") != null ? rs.getString("mgt_restricted_access_sources_enabled").trim() : "";
                Constants.Enabled[] enabledArray6 = Constants.Enabled.values();
                int n18 = enabledArray6.length;
                strManagementWebServerCertificatePassword22 = 0;
                while (strManagementWebServerCertificatePassword22 < n18) {
                    Constants.Enabled managementWebServerRestrictedAccessSourcesEnabled = enabledArray6[strManagementWebServerCertificatePassword22];
                    if (strManagementWebServerRestrictedAccessSourcesEnabled.equalsIgnoreCase(managementWebServerRestrictedAccessSourcesEnabled.getValue())) {
                        WebServerParameters.setManagementWebServerRestrictedAccessSourcesEnabled(managementWebServerRestrictedAccessSourcesEnabled);
                    }
                    ++strManagementWebServerCertificatePassword22;
                }
                String strManagementWebServerRestrictedAccessSourcesMatchType = rs.getString("mgt_restricted_access_sources_match_type") != null ? rs.getString("mgt_restricted_access_sources_match_type").trim() : "";
                Constants.MatchType[] matchTypeArray3 = Constants.MatchType.values();
                int n19 = matchTypeArray3.length;
                n18 = 0;
                while (n18 < n19) {
                    Constants.MatchType managementWebServerRestrictedAccessSourcesMatchType = matchTypeArray3[n18];
                    if (strManagementWebServerRestrictedAccessSourcesMatchType.equalsIgnoreCase(managementWebServerRestrictedAccessSourcesMatchType.getValue())) {
                        WebServerParameters.setManagementWebServerRestrictedAccessSourcesMatchType(managementWebServerRestrictedAccessSourcesMatchType);
                    }
                    ++n18;
                }
            } else {
                System.err.println("PESA Client Database Parameters Not Found. Please Confirm System Paremeters has been Set and the ParameterID has been Linked in the Config File.");
                rs.close();
                p.close();
                rs = null;
                p = null;
                strSQL = null;
                return false;
            }
            WebServerParameters.setManagementWebServerMaxRestrictedAccessSources(rs.getInt("mgt_max_restricted_access_sources") > 0 ? rs.getInt("mgt_max_restricted_access_sources") : 0);
            WebServerParameters.setManagementWebServerRestrictedAccessSources(rs.getString("mgt_restricted_access_sources") != null ? rs.getString("mgt_restricted_access_sources").trim() : "");
            System.out.println("\nPESA Client Database Parameters ... ");
            System.out.println("Client Parameters ... ");
            System.out.println("Parameters URL                       : " + LocalParameters.getParametersURL());
            System.out.println("Parameters Status                    : " + (Object)((Object)LocalParameters.getParametersStatus()));
            System.out.println("Client ID                            : " + LocalParameters.getClientID());
            System.out.println("Client Name                          : " + LocalParameters.getClientName());
            System.out.println("System User ID                       : " + LocalParameters.getSystemUserID());
            System.out.println("System Username                      : " + LocalParameters.getSystemUsername());
            System.out.println("System Password (Hidden)             : ******");
            System.out.println("System Password Type                 : " + (Object)((Object)LocalParameters.getSystemPasswordType()));
            System.out.println("Integrity Hash Enabled               : " + (Object)((Object)LocalParameters.getIntegrityHashEnabled()));
            System.out.println("Integrity Hash InboundCheck          : " + (Object)((Object)LocalParameters.getIntegrityHashInboundCheck()));
            System.out.println("Integrity Hash OutboundCheck         : " + (Object)((Object)LocalParameters.getIntegrityHashOutboundCheck()));
            System.out.println("Integrity Secret (Hidden)            : ******");
            System.out.println("Integrity Secret Type                : " + (Object)((Object)LocalParameters.getIntegritySecretType()));
            System.out.println("Client XML Parameters                : " + LocalParameters.getClientXMLParameters());
            System.out.println("Client Connection Timeout Seconds    : " + LocalParameters.getClientConnectionTimeoutSeconds());
            System.out.println("Client Encryption Type               : " + (Object)((Object)LocalParameters.getClientEncryptionType()));
            System.out.println("Client Certificate Configuration     : " + (Object)((Object)LocalParameters.getClientCertificateConfiguration()));
            System.out.println("Client Cryptographic Protocol        : " + LocalParameters.getClientCryptographicProtocol());
            System.out.println("Client Certificate Chain Validation  : " + (Object)((Object)LocalParameters.getClientCertificateChainValidation()));
            System.out.println("Client Hostname Verification         : " + (Object)((Object)LocalParameters.getClientHostnameVerification()));
            System.out.println("Client CA Certificate File Path      : " + LocalParameters.getClientCACertificateFilePath());
            System.out.println("Client Certificate File Path         : " + LocalParameters.getClientCertificateFilePath());
            System.out.println("Client Certificate Password (Hidden) : ******");
            System.out.println("Client Certificate Password Type     : " + (Object)((Object)LocalParameters.getClientCertificatePasswordType()));
            System.out.println("\nMessaging Client Web Server Parameters... ");
            System.out.println("Messaging Web Server ID                                   : " + WebServerParameters.getMessagingWebServerID());
            System.out.println("Messaging Web Server Name                                 : " + WebServerParameters.getMessagingWebServerName());
            System.out.println("Messaging Web Server Enabled                              : " + (Object)((Object)WebServerParameters.getMessagingWebServerEnabled()));
            System.out.println("Messaging Web Server Port                                 : " + WebServerParameters.getMessagingWebServerPort());
            System.out.println("Messaging Web Server Thread Maximum Pool Size             : " + WebServerParameters.getMessagingWebServerThreadMaximumPoolSize());
            System.out.println("Messaging Web Server Thread Keep Alive Time               : " + WebServerParameters.getMessagingWebServerThreadKeepAliveTime());
            System.out.println("Messaging Web Server Cryptography Enabled                 : " + (Object)((Object)WebServerParameters.getMessagingWebServerCryptographyEnabled()));
            System.out.println("Messaging Web Server Cryptographic Protocol               : " + WebServerParameters.getMessagingWebServerCryptographicProtocol());
            System.out.println("Messaging Web Server Client Auth Enabled                  : " + (Object)((Object)WebServerParameters.getMessagingWebServerClientAuthEnabled()));
            System.out.println("Messaging Web Server Strict Client Auth Check             : " + (Object)((Object)WebServerParameters.getMessagingWebServerStrictClientAuthCheck()));
            System.out.println("Messaging Web Server Home File Path                       : " + WebServerParameters.getMessagingWebServerHomeFilePath());
            System.out.println("Messaging Web Server CA Certificate File Path             : " + WebServerParameters.getMessagingWebServerCACertificateFilePath());
            System.out.println("Messaging Web Server Certificate File Path                : " + WebServerParameters.getMessagingWebServerCertificateFilePath());
            System.out.println("Messaging Web Server Certificate Password (Hidden)        : ******");
            System.out.println("Messaging Web Server Certificate Password Type            : " + (Object)((Object)WebServerParameters.getMessagingWebServerCertificatePasswordType()));
            System.out.println("Messaging Web Server Allowed Access Sources Enabled       : " + (Object)((Object)WebServerParameters.getMessagingWebServerAllowedAccessSourcesEnabled()));
            System.out.println("Messaging Web Server Allowed Access Sources Match Type    : " + (Object)((Object)WebServerParameters.getMessagingWebServerAllowedAccessSourcesMatchType()));
            System.out.println("Messaging Web Server Max Allowed Access Sources           : " + WebServerParameters.getMessagingWebServerMaxAllowedAccessSources());
            System.out.println("Messaging Web Server Allowed Access Sources               : " + WebServerParameters.getMessagingWebServerAllowedAccessSources());
            System.out.println("Messaging Web Server Restricted Access Sources Enabled    : " + (Object)((Object)WebServerParameters.getMessagingWebServerRestrictedAccessSourcesEnabled()));
            System.out.println("Messaging Web Server Restricted Access Sources Match Type : " + (Object)((Object)WebServerParameters.getMessagingWebServerRestrictedAccessSourcesMatchType()));
            System.out.println("Messaging Web Server Max Restricted Access Sources        : " + WebServerParameters.getMessagingWebServerMaxRestrictedAccessSources());
            System.out.println("Messaging Web Server Restricted Access Sources            : " + WebServerParameters.getMessagingWebServerRestrictedAccessSources());
            System.out.println("\nManagement Client Web Server Parameters... ");
            System.out.println("Management Web Server ID                                  : " + WebServerParameters.getManagementWebServerID());
            System.out.println("Management Web Server Name                                : " + WebServerParameters.getManagementWebServerName());
            System.out.println("Management Web Server Enabled                             : " + (Object)((Object)WebServerParameters.getManagementWebServerEnabled()));
            System.out.println("Management Web Server Port                                : " + WebServerParameters.getManagementWebServerPort());
            System.out.println("Management Web Server Thread Maximum Pool Size            : " + WebServerParameters.getManagementWebServerThreadMaximumPoolSize());
            System.out.println("Management Web Server Thread Keep Alive Time              : " + WebServerParameters.getManagementWebServerThreadKeepAliveTime());
            System.out.println("Management Web Server Cryptography Enabled                : " + (Object)((Object)WebServerParameters.getManagementWebServerCryptographyEnabled()));
            System.out.println("Management Web Server Cryptographic Protocol              : " + WebServerParameters.getManagementWebServerCryptographicProtocol());
            System.out.println("Management Web Server Client Auth Enabled                 : " + (Object)((Object)WebServerParameters.getManagementWebServerClientAuthEnabled()));
            System.out.println("Management Web Server Strict Client Auth Check            : " + (Object)((Object)WebServerParameters.getManagementWebServerStrictClientAuthCheck()));
            System.out.println("Management Web Server Home File Path                      : " + WebServerParameters.getManagementWebServerHomeFilePath());
            System.out.println("Management Web Server CA Certificate File Path            : " + WebServerParameters.getManagementWebServerCACertificateFilePath());
            System.out.println("Management Web Server Certificate File Path               : " + WebServerParameters.getManagementWebServerCertificateFilePath());
            System.out.println("Management Web Server Certificate Password (Hidden)       : ******");
            System.out.println("Management Web Server Certificate Password Type           : " + (Object)((Object)WebServerParameters.getManagementWebServerCertificatePasswordType()));
            System.out.println("Management Web Server Allowed Access Sources Enabled      : " + (Object)((Object)WebServerParameters.getManagementWebServerAllowedAccessSourcesEnabled()));
            System.out.println("Management Web Server Allowed Access Sources Match Type   : " + (Object)((Object)WebServerParameters.getManagementWebServerAllowedAccessSourcesMatchType()));
            System.out.println("Management Web Server Max Allowed Access Sources          : " + WebServerParameters.getManagementWebServerMaxAllowedAccessSources());
            System.out.println("Management Web Server Allowed Access Sources              : " + WebServerParameters.getManagementWebServerAllowedAccessSources());
            System.out.println("Management Web Server Restricted Access Sources Enabled   : " + (Object)((Object)WebServerParameters.getManagementWebServerRestrictedAccessSourcesEnabled()));
            System.out.println("Management Web Server Restricted Access Sources Match Type: " + (Object)((Object)WebServerParameters.getManagementWebServerRestrictedAccessSourcesMatchType()));
            System.out.println("Management Web Server Max Restricted Access Sources       : " + WebServerParameters.getManagementWebServerMaxRestrictedAccessSources());
            System.out.println("Management Web Server Restricted Access Sources           : " + WebServerParameters.getManagementWebServerRestrictedAccessSources());
            System.out.println("");
            System.out.println("*********************************************************");
            rs.close();
            p.close();
            rs = null;
            p = null;
            strSQL = null;
            return true;
        }
        catch (Exception e) {
            System.err.println("Error message DB: " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                p.close();
            }
            catch (Exception exception) {}
            rs = null;
            p = null;
            strSQL = null;
        }
        return false;
    }

    public ArrayList<PESA> getPESAData(Constants.PESAType thePESAType) {
        PESATable thePESATable = null;
        if (thePESAType.equals((Object)Constants.PESAType.PESA_OUT)) {
            thePESATable = new PESAOUTTable();
        } else if (thePESAType.equals((Object)Constants.PESAType.BUY_AIRTIME)) {
            thePESATable = new BuyAirtimeTable();
        } else if (thePESAType.equals((Object)Constants.PESAType.PESA_IN)) {
            thePESATable = new PESAINTable();
        }
        Statement stQuery = null;
        ResultSet rs = null;
        String strSQL = null;
        try {
            System.out.println("\nGetting PESA to be sent in the Database ...");
            String strMintelLEFTJOIN = "";
            String strSQLFields = String.valueOf(thePESATable.getPESATableFieldTransactionID()) + "," + thePESATable.getPESATableFieldPESAID() + "," + thePESATable.getPESATableFieldPESAType() + "," + thePESATable.getPESATableFieldPESAProductID() + "," + thePESATable.getPESATableFieldPESAStatusCode() + "," + thePESATable.getPESATableFieldPESAStatusDescription() + "," + thePESATable.getPESATableFieldPESAStatusDate() + "," + thePESATable.getPESATableFieldSender() + "," + thePESATable.getPESATableFieldSenderDetails() + "," + thePESATable.getPESATableFieldReceiver() + "," + thePESATable.getPESATableFieldReceiverDetails() + "," + thePESATable.getPESATableFieldCurrency() + "," + thePESATable.getPESATableFieldAmount() + "," + thePESATable.getPESATableFieldAccount() + "," + thePESATable.getPESATableFieldPESASourceReference() + "," + thePESATable.getPESATableFieldPESADestinationReference() + "," + thePESATable.getPESATableFieldSendIntegrityHash() + "," + thePESATable.getPESATableFieldSchedulePesa() + "," + thePESATable.getPESATableFieldDateScheduled() + "," + thePESATable.getPESATableFieldApplyTransactionCharge() + "," + thePESATable.getPESATableFieldTransactionDate() + "," + thePESATable.getPESATableFieldDateCreated() + "," + thePESATable.getPESATableFieldPESAPriority() + "," + thePESATable.getPESATableFieldPESASendCount() + "," + thePESATable.getPESATableFieldPESAXMLData();
            switch (LocalParameters.getDatabaseType()) {
                case MySQL: {
                    strSQL = "SELECT " + strSQLFields + ", TIMESTAMPDIFF(MINUTE," + thePESATable.getPESATableFieldDateCreated() + ",NOW()) AS pending_minutes " + " FROM " + thePESATable.getPESATableName() + strMintelLEFTJOIN + " WHERE " + thePESATable.getPESATableFieldPESAStatusCode() + " = " + Constants.PESAStatusCode.QUEUED.getValue() + " AND " + thePESATable.getPESATableFieldPESAType() + " = '" + thePESAType.getValue() + "'" + " OR ( (" + thePESATable.getPESATableFieldPESAStatusCode() + " = " + Constants.PESAStatusCode.SEND_ERROR.getValue() + " OR " + thePESATable.getPESATableFieldPESAStatusCode() + " = " + Constants.PESAStatusCode.INSUFFICIENT_CREDIT.getValue() + ")" + " AND " + thePESATable.getPESATableFieldPESAType() + " = '" + thePESAType.getValue() + "'" + " AND " + thePESATable.getPESATableFieldPESAStatusDate() + " < TIMESTAMPADD(SECOND,-" + RemoteParameters.getPESASendRetryWaitSeconds() + " ,NOW()) )" + " ORDER BY " + thePESATable.getPESATableFieldPESAPriority() + ", " + thePESATable.getPESATableFieldTransactionID() + " LIMIT " + RemoteParameters.getMaxPESAPerBatch();
                    break;
                }
                case MicrosoftSQL: {
                    strSQL = "SELECT TOP " + RemoteParameters.getMaxPESAPerBatch() + " " + strSQLFields + ", DATEDIFF(MINUTE," + thePESATable.getPESATableFieldDateCreated() + ",GETDATE()) AS pending_minutes " + " FROM " + thePESATable.getPESATableName() + strMintelLEFTJOIN + " WHERE " + thePESATable.getPESATableFieldPESAStatusCode() + " = " + Constants.PESAStatusCode.QUEUED.getValue() + " AND " + thePESATable.getPESATableFieldPESAType() + " = '" + thePESAType.getValue() + "'" + " OR ( (" + thePESATable.getPESATableFieldPESAStatusCode() + " = " + Constants.PESAStatusCode.SEND_ERROR.getValue() + " OR " + thePESATable.getPESATableFieldPESAStatusCode() + " = " + Constants.PESAStatusCode.INSUFFICIENT_CREDIT.getValue() + ")" + " AND " + thePESATable.getPESATableFieldPESAType() + " = '" + thePESAType.getValue() + "'" + " AND " + thePESATable.getPESATableFieldPESAStatusDate() + " < DATEADD(SECOND,-" + RemoteParameters.getPESASendRetryWaitSeconds() + " ,GETDATE()) )" + " ORDER BY " + thePESATable.getPESATableFieldPESAPriority() + ", " + thePESATable.getPESATableFieldTransactionID();
                    break;
                }
                case Oracle: {
                    System.err.println("Oracle Database Type is not yet supported\n");
                    return null;
                }
                case PostgreSQL: {
                    System.err.println("PostgreSQL Database Type is not yet supported\n");
                    return null;
                }
                case MicrosoftAccess: {
                    System.err.println("Microsoft Access Database Type is not yet supported\n");
                    return null;
                }
                default: {
                    System.err.println("Invalid Database Type selected\n");
                    return null;
                }
            }
            System.out.println("\nGenerating PESAs ...");
            ArrayList<PESA> pesaArrList = new ArrayList<PESA>();
            stQuery = conn.createStatement();
            rs = stQuery.executeQuery(strSQL);
            int intCount = 0;
            while (rs.next()) {
                System.out.println("\n(" + ++intCount + ") PESA Generated:");
                String strTransactionID = rs.getString(thePESATable.getPESATableFieldTransactionID()) != null ? rs.getString(thePESATable.getPESATableFieldTransactionID()).trim() : "";
                long lnPESAID = rs.getLong(thePESATable.getPESATableFieldPESAID());
                long lnPESAProductID = rs.getLong(thePESATable.getPESATableFieldPESAProductID());
                String strPESAType = rs.getString(thePESATable.getPESATableFieldPESAType()).trim();
                int intPESAStatusCode = rs.getInt(thePESATable.getPESATableFieldPESAStatusCode());
                String strPESAStatusDescription = rs.getString(thePESATable.getPESATableFieldPESAStatusDescription()) != null ? rs.getString(thePESATable.getPESATableFieldPESAStatusDescription()).trim() : "";
                String strPESAStatusDate = rs.getString(thePESATable.getPESATableFieldPESAStatusDate()) != null ? rs.getString(thePESATable.getPESATableFieldPESAStatusDate()).trim() : "";
                String strSender = rs.getString(thePESATable.getPESATableFieldSender()) != null ? rs.getString(thePESATable.getPESATableFieldSender()).trim() : "";
                String strSenderDetails = rs.getString(thePESATable.getPESATableFieldSenderDetails()) != null ? rs.getString(thePESATable.getPESATableFieldSenderDetails()).trim() : "";
                String strReceiver = rs.getString(thePESATable.getPESATableFieldReceiver()) != null ? rs.getString(thePESATable.getPESATableFieldReceiver()).trim() : "";
                String strReceiverDetails = rs.getString(thePESATable.getPESATableFieldReceiverDetails()) != null ? rs.getString(thePESATable.getPESATableFieldReceiverDetails()).trim() : "";
                String strCurrency = rs.getString(thePESATable.getPESATableFieldCurrency()) != null ? rs.getString(thePESATable.getPESATableFieldCurrency()).trim() : "";
                double dblAmount = rs.getDouble(thePESATable.getPESATableFieldAmount());
                String strAccount = rs.getString(thePESATable.getPESATableFieldAccount()) != null ? rs.getString(thePESATable.getPESATableFieldAccount()).trim() : "";
                String strPESASourceReference = rs.getString(thePESATable.getPESATableFieldPESASourceReference()) != null ? rs.getString(thePESATable.getPESATableFieldPESASourceReference()).trim() : "";
                String strPESADestinationReference = rs.getString(thePESATable.getPESATableFieldPESADestinationReference()) != null ? rs.getString(thePESATable.getPESATableFieldPESADestinationReference()).trim() : "";
                String strPESAXMLData = rs.getString(thePESATable.getPESATableFieldPESAXMLData()) != null ? rs.getString(thePESATable.getPESATableFieldPESAXMLData()).trim() : "<OTHER_DETAILS/>";
                int intPriority = rs.getInt(thePESATable.getPESATableFieldPESAPriority());
                int intSendCount = rs.getInt(thePESATable.getPESATableFieldPESASendCount());
                String strSendIntegrityHash = rs.getString(thePESATable.getPESATableFieldSendIntegrityHash()) != null ? rs.getString(thePESATable.getPESATableFieldSendIntegrityHash()).trim() : "";
                String strSchedulePesa = rs.getString(thePESATable.getPESATableFieldSchedulePesa()) != null ? rs.getString(thePESATable.getPESATableFieldSchedulePesa()).trim() : "";
                String strDateScheduled = rs.getString(thePESATable.getPESATableFieldDateScheduled()) != null ? rs.getString(thePESATable.getPESATableFieldDateScheduled()).trim() : "";
                String strApplyTransactionCharge = rs.getString(thePESATable.getPESATableFieldApplyTransactionCharge()) != null ? rs.getString(thePESATable.getPESATableFieldApplyTransactionCharge()).trim() : Constants.Enabled.YES.getValue();
                String strTransactionDate = rs.getString(thePESATable.getPESATableFieldTransactionDate()) != null ? rs.getString(thePESATable.getPESATableFieldTransactionDate()).trim() : "";
                String strDateCreated = rs.getString(thePESATable.getPESATableFieldDateCreated()) != null ? rs.getString(thePESATable.getPESATableFieldDateCreated()).trim() : "";
                PESAResponse thePESAResponse = new PESAResponse();
                if ((long)RemoteParameters.getPESAExpiryMinutes() > rs.getLong("pending_minutes")) {
                    boolean bDataIntegrityOK = true;
                    if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES) && LocalParameters.getIntegrityHashOutboundCheck().equals((Object)Constants.Enabled.YES)) {
                        strTransactionDate = strTransactionDate.length() > 19 ? strTransactionDate.substring(0, 19) : strTransactionDate;
                        strDateScheduled = strDateScheduled.length() > 19 ? strDateScheduled.substring(0, 19) : strDateScheduled;
                        String strIntegrirtyHash = String.valueOf(strTransactionID) + "-" + lnPESAProductID + "-" + strPESAType + "-" + strApplyTransactionCharge + "-" + strSender + "-" + strSenderDetails + "-" + strReceiver + "-" + strReceiverDetails + "-" + strCurrency + "-" + dblAmount + "-" + strAccount + "-" + strPESASourceReference + "-" + (strSchedulePesa.equalsIgnoreCase(Constants.Enabled.YES.getValue()) ? strDateScheduled : "") + "-" + strTransactionDate + "-" + strPESAXMLData + "-" + LocalParameters.getIntegritySecret();
                        strIntegrirtyHash = Utils.hash("SHA-256", strIntegrirtyHash);
                        boolean bl = bDataIntegrityOK = strIntegrirtyHash.equalsIgnoreCase(strSendIntegrityHash);
                    }
                    if (bDataIntegrityOK) {
                        PESA thePESA = new PESA();
                        thePESA.setTransactionID(strTransactionID);
                        thePESA.setPESAID(lnPESAID);
                        thePESA.setPESAType(strPESAType);
                        thePESA.setPESAProductID(lnPESAProductID);
                        thePESA.setPESAStatusCode(intPESAStatusCode);
                        thePESA.setPESAStatusDescription(strPESAStatusDescription);
                        thePESA.setPESAStatusDate(strPESAStatusDate);
                        thePESA.setSender(strSender);
                        thePESA.setSenderDetails(strSenderDetails);
                        thePESA.setReceiver(strReceiver);
                        thePESA.setReceiverDetails(strReceiverDetails);
                        thePESA.setCurrency(strCurrency);
                        thePESA.setAmount(dblAmount);
                        thePESA.setAccount(strAccount);
                        thePESA.setPESASourceReference(strPESASourceReference);
                        thePESA.setPESADestinationReference(strPESADestinationReference);
                        thePESA.setPESAXMLData(strPESAXMLData);
                        thePESA.setPriority(intPriority);
                        thePESA.setSendCount(intSendCount);
                        thePESA.setIntegrityHash(strSendIntegrityHash);
                        Enum[] enumArray = Constants.SchedulePesa.values();
                        int n = enumArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Constants.SchedulePesa schedulePesa = enumArray[n2];
                            if (strSchedulePesa.equalsIgnoreCase(schedulePesa.getValue())) {
                                thePESA.setSchedulePesa(schedulePesa);
                            }
                            ++n2;
                        }
                        thePESA.setDateScheduled(strDateScheduled);
                        if (strApplyTransactionCharge.matches("\\d+(\\.\\d+)?")) {
                            thePESA.setApplyTransactionCharge(strApplyTransactionCharge);
                        } else {
                            thePESA.setApplyTransactionCharge(Constants.Enabled.YES.getValue());
                            strApplyTransactionCharge = strApplyTransactionCharge.toUpperCase();
                            enumArray = Constants.Enabled.values();
                            n = enumArray.length;
                            n2 = 0;
                            while (n2 < n) {
                                Enum applyTransactionCharge = enumArray[n2];
                                if (strApplyTransactionCharge.equalsIgnoreCase(((Constants.Enabled)applyTransactionCharge).getValue())) {
                                    thePESA.setApplyTransactionCharge(((Constants.Enabled)applyTransactionCharge).getValue());
                                }
                                ++n2;
                            }
                        }
                        thePESA.setTransactionDate(strTransactionDate);
                        thePESA.setDateCreated(strDateCreated);
                        String strResponsePESAStatusDescription = "PESA Relayed for Sending ...";
                        System.out.println(strResponsePESAStatusDescription);
                        thePESAResponse.setTransactionID(thePESA.getTransactionID());
                        thePESAResponse.setPESAType(thePESAType.getValue());
                        thePESAResponse.setResponse(Constants.PESAServerResponse.OK.getValue());
                        thePESAResponse.setResponseCode(Constants.PESAStatusCode.RELAYED.getValue());
                        thePESAResponse.setResponseDescription(strResponsePESAStatusDescription);
                        thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                        this.setPesaServerResponseStatus(thePESAResponse);
                        pesaArrList.add(thePESA);
                        System.out.println("Transaction ID             : " + thePESA.getTransactionID());
                        System.out.println("PESA ID                    : " + thePESA.getPESAID());
                        System.out.println("PESA Product ID            : " + thePESA.getPESAProductID());
                        System.out.println("PESA Type                  : " + thePESA.getPESAType());
                        System.out.println("PESA Status Code           : " + thePESA.getPESAStatusCode());
                        System.out.println("PESA Status Description    : " + thePESA.getPESAStatusDescription());
                        System.out.println("PESA Status Date           : " + thePESA.getPESAStatusDate());
                        System.out.println("Sender                     : " + thePESA.getSender());
                        System.out.println("Sender Details             : " + thePESA.getSenderDetails());
                        System.out.println("Receiver                   : " + thePESA.getReceiver());
                        System.out.println("Receiver Details           : " + thePESA.getReceiverDetails());
                        System.out.println("Currency                   : " + thePESA.getCurrency());
                        System.out.println("Amount                     : " + thePESA.getAmount());
                        System.out.println("Account                    : " + thePESA.getAccount());
                        System.out.println("PESA Source Reference      : " + thePESA.getPESASourceReference());
                        System.out.println("PESA Destination Reference : " + thePESA.getPESADestinationReference());
                        System.out.println("PESA XML Data              : " + thePESA.getPESAXMLData());
                        System.out.println("PESA Priority              : " + thePESA.getPriority());
                        System.out.println("PESA Send Count            : " + thePESA.getSendCount());
                        System.out.println("Integrity Hash             : " + thePESA.getIntegrityHash());
                        System.out.println("Schedule Pesa              : " + (Object)((Object)thePESA.getSchedulePesa()));
                        System.out.println("Date Scheduled             : " + thePESA.getDateScheduled());
                        System.out.println("Apply Transaction Charge   : " + thePESA.getApplyTransactionCharge());
                        System.out.println("Transaction Date           : " + thePESA.getTransactionDate());
                        System.out.println("Date Created               : " + thePESA.getDateCreated());
                        continue;
                    }
                    String strResponsePESAStatusDescription = "Security Violation - Integrity Check Failed. Transaction NOT Sent";
                    System.out.println("Transaction ID '" + strTransactionID + "' FAILED : " + strResponsePESAStatusDescription);
                    thePESAResponse.setTransactionID(strTransactionID);
                    thePESAResponse.setPESAType(thePESAType.getValue());
                    thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                    thePESAResponse.setResponseCode(Constants.PESAStatusCode.TRANSACTION_REJECTED_ERROR.getValue());
                    thePESAResponse.setResponseDescription(strResponsePESAStatusDescription);
                    thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                    this.setPesaServerResponseStatus(thePESAResponse, true);
                    continue;
                }
                String strResponsePESAStatusDescription = "Transaction has taken too long than the Maximum allowed time of " + RemoteParameters.getPESAExpiryMinutes() + " minutes to be sent.";
                System.out.println("Transaction ID '" + strTransactionID + "' has EXPIRED - " + strResponsePESAStatusDescription);
                thePESAResponse.setTransactionID(strTransactionID);
                thePESAResponse.setPESAType(thePESAType.getValue());
                thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                thePESAResponse.setResponseCode(Constants.PESAStatusCode.EXPIRED.getValue());
                thePESAResponse.setResponseDescription(strResponsePESAStatusDescription);
                thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                this.setPesaServerResponseStatus(thePESAResponse, true);
            }
            System.out.println("\n" + intCount + " PESA Found in the Database");
            rs.close();
            stQuery.close();
            rs = null;
            stQuery = null;
            strSQL = null;
            ArrayList<PESA> arrayList = pesaArrList;
            return arrayList;
        }
        catch (Exception e) {
            System.err.println("Error message DB: " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stQuery.close();
            }
            catch (Exception exception) {}
            rs = null;
            stQuery = null;
            strSQL = null;
        }
        return null;
    }

    public Constants.PESAStatusCode getPESAStatusCode(String strPESAType, String strTransactionID) {
        PESATable thePESATable = null;
        if (strPESAType.equalsIgnoreCase(Constants.PESAType.PESA_OUT.getValue())) {
            thePESATable = new PESAOUTTable();
        } else if (strPESAType.equalsIgnoreCase(Constants.PESAType.BUY_AIRTIME.getValue())) {
            thePESATable = new BuyAirtimeTable();
        } else if (strPESAType.equalsIgnoreCase(Constants.PESAType.PESA_IN.getValue())) {
            thePESATable = new PESAINTable();
        }
        NamedParameterStatement p = null;
        Constants.PESAStatusCode thePESAStatusCode = null;
        ResultSet rs = null;
        String strSQL = null;
        try {
            switch (LocalParameters.getDatabaseType()) {
                case MySQL: {
                    strSQL = "SELECT " + thePESATable.getPESATableFieldPESAStatusCode() + " FROM " + thePESATable.getPESATableName() + " WHERE " + thePESATable.getPESATableFieldTransactionID() + " = :transaction_id";
                    break;
                }
                case MicrosoftSQL: {
                    strSQL = "SELECT " + thePESATable.getPESATableFieldPESAStatusCode() + " FROM " + thePESATable.getPESATableName() + " WHERE " + thePESATable.getPESATableFieldTransactionID() + " = :transaction_id";
                    break;
                }
                case Oracle: {
                    System.err.println("Oracle Database Type is not yet supported\n");
                    return null;
                }
                case PostgreSQL: {
                    System.err.println("PostgreSQL Database Type is not yet supported\n");
                    return null;
                }
                case MicrosoftAccess: {
                    System.err.println("Microsoft Access Database Type is not yet supported\n");
                    return null;
                }
                default: {
                    System.err.println("Invalid Database Type selected\n");
                    return null;
                }
            }
            try {
                p = new NamedParameterStatement(conn, strSQL);
                p.setString("transaction_id", strTransactionID);
                rs = p.executeQuery();
                if (rs.next()) {
                    int intPESAStatusCode = rs.getInt(thePESATable.getPESATableFieldPESAStatusCode());
                    Constants.PESAStatusCode[] pESAStatusCodeArray = Constants.PESAStatusCode.values();
                    int n = pESAStatusCodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constants.PESAStatusCode pesaStatusCode = pESAStatusCodeArray[n2];
                        if (pesaStatusCode.getValue() == intPESAStatusCode) {
                            thePESAStatusCode = pesaStatusCode;
                            break;
                        }
                        ++n2;
                    }
                }
                rs.close();
                p.close();
                rs = null;
                p = null;
                strSQL = null;
            }
            catch (Exception e) {
                System.err.println("Error message DB: " + e.getMessage());
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                p.close();
            }
            catch (Exception exception) {}
            rs = null;
            p = null;
            strSQL = null;
        }
        return thePESAStatusCode;
    }

    public void setEncryptedClientCertificatePassword(String strClientCertificatePassword_ENCRYPTED) {
        String strUpdateSQL = null;
        NamedParameterStatement pUpdateParameters = null;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strUpdateSQL = "UPDATE " + LocalParameters.getClientParametersTableName() + " SET client_certificate_password = :client_certificate_password," + " client_certificate_password_type = :client_certificate_password_type," + " date_modified = NOW()" + " WHERE parameters_id = :parameters_id";
                        break;
                    }
                    case MicrosoftSQL: {
                        strUpdateSQL = "UPDATE " + LocalParameters.getClientParametersTableName() + " SET client_certificate_password = :client_certificate_password," + " client_certificate_password_type = :client_certificate_password_type," + " date_modified = GETDATE()" + " WHERE parameters_id = :parameters_id";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pUpdateParameters = new NamedParameterStatement(conn, strUpdateSQL);
                pUpdateParameters.setString("client_certificate_password", strClientCertificatePassword_ENCRYPTED);
                pUpdateParameters.setString("client_certificate_password_type", Constants.PasswordType.ENCRYPTED.getValue());
                pUpdateParameters.setLong("parameters_id", LocalParameters.getParametersID());
                pUpdateParameters.executeUpdate();
                pUpdateParameters.close();
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strUpdateSQL = null;
                if (pUpdateParameters != null) {
                    try {
                        pUpdateParameters.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pUpdateParameters = null;
            }
        }
        finally {
            strUpdateSQL = null;
            if (pUpdateParameters != null) {
                try {
                    pUpdateParameters.close();
                }
                catch (Exception exception) {}
            }
            pUpdateParameters = null;
        }
    }

    public void setEncryptedSystemPassword(long lnParametersID, String strSystemPassword_ENCRYPTED) {
        String strUpdateSQL = null;
        NamedParameterStatement pUpdateParameters = null;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strUpdateSQL = "UPDATE " + LocalParameters.getClientParametersTableName() + " SET system_password = :system_password," + " system_password_type = :system_password_type," + " date_modified = NOW()" + " WHERE parameters_id = :parameters_id";
                        break;
                    }
                    case MicrosoftSQL: {
                        strUpdateSQL = "UPDATE " + LocalParameters.getClientParametersTableName() + " SET system_password = :system_password," + " system_password_type = :system_password_type," + " date_modified = GETDATE()" + " WHERE parameters_id = :parameters_id";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pUpdateParameters = new NamedParameterStatement(conn, strUpdateSQL);
                pUpdateParameters.setString("system_password", strSystemPassword_ENCRYPTED);
                pUpdateParameters.setString("system_password_type", Constants.PasswordType.ENCRYPTED.getValue());
                pUpdateParameters.setLong("parameters_id", lnParametersID);
                pUpdateParameters.executeUpdate();
                pUpdateParameters.close();
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strUpdateSQL = null;
                if (pUpdateParameters != null) {
                    try {
                        pUpdateParameters.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pUpdateParameters = null;
            }
        }
        finally {
            strUpdateSQL = null;
            if (pUpdateParameters != null) {
                try {
                    pUpdateParameters.close();
                }
                catch (Exception exception) {}
            }
            pUpdateParameters = null;
        }
    }

    public void setEncryptedIntegritySecret(long lnParametersID, String strIntegritySecret_ENCRYPTED) {
        String strUpdateSQL = null;
        NamedParameterStatement pUpdateParameters = null;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strUpdateSQL = "UPDATE " + LocalParameters.getClientParametersTableName() + " SET integrity_secret = :integrity_secret," + " integrity_secret_type = :integrity_secret_type," + " date_modified = NOW()" + " WHERE parameters_id = :parameters_id";
                        break;
                    }
                    case MicrosoftSQL: {
                        strUpdateSQL = "UPDATE " + LocalParameters.getClientParametersTableName() + " SET integrity_secret = :integrity_secret," + " integrity_secret_type = :integrity_secret_type," + " date_modified = GETDATE()" + " WHERE parameters_id = :parameters_id";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pUpdateParameters = new NamedParameterStatement(conn, strUpdateSQL);
                pUpdateParameters.setString("integrity_secret", strIntegritySecret_ENCRYPTED);
                pUpdateParameters.setString("integrity_secret_type", Constants.PasswordType.ENCRYPTED.getValue());
                pUpdateParameters.setLong("parameters_id", lnParametersID);
                pUpdateParameters.executeUpdate();
                pUpdateParameters.close();
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strUpdateSQL = null;
                if (pUpdateParameters != null) {
                    try {
                        pUpdateParameters.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pUpdateParameters = null;
            }
        }
        finally {
            strUpdateSQL = null;
            if (pUpdateParameters != null) {
                try {
                    pUpdateParameters.close();
                }
                catch (Exception exception) {}
            }
            pUpdateParameters = null;
        }
    }

    public void setEncryptedWebServerCertificatePassword(long lnWebServerID, String strWebServerCertificatePassword_ENCRYPTED) {
        String strUpdateSQL = null;
        NamedParameterStatement pUpdateParameters = null;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strUpdateSQL = "UPDATE " + LocalParameters.getClientWebServersParametersTableName() + " SET certificate_password = :certificate_password," + " certificate_password_type = :certificate_password_type," + " date_modified = NOW()" + " WHERE web_server_id = :web_server_id";
                        break;
                    }
                    case MicrosoftSQL: {
                        strUpdateSQL = "UPDATE " + LocalParameters.getClientWebServersParametersTableName() + " SET certificate_password = :certificate_password," + " certificate_password_type = :certificate_password_type," + " date_modified = GETDATE()" + " WHERE web_server_id = :web_server_id";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pUpdateParameters = new NamedParameterStatement(conn, strUpdateSQL);
                pUpdateParameters.setString("certificate_password", strWebServerCertificatePassword_ENCRYPTED);
                pUpdateParameters.setString("certificate_password_type", Constants.PasswordType.ENCRYPTED.getValue());
                pUpdateParameters.setLong("web_server_id", lnWebServerID);
                pUpdateParameters.executeUpdate();
                pUpdateParameters.close();
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strUpdateSQL = null;
                if (pUpdateParameters != null) {
                    try {
                        pUpdateParameters.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pUpdateParameters = null;
            }
        }
        finally {
            strUpdateSQL = null;
            if (pUpdateParameters != null) {
                try {
                    pUpdateParameters.close();
                }
                catch (Exception exception) {}
            }
            pUpdateParameters = null;
        }
    }

    public int setPesaServerResponseStatus(PESAResponse thePESAResponse) {
        PESATable thePESATable = null;
        if (thePESAResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.PESA_OUT.getValue())) {
            thePESATable = new PESAOUTTable();
        } else if (thePESAResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.BUY_AIRTIME.getValue())) {
            thePESATable = new BuyAirtimeTable();
        } else if (thePESAResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.PESA_IN.getValue())) {
            thePESATable = new PESAINTable();
        }
        String strUpdateSQL = null;
        NamedParameterStatement pUpdateStatus = null;
        int intUpdateCount = 0;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strUpdateSQL = "UPDATE " + thePESATable.getPESATableName() + " SET " + thePESATable.getPESATableFieldPESAID() + " = :pesa_id, " + thePESATable.getPESATableFieldPESAStatusCode() + " = :pesa_status_code, " + thePESATable.getPESATableFieldPESAStatusDescription() + " = :pesa_status_description, " + thePESATable.getPESATableFieldResponseIntegrityHash() + " = :pesa_response_integrity_hash, " + thePESATable.getPESATableFieldPESAStatusDate() + " = NOW()" + " WHERE " + thePESATable.getPESATableFieldTransactionID() + " = :transaction_id";
                        break;
                    }
                    case MicrosoftSQL: {
                        strUpdateSQL = "UPDATE " + thePESATable.getPESATableName() + " SET " + thePESATable.getPESATableFieldPESAID() + " = :pesa_id, " + thePESATable.getPESATableFieldPESAStatusCode() + " = :pesa_status_code, " + thePESATable.getPESATableFieldPESAStatusDescription() + " = :pesa_status_description, " + thePESATable.getPESATableFieldResponseIntegrityHash() + " = :pesa_response_integrity_hash, " + thePESATable.getPESATableFieldPESAStatusDate() + " = GETDATE()" + " WHERE " + thePESATable.getPESATableFieldTransactionID() + " = :transaction_id";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pUpdateStatus = new NamedParameterStatement(conn, strUpdateSQL);
                pUpdateStatus.setLong("pesa_id", thePESAResponse.getPESAID());
                pUpdateStatus.setString("transaction_id", thePESAResponse.getTransactionID());
                pUpdateStatus.setInt("pesa_status_code", thePESAResponse.getResponseCode());
                pUpdateStatus.setString("pesa_status_description", thePESAResponse.getResponseDescription());
                pUpdateStatus.setString("pesa_response_integrity_hash", thePESAResponse.getIntegrityHash());
                intUpdateCount = pUpdateStatus.executeUpdate();
                pUpdateStatus.close();
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strUpdateSQL = null;
                if (pUpdateStatus != null) {
                    try {
                        pUpdateStatus.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pUpdateStatus = null;
            }
        }
        finally {
            strUpdateSQL = null;
            if (pUpdateStatus != null) {
                try {
                    pUpdateStatus.close();
                }
                catch (Exception exception) {}
            }
            pUpdateStatus = null;
        }
        return intUpdateCount;
    }

    public int setPesaServerResponseStatus(PESAResponse thePESAResponse, boolean bLowerPesaPriority) {
        PESATable thePESATable = null;
        if (thePESAResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.PESA_OUT.getValue())) {
            thePESATable = new PESAOUTTable();
        } else if (thePESAResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.BUY_AIRTIME.getValue())) {
            thePESATable = new BuyAirtimeTable();
        } else if (thePESAResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.PESA_IN.getValue())) {
            thePESATable = new PESAINTable();
        }
        String strUpdateSQL = null;
        NamedParameterStatement pUpdateStatus = null;
        int intUpdateCount = 0;
        try {
            try {
                String strPriorityField = "";
                if (bLowerPesaPriority) {
                    strPriorityField = " " + thePESATable.getPESATableFieldPESAPriority() + " = " + thePESATable.getPESATableFieldPESAPriority() + " + 1, ";
                }
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strUpdateSQL = "UPDATE " + thePESATable.getPESATableName() + " SET " + thePESATable.getPESATableFieldPESAID() + " = :pesa_id, " + thePESATable.getPESATableFieldPESAStatusCode() + " = :pesa_status_code, " + thePESATable.getPESATableFieldPESAStatusDescription() + " = :pesa_status_description, " + thePESATable.getPESATableFieldResponseIntegrityHash() + " = :pesa_response_integrity_hash, " + thePESATable.getPESATableFieldPESAStatusDate() + " = NOW()," + strPriorityField + thePESATable.getPESATableFieldPESASendCount() + " = " + thePESATable.getPESATableFieldPESASendCount() + " + 1" + " WHERE " + thePESATable.getPESATableFieldTransactionID() + " = :transaction_id";
                        break;
                    }
                    case MicrosoftSQL: {
                        strUpdateSQL = "UPDATE " + thePESATable.getPESATableName() + " SET " + thePESATable.getPESATableFieldPESAID() + " = :pesa_id, " + thePESATable.getPESATableFieldPESAStatusCode() + " = :pesa_status_code, " + thePESATable.getPESATableFieldPESAStatusDescription() + " = :pesa_status_description, " + thePESATable.getPESATableFieldResponseIntegrityHash() + " = :pesa_response_integrity_hash, " + thePESATable.getPESATableFieldPESAStatusDate() + " = GETDATE()," + strPriorityField + thePESATable.getPESATableFieldPESASendCount() + " = " + thePESATable.getPESATableFieldPESASendCount() + " + 1" + " WHERE " + thePESATable.getPESATableFieldTransactionID() + " = :transaction_id";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pUpdateStatus = new NamedParameterStatement(conn, strUpdateSQL);
                pUpdateStatus.setLong("pesa_id", thePESAResponse.getPESAID());
                pUpdateStatus.setString("transaction_id", thePESAResponse.getTransactionID());
                pUpdateStatus.setInt("pesa_status_code", thePESAResponse.getResponseCode());
                pUpdateStatus.setString("pesa_status_description", thePESAResponse.getResponseDescription());
                pUpdateStatus.setString("pesa_response_integrity_hash", thePESAResponse.getIntegrityHash());
                intUpdateCount = pUpdateStatus.executeUpdate();
                pUpdateStatus.close();
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strUpdateSQL = null;
                if (pUpdateStatus != null) {
                    try {
                        pUpdateStatus.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pUpdateStatus = null;
            }
        }
        finally {
            strUpdateSQL = null;
            if (pUpdateStatus != null) {
                try {
                    pUpdateStatus.close();
                }
                catch (Exception exception) {}
            }
            pUpdateStatus = null;
        }
        return intUpdateCount;
    }

    public int updatePesaResultStatus(PESAResult thePESAResult) {
        PESATable thePESATable = null;
        if (thePESAResult.getPESAType().equalsIgnoreCase(Constants.PESAType.PESA_OUT.getValue())) {
            thePESATable = new PESAOUTTable();
        } else if (thePESAResult.getPESAType().equalsIgnoreCase(Constants.PESAType.BUY_AIRTIME.getValue())) {
            thePESATable = new BuyAirtimeTable();
        } else if (thePESAResult.getPESAType().equalsIgnoreCase(Constants.PESAType.PESA_IN.getValue())) {
            thePESATable = new PESAINTable();
        }
        String strUpdateSQL = null;
        NamedParameterStatement pUpdateStatus = null;
        int intUpdateCount = 0;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strUpdateSQL = "UPDATE " + thePESATable.getPESATableName() + " SET " + thePESATable.getPESATableFieldPESAID() + " = :pesa_id, " + thePESATable.getPESATableFieldPESAStatusCode() + " = :pesa_status_code, " + thePESATable.getPESATableFieldPESAStatusDescription() + " = :pesa_status_description, " + thePESATable.getPESATableFieldPESADestinationReference() + " = :pesa_destination_reference, " + thePESATable.getPESATableFieldResponseDate() + " = :pesa_response_date," + thePESATable.getPESATableFieldResponseXMLData() + "= :pesa_response_xml_data, " + thePESATable.getPESATableFieldResponseIntegrityHash() + " = :pesa_response_integrity_hash, " + thePESATable.getPESATableFieldPESAStatusDate() + " = NOW()" + " WHERE " + thePESATable.getPESATableFieldTransactionID() + " = :transaction_id" + " AND " + thePESATable.getPESATableFieldPESAType() + " = :pesa_type";
                        break;
                    }
                    case MicrosoftSQL: {
                        strUpdateSQL = "UPDATE " + thePESATable.getPESATableName() + " SET " + thePESATable.getPESATableFieldPESAID() + " = :pesa_id, " + thePESATable.getPESATableFieldPESAStatusCode() + " = :pesa_status_code, " + thePESATable.getPESATableFieldPESAStatusDescription() + " = :pesa_status_description, " + thePESATable.getPESATableFieldPESADestinationReference() + " = :pesa_destination_reference, " + thePESATable.getPESATableFieldResponseDate() + " = :pesa_response_date," + thePESATable.getPESATableFieldResponseXMLData() + "= :pesa_response_xml_data, " + thePESATable.getPESATableFieldResponseIntegrityHash() + " = :pesa_response_integrity_hash, " + thePESATable.getPESATableFieldPESAStatusDate() + " = GETDATE()" + " WHERE " + thePESATable.getPESATableFieldTransactionID() + " = :transaction_id" + " AND " + thePESATable.getPESATableFieldPESAType() + " = :pesa_type";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pUpdateStatus = new NamedParameterStatement(conn, strUpdateSQL);
                pUpdateStatus.setLong("pesa_id", thePESAResult.getPESAID());
                pUpdateStatus.setString("transaction_id", thePESAResult.getTransactionID());
                pUpdateStatus.setString("pesa_type", thePESAResult.getPESAType());
                pUpdateStatus.setInt("pesa_status_code", thePESAResult.getResponseCode());
                pUpdateStatus.setString("pesa_status_description", thePESAResult.getResponseDescription());
                pUpdateStatus.setString("pesa_destination_reference", thePESAResult.getReference());
                pUpdateStatus.setString("pesa_response_xml_data", thePESAResult.getOtherDetails());
                pUpdateStatus.setString("pesa_response_date", thePESAResult.getDateCreated());
                pUpdateStatus.setString("pesa_response_integrity_hash", thePESAResult.getIntegrityHash());
                intUpdateCount = pUpdateStatus.executeUpdate();
                pUpdateStatus.close();
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strUpdateSQL = null;
                if (pUpdateStatus != null) {
                    try {
                        pUpdateStatus.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pUpdateStatus = null;
            }
        }
        finally {
            strUpdateSQL = null;
            if (pUpdateStatus != null) {
                try {
                    pUpdateStatus.close();
                }
                catch (Exception exception) {}
            }
            pUpdateStatus = null;
        }
        return intUpdateCount;
    }

    public void QueueValidRelayedPESA(Constants.PESAType thePESAType) {
        PESATable thePESATable = null;
        if (thePESAType.equals((Object)Constants.PESAType.PESA_OUT)) {
            thePESATable = new PESAOUTTable();
        } else if (thePESAType.equals((Object)Constants.PESAType.BUY_AIRTIME)) {
            thePESATable = new BuyAirtimeTable();
        } else if (thePESAType.equals((Object)Constants.PESAType.PESA_IN)) {
            thePESATable = new PESAINTable();
        }
        String strUpdateSQL = null;
        NamedParameterStatement pQueueValidRelayedPESA = null;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strUpdateSQL = "UPDATE " + thePESATable.getPESATableName() + " SET " + thePESATable.getPESATableFieldPESAStatusCode() + " = :new_pesa_status_code, " + thePESATable.getPESATableFieldPESAStatusDescription() + " = :pesa_status_description, " + thePESATable.getPESATableFieldPESAStatusDate() + " = NOW() " + " WHERE " + thePESATable.getPESATableFieldPESASendCount() + " < :pesa_send_count" + " AND " + thePESATable.getPESATableFieldPESAType() + " = :pesa_type" + " AND " + thePESATable.getPESATableFieldPESAStatusCode() + " = :old_pesa_status_code" + " AND " + thePESATable.getPESATableFieldDateCreated() + " > TIMESTAMPADD(MINUTE,-:pesa_expiry_minutes,NOW())";
                        break;
                    }
                    case MicrosoftSQL: {
                        strUpdateSQL = "UPDATE " + thePESATable.getPESATableName() + " SET " + thePESATable.getPESATableFieldPESAStatusCode() + " = :new_pesa_status_code, " + thePESATable.getPESATableFieldPESAStatusDescription() + " = :pesa_status_description, " + thePESATable.getPESATableFieldPESAStatusDate() + " = GETDATE() " + " WHERE " + thePESATable.getPESATableFieldPESASendCount() + " < :pesa_send_count" + " AND " + thePESATable.getPESATableFieldPESAType() + " = :pesa_type" + " AND " + thePESATable.getPESATableFieldPESAStatusCode() + " = :old_pesa_status_code" + " AND " + thePESATable.getPESATableFieldDateCreated() + " > DATEADD(MINUTE,-:pesa_expiry_minutes,GETDATE())";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pQueueValidRelayedPESA = new NamedParameterStatement(conn, strUpdateSQL);
                pQueueValidRelayedPESA.setInt("new_pesa_status_code", Constants.PESAStatusCode.QUEUED.getValue());
                pQueueValidRelayedPESA.setString("pesa_status_description", "Queued Relayed PESA");
                pQueueValidRelayedPESA.setInt("pesa_send_count", RemoteParameters.getMaxPESASendCount());
                pQueueValidRelayedPESA.setString("pesa_type", thePESAType.getValue());
                pQueueValidRelayedPESA.setInt("old_pesa_status_code", Constants.PESAStatusCode.RELAYED.getValue());
                pQueueValidRelayedPESA.setInt("pesa_expiry_minutes", RemoteParameters.getPESAExpiryMinutes());
                long count = pQueueValidRelayedPESA.executeUpdate();
                pQueueValidRelayedPESA.close();
                System.out.println(String.valueOf(count) + " RELAYED PESA has been QUEUED\n");
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strUpdateSQL = null;
                if (pQueueValidRelayedPESA != null) {
                    try {
                        pQueueValidRelayedPESA.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pQueueValidRelayedPESA = null;
            }
        }
        finally {
            strUpdateSQL = null;
            if (pQueueValidRelayedPESA != null) {
                try {
                    pQueueValidRelayedPESA.close();
                }
                catch (Exception exception) {}
            }
            pQueueValidRelayedPESA = null;
        }
    }

    public boolean isPESAINRecordExist(long lnPESAID) {
        NamedParameterStatement p = null;
        ResultSet rs = null;
        String strSQL = null;
        PESAINTable thePESAINTable = new PESAINTable();
        try {
            switch (LocalParameters.getDatabaseType()) {
                case MySQL: {
                    strSQL = "SELECT COUNT(" + thePESAINTable.getPESATableFieldTransactionID() + ") AS rec_count" + " FROM " + thePESAINTable.getPESATableName() + " WHERE " + thePESAINTable.getPESATableFieldPESAID() + " = :pesa_id" + " AND " + thePESAINTable.getPESATableFieldPESAType() + " = :pesa_type";
                    break;
                }
                case MicrosoftSQL: {
                    strSQL = "SELECT COUNT(" + thePESAINTable.getPESATableFieldTransactionID() + ") AS rec_count" + " FROM " + thePESAINTable.getPESATableName() + " WHERE " + thePESAINTable.getPESATableFieldPESAID() + " = :pesa_id" + " AND " + thePESAINTable.getPESATableFieldPESAType() + " = :pesa_type";
                    break;
                }
                case Oracle: {
                    System.err.println("Oracle Database Type is not yet supported\n");
                    break;
                }
                case PostgreSQL: {
                    System.err.println("PostgreSQL Database Type is not yet supported\n");
                    break;
                }
                case MicrosoftAccess: {
                    System.err.println("Microsoft Access Database Type is not yet supported\n");
                    break;
                }
                default: {
                    System.err.println("Invalid Database Type selected\n");
                }
            }
            p = new NamedParameterStatement(conn, strSQL);
            p.setLong("pesa_id", lnPESAID);
            p.setString("pesa_type", Constants.PESAType.PESA_IN.getValue());
            rs = p.executeQuery();
            if (rs.next() && rs.getLong("rec_count") > 0L) {
                return true;
            }
            try {
                rs.close();
                p.close();
                rs = null;
                p = null;
                strSQL = null;
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
            }
        }
        finally {
            strSQL = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (p != null) {
                try {
                    p.close();
                }
                catch (Exception exception) {}
            }
            rs = null;
            p = null;
            strSQL = null;
        }
        return false;
    }

    public int insertPESAINLog(PESA thePESAIN) {
        String strInsertSQL = null;
        int count = 0;
        NamedParameterStatement pInsertPESALog = null;
        PESAINTable thePESAINTable = new PESAINTable();
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strInsertSQL = "INSERT INTO " + thePESAINTable.getPESATableName() + "(" + thePESAINTable.getPESATableFieldPESAID() + "," + thePESAINTable.getPESATableFieldPESAProductID() + "," + thePESAINTable.getPESATableFieldPESAType() + "," + thePESAINTable.getPESATableFieldPESAStatusCode() + "," + thePESAINTable.getPESATableFieldPESAStatusDescription() + "," + thePESAINTable.getPESATableFieldPESAStatusDate() + "," + thePESAINTable.getPESATableFieldSender() + "," + thePESAINTable.getPESATableFieldSenderDetails() + "," + thePESAINTable.getPESATableFieldReceiver() + "," + thePESAINTable.getPESATableFieldReceiverDetails() + "," + thePESAINTable.getPESATableFieldCurrency() + "," + thePESAINTable.getPESATableFieldAmount() + "," + thePESAINTable.getPESATableFieldAccount() + "," + thePESAINTable.getPESATableFieldPESASourceReference() + "," + thePESAINTable.getPESATableFieldPESAPriority() + "," + thePESAINTable.getPESATableFieldPESASendCount() + "," + thePESAINTable.getPESATableFieldSchedulePesa() + "," + thePESAINTable.getPESATableFieldDateScheduled() + "," + thePESAINTable.getPESATableFieldApplyTransactionCharge() + "," + thePESAINTable.getPESATableFieldPESAXMLData() + "," + thePESAINTable.getPESATableFieldSendIntegrityHash() + "," + thePESAINTable.getPESATableFieldTransactionDate() + "," + thePESAINTable.getPESATableFieldDateCreated() + ")" + " VALUES(:pesa_id, :pesa_product_id, :pesa_type, :pesa_status_code, :pesa_status_description, NOW()," + ":sender, :sender_details, :receiver, :receiver_details, :currency, :amount, :account, :pesa_source_reference," + ":pesa_priority, :pesa_send_count, :schedule_pesa, NOW(), :apply_transaction_charge," + ":pesa_xml_data, :pesa_send_integrity_hash, :transaction_date, NOW())";
                        break;
                    }
                    case MicrosoftSQL: {
                        strInsertSQL = "INSERT INTO " + thePESAINTable.getPESATableName() + "(" + thePESAINTable.getPESATableFieldPESAID() + "," + thePESAINTable.getPESATableFieldPESAProductID() + "," + thePESAINTable.getPESATableFieldPESAType() + "," + thePESAINTable.getPESATableFieldPESAStatusCode() + "," + thePESAINTable.getPESATableFieldPESAStatusDescription() + "," + thePESAINTable.getPESATableFieldPESAStatusDate() + "," + thePESAINTable.getPESATableFieldSender() + "," + thePESAINTable.getPESATableFieldSenderDetails() + "," + thePESAINTable.getPESATableFieldReceiver() + "," + thePESAINTable.getPESATableFieldReceiverDetails() + "," + thePESAINTable.getPESATableFieldCurrency() + "," + thePESAINTable.getPESATableFieldAmount() + "," + thePESAINTable.getPESATableFieldAccount() + "," + thePESAINTable.getPESATableFieldPESASourceReference() + "," + thePESAINTable.getPESATableFieldPESAPriority() + "," + thePESAINTable.getPESATableFieldPESASendCount() + "," + thePESAINTable.getPESATableFieldSchedulePesa() + "," + thePESAINTable.getPESATableFieldDateScheduled() + "," + thePESAINTable.getPESATableFieldApplyTransactionCharge() + "," + thePESAINTable.getPESATableFieldPESAXMLData() + "," + thePESAINTable.getPESATableFieldSendIntegrityHash() + "," + thePESAINTable.getPESATableFieldTransactionDate() + "," + thePESAINTable.getPESATableFieldDateCreated() + ")" + " VALUES(:pesa_id, :pesa_product_id, :pesa_type, :pesa_status_code, :pesa_status_description, GETDATE()," + ":sender, :sender_details, :receiver, :receiver_details, :currency, :amount, :account, :pesa_source_reference," + ":pesa_priority, :pesa_send_count, :schedule_pesa, GETDATE(), :apply_transaction_charge," + ":pesa_xml_data, :pesa_send_integrity_hash, :transaction_date, GETDATE())";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                pInsertPESALog = new NamedParameterStatement(conn, strInsertSQL);
                pInsertPESALog.setLong("pesa_id", thePESAIN.getPESAID());
                pInsertPESALog.setLong("pesa_product_id", thePESAIN.getPESAProductID());
                pInsertPESALog.setString("pesa_type", thePESAIN.getPESAType());
                pInsertPESALog.setInt("pesa_status_code", Constants.PESAStatusCode.QUEUED.getValue());
                pInsertPESALog.setString("pesa_status_description", "New PESA IN Transaction");
                pInsertPESALog.setString("sender", thePESAIN.getSender());
                pInsertPESALog.setString("sender_details", thePESAIN.getSenderDetails());
                pInsertPESALog.setString("receiver", thePESAIN.getReceiver());
                pInsertPESALog.setString("receiver_details", thePESAIN.getReceiverDetails());
                pInsertPESALog.setString("currency", thePESAIN.getCurrency());
                pInsertPESALog.setDouble("amount", thePESAIN.getAmount());
                pInsertPESALog.setString("account", thePESAIN.getAccount());
                pInsertPESALog.setString("pesa_source_reference", thePESAIN.getPESASourceReference());
                pInsertPESALog.setInt("pesa_priority", 100);
                pInsertPESALog.setInt("pesa_send_count", 0);
                pInsertPESALog.setString("schedule_pesa", Constants.SchedulePesa.NO.getValue());
                pInsertPESALog.setString("apply_transaction_charge", Constants.Enabled.YES.getValue());
                pInsertPESALog.setString("pesa_xml_data", thePESAIN.getPESAXMLData());
                pInsertPESALog.setString("pesa_send_integrity_hash", thePESAIN.getIntegrityHash());
                pInsertPESALog.setString("transaction_date", thePESAIN.getDateCreated());
                count = pInsertPESALog.executeUpdate();
                pInsertPESALog.close();
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                strInsertSQL = null;
                if (pInsertPESALog != null) {
                    try {
                        pInsertPESALog.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                pInsertPESALog = null;
            }
        }
        finally {
            strInsertSQL = null;
            if (pInsertPESALog != null) {
                try {
                    pInsertPESALog.close();
                }
                catch (Exception exception) {}
            }
            pInsertPESALog = null;
        }
        return count;
    }

    public String getPESAINTransactionID(long lnPESAID) {
        NamedParameterStatement p = null;
        ResultSet rs = null;
        String strSQL = null;
        String strTransactionID = "";
        PESAINTable thePESAINTable = new PESAINTable();
        try {
            switch (LocalParameters.getDatabaseType()) {
                case MySQL: {
                    strSQL = "SELECT " + thePESAINTable.getPESATableFieldTransactionID() + " FROM " + thePESAINTable.getPESATableName() + " WHERE " + thePESAINTable.getPESATableFieldPESAID() + " = :pesa_id" + " AND " + thePESAINTable.getPESATableFieldPESAType() + " = :pesa_type";
                    break;
                }
                case MicrosoftSQL: {
                    strSQL = "SELECT " + thePESAINTable.getPESATableFieldTransactionID() + " FROM " + thePESAINTable.getPESATableName() + " WHERE " + thePESAINTable.getPESATableFieldPESAID() + " = :pesa_id" + " AND " + thePESAINTable.getPESATableFieldPESAType() + " = :pesa_type";
                    break;
                }
                case Oracle: {
                    System.err.println("Oracle Database Type is not yet supported\n");
                    return null;
                }
                case PostgreSQL: {
                    System.err.println("PostgreSQL Database Type is not yet supported\n");
                    return null;
                }
                case MicrosoftAccess: {
                    System.err.println("Microsoft Access Database Type is not yet supported\n");
                    return null;
                }
                default: {
                    System.err.println("Invalid Database Type selected\n");
                    return null;
                }
            }
            try {
                p = new NamedParameterStatement(conn, strSQL);
                p.setLong("pesa_id", lnPESAID);
                p.setString("pesa_type", Constants.PESAType.PESA_IN.getValue());
                rs = p.executeQuery();
                if (rs.next()) {
                    strTransactionID = rs.getString(thePESAINTable.getPESATableFieldTransactionID());
                }
                rs.close();
                p.close();
                rs = null;
                p = null;
                strSQL = null;
            }
            catch (Exception e) {
                System.err.println("Error message DB: " + e.getMessage());
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                p.close();
            }
            catch (Exception exception) {}
            rs = null;
            p = null;
            strSQL = null;
        }
        return strTransactionID;
    }

    public static void Close() {
        if (conn != null) {
            try {
                conn.close();
                System.out.println("\n\nDatabase connection terminated\n");
            }
            catch (Exception e) {
                System.err.println("\n\nError message: " + e.getMessage());
            }
        }
    }

    public static Connection getConnection() {
        return conn;
    }

    public static boolean isConnected() {
        if (conn != null) {
            try {
                return !conn.isClosed();
            }
            catch (SQLException e) {
                return false;
            }
        }
        return false;
    }

    public static int isConnectionNull() {
        if (conn != null) {
            return 0;
        }
        return 1;
    }

    public static String getDBDateTime() {
        Statement st = null;
        ResultSet rs = null;
        String strDateTime = null;
        String strSQL = null;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strSQL = "SELECT NOW() AS DB_DATETIME";
                        break;
                    }
                    case MicrosoftSQL: {
                        strSQL = "SELECT CONVERT(VARCHAR, GETDATE(), 120) AS DB_DATETIME";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                st = conn.createStatement();
                rs = st.executeQuery(strSQL);
                rs.next();
                strDateTime = rs.getString("DB_DATETIME").substring(0, 19);
            }
            catch (Exception e) {
                System.err.println("Error message: " + e.getMessage());
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    st.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                rs = null;
                st = null;
                strSQL = null;
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                st.close();
            }
            catch (Exception exception) {}
            rs = null;
            st = null;
            strSQL = null;
        }
        return strDateTime;
    }

    public static String getDBTimeStamp() {
        Statement st = null;
        ResultSet rs = null;
        String strDateTime = null;
        String strSQL = null;
        try {
            try {
                switch (LocalParameters.getDatabaseType()) {
                    case MySQL: {
                        strSQL = "SELECT DATE_FORMAT(NOW(),'%Y%m%d%H%i%s') AS DB_DATETIME";
                        break;
                    }
                    case MicrosoftSQL: {
                        strSQL = "DECLARE @today DATETIME = SYSDATETIME(); SELECT CONVERT(VARCHAR,@today,112) + REPLACE(CONVERT(VARCHAR, @today, 108),':','')  AS DB_DATETIME;";
                        break;
                    }
                    case Oracle: {
                        System.err.println("Oracle Database Type is not yet supported\n");
                        break;
                    }
                    case PostgreSQL: {
                        System.err.println("PostgreSQL Database Type is not yet supported\n");
                        break;
                    }
                    case MicrosoftAccess: {
                        System.err.println("Microsoft Access Database Type is not yet supported\n");
                        break;
                    }
                    default: {
                        System.err.println("Invalid Database Type selected\n");
                    }
                }
                st = conn.createStatement();
                rs = st.executeQuery(strSQL);
                if (rs.next()) {
                    strDateTime = rs.getString("DB_DATETIME");
                }
            }
            catch (Exception e) {
                System.err.println("Error message : " + e.getMessage());
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    st.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                rs = null;
                st = null;
                strSQL = null;
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                st.close();
            }
            catch (Exception exception) {}
            rs = null;
            st = null;
            strSQL = null;
        }
        return strDateTime;
    }
}

