/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import java.net.URLEncoder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class PESAClientRemoteParameters {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setGlobalRemoteParameters() {
        try {
            boolean isPESAXMLClearText;
            String strReplyXMLData;
            PESAXMLFactory thePESAXMLFactory;
            block39: {
                thePESAXMLFactory = new PESAXMLFactory();
                String strPostData = thePESAXMLFactory.generateGetParametersXMLString();
                strPostData = "data=" + URLEncoder.encode(strPostData, "UTF-8");
                String strUrl = LocalParameters.getParametersURL();
                strReplyXMLData = null;
                if (LocalParameters.getClientSSLEnabled().equals((Object)Constants.Enabled.NO)) {
                    System.out.println("SSL is NOT Enabled for Parameters URL");
                    HTTPClient theHTTPClient = new HTTPClient();
                    strReplyXMLData = theHTTPClient.httpPost(strUrl, strPostData, LocalParameters.getClientConnectionTimeoutSeconds());
                    theHTTPClient = null;
                } else {
                    System.out.println("SSL is Enabled for Parameters URL");
                    HTTPSClient theHTTPSClient = new HTTPSClient();
                    boolean bValidateCertificateChain = LocalParameters.getClientCertificateChainValidation().equals((Object)Constants.CertificateChainValidation.YES);
                    boolean bVerifyHostname = LocalParameters.getClientHostnameVerification().equals((Object)Constants.HostnameVerification.YES);
                    switch (LocalParameters.getClientCertificateConfiguration()) {
                        case PUBLIC_CA: {
                            theHTTPSClient.setDefaultPublicCA(LocalParameters.getClientCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                            break;
                        }
                        case PRIVATE_CA: {
                            theHTTPSClient.setDefaultPrivateCA(LocalParameters.getClientCACertificateFilePath(), LocalParameters.getClientCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                            break;
                        }
                        case PRIVATE_CA_WITH_CLIENT_AUTH: {
                            theHTTPSClient.setDefaultPrivateCAWithClientAuth(LocalParameters.getClientCertificateFilePath(), LocalParameters.getClientCertificatePassword(), LocalParameters.getClientCACertificateFilePath(), LocalParameters.getClientCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                            break;
                        }
                        case PUBLIC_CA_WITH_CLIENT_AUTH: {
                            theHTTPSClient.setDefaultPublicCAWithClientAuth(LocalParameters.getClientCertificateFilePath(), LocalParameters.getClientCertificatePassword(), LocalParameters.getClientCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                            break;
                        }
                        default: {
                            theHTTPSClient.setDefaultPublicCA(LocalParameters.getClientCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                        }
                    }
                    strReplyXMLData = theHTTPSClient.httpsPost(strUrl, strPostData, LocalParameters.getClientConnectionTimeoutSeconds());
                    theHTTPSClient = null;
                }
                isPESAXMLClearText = false;
                if (strReplyXMLData == null) {
                    System.err.println("\nError on HTTP POST Client\n");
                    System.err.println("Message POST Error - No response was received");
                    return false;
                }
                if (LocalParameters.getClientEncryptionType().equals((Object)Constants.ClientEncryptionType.Rijndael_128)) {
                    try {
                        if (thePESAXMLFactory.validateXML(strReplyXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='WRAPPER'><xs:complexType><xs:simpleContent><xs:extension base='xs:string'><xs:attribute type='xs:string' name='ID' use='required'/><xs:attribute type='xs:string' name='t' use='required'/></xs:extension></xs:simpleContent></xs:complexType></xs:element></xs:schema>")) {
                            DocumentBuilder wrapperDocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                            InputSource wrapperIS = new InputSource();
                            wrapperIS.setCharacterStream(new StringReader(strReplyXMLData));
                            Document wrapperDoc = wrapperDocBuilder.parse(wrapperIS);
                            String strEncryptedReplyXMLData = wrapperDoc.getElementsByTagName("WRAPPER").item(0).getTextContent();
                            String strTimeStamp = wrapperDoc.getElementsByTagName("WRAPPER").item(0).getAttributes().getNamedItem("t").getTextContent();
                            Crypto theCrypto = new Crypto();
                            String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                            strReplyXMLData = theCrypto.decrypt(strEncryptionKey, strEncryptedReplyXMLData);
                            isPESAXMLClearText = true;
                            break block39;
                        }
                        System.err.println("Invalid WRAPPER XML Response.");
                        isPESAXMLClearText = false;
                    }
                    catch (Exception e) {
                        System.err.println("ERROR: " + e.getMessage());
                        System.err.println("Message Forward Error - Unkown response was received");
                        isPESAXMLClearText = false;
                    }
                } else {
                    isPESAXMLClearText = true;
                }
            }
            if (!isPESAXMLClearText) {
                System.err.println("Ecrypted data could not be decrypted");
                return false;
            }
            if (!thePESAXMLFactory.validateXML(strReplyXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='MESSAGES'><xs:complexType><xs:sequence><xs:element name='PESA_PARAMETERS' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element name='RESPONSE' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='OK' /><xs:enumeration value='ERROR' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:positiveInteger' name='RESPONSE_CODE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='DESCRIPTION' maxOccurs='1' minOccurs='1'/><xs:element name='OTHER_DETAILS' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:element name='PARAMETERS_STATUS' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='ACTIVE' /><xs:enumeration value='INACTIVE' /><xs:enumeration value='SUSPENDED' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:string' name='PARAMETERS_STATUS_DATE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:anyURI' name='SERVICE_URL' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='SERVICE_URL_MODE_CODE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='ENCRYPTION_TYPE_CODE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='CONNECTION_TIMEOUT_SECONDS' maxOccurs='1' minOccurs='1'/><xs:element name='CERTIFICATE_CONFIGURATION' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='PRIVATE_CA' /><xs:enumeration value='PRIVATE_CA_WITH_CLIENT_AUTH' /><xs:enumeration value='PUBLIC_CA' /><xs:enumeration value='PUBLIC_CA_WITH_CLIENT_AUTH' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:string' name='CRYPTOGRAPHIC_PROTOCOL' maxOccurs='1' minOccurs='1'/><xs:element name='CERTIFICATE_CHAIN_VALIDATION' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='YES' /><xs:enumeration value='NO' /></xs:restriction></xs:simpleType></xs:element><xs:element name='HOSTNAME_VERIFICATION' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='YES' /><xs:enumeration value='NO' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:positiveInteger' name='MAX_PESA_SENDER_THREADS' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='MAX_PESA_PER_THREAD' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='MAX_PESA_PER_MESSAGE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='MAX_PESA_PER_BATCH' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='MAX_PESA_SEND_COUNT' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='PESA_SEND_RETRY_WAIT_SECONDS' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='PESA_EXPIRY_MINUTES' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='PAUSE_PER_PESA_SECONDS' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='PAUSE_NEW_PESA_SECONDS' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='REFRESH_PARAMETERS_MINUTES' maxOccurs='1' minOccurs='1'/><xs:element type='xs:positiveInteger' name='RESTART_SYSTEM_SECONDS' maxOccurs='1' minOccurs='1'/><xs:element name='CLIENT_XML_PARAMETERS' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:any minOccurs='0' maxOccurs='100' processContents='skip'/></xs:sequence></xs:complexType></xs:element></xs:sequence></xs:complexType></xs:element></xs:sequence><xs:attribute type='xs:string' name='TYPE' fixed='PESA_OUT' use='required'/></xs:complexType></xs:element></xs:sequence><xs:attribute type='xs:decimal' name='VERSION' use='required'/><xs:attribute type='xs:string' name='DATETIME' use='required'/></xs:complexType></xs:element></xs:schema>")) {
                System.err.println("Unknown Response - Respose received could not be understood");
                return false;
            }
            InputSource source = new InputSource(new StringReader(strReplyXMLData));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            String strResponse = configXPath.evaluate("PESA_PARAMETERS/RESPONSE", objMessages).trim();
            int intResponseCode = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/RESPONSE_CODE", objMessages).trim());
            String strResponseDescription = configXPath.evaluate("PESA_PARAMETERS/DESCRIPTION", objMessages).trim();
            if (!strResponse.equalsIgnoreCase(Constants.PESAServerResponse.OK.getValue())) {
                System.out.println("Error Occured when Getting PESA Parameters.");
                System.out.println("Response            : " + strResponse);
                System.out.println("Response Code       : " + intResponseCode);
                System.out.println("Response Description: " + strResponseDescription);
                return false;
            }
            System.out.println(String.valueOf(strResponse) + ": Message Processed Successfully");
            System.out.println("Response            : " + strResponse);
            System.out.println("Response Code       : " + intResponseCode);
            System.out.println("Response Description: " + strResponseDescription);
            String strParametersStatus = configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/PARAMETERS_STATUS", objMessages).trim();
            String strParametersStatusDate = configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/PARAMETERS_STATUS_DATE", objMessages).trim();
            String strServiceURL = configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/SERVICE_URL", objMessages).trim();
            int intServiceURLModeCode = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/SERVICE_URL_MODE_CODE", objMessages).trim());
            int intEncryptionTypeCode = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/ENCRYPTION_TYPE_CODE", objMessages).trim());
            int intConnectionTimeOutSeconds = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/CONNECTION_TIMEOUT_SECONDS", objMessages).trim());
            String strCertificateConfiguration = configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/CERTIFICATE_CONFIGURATION", objMessages).trim();
            String strCryptographicProtocol = configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/CRYPTOGRAPHIC_PROTOCOL", objMessages).trim();
            String strCertificateChainValidation = configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/CERTIFICATE_CHAIN_VALIDATION", objMessages).trim();
            String strHostnameVerification = configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/HOSTNAME_VERIFICATION", objMessages).trim();
            int intMaxPESASenderThreads = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/MAX_PESA_SENDER_THREADS", objMessages).trim());
            int intMaxPESAPerThread = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/MAX_PESA_PER_THREAD", objMessages).trim());
            int intMaxPESAPerMessage = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/MAX_PESA_PER_MESSAGE", objMessages).trim());
            int intMaxPESAPerBatch = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/MAX_PESA_PER_BATCH", objMessages).trim());
            int intMaxPESASendCount = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/MAX_PESA_SEND_COUNT", objMessages).trim());
            int intPESASendRetryWaitSeconds = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/PESA_SEND_RETRY_WAIT_SECONDS", objMessages).trim());
            int intPESAExpiryMinutes = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/PESA_EXPIRY_MINUTES", objMessages).trim());
            int intPausePerPESASeconds = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/PAUSE_PER_PESA_SECONDS", objMessages).trim());
            int intPauseNewPESASeconds = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/PAUSE_NEW_PESA_SECONDS", objMessages).trim());
            int intRefreshParametersMinutes = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/REFRESH_PARAMETERS_MINUTES", objMessages).trim());
            int intRestartSystemSeconds = Integer.parseInt(configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/RESTART_SYSTEM_SECONDS", objMessages).trim());
            String strClientXMLParameters = configXPath.evaluate("PESA_PARAMETERS/OTHER_DETAILS/CLIENT_XML_PARAMETERS", objMessages).trim();
            RemoteParameters.setParametersStatus(strParametersStatus);
            RemoteParameters.setParametersStatusDate(strParametersStatusDate);
            RemoteParameters.setServiceURL(strServiceURL);
            if (Utils.sslURL(strServiceURL)) {
                RemoteParameters.setSSLEnabled(Constants.Enabled.YES);
            } else {
                RemoteParameters.setSSLEnabled(Constants.Enabled.NO);
            }
            Enum[] enumArray = Constants.ServiceURLMode.values();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constants.ServiceURLMode serviceURLMode = enumArray[n2];
                if (intServiceURLModeCode == serviceURLMode.getValue()) {
                    RemoteParameters.setServiceURLMode(serviceURLMode);
                }
                ++n2;
            }
            enumArray = Constants.EncryptionType.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                Enum encryptionType = enumArray[n2];
                if (intEncryptionTypeCode == ((Constants.EncryptionType)encryptionType).getValue()) {
                    RemoteParameters.setEncryptionType((Constants.EncryptionType)encryptionType);
                }
                ++n2;
            }
            RemoteParameters.setConnectionTimeoutSeconds(intConnectionTimeOutSeconds);
            enumArray = Constants.CertificateConfiguration.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                Enum certificateConfiguration = enumArray[n2];
                if (strCertificateConfiguration.equalsIgnoreCase(((Constants.CertificateConfiguration)certificateConfiguration).getValue())) {
                    RemoteParameters.setCertificateConfiguration((Constants.CertificateConfiguration)certificateConfiguration);
                }
                ++n2;
            }
            RemoteParameters.setCryptographicProtocol(strCryptographicProtocol);
            enumArray = Constants.CertificateChainValidation.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                Enum certificateChainValidation = enumArray[n2];
                if (strCertificateChainValidation.equalsIgnoreCase(((Constants.CertificateChainValidation)certificateChainValidation).getValue())) {
                    RemoteParameters.setCertificateChainValidation((Constants.CertificateChainValidation)certificateChainValidation);
                }
                ++n2;
            }
            enumArray = Constants.HostnameVerification.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                Enum hostnameVerification = enumArray[n2];
                if (strHostnameVerification.equalsIgnoreCase(((Constants.HostnameVerification)hostnameVerification).getValue())) {
                    RemoteParameters.setHostnameVerification((Constants.HostnameVerification)hostnameVerification);
                }
                ++n2;
            }
            RemoteParameters.setMaxPESASenderThreads(intMaxPESASenderThreads);
            RemoteParameters.setMaxPESAPerThread(intMaxPESAPerThread);
            RemoteParameters.setMaxPESAPerMessage(intMaxPESAPerMessage);
            RemoteParameters.setMaxPESAPerBatch(intMaxPESAPerBatch);
            RemoteParameters.setMaxPESASendCount(intMaxPESASendCount);
            RemoteParameters.setPESASendRetryWaitSeconds(intPESASendRetryWaitSeconds);
            RemoteParameters.setPESAExpiryMinutes(intPESAExpiryMinutes);
            RemoteParameters.setPausePerPESASeconds(intPausePerPESASeconds);
            RemoteParameters.setPauseNewPESASeconds(intPauseNewPESASeconds);
            RemoteParameters.setRefreshParametersMinutes(intRefreshParametersMinutes);
            RemoteParameters.setRestartSystemSeconds(intRestartSystemSeconds);
            RemoteParameters.setClientXMLParameters(strClientXMLParameters);
            if (RemoteParameters.getSSLEnabled().equals((Object)Constants.Enabled.YES)) {
                System.out.println("SSL is Enabled for Service URL");
                HTTPSClient theHTTPSClient = new HTTPSClient();
                boolean bValidateCertificateChain = RemoteParameters.getCertificateChainValidation().equals((Object)Constants.CertificateChainValidation.YES);
                boolean bVerifyHostname = RemoteParameters.getHostnameVerification().equals((Object)Constants.HostnameVerification.YES);
                switch (LocalParameters.getClientCertificateConfiguration()) {
                    case PUBLIC_CA: {
                        theHTTPSClient.setDefaultPublicCA(RemoteParameters.getCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                        break;
                    }
                    case PRIVATE_CA: {
                        theHTTPSClient.setDefaultPrivateCA(LocalParameters.getClientCACertificateFilePath(), RemoteParameters.getCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                        break;
                    }
                    case PRIVATE_CA_WITH_CLIENT_AUTH: {
                        theHTTPSClient.setDefaultPrivateCAWithClientAuth(LocalParameters.getClientCertificateFilePath(), LocalParameters.getClientCertificatePassword(), LocalParameters.getClientCACertificateFilePath(), RemoteParameters.getCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                        break;
                    }
                    case PUBLIC_CA_WITH_CLIENT_AUTH: {
                        theHTTPSClient.setDefaultPublicCAWithClientAuth(LocalParameters.getClientCertificateFilePath(), LocalParameters.getClientCertificatePassword(), RemoteParameters.getCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                        break;
                    }
                    default: {
                        theHTTPSClient.setDefaultPublicCA(RemoteParameters.getCryptographicProtocol(), bValidateCertificateChain, bVerifyHostname);
                        break;
                    }
                }
            } else {
                System.out.println("SSL is NOT Enabled for Service URL");
            }
            System.out.println("\nREMOTE XML PARAMETERS ....");
            System.out.println("Parameters Status            : " + RemoteParameters.getParametersStatus());
            System.out.println("Parameters Status Date       : " + RemoteParameters.getParametersStatusDate());
            System.out.println("Service URL                  : " + RemoteParameters.getServiceURL());
            System.out.println("SSL Enabled                  : " + (Object)((Object)RemoteParameters.getSSLEnabled()));
            System.out.println("Service URL Mode Code        : " + (Object)((Object)RemoteParameters.getServiceURLMode()));
            System.out.println("Encryption Type Code         : " + (Object)((Object)RemoteParameters.getEncryptionType()));
            System.out.println("Connection Timeout Seconds   : " + RemoteParameters.getConnectionTimeoutSeconds());
            System.out.println("Certificate Configuration    : " + (Object)((Object)RemoteParameters.getCertificateConfiguration()));
            System.out.println("Cryptographic Protocol       : " + RemoteParameters.getCryptographicProtocol());
            System.out.println("Certificate Chain Validation : " + (Object)((Object)RemoteParameters.getCertificateChainValidation()));
            System.out.println("Hostname Verification        : " + (Object)((Object)RemoteParameters.getHostnameVerification()));
            System.out.println("Max PESA Sender Threads      : " + RemoteParameters.getMaxPESASenderThreads());
            System.out.println("Max PESA Per Thread          : " + RemoteParameters.getMaxPESAPerThread());
            System.out.println("Max PESA Per Message         : " + RemoteParameters.getMaxPESAPerMessage());
            System.out.println("Max PESA Per Batch           : " + RemoteParameters.getMaxPESAPerBatch());
            System.out.println("Max PESA Send Count          : " + RemoteParameters.getMaxPESASendCount());
            System.out.println("PESA Send Retry Wait Seconds : " + RemoteParameters.getPESASendRetryWaitSeconds());
            System.out.println("PESA Expiry Minutes          : " + RemoteParameters.getPESAExpiryMinutes());
            System.out.println("Pause Per PESA Seconds       : " + RemoteParameters.getPausePerPESASeconds());
            System.out.println("Pause New PESA Seconds       : " + RemoteParameters.getPauseNewPESASeconds());
            System.out.println("Refresh Parameters Minutes   : " + RemoteParameters.getRefreshParametersMinutes());
            System.out.println("Restart System Seconds       : " + RemoteParameters.getRestartSystemSeconds());
            System.out.println("Client XML Parameters        : " + RemoteParameters.getClientXMLParameters());
            return true;
        }
        catch (Exception e) {
            System.err.println("getRemoteParameters(): " + e.getMessage());
        }
        return false;
    }
}

