/*
 * Decompiled with CFR 0.152.
 */
public class PESAReceiver {
    PESAReceiver() {
    }

    public void processPESAIN(PESAXMLFactory thePESAXMLFactory, String strPOSTXMLData, PESAResponse thePESAResponse) {
        try {
            if (thePESAXMLFactory.validateXML(strPOSTXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='MESSAGES'><xs:complexType><xs:sequence><xs:element name='PESA' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element type='xs:string' name='SENDER' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='SENDER_DETAILS' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='RECEIVER' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='RECEIVER_DETAILS' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='CURRENCY' maxOccurs='1' minOccurs='1'/><xs:element type='xs:decimal' name='AMOUNT' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='ACCOUNT' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='REFERENCE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='DATE_CREATED' maxOccurs='1' minOccurs='1'/><xs:element name='OTHER_DETAILS' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:any minOccurs='0' maxOccurs='20' processContents='skip'/></xs:sequence></xs:complexType></xs:element><xs:element type='xs:string' name='INTEGRITY_HASH' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:unsignedLong' name='ID' use='required'/><xs:attribute type='xs:unsignedLong' name='PRODUCT_ID' use='required'/><xs:attribute type='xs:string' name='TYPE' fixed='PESA_IN' use='required'/></xs:complexType></xs:element></xs:sequence><xs:attribute type='xs:decimal' name='VERSION' use='required'/><xs:attribute type='xs:string' name='DATETIME' use='required'/></xs:complexType></xs:element></xs:schema>")) {
                PESA thePESAIN = thePESAXMLFactory.getPESAIN(strPOSTXMLData);
                thePESAResponse.setTransactionID(thePESAIN.getTransactionID());
                thePESAResponse.setPESAID(thePESAIN.getPESAID());
                System.out.println("PESA ID               : " + thePESAIN.getPESAID());
                System.out.println("PESA Product ID       : " + thePESAIN.getPESAProductID());
                System.out.println("PESA Type             : " + thePESAIN.getPESAType());
                System.out.println("Sender                : " + thePESAIN.getSender());
                System.out.println("Sender Details        : " + thePESAIN.getSenderDetails());
                System.out.println("Receiver              : " + thePESAIN.getReceiver());
                System.out.println("Receiver Details      : " + thePESAIN.getReceiverDetails());
                System.out.println("Currency              : " + thePESAIN.getCurrency());
                System.out.println("Amount                : " + thePESAIN.getAmount());
                System.out.println("Account               : " + thePESAIN.getAccount());
                System.out.println("PESA Source Reference : " + thePESAIN.getPESASourceReference());
                System.out.println("Date Created          : " + thePESAIN.getDateCreated());
                System.out.println("PESA XML Data         : " + thePESAIN.getPESAXMLData());
                System.out.println("Integrity Hash        : " + thePESAIN.getIntegrityHash());
                PESAClientDB thePESAClientDB = new PESAClientDB();
                boolean bDataIntegrityOK = true;
                if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES) && LocalParameters.getIntegrityHashInboundCheck().equals((Object)Constants.Enabled.YES)) {
                    String strIntegrityHash = String.valueOf(thePESAIN.getPESAID()) + "-" + thePESAIN.getPESAProductID() + "-" + thePESAIN.getPESAType() + "-" + thePESAIN.getSender() + "-" + thePESAIN.getSenderDetails() + "-" + thePESAIN.getReceiver() + "-" + thePESAIN.getReceiverDetails() + "-" + thePESAIN.getCurrency() + "-" + thePESAIN.getAmount() + "-" + thePESAIN.getAccount() + "-" + thePESAIN.getPESASourceReference() + "-" + thePESAIN.getDateCreated() + "-" + thePESAIN.getPESAXMLData() + "-" + LocalParameters.getIntegritySecret();
                    boolean bl = bDataIntegrityOK = (strIntegrityHash = Utils.hash("SHA-256", strIntegrityHash)).equalsIgnoreCase(thePESAIN.getIntegrityHash());
                }
                if (bDataIntegrityOK) {
                    if (thePESAClientDB.isPESAINRecordExist(thePESAIN.getPESAID())) {
                        thePESAResponse.setTransactionID(thePESAClientDB.getPESAINTransactionID(thePESAIN.getPESAID()));
                        thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                        thePESAResponse.setResponseDescription("PESA ID " + thePESAResponse.getPESAID() + " Exist. Transaction NOT Accepted");
                        thePESAResponse.setApplyTransactionCharge(Constants.Enabled.YES.getValue());
                    } else {
                        int intUpdateCount = thePESAClientDB.insertPESAINLog(thePESAIN);
                        if (intUpdateCount > 0) {
                            thePESAResponse.setTransactionID(thePESAClientDB.getPESAINTransactionID(thePESAIN.getPESAID()));
                            thePESAResponse.setResponse(Constants.PESAServerResponse.OK.getValue());
                            thePESAResponse.setResponseDescription("Transaction Accepted.");
                            thePESAResponse.setApplyTransactionCharge(Constants.Enabled.YES.getValue());
                        } else {
                            thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                            thePESAResponse.setResponseDescription("PESA ID " + thePESAResponse.getPESAID() + " Inserted FAILED. Transaction NOT Accepted");
                            thePESAResponse.setApplyTransactionCharge(Constants.Enabled.NO.getValue());
                        }
                    }
                } else {
                    thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                    thePESAResponse.setResponseDescription("Security Violation - Integrity Check Failed. Transaction NOT Accepted");
                    thePESAResponse.setApplyTransactionCharge(Constants.Enabled.NO.getValue());
                }
            } else {
                thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                thePESAResponse.setResponseDescription("Invalid XML. Transaction NOT Accepted");
                thePESAResponse.setApplyTransactionCharge(Constants.Enabled.NO.getValue());
            }
        }
        catch (Exception e) {
            System.err.println("processPESAIN(PESAXMLFactory thePESAXMLFactory, String strPOSTXMLData, PESAResponse thePESAResponse) Error message: " + e.getMessage());
            thePESAResponse.setApplyTransactionCharge(Constants.Enabled.NO.getValue());
        }
    }

    public void processPESAResult(PESAXMLFactory thePESAXMLFactory, String strPOSTXMLData, PESAResponse thePESAResponse) {
        try {
            thePESAResponse.setApplyTransactionCharge(Constants.Enabled.NO.getValue());
            if (thePESAXMLFactory.validateXML(strPOSTXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='MESSAGES'><xs:complexType><xs:sequence><xs:element name='PESA' maxOccurs='1' minOccurs='1'><xs:complexType><xs:sequence><xs:element name='RESPONSE_CODE' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:positiveInteger'><xs:enumeration value='105' /><xs:enumeration value='201' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:string' name='DESCRIPTION' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='REFERENCE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='DATE_CREATED' maxOccurs='1' minOccurs='1'/><xs:element name='OTHER_DETAILS' maxOccurs='1' minOccurs='0'><xs:complexType><xs:sequence><xs:any minOccurs='0' maxOccurs='20' processContents='skip'/></xs:sequence></xs:complexType></xs:element><xs:element type='xs:string' name='INTEGRITY_HASH' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='ORIGINATOR_ID' use='required'/><xs:attribute type='xs:unsignedLong' name='ID' use='required'/><xs:attribute type='xs:unsignedLong' name='PRODUCT_ID' use='required'/><xs:attribute name='TYPE' use='required'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='PESA_OUT' /><xs:enumeration value='BUY_AIRTIME' /></xs:restriction></xs:simpleType></xs:attribute></xs:complexType></xs:element></xs:sequence><xs:attribute type='xs:decimal' name='VERSION' use='required'/><xs:attribute type='xs:string' name='DATETIME' use='required'/></xs:complexType></xs:element></xs:schema>")) {
                PESAResult thePESAResult = thePESAXMLFactory.getPESAResult(strPOSTXMLData);
                thePESAResponse.setTransactionID(thePESAResult.getTransactionID());
                thePESAResponse.setPESAID(thePESAResult.getPESAID());
                System.out.println("Transaction ID       : " + thePESAResult.getTransactionID());
                System.out.println("PESA ID              : " + thePESAResult.getPESAID());
                System.out.println("Product ID           : " + thePESAResult.getProductID());
                System.out.println("PESA Type            : " + thePESAResult.getPESAType());
                System.out.println("Response Code        : " + thePESAResult.getResponseCode());
                System.out.println("Response Description : " + thePESAResult.getResponseDescription());
                System.out.println("Reference            : " + thePESAResult.getReference());
                System.out.println("Date Created         : " + thePESAResult.getDateCreated());
                System.out.println("Other Details        : " + thePESAResult.getOtherDetails());
                System.out.println("Integrity Hash       : " + thePESAResult.getIntegrityHash());
                PESAClientDB thePESAClientDB = new PESAClientDB();
                boolean bDataIntegrityOK = true;
                if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES) && LocalParameters.getIntegrityHashInboundCheck().equals((Object)Constants.Enabled.YES)) {
                    String strIntegrityHash = String.valueOf(thePESAResult.getTransactionID()) + "-" + thePESAResult.getPESAID() + "-" + thePESAResult.getProductID() + "-" + thePESAResult.getPESAType() + "-" + thePESAResult.getResponseCode() + "-" + thePESAResult.getResponseDescription() + "-" + thePESAResult.getReference() + "-" + thePESAResult.getDateCreated() + "-" + thePESAResult.getOtherDetails() + "-" + LocalParameters.getIntegritySecret();
                    boolean bl = bDataIntegrityOK = (strIntegrityHash = Utils.hash("SHA-256", strIntegrityHash)).equalsIgnoreCase(thePESAResult.getIntegrityHash());
                }
                if (bDataIntegrityOK) {
                    Constants.PESAStatusCode theCurrentPESAStatusCode = thePESAClientDB.getPESAStatusCode(thePESAResult.getPESAType(), thePESAResponse.getTransactionID());
                    if (theCurrentPESAStatusCode == null) {
                        thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                        thePESAResponse.setResponseDescription("Transaction ID " + thePESAResponse.getTransactionID() + " Does not EXIST or Transaction Status Code Cannot be determined. Transaction Update NOT Accepted");
                    } else if (theCurrentPESAStatusCode.equals((Object)Constants.PESAStatusCode.SENT) || theCurrentPESAStatusCode.equals((Object)Constants.PESAStatusCode.SEND_ERROR) || theCurrentPESAStatusCode.equals((Object)Constants.PESAStatusCode.SEND_FAILED) || theCurrentPESAStatusCode.equals((Object)Constants.PESAStatusCode.DUPLICATE_TRANSACTION_ERROR)) {
                        int intUpdateCount = thePESAClientDB.updatePesaResultStatus(thePESAResult);
                        if (intUpdateCount > 0) {
                            thePESAResponse.setResponse(Constants.PESAServerResponse.OK.getValue());
                            thePESAResponse.setResponseDescription("Transaction Update Accepted.");
                        } else {
                            thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                            thePESAResponse.setResponseDescription("Transaction ID " + thePESAResult.getTransactionID() + " NOT found. Transaction Update NOT Accepted");
                        }
                    } else {
                        thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                        thePESAResponse.setResponseDescription("Status Code " + theCurrentPESAStatusCode.getValue() + " CANNOT be modified. Transaction Update NOT Accepted");
                    }
                } else {
                    thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                    thePESAResponse.setResponseDescription("Security Violation - Integrity Check Failed. Transaction NOT Accepted");
                }
            } else {
                thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                thePESAResponse.setResponseDescription("Invalid XML. Transaction Update NOT Accepted");
            }
        }
        catch (Exception e) {
            System.err.println("processPESAResult(PESAXMLFactory thePESAXMLFactory, String strPOSTXMLData, PESAResponse thePESAResponse) Error message: " + e.getMessage());
        }
    }
}

