/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class PESASender {
    PESASender() {
    }

    public void processPESA(Constants.PESAType thePESAType, ArrayList<PESA> pesaArrList) {
        try {
            ArrayList<PESASenderThread> pesaSenderThreadArrList = new ArrayList<PESASenderThread>();
            int maxThreads = RemoteParameters.getMaxPESASenderThreads();
            int intMaxDataPerThread = RemoteParameters.getMaxPESAPerThread();
            long threadCount = 0L;
            PESAClientDB thePESAClientDB = new PESAClientDB();
            while (pesaSenderThreadArrList.size() > 0 || pesaArrList.size() > 0) {
                if (pesaArrList.size() > 0) {
                    int pendingThreads = (int)Math.ceil((double)pesaArrList.size() / (double)intMaxDataPerThread);
                    int activeThreads = pesaSenderThreadArrList.size();
                    int noOfThreads = maxThreads - activeThreads;
                    if (noOfThreads > pendingThreads) {
                        noOfThreads = pendingThreads;
                    }
                    int i = 0;
                    while (i < noOfThreads) {
                        ArrayList<PESA> pesaThreadArrList = new ArrayList<PESA>();
                        int intDataPerThread = intMaxDataPerThread;
                        if (intDataPerThread > pesaArrList.size()) {
                            intDataPerThread = pesaArrList.size();
                        }
                        int j = 0;
                        while (j < intDataPerThread) {
                            pesaThreadArrList.add(pesaArrList.get(0));
                            pesaArrList.remove(0);
                            ++j;
                        }
                        PESASenderThread pesaSenderThread = new PESASenderThread(threadCount, pesaThreadArrList);
                        System.out.println(String.valueOf(threadCount) + " - Adding: " + pesaSenderThread.getName());
                        pesaSenderThreadArrList.add(pesaSenderThread);
                        ++threadCount;
                        ++i;
                    }
                } else {
                    System.out.println("\nThread waiting for " + RemoteParameters.getPauseNewPESASeconds() + " seconds to process the NEXT Messages Batch");
                    Thread.sleep(RemoteParameters.getPauseNewPESASeconds() * 1000);
                    pesaArrList = thePESAClientDB.getPESAData(thePESAType);
                }
                ListIterator pesaSenderThreadArrIterator = pesaSenderThreadArrList.listIterator();
                while (pesaSenderThreadArrIterator.hasNext()) {
                    PESASenderThread nextPESASenderThread = (PESASenderThread)pesaSenderThreadArrIterator.next();
                    if (nextPESASenderThread.isAlive()) continue;
                    System.out.println("Removing: " + nextPESASenderThread.getName());
                    pesaSenderThreadArrIterator.remove();
                }
            }
            System.out.println("Main thread's run is over");
        }
        catch (Exception e) {
            System.err.println("processPESA(ArrayList<PESA> pesaArrList) Error message: " + e.getMessage());
        }
    }

    public boolean sendPESA(ArrayList<PESA> thePESAArrList) {
        try {
            for (PESA thePESA : thePESAArrList) {
                switch (RemoteParameters.getServiceURLMode()) {
                    case HTTP_XML_POST: {
                        System.out.println("Sending out PESA using HTTP_XML_POST Sending Mode\n");
                        this.send_HTTP_XML_POST_PESA(thePESA);
                        break;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("sendPESA(ArrayList<PESA> msgArrList): " + e.getMessage());
            return false;
        }
    }

    private boolean send_HTTP_XML_POST_PESA(PESA thePESA) throws UnsupportedEncodingException {
        block31: {
            PESAXMLFactory thePESAXMLFactory = new PESAXMLFactory();
            PESAClientDB thePESAClientDB = new PESAClientDB();
            String strPostData = thePESAXMLFactory.generatePESAXMLString(thePESA);
            PESAResponse thePESAResponse = new PESAResponse();
            strPostData = "data=" + URLEncoder.encode(strPostData, "UTF-8");
            String strPesaStatusDescription = "Status Description Not Provided";
            String strUrl = RemoteParameters.getServiceURL();
            String strReplyXMLData = null;
            if (RemoteParameters.getSSLEnabled().equals((Object)Constants.Enabled.NO)) {
                HTTPClient theHTTPClient = new HTTPClient();
                strReplyXMLData = theHTTPClient.httpPost(strUrl, strPostData, RemoteParameters.getConnectionTimeoutSeconds());
                theHTTPClient = null;
            } else {
                HTTPSClient theHTTPSClient = new HTTPSClient();
                strReplyXMLData = theHTTPSClient.httpsPost(strUrl, strPostData, LocalParameters.getClientConnectionTimeoutSeconds());
                theHTTPSClient = null;
            }
            boolean isPesaXMLClearText = false;
            if (strReplyXMLData != null) {
                block30: {
                    if (RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.Rijndael_128)) {
                        try {
                            if (thePESAXMLFactory.validateXML(strReplyXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='WRAPPER'><xs:complexType><xs:simpleContent><xs:extension base='xs:string'><xs:attribute type='xs:string' name='ID' use='required'/><xs:attribute type='xs:string' name='t' use='required'/></xs:extension></xs:simpleContent></xs:complexType></xs:element></xs:schema>")) {
                                DocumentBuilder wrapperDocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                                InputSource wrapperIS = new InputSource();
                                wrapperIS.setCharacterStream(new StringReader(strReplyXMLData));
                                Document wrapperDoc = wrapperDocBuilder.parse(wrapperIS);
                                String strEncryptedReplyXMLData = wrapperDoc.getElementsByTagName("WRAPPER").item(0).getTextContent();
                                String strTimeStamp = wrapperDoc.getElementsByTagName("WRAPPER").item(0).getAttributes().getNamedItem("t").getTextContent();
                                Crypto theCrypto = new Crypto();
                                String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                                strReplyXMLData = theCrypto.decrypt(strEncryptionKey, strEncryptedReplyXMLData);
                                isPesaXMLClearText = true;
                                break block30;
                            }
                            System.err.println("\nError on HTTP POST Client\n");
                            if (thePESA.getSendCount() + 1 < RemoteParameters.getMaxPESASendCount()) {
                                System.out.println("Invalid WRAPPER XML Response. The transaction will be sent a gain later ...");
                                strPesaStatusDescription = "Transaction Send Error - Respose received could not be understood. Invalid WRAPPER XML Response";
                                thePESAResponse.setTransactionID(thePESA.getTransactionID());
                                thePESAResponse.setPESAType(thePESA.getPESAType());
                                thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                                thePESAResponse.setResponseCode(Constants.PESAStatusCode.SEND_ERROR.getValue());
                                thePESAResponse.setResponseDescription(strPesaStatusDescription);
                                thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                            } else {
                                System.out.println("Invalid WRAPPER XML Response. The transaction will be marked as UNKNOWN_RESPONSE");
                                strPesaStatusDescription = "Unknown Response - Respose received could not be understood. Invalid WRAPPER XML Response";
                                thePESAResponse.setTransactionID(thePESA.getTransactionID());
                                thePESAResponse.setPESAType(thePESA.getPESAType());
                                thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                                thePESAResponse.setResponseCode(Constants.PESAStatusCode.UNKNOWN_RESPONSE.getValue());
                                thePESAResponse.setResponseDescription(strPesaStatusDescription);
                                thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                            }
                            isPesaXMLClearText = false;
                        }
                        catch (Exception e) {
                            System.err.println("ERROR: " + e.getMessage());
                            if (thePESA.getSendCount() + 1 < RemoteParameters.getMaxPESASendCount()) {
                                System.out.println("The transaction will be sent a gain later ...");
                                strPesaStatusDescription = "Transaction Send Error - Respose received could not be understood";
                                thePESAResponse.setTransactionID(thePESA.getTransactionID());
                                thePESAResponse.setPESAType(thePESA.getPESAType());
                                thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                                thePESAResponse.setResponseCode(Constants.PESAStatusCode.SEND_ERROR.getValue());
                                thePESAResponse.setResponseDescription(strPesaStatusDescription);
                                thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                            } else {
                                System.out.println("The transaction will be marked as UNKNOWN_RESPONSE");
                                strPesaStatusDescription = "Unknown Response - Respose received could not be understood";
                                thePESAResponse.setTransactionID(thePESA.getTransactionID());
                                thePESAResponse.setPESAType(thePESA.getPESAType());
                                thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                                thePESAResponse.setResponseCode(Constants.PESAStatusCode.UNKNOWN_RESPONSE.getValue());
                                thePESAResponse.setResponseDescription(strPesaStatusDescription);
                                thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                            }
                            isPesaXMLClearText = false;
                        }
                    } else {
                        isPesaXMLClearText = true;
                    }
                }
                if (thePESAXMLFactory.validateXML(strReplyXMLData, "<xs:schema attributeFormDefault='unqualified' elementFormDefault='qualified' xmlns:xs='http://www.w3.org/2001/XMLSchema'><xs:element name='MESSAGES'><xs:complexType><xs:sequence><xs:element name='PESA'><xs:complexType><xs:sequence><xs:element name='RESPONSE' maxOccurs='1' minOccurs='1'><xs:simpleType><xs:restriction base='xs:string'><xs:enumeration value='OK' /><xs:enumeration value='ERROR' /></xs:restriction></xs:simpleType></xs:element><xs:element type='xs:positiveInteger' name='RESPONSE_CODE' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='DESCRIPTION' maxOccurs='1' minOccurs='1'/><xs:element type='xs:string' name='INTEGRITY_HASH' maxOccurs='1' minOccurs='0'/></xs:sequence><xs:attribute type='xs:string' name='ORIGINATOR_ID' use='required'/><xs:attribute type='xs:unsignedLong' name='ID' use='required'/><xs:attribute type='xs:string' name='TYPE' use='required'/></xs:complexType></xs:element></xs:sequence><xs:attribute type='xs:decimal' name='VERSION' use='required'/><xs:attribute type='xs:string' name='DATETIME' use='required'/></xs:complexType></xs:element></xs:schema>") && isPesaXMLClearText) {
                    try {
                        thePESAResponse = thePESAXMLFactory.getPESAResponse(strReplyXMLData);
                        thePESAResponse.setTransactionID(thePESA.getTransactionID());
                        System.out.println("\nResponse Details ...");
                        System.out.println("Transaction ID       : " + thePESAResponse.getTransactionID());
                        System.out.println("PESA ID              : " + thePESAResponse.getPESAID());
                        System.out.println("PESA Type            : " + thePESAResponse.getPESAType());
                        System.out.println("Response             : " + thePESAResponse.getResponse());
                        System.out.println("Response Code        : " + thePESAResponse.getResponseCode());
                        System.out.println("Response Description : " + thePESAResponse.getResponseDescription());
                        System.out.println("Integrity Hash       : " + thePESAResponse.getIntegrityHash());
                        String strResponse = thePESAResponse.getResponse();
                        strPesaStatusDescription = thePESAResponse.getResponseDescription();
                        int intPesaStatusCode = thePESAResponse.getResponseCode();
                        boolean bDataIntegrityOK = true;
                        if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES) && LocalParameters.getIntegrityHashInboundCheck().equals((Object)Constants.Enabled.YES)) {
                            String strIntegrirtyHash = thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret());
                            boolean bl = bDataIntegrityOK = strIntegrirtyHash.equalsIgnoreCase(thePESAResponse.getIntegrityHash());
                        }
                        if (bDataIntegrityOK) {
                            if (!strResponse.equalsIgnoreCase(Constants.PESAServerResponse.OK.getValue())) {
                                boolean bStatusCodeFound = false;
                                Constants.PESAStatusCode[] pESAStatusCodeArray = Constants.PESAStatusCode.values();
                                int n = pESAStatusCodeArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Constants.PESAStatusCode theStatusCode = pESAStatusCodeArray[n2];
                                    if (intPesaStatusCode == theStatusCode.getValue()) {
                                        bStatusCodeFound = true;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (!bStatusCodeFound) {
                                    intPesaStatusCode = Constants.PESAStatusCode.SEND_FAILED.getValue();
                                    strPesaStatusDescription = "Transaction Send FAILED: Response Code = " + intPesaStatusCode + " - " + strPesaStatusDescription;
                                    thePESAResponse.setResponseCode(intPesaStatusCode);
                                    thePESAResponse.setResponseDescription(strPesaStatusDescription);
                                    thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                                }
                            }
                        } else {
                            intPesaStatusCode = Constants.PESAStatusCode.TRANSACTION_REJECTED_ERROR.getValue();
                            strPesaStatusDescription = "Security Violation - Integrity Check Failed. Response NOT Accepted";
                            thePESAResponse.setResponseCode(intPesaStatusCode);
                            thePESAResponse.setResponseDescription(strPesaStatusDescription);
                            thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                            System.out.println("\n" + strPesaStatusDescription + "\n");
                        }
                        thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                    }
                    catch (Exception e) {
                        System.err.println("ERROR: " + e.getMessage());
                        if (thePESA.getSendCount() + 1 < RemoteParameters.getMaxPESASendCount()) {
                            System.out.println("The transaction will be sent a gain later ...");
                            strPesaStatusDescription = "Transaction Send Error - Respose received could not be understood";
                            thePESAResponse.setTransactionID(thePESA.getTransactionID());
                            thePESAResponse.setPESAType(thePESA.getPESAType());
                            thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                            thePESAResponse.setResponseCode(Constants.PESAStatusCode.SEND_ERROR.getValue());
                            thePESAResponse.setResponseDescription(strPesaStatusDescription);
                            thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                            thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                            break block31;
                        }
                        System.out.println("The transaction will be marked as UNKNOWN_RESPONSE");
                        strPesaStatusDescription = "Unknown Response - Respose received could not be understood";
                        thePESAResponse.setTransactionID(thePESA.getTransactionID());
                        thePESAResponse.setPESAType(thePESA.getPESAType());
                        thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                        thePESAResponse.setResponseCode(Constants.PESAStatusCode.UNKNOWN_RESPONSE.getValue());
                        thePESAResponse.setResponseDescription(strPesaStatusDescription);
                        thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                        thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                    }
                } else if (isPesaXMLClearText) {
                    System.err.println("\nError on HTTP POST Client\n");
                    if (thePESA.getSendCount() + 1 < RemoteParameters.getMaxPESASendCount()) {
                        System.out.println("Invalid XML Response. The transaction will be sent a gain later ...");
                        strPesaStatusDescription = "Transaction Send Error - Respose received could not be understood. Invalid XML Response";
                        thePESAResponse.setTransactionID(thePESA.getTransactionID());
                        thePESAResponse.setPESAType(thePESA.getPESAType());
                        thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                        thePESAResponse.setResponseCode(Constants.PESAStatusCode.SEND_ERROR.getValue());
                        thePESAResponse.setResponseDescription(strPesaStatusDescription);
                        thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                        thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                    } else {
                        System.out.println("Invalid XML Response. The transaction will be marked as UNKNOWN_RESPONSE");
                        strPesaStatusDescription = "Unknown Response - Respose received could not be understood. Invalid XML Response";
                        thePESAResponse.setTransactionID(thePESA.getTransactionID());
                        thePESAResponse.setPESAType(thePESA.getPESAType());
                        thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                        thePESAResponse.setResponseCode(Constants.PESAStatusCode.UNKNOWN_RESPONSE.getValue());
                        thePESAResponse.setResponseDescription(strPesaStatusDescription);
                        thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                        thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                    }
                }
            } else {
                System.err.println("\nError on HTTP POST Client\n");
                if (thePESA.getSendCount() + 1 < RemoteParameters.getMaxPESASendCount()) {
                    System.out.println("The transaction will be sent a gain later ...");
                    strPesaStatusDescription = "Transaction Send Error - No response was received";
                    thePESAResponse.setTransactionID(thePESA.getTransactionID());
                    thePESAResponse.setPESAType(thePESA.getPESAType());
                    thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                    thePESAResponse.setResponseCode(Constants.PESAStatusCode.SEND_ERROR.getValue());
                    thePESAResponse.setResponseDescription(strPesaStatusDescription);
                    thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                    thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                } else {
                    System.out.println("The transaction will be SEND_FAILED");
                    strPesaStatusDescription = "Transaction Send FAILED - No response was received";
                    thePESAResponse.setTransactionID(thePESA.getTransactionID());
                    thePESAResponse.setPESAType(thePESA.getPESAType());
                    thePESAResponse.setResponse(Constants.PESAServerResponse.ERROR.getValue());
                    thePESAResponse.setResponseCode(Constants.PESAStatusCode.SEND_FAILED.getValue());
                    thePESAResponse.setResponseDescription(strPesaStatusDescription);
                    thePESAResponse.setIntegrityHash(thePESAResponse.generateServerResponseIntegrityHash(LocalParameters.getIntegritySecret()));
                    thePESAClientDB.setPesaServerResponseStatus(thePESAResponse, true);
                }
            }
        }
        return true;
    }
}

