/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PESAXMLFactory {
    public String generateGetParametersXMLString() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elMessages = doc.createElement("MESSAGES");
            doc.appendChild(elMessages);
            Attr attrVersion = doc.createAttribute("VERSION");
            attrVersion.setValue("0.01");
            elMessages.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DATETIME");
            attrDateTime.setValue(PESAClientDB.getDBDateTime());
            elMessages.setAttributeNode(attrDateTime);
            Element elLogin = doc.createElement("LOGIN");
            elMessages.appendChild(elLogin);
            Attr attrUsername = doc.createAttribute("USERNAME");
            attrUsername.setValue(LocalParameters.getSystemUsername());
            elLogin.setAttributeNode(attrUsername);
            Attr attrPassword = doc.createAttribute("PASSWORD");
            attrPassword.setValue(LocalParameters.getSystemPassword());
            elLogin.setAttributeNode(attrPassword);
            Element elPESA = doc.createElement("PESA");
            elMessages.appendChild(elPESA);
            Element elClientID = doc.createElement("CLIENT_ID");
            elClientID.appendChild(doc.createTextNode(Long.toString(LocalParameters.getClientID())));
            elPESA.appendChild(elClientID);
            Element elAction = doc.createElement("ACTION");
            elAction.appendChild(doc.createTextNode("GET_PARAMETERS"));
            elPESA.appendChild(elAction);
            String output = this.convertDocumentToString(doc, false);
            output = output.trim();
            if (LocalParameters.getClientEncryptionType().equals((Object)Constants.ClientEncryptionType.Rijndael_128)) {
                String wrapperOutput;
                DocumentBuilderFactory wrapperDocFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder wrapperDocBuilder = wrapperDocFactory.newDocumentBuilder();
                String strTimeStamp = PESAClientDB.getDBTimeStamp();
                String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                Crypto theCrypto = new Crypto();
                String encryptedOutput = theCrypto.encrypt(strEncryptionKey, output);
                Document wrapperDoc = wrapperDocBuilder.newDocument();
                Element elWrapper = wrapperDoc.createElement("WRAPPER");
                elWrapper.appendChild(wrapperDoc.createTextNode(encryptedOutput));
                wrapperDoc.appendChild(elWrapper);
                Attr attrSystemUserID = wrapperDoc.createAttribute("ID");
                attrSystemUserID.setValue(Long.toString(LocalParameters.getSystemUserID()));
                elWrapper.setAttributeNode(attrSystemUserID);
                Attr attrTimeStamp = wrapperDoc.createAttribute("t");
                attrTimeStamp.setValue(strTimeStamp);
                elWrapper.setAttributeNode(attrTimeStamp);
                output = wrapperOutput = this.convertDocumentToString(wrapperDoc, false);
                System.out.println("\nDATA TO BE TRANSMITED IS ENCRYPTED");
            } else {
                System.out.println("\nDATA TO BE TRANSMITED IN CLEAR TEXT");
            }
            return output;
        }
        catch (Exception e) {
            System.err.println("generateGetParametersXMLString(): " + e.getMessage());
            return null;
        }
    }

    public String generatePESAXMLString(PESA thePESA) {
        try {
            Node elPESAOutXMLParameters;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elMessages = doc.createElement("MESSAGES");
            doc.appendChild(elMessages);
            Attr attrVersion = doc.createAttribute("VERSION");
            attrVersion.setValue("1.01");
            elMessages.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DATETIME");
            attrDateTime.setValue(PESAClientDB.getDBDateTime());
            elMessages.setAttributeNode(attrDateTime);
            Element elLogin = doc.createElement("LOGIN");
            elMessages.appendChild(elLogin);
            Attr attrUsername = doc.createAttribute("USERNAME");
            attrUsername.setValue(LocalParameters.getSystemUsername());
            elLogin.setAttributeNode(attrUsername);
            Attr attrPassword = doc.createAttribute("PASSWORD");
            attrPassword.setValue(LocalParameters.getSystemPassword());
            elLogin.setAttributeNode(attrPassword);
            Element elPESA = doc.createElement("PESA");
            elMessages.appendChild(elPESA);
            Attr attrOriginatorID = doc.createAttribute("ORIGINATOR_ID");
            attrOriginatorID.setValue(thePESA.getTransactionID());
            elPESA.setAttributeNode(attrOriginatorID);
            Attr attrProductID = doc.createAttribute("PRODUCT_ID");
            attrProductID.setValue(Long.toString(thePESA.getPESAProductID()));
            elPESA.setAttributeNode(attrProductID);
            Attr attrType = doc.createAttribute("TYPE");
            attrType.setValue(thePESA.getPESAType());
            elPESA.setAttributeNode(attrType);
            Attr attrCharge = doc.createAttribute("CHARGE");
            attrCharge.setValue(thePESA.getApplyTransactionCharge());
            elPESA.setAttributeNode(attrCharge);
            Element elSender = doc.createElement("SENDER");
            elSender.appendChild(doc.createTextNode(thePESA.getSender()));
            elPESA.appendChild(elSender);
            Element elSenderDetails = doc.createElement("SENDER_DETAILS");
            elSenderDetails.appendChild(doc.createTextNode(thePESA.getSenderDetails()));
            elPESA.appendChild(elSenderDetails);
            Element elReceiver = doc.createElement("RECEIVER");
            elReceiver.appendChild(doc.createTextNode(thePESA.getReceiver()));
            elPESA.appendChild(elReceiver);
            Element elReceiverDetails = doc.createElement("RECEIVER_DETAILS");
            elReceiverDetails.appendChild(doc.createTextNode(thePESA.getReceiverDetails()));
            elPESA.appendChild(elReceiverDetails);
            Element elCurrency = doc.createElement("CURRENCY");
            elCurrency.appendChild(doc.createTextNode(thePESA.getCurrency()));
            elPESA.appendChild(elCurrency);
            Element elAmount = doc.createElement("AMOUNT");
            elAmount.appendChild(doc.createTextNode(Double.toString(thePESA.getAmount())));
            elPESA.appendChild(elAmount);
            Element elAccount = doc.createElement("ACCOUNT");
            elAccount.appendChild(doc.createTextNode(thePESA.getAccount()));
            elPESA.appendChild(elAccount);
            Element elReference = doc.createElement("REFERENCE");
            elReference.appendChild(doc.createTextNode(thePESA.getPESASourceReference()));
            elPESA.appendChild(elReference);
            if (thePESA.getSchedulePesa().equals((Object)Constants.SchedulePesa.YES)) {
                Element elDateScheduled = doc.createElement("DATE_SCHEDULED");
                elDateScheduled.appendChild(doc.createTextNode(thePESA.getDateScheduled()));
                elPESA.appendChild(elDateScheduled);
            }
            Element elDateCreated = doc.createElement("DATE_CREATED");
            elDateCreated.appendChild(doc.createTextNode(thePESA.getTransactionDate()));
            elPESA.appendChild(elDateCreated);
            Document docOtherDetailsData = this.convertStringToDocument(thePESA.getPESAXMLData());
            if (docOtherDetailsData != null && (elPESAOutXMLParameters = doc.importNode(docOtherDetailsData.getDocumentElement(), true)) != null) {
                elPESA.appendChild(elPESAOutXMLParameters);
            }
            if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES)) {
                Element elIntegrityHash = doc.createElement("INTEGRITY_HASH");
                elIntegrityHash.appendChild(doc.createTextNode(thePESA.getIntegrityHash()));
                elPESA.appendChild(elIntegrityHash);
            }
            String output = this.convertDocumentToString(doc, false);
            output = output.trim();
            if (RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.Rijndael_128)) {
                String wrapperOutput;
                DocumentBuilderFactory wrapperDocFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder wrapperDocBuilder = wrapperDocFactory.newDocumentBuilder();
                String strTimeStamp = PESAClientDB.getDBTimeStamp();
                String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                Crypto theCrypto = new Crypto();
                String encryptedOutput = theCrypto.encrypt(strEncryptionKey, output);
                Document wrapperDoc = wrapperDocBuilder.newDocument();
                Element elWrapper = wrapperDoc.createElement("WRAPPER");
                elWrapper.appendChild(wrapperDoc.createTextNode(encryptedOutput));
                wrapperDoc.appendChild(elWrapper);
                Attr attrSystemUserID = wrapperDoc.createAttribute("ID");
                attrSystemUserID.setValue(Long.toString(LocalParameters.getSystemUserID()));
                elWrapper.setAttributeNode(attrSystemUserID);
                Attr attrTimeStamp = wrapperDoc.createAttribute("t");
                attrTimeStamp.setValue(strTimeStamp);
                elWrapper.setAttributeNode(attrTimeStamp);
                output = wrapperOutput = this.convertDocumentToString(wrapperDoc, false);
                System.out.println("\nDATA TO BE TRANSMITED IS ENCRYPTED");
            } else {
                System.out.println("\nDATA TO BE TRANSMITED IN CLEAR TEXT");
            }
            return output;
        }
        catch (Exception e) {
            System.err.println("sendPESA(ArrayList<PESA> pesaArrList): " + e.getMessage());
            return null;
        }
    }

    public String generateUpdatePESAResponseXMLString(long lnWrapperID, PESAResponse theResponse) {
        try {
            Element elIntegrityHash;
            String strIntegrirtyHash;
            Element elPESA;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elMessages = doc.createElement("MESSAGES");
            doc.appendChild(elMessages);
            Attr attrVersion = doc.createAttribute("VERSION");
            attrVersion.setValue("1.01");
            elMessages.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DATETIME");
            attrDateTime.setValue(PESAClientDB.getDBDateTime());
            elMessages.setAttributeNode(attrDateTime);
            if (theResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.PESA_IN.getValue())) {
                elPESA = doc.createElement("PESA");
                elMessages.appendChild(elPESA);
                Attr attrID = doc.createAttribute("ID");
                attrID.setValue(Long.toString(theResponse.getPESAID()));
                elPESA.setAttributeNode(attrID);
                Attr attrType = doc.createAttribute("TYPE");
                attrType.setValue(theResponse.getPESAType());
                elPESA.setAttributeNode(attrType);
                Attr attrCharge = doc.createAttribute("CHARGE");
                attrCharge.setValue(theResponse.getApplyTransactionCharge());
                elPESA.setAttributeNode(attrCharge);
                Element elResponse = doc.createElement("RESPONSE");
                elResponse.appendChild(doc.createTextNode(theResponse.getResponse()));
                elPESA.appendChild(elResponse);
                Element elDescription = doc.createElement("DESCRIPTION");
                elDescription.appendChild(doc.createTextNode(theResponse.getResponseDescription()));
                elPESA.appendChild(elDescription);
                Element elReference = doc.createElement("REFERENCE");
                elReference.appendChild(doc.createTextNode(theResponse.getTransactionID()));
                elPESA.appendChild(elReference);
                if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES)) {
                    strIntegrirtyHash = theResponse.generateClientResponseIntegrityHash(LocalParameters.getIntegritySecret());
                    elIntegrityHash = doc.createElement("INTEGRITY_HASH");
                    elIntegrityHash.appendChild(doc.createTextNode(strIntegrirtyHash));
                    elPESA.appendChild(elIntegrityHash);
                }
            } else if (theResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.PESA_OUT.getValue()) || theResponse.getPESAType().equalsIgnoreCase(Constants.PESAType.BUY_AIRTIME.getValue())) {
                elPESA = doc.createElement("PESA");
                elMessages.appendChild(elPESA);
                Attr attrOriginatorID = doc.createAttribute("ORIGINATOR_ID");
                attrOriginatorID.setValue(theResponse.getTransactionID());
                elPESA.setAttributeNode(attrOriginatorID);
                Attr attrID = doc.createAttribute("ID");
                attrID.setValue(Long.toString(theResponse.getPESAID()));
                elPESA.setAttributeNode(attrID);
                Attr attrType = doc.createAttribute("TYPE");
                attrType.setValue(theResponse.getPESAType());
                elPESA.setAttributeNode(attrType);
                Attr attrCharge = doc.createAttribute("CHARGE");
                attrCharge.setValue(theResponse.getApplyTransactionCharge());
                elPESA.setAttributeNode(attrCharge);
                Element elResponse = doc.createElement("RESPONSE");
                elResponse.appendChild(doc.createTextNode(theResponse.getResponse()));
                elPESA.appendChild(elResponse);
                Element elDescription = doc.createElement("DESCRIPTION");
                elDescription.appendChild(doc.createTextNode(theResponse.getResponseDescription()));
                elPESA.appendChild(elDescription);
                if (LocalParameters.getIntegrityHashEnabled().equals((Object)Constants.Enabled.YES)) {
                    strIntegrirtyHash = theResponse.generateClientResultResponseIntegrityHash(LocalParameters.getIntegritySecret());
                    elIntegrityHash = doc.createElement("INTEGRITY_HASH");
                    elIntegrityHash.appendChild(doc.createTextNode(strIntegrirtyHash));
                    elPESA.appendChild(elIntegrityHash);
                }
            }
            String output = this.convertDocumentToString(doc, false);
            output = output.trim();
            if (RemoteParameters.getEncryptionType().equals((Object)Constants.EncryptionType.Rijndael_128)) {
                String wrapperOutput;
                DocumentBuilderFactory wrapperDocFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder wrapperDocBuilder = wrapperDocFactory.newDocumentBuilder();
                String strTimeStamp = PESAClientDB.getDBTimeStamp();
                String strEncryptionKey = String.valueOf(LocalParameters.getSystemUsername()) + "/" + LocalParameters.getSystemPassword() + "/" + strTimeStamp;
                Crypto theCrypto = new Crypto();
                String encryptedOutput = theCrypto.encrypt(strEncryptionKey, output);
                Document wrapperDoc = wrapperDocBuilder.newDocument();
                Element elWrapper = wrapperDoc.createElement("WRAPPER");
                elWrapper.appendChild(wrapperDoc.createTextNode(encryptedOutput));
                wrapperDoc.appendChild(elWrapper);
                Attr attrWrapperID = wrapperDoc.createAttribute("ID");
                attrWrapperID.setValue(Long.toString(lnWrapperID));
                elWrapper.setAttributeNode(attrWrapperID);
                Attr attrTimeStamp = wrapperDoc.createAttribute("t");
                attrTimeStamp.setValue(strTimeStamp);
                elWrapper.setAttributeNode(attrTimeStamp);
                output = wrapperOutput = this.convertDocumentToString(wrapperDoc, false);
                System.out.println("\nDATA TO BE TRANSMITED IS ENCRYPTED");
            } else {
                System.out.println("\nDATA TO BE TRANSMITED IN CLEAR TEXT");
            }
            return output;
        }
        catch (Exception e) {
            System.err.println("generateUpdatePESAResponseXMLString(long lnWrapperID, PESAResponse theResponse, String strPesaType): " + e.getMessage());
            return null;
        }
    }

    public PESAWrapper getPESAWrapper(String strWrapperXML) {
        PESAWrapper pesaWrapper = new PESAWrapper();
        try {
            InputSource source = new InputSource(new StringReader(strWrapperXML));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/WRAPPER", xmlDocument, XPathConstants.NODE);
            long lnID = Long.parseLong(configXPath.evaluate("@ID", objMessages).trim());
            String strTimeStamp = configXPath.evaluate("@t", objMessages).trim();
            String strEncryptedData = configXPath.evaluate("/WRAPPER", objMessages).trim();
            pesaWrapper.setID(lnID);
            pesaWrapper.setTimeStamp(strTimeStamp);
            pesaWrapper.setEncryptedData(strEncryptedData);
            return pesaWrapper;
        }
        catch (Exception e) {
            System.err.println("getPESAWrapper(String strWrapperXML) error: " + e.getMessage());
            return null;
        }
    }

    public PESAResult getPESAResult(String strResponseXML) {
        PESAResult pesaResult = new PESAResult();
        try {
            InputSource source = new InputSource(new StringReader(strResponseXML));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            String strOriginatorID = configXPath.evaluate("PESA/@ORIGINATOR_ID", objMessages).trim();
            long lnPESAID = Long.parseLong(configXPath.evaluate("PESA/@ID", objMessages).trim());
            long lnProductID = Long.parseLong(configXPath.evaluate("PESA/@PRODUCT_ID", objMessages).trim());
            String strPESAType = configXPath.evaluate("PESA/@TYPE", objMessages).trim();
            int intResponseCode = Integer.parseInt(configXPath.evaluate("PESA/RESPONSE_CODE", objMessages).trim());
            String strResponseDescription = configXPath.evaluate("PESA/DESCRIPTION", objMessages).trim();
            String strReference = configXPath.evaluate("PESA/REFERENCE", objMessages).trim();
            String strDateCreated = configXPath.evaluate("PESA/DATE_CREATED", objMessages).trim();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource domsource = new DOMSource((Node)configXPath.evaluate("/MESSAGES/PESA/OTHER_DETAILS", xmlDocument, XPathConstants.NODE));
            StringWriter writer = new StringWriter();
            transformer.transform(domsource, new StreamResult(writer));
            String strOtherDetails = writer.getBuffer().toString();
            String strIntegrityHash = configXPath.evaluate("PESA/INTEGRITY_HASH", objMessages).trim();
            pesaResult.setTransactionID(strOriginatorID);
            pesaResult.setPESAID(lnPESAID);
            pesaResult.setProductID(lnProductID);
            pesaResult.setPESAType(strPESAType);
            pesaResult.setResponseCode(intResponseCode);
            pesaResult.setResponseDescription(strResponseDescription);
            pesaResult.setReference(strReference);
            pesaResult.setDateCreated(strDateCreated);
            pesaResult.setOtherDetails(strOtherDetails);
            pesaResult.setIntegrityHash(strIntegrityHash);
            return pesaResult;
        }
        catch (Exception e) {
            System.err.println("getPESAResult(String strResponseXML) error: " + e.getMessage());
            return null;
        }
    }

    public PESAResponse getPESAResponse(String strResponseXML) {
        PESAResponse pesaResponse = new PESAResponse();
        try {
            InputSource source = new InputSource(new StringReader(strResponseXML));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            long lnPESAID = Long.parseLong(configXPath.evaluate("PESA/@ID", objMessages).trim());
            String strOriginatorID = configXPath.evaluate("PESA/@ORIGINATOR_ID", objMessages).trim();
            String strPESAType = configXPath.evaluate("PESA/@TYPE", objMessages).trim();
            String strResponse = configXPath.evaluate("PESA/RESPONSE", objMessages).trim();
            int intResponseCode = Integer.parseInt(configXPath.evaluate("PESA/RESPONSE_CODE", objMessages).trim());
            String strResponseDescription = configXPath.evaluate("PESA/DESCRIPTION", objMessages).trim();
            String strIntegrityHash = configXPath.evaluate("PESA/INTEGRITY_HASH", objMessages).trim();
            pesaResponse.setPESAID(lnPESAID);
            pesaResponse.setTransactionID(strOriginatorID);
            pesaResponse.setPESAType(strPESAType);
            pesaResponse.setResponse(strResponse);
            pesaResponse.setResponseCode(intResponseCode);
            pesaResponse.setResponseDescription(strResponseDescription);
            pesaResponse.setIntegrityHash(strIntegrityHash);
            return pesaResponse;
        }
        catch (Exception e) {
            System.err.println("getPESAResponse(String strResponseXML) error: " + e.getMessage());
            return null;
        }
    }

    public String getReceiverXMLPESAType(String strPOSTXMLData) {
        try {
            InputSource source = new InputSource(new StringReader(strPOSTXMLData));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            String strPESAType = configXPath.evaluate("PESA/@TYPE", objMessages).trim();
            return strPESAType;
        }
        catch (Exception e) {
            System.err.println("getReceiverXMLPESAType(String strPOSTXMLData) error: " + e.getMessage());
            return null;
        }
    }

    public PESA getPESAIN(String strPOSTXMLData) {
        PESA thePESAIN = new PESA();
        try {
            InputSource source = new InputSource(new StringReader(strPOSTXMLData));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(source);
            XPath configXPath = XPathFactory.newInstance().newXPath();
            Object objMessages = configXPath.evaluate("/MESSAGES", xmlDocument, XPathConstants.NODE);
            long lnPESAID = Long.parseLong(configXPath.evaluate("PESA/@ID", objMessages).trim());
            long lnProductID = Long.parseLong(configXPath.evaluate("PESA/@PRODUCT_ID", objMessages).trim());
            String strPESAType = configXPath.evaluate("PESA/@TYPE", objMessages).trim();
            String strSender = configXPath.evaluate("PESA/SENDER", objMessages).trim();
            String strSenderDetails = configXPath.evaluate("PESA/SENDER_DETAILS", objMessages).trim();
            String strReceiver = configXPath.evaluate("PESA/RECEIVER", objMessages).trim();
            String strReceiverDetails = configXPath.evaluate("PESA/RECEIVER_DETAILS", objMessages).trim();
            String strCurrency = configXPath.evaluate("PESA/CURRENCY", objMessages).trim();
            double dblAmount = Double.parseDouble(configXPath.evaluate("PESA/AMOUNT", objMessages).trim());
            String strAccount = configXPath.evaluate("PESA/ACCOUNT", objMessages).trim();
            String strReference = configXPath.evaluate("PESA/REFERENCE", objMessages).trim();
            String strDateCreated = configXPath.evaluate("PESA/DATE_CREATED", objMessages).trim();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource domsource = new DOMSource((Node)configXPath.evaluate("/MESSAGES/PESA/OTHER_DETAILS", xmlDocument, XPathConstants.NODE));
            StringWriter writer = new StringWriter();
            transformer.transform(domsource, new StreamResult(writer));
            String strOtherDetails = writer.getBuffer().toString();
            String strIntegrityHash = configXPath.evaluate("PESA/INTEGRITY_HASH", objMessages).trim();
            thePESAIN.setPESAID(lnPESAID);
            thePESAIN.setPESAProductID(lnProductID);
            thePESAIN.setPESAType(strPESAType);
            thePESAIN.setSender(strSender);
            thePESAIN.setSenderDetails(strSenderDetails);
            thePESAIN.setReceiver(strReceiver);
            thePESAIN.setReceiverDetails(strReceiverDetails);
            thePESAIN.setCurrency(strCurrency);
            thePESAIN.setAmount(dblAmount);
            thePESAIN.setAccount(strAccount);
            thePESAIN.setPESASourceReference(strReference);
            thePESAIN.setDateCreated(strDateCreated);
            thePESAIN.setPESAXMLData(strOtherDetails);
            thePESAIN.setIntegrityHash(strIntegrityHash);
            return thePESAIN;
        }
        catch (Exception e) {
            System.err.println("getPESAIN(String strPOSTXMLData) error: " + e.getMessage());
            return null;
        }
    }

    public String generateSytemHealthXMLString() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elSystemHealth = doc.createElement("SystemHealth");
            doc.appendChild(elSystemHealth);
            Attr attrVersion = doc.createAttribute("Version");
            attrVersion.setValue(Constants.SystemHealth.XMLVersion.getValue());
            elSystemHealth.setAttributeNode(attrVersion);
            Attr attrDateTime = doc.createAttribute("DateTime");
            attrDateTime.setValue(PESAClientDB.getDBDateTime());
            elSystemHealth.setAttributeNode(attrDateTime);
            Element elSystemStartTime = doc.createElement("SystemStartTime");
            elSystemStartTime.appendChild(doc.createTextNode(SystemHealth.getSystemStartTime().toString()));
            elSystemHealth.appendChild(elSystemStartTime);
            Element elSystemLastHeartBeatTime = doc.createElement("SystemLastHeartBeatTime");
            elSystemLastHeartBeatTime.appendChild(doc.createTextNode(SystemHealth.getSystemLastHeartBeatTime().toString()));
            elSystemHealth.appendChild(elSystemLastHeartBeatTime);
            Element elAuthErrorCount = doc.createElement("AuthErrorCount");
            elAuthErrorCount.appendChild(doc.createTextNode(Long.toString(SystemHealth.getAuthErrorCount())));
            elSystemHealth.appendChild(elAuthErrorCount);
            Element elLowCreditErrorCount = doc.createElement("LowCreditErrorCount");
            elLowCreditErrorCount.appendChild(doc.createTextNode(Long.toString(SystemHealth.getLowCreditErrorCount())));
            elSystemHealth.appendChild(elLowCreditErrorCount);
            Element elInvalidPESAErrorCount = doc.createElement("InvalidPESAErrorCount");
            elInvalidPESAErrorCount.appendChild(doc.createTextNode(Long.toString(SystemHealth.getInvalidPESAErrorCount())));
            elSystemHealth.appendChild(elInvalidPESAErrorCount);
            String output = this.convertDocumentToString(doc, false);
            output = output.trim();
            return output;
        }
        catch (Exception e) {
            System.err.println("sendPESA(ArrayList<PESA> smsArrList): " + e.getMessage());
            return null;
        }
    }

    public boolean validateXML(String theXML, String theSchema) {
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder parser = null;
        InputSource XMLSource = null;
        Document XMLDocument = null;
        StreamSource schemaSource = null;
        Schema schema = null;
        Validator validator = null;
        boolean isValidXML = false;
        try {
            try {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(false);
                parser = documentBuilderFactory.newDocumentBuilder();
                final String dtd = theSchema;
                parser.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(dtd);
                    }
                });
                XMLSource = new InputSource(new StringReader(theXML));
                XMLDocument = parser.parse(XMLSource);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schemaSource = new StreamSource(new StringReader(theSchema));
                schema = schemaFactory.newSchema(schemaSource);
                validator = schema.newValidator();
                validator.validate(new DOMSource(XMLDocument));
                isValidXML = true;
            }
            catch (Exception e) {
                isValidXML = false;
                System.err.println("XML is NOT valid - ERROR: " + e.getMessage());
                documentBuilderFactory = null;
                parser = null;
                XMLSource = null;
                XMLDocument = null;
                schemaSource = null;
                schema = null;
                validator = null;
            }
        }
        finally {
            documentBuilderFactory = null;
            parser = null;
            XMLSource = null;
            XMLDocument = null;
            schemaSource = null;
            schema = null;
            validator = null;
        }
        return isValidXML;
    }

    public String convertDocumentToString(Document doc, boolean bOmitXMLDeclaration) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            if (bOmitXMLDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "no");
            }
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

