/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class ServiceThread
extends Thread {
    Constants.ServiceType serviceType = null;
    PESAClientDB thePESAClientDB = new PESAClientDB();
    boolean bPESAOUTServiceRunning = false;
    boolean bPESAINServiceRunning = false;
    boolean bBuyAirtimeServiceRunning = false;

    ServiceThread(Constants.ServiceType theServiceType) {
        this.serviceType = theServiceType;
        this.start();
    }

    @Override
    public void run() {
        try {
            if (this.serviceType.equals((Object)Constants.ServiceType.PESA_OUT)) {
                System.out.println("PESA OUT Service Activated\n");
                this.bPESAOUTServiceRunning = true;
                this.runPESAOUTService();
                this.bPESAOUTServiceRunning = false;
                System.out.println("PESA OUT Service has Ended\n");
            } else if (this.serviceType.equals((Object)Constants.ServiceType.PESA_IN)) {
                System.out.println("PESA IN Service Activated\n");
                this.bPESAINServiceRunning = true;
                this.runPESAINService();
                this.bPESAINServiceRunning = false;
                System.out.println("PESA IN Service has Ended\n");
            } else if (this.serviceType.equals((Object)Constants.ServiceType.BUY_AIRTIME)) {
                System.out.println("BUY AIRTIME Service Activated\n");
                this.bBuyAirtimeServiceRunning = true;
                this.runBuyAirtimeService();
                this.bBuyAirtimeServiceRunning = false;
                System.out.println("BUY AIRTIME Service has Ended\n");
            } else {
                System.err.println("\nINVALID PESA SERVICE - THREAD TERMINATED\n");
            }
        }
        catch (Exception e) {
            System.err.println("Thread - " + this.serviceType.getValue() + " error: " + e.getMessage());
        }
        System.out.println("Thread - " + this.serviceType.getValue() + " RUN is over");
    }

    public void stopService() {
        if (this.serviceType.equals((Object)Constants.ServiceType.PESA_OUT)) {
            this.bPESAOUTServiceRunning = false;
            System.out.println("Stopping PESA OUT Service ...\n");
        } else if (this.serviceType.equals((Object)Constants.ServiceType.PESA_IN)) {
            System.out.println("Stopping PESA IN Service ...\n");
            this.bPESAINServiceRunning = false;
        } else if (this.serviceType.equals((Object)Constants.ServiceType.BUY_AIRTIME)) {
            System.out.println("Stopping BUY AIRTIME Service ...\n");
            this.bBuyAirtimeServiceRunning = false;
        } else {
            System.err.println("\nINVALID PESA SERVICE - THREAD TERMINATED\n");
        }
    }

    private void runPESAOUTService() {
        try {
            try {
                this.thePESAClientDB.QueueValidRelayedPESA(Constants.PESAType.PESA_OUT);
                boolean isNewPESA = true;
                while (this.bPESAOUTServiceRunning) {
                    try {
                        if (LocalParameters.isPESAOUTTableActive()) {
                            System.out.println("PESA OUT Service is Active");
                            SystemHealth.setSystemLastHeartBeatTime();
                            ArrayList<PESA> pesaArrList = this.thePESAClientDB.getPESAData(Constants.PESAType.PESA_OUT);
                            System.out.println();
                            System.out.println(String.valueOf(pesaArrList.size()) + " PESA ready to be sent ...\n");
                            if (pesaArrList.size() > 0) {
                                isNewPESA = false;
                                PESASender thePESASender = new PESASender();
                                if (RemoteParameters.getMaxPESASenderThreads() > 1) {
                                    thePESASender.processPESA(Constants.PESAType.PESA_OUT, pesaArrList);
                                } else {
                                    thePESASender.sendPESA(pesaArrList);
                                }
                                System.out.println(String.valueOf(pesaArrList.size()) + " PESA Processed\n");
                            } else {
                                isNewPESA = true;
                            }
                            if (isNewPESA) {
                                System.out.println("\nWaiting for " + RemoteParameters.getPauseNewPESASeconds() + " seconds to process NEW PESA OUT Messages Batch");
                                Thread.sleep(RemoteParameters.getPauseNewPESASeconds() * 1000);
                                continue;
                            }
                            System.out.println("\nWaiting for " + RemoteParameters.getPausePerPESASeconds() + " seconds to process the NEXT PESA OUT Messages Batch");
                            Thread.sleep(RemoteParameters.getPausePerPESASeconds() * 1000);
                            continue;
                        }
                        System.out.println("PESA OUT Service is CANNOT be Stated since PESA OUT Table is NOT Active\n");
                        System.out.println("The Service will be terminated ...");
                        this.bPESAOUTServiceRunning = false;
                        break;
                    }
                    catch (Exception e) {
                        System.err.println("Error on runPESAOUTService() : " + e.getMessage());
                        System.out.println("\nWaiting for " + RemoteParameters.getPauseNewPESASeconds() + " seconds to process NEW PESA OUT Messages Batch");
                        Thread.sleep(RemoteParameters.getPauseNewPESASeconds() * 1000);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error Occured while Starting runPESAOUTService() : " + e.getMessage());
                this.bPESAOUTServiceRunning = false;
                System.out.println("PESA OUT Service STOPPED!");
            }
        }
        finally {
            this.bPESAOUTServiceRunning = false;
            System.out.println("PESA OUT Service STOPPED!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runPESAINService() {
        try {
            try {
                while (true) {
                    if (!this.bPESAINServiceRunning) {
                        return;
                    }
                    try {
                        if (!LocalParameters.isPESAINTableActive()) {
                            System.out.println("PESA IN Service is CANNOT be Stated since PESA IN Table is NOT Active\n");
                            System.out.println("The Service will be terminated ...");
                            this.bPESAINServiceRunning = false;
                            return;
                        }
                        System.out.println("PESA IN Service is Active");
                        System.out.println("PESA IN Service Thread will sleep for 60 seconds");
                        Thread.sleep(60000L);
                    }
                    catch (Exception e) {
                        System.err.println("Error on runBuyAirtimeService() : " + e.getMessage());
                        System.out.println("PESA IN Service Thread will sleep for 60 seconds");
                        Thread.sleep(60000L);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error Occured while Starting runPESAINService() : " + e.getMessage());
                this.bPESAINServiceRunning = false;
                System.out.println("PESA IN Service STOPPED!");
                return;
            }
        }
        finally {
            this.bPESAINServiceRunning = false;
            System.out.println("PESA IN Service STOPPED!");
        }
    }

    private void runBuyAirtimeService() {
        try {
            try {
                this.thePESAClientDB.QueueValidRelayedPESA(Constants.PESAType.BUY_AIRTIME);
                boolean isNewBuyAirtime = true;
                while (this.bBuyAirtimeServiceRunning) {
                    try {
                        if (LocalParameters.isBuyAirtimeTableActive()) {
                            System.out.println("Buy Airtime Service is Active");
                            SystemHealth.setSystemLastHeartBeatTime();
                            ArrayList<PESA> pesaArrList = this.thePESAClientDB.getPESAData(Constants.PESAType.BUY_AIRTIME);
                            System.out.println();
                            System.out.println(String.valueOf(pesaArrList.size()) + " Buy Airtime ready to be sent ...\n");
                            if (pesaArrList.size() > 0) {
                                isNewBuyAirtime = false;
                                PESASender thePESASender = new PESASender();
                                if (RemoteParameters.getMaxPESASenderThreads() > 1) {
                                    thePESASender.processPESA(Constants.PESAType.BUY_AIRTIME, pesaArrList);
                                } else {
                                    thePESASender.sendPESA(pesaArrList);
                                }
                                System.out.println(String.valueOf(pesaArrList.size()) + " Buy Airtime Processed\n");
                            } else {
                                isNewBuyAirtime = true;
                            }
                            if (isNewBuyAirtime) {
                                System.out.println("\nWaiting for " + RemoteParameters.getPauseNewPESASeconds() + " seconds to process NEW Buy Airtime Messages Batch");
                                Thread.sleep(RemoteParameters.getPauseNewPESASeconds() * 1000);
                                continue;
                            }
                            System.out.println("\nWaiting for " + RemoteParameters.getPausePerPESASeconds() + " seconds to process the NEXT Buy Airtime Messages Batch");
                            Thread.sleep(RemoteParameters.getPausePerPESASeconds() * 1000);
                            continue;
                        }
                        System.out.println("Buy Airtime Service is CANNOT be Stated since BUY AIRTIME Table is NOT Active\n");
                        System.out.println("The Service will be terminated ...");
                        this.bBuyAirtimeServiceRunning = false;
                        break;
                    }
                    catch (Exception e) {
                        System.err.println("Error on runBuyAirtimeService() : " + e.getMessage());
                        System.out.println("\nWaiting for " + RemoteParameters.getPauseNewPESASeconds() + " seconds to process NEW Buy Airtime Messages Batch");
                        Thread.sleep(RemoteParameters.getPauseNewPESASeconds() * 1000);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error Occured while Starting runBuyAirtimeService() : " + e.getMessage());
                this.bBuyAirtimeServiceRunning = false;
                System.out.println("Buy Airtime Service STOPPED!");
            }
        }
        finally {
            this.bBuyAirtimeServiceRunning = false;
            System.out.println("Buy Airtime Service STOPPED!");
        }
    }
}

