/*
 * Decompiled with CFR 0.152.
 */
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class Utils {
    public static final String strFilesCharset = "ISO-8859-1";

    public static long getFileSize(String path) {
        try {
            if (Files.isReadable(Paths.get(path, new String[0]))) {
                long fileSize = Files.size(Paths.get(path, new String[0]));
                return fileSize;
            }
            System.err.println("Either the File Does NOT Exist or is NOT Readable");
            return 0L;
        }
        catch (Exception e) {
            System.err.println("getFileSize(...) Error message: " + e.getMessage());
            return 0L;
        }
    }

    public static String readFile(String path) {
        try {
            if (Files.isReadable(Paths.get(path, new String[0]))) {
                byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
                return new String(encoded, StandardCharsets.ISO_8859_1);
            }
            System.err.println("Either the File Does NOT Exist or is NOT Readable");
            return null;
        }
        catch (Exception e) {
            System.err.println("readFile(...) Error message: " + e.getMessage());
            return null;
        }
    }

    public static List<String> readFileAllLines(String path) {
        try {
            if (Files.isReadable(Paths.get(path, new String[0]))) {
                List<String> lines = Files.readAllLines(Paths.get(path, new String[0]), StandardCharsets.ISO_8859_1);
                return lines;
            }
            System.err.println("Either the File Does NOT Exist or is NOT Readable");
            return null;
        }
        catch (Exception e) {
            System.err.println("readFileAllLines(...) Error message: " + e.getMessage());
            return null;
        }
    }

    public static boolean writeFile(String path, String data) {
        block3: {
            try {
                if (!Files.isReadable(Paths.get(path, new String[0]))) break block3;
                Files.write(Paths.get(path, new String[0]), data.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                return true;
            }
            catch (Exception e) {
                System.err.println("readFileAllLines(...) Error message: " + e.getMessage());
                return false;
            }
        }
        System.err.println("Either the File Does NOT Exist or is NOT Readable");
        return false;
    }

    public static boolean sslURL(String strURL) {
        return strURL.matches("^https://.*");
    }

    public static Map<String, String> queryToMap(String query, String delimiter) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = query.split(delimiter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] pair = param.split("=");
            if (pair.length > 1) {
                result.put(pair[0], pair[1]);
            } else {
                result.put(pair[0], "");
            }
            ++n2;
        }
        return result;
    }

    public static boolean findStringInArray(String str, String[] arr) {
        return Arrays.asList(arr).contains(str);
    }

    public static boolean findRegexInArray(String str, String[] arr) {
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String regex = stringArray[n2];
            System.out.println(regex);
            if (str.matches(regex)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String hash(String algo, String data) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algo);
            messageDigest.reset();
            messageDigest.update(data.getBytes(Charset.forName("UTF8")));
            byte[] resultByte = messageDigest.digest();
            String result = new String(Hex.encodeHex(resultByte));
            messageDigest = null;
            String string = result;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            messageDigest = null;
        }
        return null;
    }
}

