/*
 * Decompiled with CFR 0.152.
 */
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class WebServer {
    private int intWebServerPort = 80;
    private boolean bNeedClientAuth = true;
    HttpsServer httpsServer = null;
    HttpServer httpServer = null;

    public WebServer() {
    }

    public WebServer(int intPort) {
        try {
            this.startHTTPWebServer(intPort);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WebServer(int thePort, InputStream isKeyStore, String strKeyStorePassword, InputStream isCA, String strCryptographicProtocol, boolean bClientAuthEnabled) {
        try {
            this.startHTTPSWebServer(thePort, isKeyStore, strKeyStorePassword, isCA, strCryptographicProtocol, bClientAuthEnabled);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SSLContext getSSLContext(InputStream isKeyStore, String strKeyStorePassword, InputStream isCA, String strCryptographicProtocol) throws Exception {
        String strKeyStoreType = "PKCS12";
        KeyManager[] kmf = this.getKeyManagers(strKeyStoreType, isKeyStore, strKeyStorePassword);
        String trustStoreType = "X509";
        TrustManager[] tmf = this.getTrustManagers(trustStoreType, isCA);
        SSLContext sslContext = SSLContext.getInstance(strCryptographicProtocol);
        sslContext.init(kmf, tmf, new SecureRandom());
        return sslContext;
    }

    public void startHTTPWebServer(int thePort) throws Exception {
        this.intWebServerPort = thePort;
        int intCorePoolSize = WebServerParameters.getManagementWebServerThreadMaximumPoolSize();
        int intMaximumPoolSize = WebServerParameters.getManagementWebServerThreadMaximumPoolSize() * 2;
        long lnKeepAliveTime = WebServerParameters.getManagementWebServerThreadKeepAliveTime();
        ThreadPoolExecutor theThreadPoolExecutor = new ThreadPoolExecutor(intCorePoolSize, intMaximumPoolSize, lnKeepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(intCorePoolSize));
        theThreadPoolExecutor.allowCoreThreadTimeOut(true);
        this.httpServer = HttpServer.create(new InetSocketAddress(this.intWebServerPort), 8);
        this.httpServer.setExecutor(theThreadPoolExecutor);
        this.httpServer.createContext("/", new WebServerHandler());
        this.httpServer.start();
    }

    public void startHTTPSWebServer(int thePort, InputStream isKeyStore, String strKeyStorePassword, InputStream isCA, String strCryptographicProtocol, boolean bClientAuthEnabled) throws Exception {
        this.intWebServerPort = thePort;
        this.bNeedClientAuth = bClientAuthEnabled;
        SSLContext sslContext = this.getSSLContext(isKeyStore, strKeyStorePassword, isCA, strCryptographicProtocol);
        HttpsConfigurator httpsConfigurator = new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters httpsParameters) {
                try {
                    SSLContext theSSLContext = this.getSSLContext();
                    SSLParameters defaultSSLParameters = theSSLContext.getDefaultSSLParameters();
                    defaultSSLParameters.setNeedClientAuth(WebServer.this.bNeedClientAuth);
                    httpsParameters.setSSLParameters(defaultSSLParameters);
                }
                catch (Exception e) {
                    System.err.println("HttpsConfigurator: " + e.getMessage());
                }
            }
        };
        int intCorePoolSize = WebServerParameters.getManagementWebServerThreadMaximumPoolSize();
        int intMaximumPoolSize = WebServerParameters.getManagementWebServerThreadMaximumPoolSize() * 2;
        long lnKeepAliveTime = WebServerParameters.getManagementWebServerThreadKeepAliveTime();
        ThreadPoolExecutor theThreadPoolExecutor = new ThreadPoolExecutor(intCorePoolSize, intMaximumPoolSize, lnKeepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(intCorePoolSize));
        theThreadPoolExecutor.allowCoreThreadTimeOut(true);
        this.httpsServer = HttpsServer.create(new InetSocketAddress(this.intWebServerPort), 8);
        this.httpsServer.setHttpsConfigurator(httpsConfigurator);
        this.httpsServer.setExecutor(theThreadPoolExecutor);
        this.httpsServer.createContext("/", new WebServerHandler(this.bNeedClientAuth));
        this.httpsServer.start();
    }

    public void stopWebServer() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop(0);
            this.httpServer = null;
        }
        if (this.httpsServer != null) {
            this.httpsServer.stop(0);
            this.httpsServer = null;
        }
    }

    private KeyManager[] getKeyManagers(String keyStoreType, InputStream keyStoreFile, String keyStorePassword) {
        KeyManagerFactory kmf = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(keyStoreFile, keyStorePassword.toCharArray());
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            System.err.println("Error on getJKSTrustManagers() : " + e.getMessage());
        }
        return kmf.getKeyManagers();
    }

    private TrustManager[] getTrustManagers(String trustStoreType, InputStream caInput) {
        TrustManagerFactory tmf;
        block6: {
            CertificateFactory cf = null;
            Certificate ca = null;
            tmf = null;
            try {
                try {
                    cf = CertificateFactory.getInstance(trustStoreType);
                    ca = cf.generateCertificate(caInput);
                    System.out.println("Getting CA certificate ...");
                    String keyStoreType = KeyStore.getDefaultType();
                    KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                    keyStore.load(null, null);
                    keyStore.setCertificateEntry("ca", ca);
                    String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                    tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
                    tmf.init(keyStore);
                }
                catch (Exception e) {
                    System.err.println("Error on getTrustManagers() : " + e.getMessage());
                    caInput = null;
                    cf = null;
                    ca = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                caInput = null;
                cf = null;
                ca = null;
                throw throwable;
            }
            caInput = null;
            cf = null;
            ca = null;
        }
        if (tmf != null) {
            return tmf.getTrustManagers();
        }
        return null;
    }
}

